/*************************************************************
 *
 * A2PS: Database Access Languages Styles
 *
 *
 * * * * S Q L   P R E T T Y   P R I N T I N G
 *
 *  # - Prefix -   Style Description                     - Test Files
 *  --  ------   -----------------                       ----------
 *  1.  sql92  - SQL92 Standard Keywords   sqlcrt92.sql, sqlpq92.sql
 *  2.  sql    - Oracle SQL                sqlcrtbl.sql, sqlpqry.pkb
 *  3.  plsql  - Oracle PL/SQL                           sqlspace.pkb
 *  4.  oracle - Oracle SQL, including PL/SQL and tools  sqlschema.sql
 *  5.  initora- Oracle initilization parameter file     sqlinit.ora
 *  6.  sql3   - SQL3 Standard Keyword                   When available
 *  7.         - Other DB systems.
 *
 *
 * * * * N O T E S
 *
 *    1. sql92: SQL92 Standard Keywords
 *                By: Pierre Mareschal <pmaresch@be.oracle.com>.
 *              From: SQL92 standards taken from SQL92 BNF syntax.
 *                  (Available in text format from several sources.)
 *    2. sql  : Oracle SQL
 *    3. pls  : Oracle PL/SQL (Later...)
 *    4. pls  : Oracle SQL, including PL/SQL and tools (SQL*Plus...)
 *    2,3,4       By: Pierre Mareschal <pmaresch@be.oracle.com>.
 *              From: - PL/SQL User's Guide and Reference Manual (V 2.3)
 *                    - Programmer's Guide to the Oracle Precompiler (V 1.6)
 *    5. ora  : Oracle initilization parameter file
 *                By: Pierre Mareschal <pmaresch@be.oracle.com>.
 *              From: Oracle7 Server Manuals (Version 7.3).
 *    6. sql3 : SQL3 Standard Keywords (when available)
 *    7.      : Yours. (Other DB systems.)
 *              by Someone, somewhere, in summertime.
 *
 *
 * * * * * R E A D   M E ' S
 *
 * Read Me for Language 1 to 6
 *
 * I primarly added SQL pretty printing for my work.
 * Since I work to Oracle, the SQL extension defaults to SQL
 * and PL/SQL at Oracle's flavour.
 * However, since not everybody uses Oracle as a database
 * (and I wonder why?), I also added support for SQL92 standard.
 * I'll add support for SQL3 as soon as a standard appears...
 * Also, I'll do my best to maintain and keep up to date with
 * Oracle versions.
 *
 * Please read the manual: Pretty printing in a2ps is "keyword" based
 * and there is not lexical or syntaxtical analysis.
 *
 * Pierre Mareschal <pmaresch@be.oracle.com> - 18-MAR-97
 *
 *
 *************************************************************/

/*************************************************************
 * 1. SQL92 Standard
 *    --------------
 */
const sequence sql92_sequences [] = {
  /* Comments         */
  a2_sequence(/*,  comment, comment,  */, comment),
  /* Literals         */
  a2_sequence(\",  PLAIN, string,   \", PLAIN),
  a2_sequence(\',  PLAIN, string,   \', PLAIN),
  ENDSEQUENCE
};
const uchar sql92_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\0'
};
const keyword sql92_keywords [] = {
   a2_keyword(KEYWORD_strong, action, add, all, allocate, alter, and,
any, are, as, asc, assertion, at, authorization, avg, begin, between,
bit, bit_length, both, by, cascade, cascaded, case, cast, catalog,
char, char_length, character, character_length, check, close,
coalesce, collate, collation, column, commit, connect, connection,
constraint, constraints, continue, convert, corresponding, count,
create, cross, current, current_date, current_time, current_timestamp,
current_user, cursor, date, day, deallocate, dec, decimal, declare,
default, deferrable, deferred, delete, desc, describe, descriptor,
diagnostics, disconnect, distinct, domain, double, drop, else, end,
end-exec, escape, except, exception, exec, execute, exists, external,
extract, false, fetch, first, float, for, foreign, found, from, full,
get, global, go, goto, grant, group, having, hour, identity,
immediate, in, indicator, initially, inner, input, insensitive,
insert, int, integer, intersect, interval, into, is, isolation, join,
key, language, last, leading, left, level, like, local, lower, match,
max, min, minute, module, month, names, national, natural, nchar,
next, no, not, null, nullif, numeric, octet_length, of, on, only,
open, option, or, order, outer, output, overlaps, pad, partial,
position, precision, prepare, preserve, primary, prior, privileges,
procedure, public, read, real, references, relative, restrict, revoke,
right, rollback, rows, schema, scroll, second, section, select,
session, session_user, set, size, smallint, some, space, sql, sqlcode,
sqlerror, sqlstate, substring, sum, system_user, table, temporary,
then, time, timestamp, timezone_hour, timezone_minute, to, trailing,
transaction, translate, translation, trim, true, union, unique,
unknown, update, upper, usage, user, using, value, values, varchar,
varying, view, when, whenever, where, with, work, write, year, zone)
   ENDKEYWORD
};

const char * sql92_abbreviations[]= {
  "sql92", "\0"
};

const uchar sql92_description[] = "\
a2ps-sql92 Pretty Printer Version 1.0.0 alpha - 18-MAR-97\
This style is to be checked.\n\
Please report changes needed to Pierre Mareschal <pmaresch@be.oracle.com>";

#define sql92_style_def { sql92_style, "sql92",				\
  sql92_abbreviations, sql92_description, 				\
  CASE_SENSITIVE, sql92_characters, sql92_characters, sql92_keywords,	\
  NOSYMBOL, NOSYMBOL, sql92_sequences, sh_verbatims, EMPTY }


/************************************************************
 * O r a c l e   P r e t t y   P r i n t e r s
 * ===========================================
 *
 *
 * G E N E R I C (Common to all Oracle Pretty Printers)
 * =============
 */

const sequence sql_sequences [] = {
  /* Optimizer Pragma */
  a2_homo_sequence(/*+, comment_strong, */),
  /* Comments         */
  a2_homo_sequence(--,  comment, $),
  a2_homo_sequence(/*,  comment, */),
  a2_homo_sequence(//,  comment, $),
  /* Literals         */
  a2_sequence(\",  PLAIN, string,   \", PLAIN),
  a2_sequence(\',  PLAIN, string,   \', PLAIN),
  ENDSEQUENCE
};
const uchar sql_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\0'
};

/* C U S T O M (Custom for each Oracle language flavour)
 * ===========
 *
 *
 ************************************************************
 * 2. Oracle SQL
 *    ----------
 */
const keyword sql_keywords [] = {
   a2_keyword(keyword_strong,
access, add, all, alter, and, any, arraylen, as, asc, audit, 
between, by, char, check, cluster, column, comment, compress, 
connect, create, current, date, decimal, default, delete, 
desc, distinct, drop, else, exclusive, exists, file, float, 
for, from, grant, group, having, identified, immediate, in, 
increment, index, initial, insert, integer, intersect, into, 
is, level, like, lock, long, maxextents, minus, mode, modify, 
noaudit, nocompress, not, notfound, nowait, null, number, of, 
offline, on, online, option, or, order, pctfree, prior, 
privileges, public, raw, rename, resource, revoke, row, rowid, 
rowlabel, rownum, rows, select, session, set, share, size, 
smallint, sqlbuf, start, successful, synonym, sysdate, table, 
then, to, trigger, uid, union, unique, update, user, validate, 
values, varchar, varchar2, view, whenever, where, with)
   ENDKEYWORD
};

const char * sql_abbreviations[]= {
  "sql", "\0"
};

const uchar sql_description[] = "\
a2ps-sql Pretty Printer Version 1.0.0 beta - 18-MAR-97\
For comments, support for -- /*..*/ and //.\n\
This style is to be checked.\n\
Please report changes needed to Pierre Mareschal <pmaresch@be.oracle.com>";

#define sql_style_def { sql_style, "sql",			\
  sql_abbreviations, sql_description, 				\
  CASE_SENSITIVE, sql_characters, sql_characters, sql_keywords,	\
  NOSYMBOL, NOSYMBOL, sql_sequences, sh_verbatims, EMPTY }



/************************************************************
 * 3. Oracle PL/SQL (v. 2.3)
 *    ----------------------
 */
const keyword plsql_keywords [] = {
   a2_keyword(keyword_strong,
abort, accept, access, add, all, alter, and, any, array, 
arraylen, as, asc, assert, assign, at, audit, 
authorization, avg, base_table, begin, between, 
binary_integer, body, boolean, by, case, char, char_base, 
check, close, cluster, clusters, colauth, column, comment, 
commit, compress, connect, constant, crash, create, 
current, currval, cursor, data_base, database, date, dba, 
debugoff, debugon, decimal, declare, default, definition, 
delay, delete, delta, desc, digits, dispose, distinct, do, 
drop, else, elsif, end, entry, exception, exception_init, 
exclusive, exists, exit, false, fetch, file, float, for, 
form, from, function, generic, goto, grant, group, having, 
identified, if, immediate, in, increment, index, indexes, 
indicator, initial, insert, integer, interface, intersect, 
into, is, level, like, limited, lock, long, loop, max, 
maxextents, min, minus, mlslabel, mod, mode, modify, 
natural, naturaln, new, nextval, noaudit, nocompress, not, 
nowait, null, number, number_base, of, offline, on, online, 
open, option, or, order, others, out, package, partition, 
pctfree, pls_integer, positive, positiven, pragma, prior, 
private, privileges, procedure, public, raise, range, raw, 
real, record, ref, release, remr, rename, resource, return, 
reverse, revoke, rollback, row, rowid, rowlabel, rownum, 
rows, rowtype, run, savepoint, schema, select, separate, 
session, set, share, size, smallint, space, sql, sqlcode, 
sqlerrm, start, statement, stddev, subtype, successful, 
sum, synonym, sysdate, tabauth, table, tables, task, 
terminate, then, to, trigger, true, type, uid, union, 
unique, update, use, user, validate, values, varchar, 
varchar2, variance, view, views, when, whenever, where, 
while, with, work, write, xor)
   ENDKEYWORD
};

const char * plsql_abbreviations[]= {
  "pks", "pkb", "\0"
};

const uchar  plsql_description[] = "\
a2ps-plsql Pretty Printer Version 1.0.0 beta - 18-MAR-97\
This style is to be checked.\n\
Please report changes needed to Pierre Mareschal <pmaresch@be.oracle.com>";

#define plsql_style_def { plsql_style, "plsql",				\
  plsql_abbreviations, plsql_description, 				\
  CASE_SENSITIVE, sql_characters, sql_characters, plsql_keywords,	\
  NOSYMBOL, NOSYMBOL, sql_sequences, sh_verbatims, EMPTY }



/************************************************************
 * 4. Oracle SQL, Oracle PL/SQL (v. 2.3), and SQL*Plus keywords
 *    ---------------------------------------------------------
 */
const keyword oracle_keywords [] = {
   a2_keyword(keyword_strong,
abort, accept, access, add, admin, after, all, allocate, alter, 
analyze, and, any, archive, archivelog, array, arraylen, as, 
asc, assert, assign, at, audit, authorization, avg, backup, 
base_table, become, before, begin, between, binary_integer, 
block, body, boolean, by, cache, cancel, cascade, case, change, 
char, char_base, character, check, checkpoint, close, cluster, 
clusters, cobol, colauth, column, columns, comment, commit, 
compile, compress, connect, constant, constraint, constraints, 
contents, continue, controlfile, count, crash, create, current, 
currval, cursor, cycle, data_base, database, datafile, date, 
dba, debugoff, debugon, dec, decimal, declare, default, 
definition, delay, delete, delta, desc, digits, disable, 
dismount, dispose, distinct, do, double, drop, dump, each, else, 
elsif, enable, end, entry, escape, events, except, exception, 
exception_init, exceptions, exclusive, exec, execute, exists, 
exit, explain, extent, externally, false, fetch, file, float, 
flush, for, force, foreign, form, fortran, found, freelist, 
freelists, from, function, generic, go, goto, grant, group, 
groups, having, identified, if, immediate, in, including, 
increment, index, indexes, indicator, initial, initrans, insert, 
instance, int, integer, interface, intersect, into, is, key, 
language, layer, level, like, limited, link, lists, lock, 
logfile, long, loop, manage, manual, max, maxdatafiles, 
maxextents, maxinstances, maxlogfiles, maxloghistory, 
maxlogmembers, maxtrans, maxvalue, min, minextents, minus, 
minvalue, mlslabel, mod, mode, modify, module, mount, natural, 
naturaln, new, next, nextval, noarchivelog, noaudit, nocache, 
nocompress, nocycle, nomaxvalue, nominvalue, none, noorder, 
noresetlogs, normal, nosort, not, notfound, nowait, null, 
number, number_base, numeric, of, off, offline, old, on, online, 
only, open, optimal, option, or, order, others, out, own, 
package, parallel, partition, pctfree, pctincrease, pctused, 
plan, pli, pls_integer, positive, positiven, pragma, precision, 
primary, prior, private, privileges, procedure, profile, public, 
quota, raise, range, raw, read, real, record, recover, ref, 
references, referencing, release, remr, rename, resetlogs, 
resource, restricted, return, reuse, reverse, revoke, role, 
roles, rollback, row, rowid, rowlabel, rownum, rows, rowtype, 
run, savepoint, schema, scn, section, segment, select, separate, 
sequence, session, set, share, shared, size, smallint, snapshot, 
some, sort, space, sql, sqlbuf, sqlcode, sqlerrm, sqlerror, 
sqlstate, start, statement, statement_id, statistics, stddev, 
stop, storage, subtype, successful, sum, switch, synonym, 
sysdate, system, tabauth, table, tables, tablespace, task, 
temporary, terminate, then, thread, time, to, tracing, 
transaction, trigger, triggers, true, truncate, type, uid, 
under, union, unique, unlimited, until, update, use, user, 
using, validate, values, varchar, varchar2, variance, view, 
views, when, whenever, where, while, with, work, write, xor)
   ENDKEYWORD
};

const char * oracle_abbreviations[]= {
  "\0"
};

const uchar oracle_description[] = "\
a2ps-oracle Pretty Printer Version 1.0.0 beta - 18-MAR-97\
For comments, support for -- /*..*/ and //.\n\
This style is to be checked.\n\
Please report changes needed to Pierre Mareschal <pmaresch@be.oracle.com>";

#define oracle_style_def { oracle_style, "oracle",			\
  oracle_abbreviations, oracle_description, 				\
  CASE_SENSITIVE, sql_characters, sql_characters, oracle_keywords,	\
  NOSYMBOL, NOSYMBOL, sql_sequences, sh_verbatims, EMPTY }


/************************************************************
 * 5. Oracle Server Parameter File
 *    ----------------------------
 */
const sequence initora_sequences [] = {
  a2_homo_sequence(#,  comment, $),
  /* Literals         */
  a2_sequence(\",  PLAIN, string,   \", PLAIN),
  a2_sequence(\',  PLAIN, string,   \', PLAIN),
  ENDSEQUENCE
};
const uchar initora_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\0'
};

const keyword initora_keywords [] = {
   a2_keyword(keyword_strong,
always_anti_join, audit_trail, background_dump_dest, 
bitmap_merge_area_size, blank_trimming, cache_size_threshold, 
checkpoint_process, cleanup_rollback_entries, 
close_cached_open_cursors, commit_point_strength, compatible, 
compatible_no_recovery, control_files, cpu_count, 
create_bitmap_area_size, cursor_space_for_time, 
db_block_buffers, db_block_checkpoint_batch, 
db_block_checksum, db_block_lru_extended_statistics, 
db_block_lru_latches, db_block_lru_statistics, db_block_size, 
db_domain, db_file_multiblock_read_count, 
db_file_simultaneous_writes, db_file_standby_name_convert, 
db_files, db_name, dblink_encrypt_login, 
delayed_logging_block_cleanouts, 
discrete_transactions_enabled, distributed_lock_timeout, 
distributed_recovery_connection_hold_time, 
distributed_transactions, dml_locks, enqueue_resources, 
event, fixed_date, gc_db_locks, gc_files_to_locks, 
gc_freelist_groups, gc_lck_procs, gc_releasable_locks, 
gc_rollback_locks, gc_rollback_segments, 
gc_save_rollback_locks, gc_segments, gc_tablespaces, 
global_names, hash_area_size, hash_join_enabled, 
hash_multiblock_io_count, ifile, instance_number, 
job_queue_interval, job_queue_keep_connections, 
job_queue_processes, license_max_sessions, license_max_users, 
license_sessions_warning, log_archive_buffer_size, 
log_archive_buffers, log_archive_dest, log_archive_format, 
log_archive_start, log_block_checksum, log_buffer, 
log_checkpoint_interval, log_checkpoint_timeout, 
log_checkpoints_to_alert, log_file_standby_name_convert, 
log_files, log_simultaneous_copies, log_small_entry_max_size, 
max_commit_propagation_delay, max_dump_file_size, 
max_enabled_roles, max_rollback_segments, 
max_transaction_branches, mts_dispatchers, 
mts_listener_address, mts_max_dispatchers, mts_max_servers, 
mts_multiple_listeners, mts_servers, mts_service, 
nls_currency, nls_date_format, nls_date_language, 
nls_iso_currency, nls_language, nls_numeric_characters, 
nls_sort, nls_territory, open_cursors, open_links, 
optimizer_mode, optimizer_percent_parallel, 
oracle_trace_collection_name, oracle_trace_collection_path, 
oracle_trace_collection_size, oracle_trace_enable, 
oracle_trace_facility_name, oracle_trace_facility_path, 
os_authent_prefix, os_roles, parallel_default_max_instances, 
parallel_max_servers, parallel_min_percent, 
parallel_min_servers, parallel_server_idle_time, 
partition_view_enabled, pre_page_sga, processes, 
recovery_parallelism, remote_dependencies_mode, 
remote_login_passwordfile, remote_os_authent, 
remote_os_roles, resource_limit, rollback_segments, 
row_cache_cursors, row_locking, sequence_cache_entries, 
sequence_cache_hash_buckets, serializable, 
session_cached_cursors, sessions, 
shared_pool_reserved_min_alloc, shared_pool_reserved_size, 
shared_pool_size, snapshot_refresh_interval, 
snapshot_refresh_keep_connections, 
snapshot_refresh_processes, sort_area_retained_size, 
sort_area_size, sort_direct_writes, sort_read_fac, 
sort_spacemap_size, sort_write_buffer_size, 
sort_write_buffers, sql92_security, sql_trace, 
temporary_table_locks, text_enable, thread, timed_statistics, 
transactions, transactions_per_rollback_segment, 
user_dump_dest, utl_file_dir)
   ENDKEYWORD
};

const char * initora_abbreviations[]= {
  "ora", "\0"
};

const uchar initora_description[] = "\
a2ps-initora Pretty Printer Version 1.0.0 beta - 18-MAR-97\
This style is to be checked.\n\
Please report changes needed to Pierre Mareschal <pmaresch@be.oracle.com>";

#define initora_style_def { initora_style, "initora", 			\
  initora_abbreviations, initora_description, 				\
  CASE_INSENSITIVE, initora_characters, initora_characters, initora_keywords,\
  NOSYMBOL, NOSYMBOL, initora_sequences, sh_verbatims, EMPTY }


/************************************************************
 * 6. SQL3 Standard
 *    -------------
 */


/************************************************************
 * 7. Other Database Access Language (and specifics)
 *    ----------------------------------------------
 */

/************************************************************
 *	End of Database Access Languages
 ************************************************************/
