/************************************************************************/
/*			Assembly languages			   	*/
/************************************************************************/
/*
 *		Motorola 68000
 */
const uchar m68000_characters [] = {
  'A', 'Z',
  'a', 'z',
  '.', '.',
  '\0'
};
const keyword m68000_keywords [] = {
  /* Preprocessor */
  a2_preprocessor_keywords

  a2_keyword(KEYWORD_STRONG, .data, .globl, .long, .skip, .text)

  a2_keyword(KEYWORD_STRONG, addw, beq, bgt, ble, bne, bra, bset,
btst, clrl, cmpl, jmp, jsr, movel, moveb, moveml, movew, movw, rte,
rts, subw, subql, tstl)
   ENDKEYWORD
};
const sequence m68000_sequences [] = {
  /* comments */
  a2_line_sequences(comment_strong, |#, |*),
  a2_line_sequences(comment, |),
  ENDSEQUENCE
};
const char * m68000_abbreviations []= {
  "68000", "S", "s", "\0"
};
const uchar m68000_description [] = "\
This style is devoted to the assembly language of the Motorola 68000. \
It is still experimental. Send comments to demaille@inf.enst.fr";
#define m68000_style_def { m68000_style, "68000", 				\
  m68000_abbreviations, m68000_description, 				\
  CASE_INSENSITIVE, m68000_characters, m68000_characters, m68000_keywords,\
  NOSYMBOL, NOSYMBOL, m68000_sequences, sh_verbatims, EMPTY }
