/************************************************************************/
/*			         Fortran      			   	*/
/************************************************************************/
/*
 *		Fortran (Fortran 95 - with some keywords of HPF)
 *
 */
/* Denis GIROU (CNRS/IDRIS - France) <Denis.Girou@idris.fr> - 10 Oct. 1996 */

const sequence fortran_sequences [] = {
  /* comments */
  a2_line_sequences(comment, !, ^c, ^*),

  /* char and strings litteral */
  a2_sequence(\', plain, string, \', plain),
  a2_sequence(\", plain, string, \", plain),

  /* Sections in the source file */
  a2_sequence(program , keyword_strong, label_strong|dec1, ` ', plain),
  a2_sequence(program , keyword_strong, label_strong|dec1, `(', plain),
  a2_sequence(program , keyword_strong, label_strong|dec1, `$', plain),

  a2_sequence(end program , keyword_strong, label_strong, ` ', plain),
  a2_sequence(end program , keyword_strong, label_strong, `(', plain),
  a2_sequence(end program , keyword_strong, label_strong, `$', plain),

  a2_sequence(subroutine , keyword_strong, label_strong, ` ', plain),
  a2_sequence(subroutine , keyword_strong, label_strong, `(', plain),
  a2_sequence(subroutine , keyword_strong, label_strong, `$', plain),

  a2_sequence(end subroutine , keyword_strong, label_strong, ` ', plain),
  a2_sequence(end subroutine , keyword_strong, label_strong, `(', plain),
  a2_sequence(end subroutine , keyword_strong, label_strong, `$', plain),

  a2_sequence(function , keyword_strong, label_strong, ` ', plain),
  a2_sequence(function , keyword_strong, label_strong, `(', plain),
  a2_sequence(function , keyword_strong, label_strong, `$', plain),

  a2_sequence(end function , keyword_strong, label_strong, ` ', plain),
  a2_sequence(end function , keyword_strong, label_strong, `(', plain),
  a2_sequence(end function , keyword_strong, label_strong, `$', plain),

  a2_sequence(module procedure , keyword_strong, label_strong, ` ', plain),
  a2_sequence(module procedure , keyword_strong, label_strong, `(', plain),
  a2_sequence(module procedure , keyword_strong, label_strong, `$', plain),

  a2_sequence(module , keyword_strong, label_strong, ` ', plain),
  a2_sequence(module , keyword_strong, label_strong, `(', plain),
  a2_sequence(module , keyword_strong, label_strong, `$', plain),

  a2_sequence(end module , keyword_strong, label_strong, ` ', plain),
  a2_sequence(end module , keyword_strong, label_strong, `(', plain),
  a2_sequence(end module , keyword_strong, label_strong, `$', plain),


  /* Interface */
  a2_sequence(`interface assignment(', keyword_strong,  
              label_strong, `)', plain),
  a2_sequence(`interface assignment (', keyword_strong,  
              label_strong, `)', plain),
  a2_sequence(`interface operator(', keyword_strong,  
              label_strong, `)', plain),
  a2_sequence(`interface operator (', keyword_strong,  
              label_strong, `)', plain),

  /* Calls */
  a2_sequence(call , keyword, label, ` ', plain),
  a2_sequence(call , keyword, label, `(', plain),
  a2_sequence(call , keyword, label, `$', plain),

  ENDSEQUENCE
};
const uchar fortran_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '.', '.',
  '\0'
};
const symbol fortran_specials []  = {
  /* boolean operations */
  a2_not(.not.),
  a2_or(.or.),
  a2_and(.and.),
  /* comparatives */
  a2_geq(.ge.),
  a2_Symbol(.gt., >),
  a2_Symbol(.lt., <),
  a2_leq(.le.),
  a2_equiv(.eq.),
  a2_neq(.ne.),
  a2_equiv(.eqv.),
  a2_neq(.neqv.),
  a2_neq(/=),
  a2_imply(=>),
  ENDSYMBOL
};
const keyword fortran_keywords [] = {
  /* Fortran keywords */
  a2_keyword(keyword, access, action, align, allocate, assign,
assignment, backspace, blanck, block, case, close, common, contains,
continue, cycle, cyclic, data, deallocate, default, define, direct,
distribute, do, dynamic, elseif, elemental, elsewhere, else, endfile,
enddo, endif, end, entry, eor, equivalence, err, exist, exit, .false.,
file, find, forall, form, format, formatted, go, goto, hpf, if,
include, independent, inherit, inquire, interface, iolength, iostat,
mask, named, namelist, nextrec, new, nml, no, nullify, number, onto,
open, operator, pad, pause, position, print, processors, pure, read,
readwrite, realign, recl, recursive, redistribute, result, return,
rewind, select, sequential, status, stop, template, then, to, .true.,
unformatted, unit, where, while, with, write)

  /* Fortran intrinsic functions */
  a2_keyword(keyword, abs, achar, acos, ajustl, ajustr, aimag, aint,
all, allocated, anint, any, asin, associated, atan, atan2, bit_size,
btest, ceiling, char, cmplx, conjg, cos, cosh, count, cshift,
cpu_time, date_and_time, dble, digits, dim, dimag, dot_product, dprod,
dreal, eoshift, epsilon, exp, exponent, floor, fraction, huge, iachar,
iand, ibclr, ibits, ibset, ichar, ieor, index, int, ior, ishft,
ishftc, lbound, len, len_trim, lge, lgt, lle, llt, log, log10, matmul,
max, maxexponent, maxloc, maxval, merge, min, minexponent, minloc,
minval, mod, modulo, mvbits, nearest, nint, not, null, pack,
precision, present, product, radix, random_number, random_seed, range,
repeat, reshape, rrspacing, scale, scan, set_exponent, shape, sign,
sin, sinh, size, spacing, spread, sqrt, sum, system_clock, tan, tanh,
tiny, transfer, transpose, trim, ubound, unpack, verify)

  /* Fortran keywords for declarations */
  a2_keyword(keyword, character, complex, double, integer, logical,
real, allocatable, dimension, external, implicit, in, inout, intent,
intrinsic, kind, none, only, optional, out, parameter, pointer,
private, public, save, selected_int_kind, selected_real_kind, sequence,
target, type, use)

  /* The operators */
  a2_keyword(keyword, .not., .or., .and., .ge., .gt., .lt., .le.,
.eq., .ne., .eqv., .neqv.)

  ENDKEYWORD
};
const char * fortran_abbreviations []= {
  "f95", "f90", "f9", "f", "F", "\0"
};
const uchar fortran_description [] = "\
This style is to check.  \
Please report changes needed to Denis.Girou@idris.fr";
#define fortran_style_def { fortran_style, "Fortran",			\
  fortran_abbreviations, fortran_description, 				\
  CASE_INSENSITIVE, fortran_characters, fortran_characters, fortran_keywords, \
  NOSYMBOL, fortran_specials, fortran_sequences, sh_verbatims, EMPTY }
