/*
 *		Promela
 */
const symbol promela_specials [] = {
  a2_rightarrow(->),
  a2_and(&&),
  a2_or(||),
  a2_neq(!=),
  a2_equiv(==),
  a2_leq(<=),
  a2_geq(>=),
  /* ! cannot be translated as not, since it is used for "send" */
  ENDSYMBOL
};
const keyword promela_keywords [] = {
  a2_keyword(keyword, bit, bool, byte, chan)

  a2_keyword(KEYWORD_STRONG, active, assert, atomic, break, d_step,
progress, do, else, empty, enabled, fi, full, goto, hidden, if, init,
int, len, accept, mtype, nempty, never, nfull, od, of, pc_value,
printf, proctype, run, short, skip, timeout, typedef, unless, xr, xs,
priority)
  /* Preprocessor */
  a2_keyword(KEYWORD_STRONG, #define, #if, #endif)
   ENDKEYWORD
};
const char * promela_abbreviations []= {
  "pml", "\0"
};
const uchar  promela_description [] =
  "There is no way for this program to highlight send and receive primitives.";
#define promela_style_def { promela_style, "Promela", 			\
  promela_abbreviations, promela_description, 				\
  CASE_INSENSITIVE, c_characters, c_characters,	promela_keywords,	\
  NOSYMBOL, promela_specials, c_sequences, sh_verbatims, EMPTY }

/*
 *		SDL 88
 */
const sequence sdl_sequences [] = {
  a2_homo_sequence(/*, COMMENT, */),
  a2_sequence(\", PLAIN, string,	\", PLAIN),
  a2_sequence(\', PLAIN, string, 	\', PLAIN),
  a2_sequence(`(.', PLAIN, PLAIN,`.)', PLAIN),
  a2_sequence(<<, PLAIN, PLAIN,>>, PLAIN),
  ENDSEQUENCE
};
const uchar sdl_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\0'
};
const symbol sdl_specials [] = {
  a2_rightarrow(->),
  a2_imply(=>),
  a2_neq(/=),
  a2_equiv(==),
  a2_leq(<=),
  a2_geq(>=),
  a2_not(!),
  ENDSYMBOL
};
const keyword sdl_keywords [] = {
  a2_keyword(KEYWORD_STRONG, active, adding, all, alternative, any,
as, atleast, axioms, block, call, channel, comment, connect,
connection, constant, constants, create, dcl, decision, default, else,
endalternative, endblock, endchannel, endconnection, enddecision,
endgenerator, endnewtype, endoperator, endpackage, endprocedure,
endprocess, endrefinement, endselect, endservice, endstate,
endsubstructure, endsyntype, endsystem, enum, env, error, export,
exported, external, fi, finalized, for, fpar, from, gate, generator,
if, import, imported, in, inherits, input, interface, join, literal,
literals, map, nameclass, newtype, nextstate, nodelay, noequality,
none, now, offspring, operator, operators, ordering, out, output,
package, parent, priority, procedure, process, provided, redefined,
referenced, refinement, remote, reset, return, returns, revealed,
reverse, save, select, self, sender, service, set, signal, signallist,
signalroute, signalset, spelling, start, state, stop, struct,
substructure, synonym, syntype, system, task, then, this, timer, to,
type, use, variant, varstruct, via, view, viewed, virtual, with, or,
xor, and, mod, rem, not, end, macrodefinition, =>, /=, >, >=, <, <=,
+, -, //, ==>, ==, ->, :=, *, :, /, =, !)
   ENDKEYWORD
};
const char * sdl_abbreviations []= {
  "pr", "sdl", "\0"
};
const uchar  sdl_description [] = "";
#define sdl_style_def { sdl_style, "SDL-88",				\
  sdl_abbreviations, sdl_description, 					\
  CASE_INSENSITIVE, sdl_characters, sdl_characters, sdl_keywords,	\
  NOSYMBOL, sdl_specials, sdl_sequences, sh_verbatims, EMPTY }

/*
 *             VHDL
 * Implemented by Thomas.Parmelan@efrei.fr
 */
const sequence vhdl_sequences [] = {
  a2_line_sequences(comment, `--'),
  a2_sequence(\", PLAIN, string, \", PLAIN),
  a2_sequence(\', PLAIN, string, \', PLAIN),
  ENDSEQUENCE
};
const uchar vhdl_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\0'
};
const symbol vhdl_regulars [] = {
  a2_not(not), a2_or(or), a2_and(and), a2_imply(implies),
  ENDSYMBOL
};
const keyword vhdl_keywords [] = {
   a2_keyword(KEYWORD_STRONG, abs, access, after, alias, all, and,
architecture, array, assert, attribute, begin, block, body, buffer,
bus, case, component, configuration, constant, disconnect, downto,
else, elsif, end, entity, exit, file, for, function, generate,
generic, guarded, if, inout, in, is, label, library, linkage, loop,
map, mod, nand, new, next, nor, not, null, of, on, open, or, others,
out, package, port, procedure, process, range, record, register, rem,
report, return, select, severity, signal, subtype, then, to,
transport, type, units, until, use, variable, wait, when, while, with,
xor)
   ENDKEYWORD
};
const char * vhdl_abbreviations []= {
  "vhdl", "vhd", "\0"
};
const uchar  vhdl_description [] = "\
This experimental style is devoted to the VHDL modelisation language. \
Please report comments to Thomas.Parmelan@efrei.fr";
#define vhdl_style_def { vhdl_style, "VHDL",				\
  vhdl_abbreviations, vhdl_description,					\
  CASE_INSENSITIVE, vhdl_characters, vhdl_characters, vhdl_keywords,	\
  vhdl_regulars, NOSYMBOL, vhdl_sequences, sh_verbatims, EMPTY }

/*
 *             Verilog
 * Implemented by Edward S. Arthur eda@ultranet.com
 */
/*
 tried to make TICK-define or TICK-MACRO a string font as well as HASH-NUMBER
*/

const sequence verilog_sequences [] = {
  a2_homo_sequence(//,  comment,  \n),
  a2_homo_sequence(/*,  comment,  */),
  a2_sequence(\",    PLAIN, string,               \", PLAIN),

  /* We need to protect the starting $, so that they are not
     understood as "end of line" */
  a2_sequence(`$\\', KEYWORD, KEYWORD, ` ', PLAIN),
  a2_sequence(`$\\', KEYWORD, KEYWORD, `$', PLAIN),
  a2_sequence(`$\\', KEYWORD, KEYWORD, `\t', PLAIN),
  a2_sequence(`$\\', KEYWORD, KEYWORD, `;', PLAIN),
  a2_sequence(`$\\', KEYWORD, KEYWORD, `(', PLAIN),
  ENDSEQUENCE
};
/*
 added TICK and DOLLAR as a characters
*/
const uchar verilog_characters [] = {
  'A', 'Z',
  'a', 'z',
m4_changequote([, ])
  '_', '`',
m4_changequote(`, ')
  '\'', '\'',
  '$', '$', 
  '0', '0',
  '\0'
};
const symbol verilog_regulars [] = {
  a2_not(not), a2_or(or), a2_and(and), a2_imply(implies),
  ENDSYMBOL
};
/*
 *	From OVI spec 1.0
 */
const keyword verilog_keywords [] = {
   /* keywords */
   a2_keyword(KEYWORD_STRONG, always, and, assign, begin, buf, bufif0,
bufif1, case, casex, casez, cmos, deassign, default, defparam,
disable, edge, else, end, endcase, endmodule, endfunction,
endprimitive, endspecify, endtable, endtask, event, for, force,
forever, fork, function, highz0, highz1, if, initial, inout, input,
integer, join, large, macromodule, medium, module, nand, negedge,
nmos, nor, not, notif0, notif1, or, output, parameter, pmos, posedge,
primitive, pull0, pull1, pullup, pulldown, rcmos, reg, release,
repeat, rnmos, rpmos, rtran, rtranif0, rtranif1, scalared, small,
specify, specparam, strength, strong0, strong1, supply0, supply1,
table, task, time, tran, tranif0, tranif1, tri, tri0, tri1, triand,
trior, trireg, vectored, wait, wand, weak0, weak1, while, wire, wor,
xnor, xor)

  /* compiler directives */
m4_changequote([, ])m4_dnl Because that's the only to get `
m4_dnl Note that a special alternative to a2_keyword is used:
m4_dnl a2_keywords (with an `s' as in Squarre brackets).
m4_dnl This is because even recursively used macros must use the
m4_dnl same quotes.
a2_keywords(KEYWORD, [`accelerate], [`autoexpand_vectornets],
[`celldefine], [`default_nettype], [`define], [`else],
[`endcelldefine], [`endif], [`endprotect], [`endprotected],
[`expand_vectornets], [`ifdef], [`include], [`noaccelerate],
[`noexpand_vectornets], [`noremove_gatenames], [`noremove_netnames],
[`nounconnected_drive], [`protect], [`protected], [`remove_gatenames],
[`remove_netnames], [`resetall], [`timescale], [`unconnected_drive],
[`uselib])

m4_changequote(`, ')

   /* system tasks */
/* These make no sense this they are doubling the work done by
 * the sequences
   a2_keyword(KEYWORD, $bitstoreal, $countdrivers, $display, $fclose,
$fdisplay, $fmonitor, $fopen, $fstrobe, $fwrite, $finish, $getpattern,
$history, $incsave, $input, $itor, $key, $list, $log, $monitor, $monitoroff,
$monitoron, $nokey, $nolog, $printtimescale, $readmemb, $readmemh, $realtime,
$realtobits, $reset, $reset_count, $reset_value, $restart, $rtoi, $save,
$scale, $scope, $showscopes, $showvariables, $showvars, $sreadmemb,
$sreadmemh, $stime, $stop, $strobe, $time, $timeformat, $write, $vcdpluson,
$vcdplusoff, $vcdplustraceon, $vcdplustraceoff, $dumpvars)
*/

ENDKEYWORD
};

const char * verilog_abbreviations []= {
  "verilog", "v", "vh", "\0"
};

const uchar  verilog_description [] = "\
This style is devoted to the VERILOG hardware description language. \
Please send hatemail or love letters to eda@ultranet.com";
#define verilog_style_def { verilog_style, "VERILOG",			\
  verilog_abbreviations, verilog_description,				\
  CASE_SENSITIVE, verilog_characters, verilog_characters, verilog_keywords, \
  verilog_regulars, NOSYMBOL, verilog_sequences, sh_verbatims, EMPTY }

/*
 *             UNITY
 * Implemented by cottin@inf.enst.fr & demaille@inf.enst.fr
 */
const sequence unity_sequences [] = {
  a2_line_sequences(comment, //),
  a2_sequence(program , keyword_strong, label_strong, $, plain),
  ENDSEQUENCE
};
const uchar unity_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '<', '<',
  '>', '>',
  '=', '=',
  '/', '/',
  '\\', '\\',
  '|', '|',
  '\0'
};
const symbol unity_regulars [] = {
  a2_or(\\/), a2_and(/\\), a2_imply(==>),
  a2_leq(<=), a2_geq(>=), a2_implied(<==),
  ENDSYMBOL
};
const symbol unity_symbols [] = {
  a2_not(~), a2_neq(~=),
  ENDSYMBOL
};
const keyword unity_keywords [] = {
   a2_keyword(KEYWORD_STRONG, assign, co, const, constant, declare,
end, ensures, if, in, initially, invariant, program, stable,
transient, type, unless, var)

  a2_keyword(keyword, boolean)
   ENDKEYWORD
};
const char * unity_abbreviations []= {
  "unity", "\0"
};
const uchar unity_description [] = "\
This experimental style is devoted to UNITY. \
Please report comments to demaille@inf.enst.fr";
#define unity_style_def { unity_style, "Unity",				\
  unity_abbreviations, unity_description,				\
  CASE_SENSITIVE, unity_characters, unity_characters, unity_keywords,	\
  unity_regulars, unity_symbols, unity_sequences, sh_verbatims, EMPTY }
