/************************************************************************/
/*			  Modula              			   	*/
/************************************************************************/
/*
 *		Pascal
 */
const sequence pascal_sequences [] = {
  /* comments */
  a2_homo_sequence(`(*', comment_strong, `*)'), 
  a2_homo_sequence(`{', comment, `}'), 
  /* char and strings litteral */
  a2_sequence(\', PLAIN, string, \', PLAIN),
  /* Sections in the source file */
  a2_sequence(unit , keyword_STRONG, label_STRONG, $, plain),
  a2_sequence(interface , keyword_STRONG, label_STRONG, $, plain),
  a2_sequence(implementation , keyword_STRONG, label_STRONG, $, plain),
  a2_sequence(program , keyword_STRONG, label_STRONG, $, plain),
  ENDSEQUENCE
};
const uchar pascal_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\0'
};
const symbol pascal_regulars [] = {
  a2_Symbol(in, \316),
  a2_not(not),
  a2_and(and),
  a2_or(or),
  ENDSYMBOL
};
const symbol pascal_specials [] = {
  a2_rightarrow(->),
  a2_leq(<=),
  a2_geq(>=),
  a2_not_symbol(:=, plain),	/* to avoid the change of = in := */
  a2_neq(<>),
  a2_equiv(=),
  ENDSYMBOL
};
const keyword pascal_keywords [] = {
  /* Pascal keywords */
  a2_keyword(KEYWORD_STRONG, and, array, begin, constructor, const,
dec, downto, do, else, end, exit, false, file, forward, for, function,
goto, halt, if, inc, in, label, new, nil, not, object, of, or, packed,
procedure, readln, read, record, repeat, set, shl, shr, then, to,
true, type, until, uses, var, while, with, write, writeln, xor)

  /* Pascal reserved identifiers */
  a2_keyword(KEYWORD, abs, boolean, byte, div, integer, length, mod,
odd, pointer, real, registers, string, text, trunc, word)
  ENDKEYWORD
};
const char * pascal_abbreviations []= {
  "pascal", "pas", "p", "\0"
};
const uchar  pascal_description [] = "\
The standard Pascal is covered by this style. But some extension have been \
added too, hence modern Pascal programs should be correctly handled.";
#define pascal_style_def { pascal_style, "Pascal",				\
  pascal_abbreviations, pascal_description, 				\
  CASE_INSENSITIVE, pascal_characters, pascal_characters, pascal_keywords, \
  pascal_regulars, pascal_specials, pascal_sequences, sh_verbatims, EMPTY }

/*
 *		Modula-3
 */
const sequence modula3_sequences [] = {
  /* comments */
  a2_sequence(`(*', PLAIN, COMMENT, `*)', PLAIN), 
  /* strings litteral */
  a2_sequence(\", PLAIN, string, \", PLAIN),
  /* char litteral */
  a2_sequence(\', PLAIN, string, \', PLAIN),
  ENDSEQUENCE
};
const uchar modula3_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\0'
};
const symbol modula3_regulars [] = {
  a2_Symbol(IN, \316), 	/* is member of */
  a2_not(NOT),
  a2_and(AND),
  a2_or(OR),
  ENDSYMBOL
};
const symbol modula3_specials [] = {
  a2_rightarrow(->),
  a2_leq(<=),
  a2_geq(>=),
  a2_not_symbol(:=, plain),	/* to avoid the change of = in := */
  a2_neq(#),
  a2_equiv(=),
  ENDSYMBOL
};
const keyword modula3_keywords [] = {
  /* Modula 3 keywords */
  a2_keyword(KEYWORD_STRONG, AND, DO, FROM, NOT, REPEAT, UNTIL, ANY,
ELSE, GENERIC, OBJECT, RETURN, UNTRACED, ARRAY, ELSIF, IF, OF, REVEAL,
VALUE, AS, END, IMPORT, OR, ROOT, VAR, BEGIN, EVAL, IN, OVERRIDES,
SET, WHILE, BITS, EXCEPT, INTERFACE, PROCEDURE, THEN, WITH, BRANDED,
EXCEPTION, LOCK, RAISE, TO, BY, EXIT, LOOP, RAISES, TRY, CASE,
EXPORTS, METHODS, READONLY, TYPE, CONST, FINALLY, MOD, RECORD,
TYPECASE, DIV, FOR, MODULE, REF, UNSAFE)
  /* Modula 3 reserved identifiers */
  a2_keyword(KEYWORD, ABS, BYTESIZE, EXTENDED, INTEGER, MIN, NUMBER,
TEXT, ADDRESS, CARDINAL, FALSE, ISTYPE, MUTEX, ORD, TRUE, ADR,
CEILING, FIRST, LAST, NARROW, REAL, TRUNC, ADRSIZE, CHAR, FLOAT,
LONGREAL, NEW, REFANY, TYPECODE, BITSIZE, DEC, FLOOR, LOOPHOLE, NIL,
ROUND, VAL, BOOLEAN, DISPOSE, INC, MAX, NULL, SUBARRAY)
  ENDKEYWORD
};
const char * modula3_abbreviations []= {
  "m3", "\0"
};
const uchar  modula3_description [] = "";
#define modula3_style_def { modula3_style, "modula-3",			\
  modula3_abbreviations, modula3_description, 				\
  CASE_SENSITIVE, modula3_characters, modula3_characters, modula3_keywords, \
  modula3_regulars, modula3_specials, modula3_sequences, sh_verbatims, EMPTY }

/*
 *		Oberon
 */
const sequence oberon_sequences [] = {
  /* comments */
  a2_sequence(`(*', PLAIN, COMMENT, `*)', PLAIN), 
  /* strings litteral */
  a2_sequence(\", PLAIN, string,  \", PLAIN),
  /* char litteral */
  a2_sequence(\', PLAIN, string,  \', PLAIN),
  ENDSEQUENCE
};
const uchar oberon_characters [] = {
  'A', 'Z',
  'a', 'z',
  '\0'
};
const symbol oberon_regulars [] = {
  a2_Symbol(IN, \316),
  a2_not(NOT),
  a2_and(AND),
  a2_or(OR),
  ENDSYMBOL
};
const symbol oberon_specials [] = {
  a2_rightarrow(->),
  a2_leq(<=),
  a2_geq(>=),
  a2_not_symbol(:=, plain),	/* to avoid the change of = in := */
  a2_neq(#),
  a2_equiv(=),
  ENDSYMBOL
};
const keyword oberon_keywords [] = {
  a2_keyword(KEYWORD_STRONG, ARRAY, IS, TO, BEGIN, LOOP, TYPE, CASE,
MOD, UNTIL, CONST, MODULE, VAR, DIV, NIL, WHILE, DO, OF, WITH, ELSE,
OR, ELSIF, POINTER, END, PROCEDURE, EXIT, RECORD, IF, REPEAT, IMPORT,
RETURN, IN, THEN)
  /* builtins */
  a2_keyword(KEYWORD, ABS, LEN, ASH, LONG, BOOLEAN, LONGINT, BYTE,
LONGREAL, CAP, MAX, CHAR, MIN, CHR, NEW, DEC, ODD, ENTIER, ORD, EXCL,
REAL, FALSE, SET, HALT, SHORT, INC, SHORTINT, INCL, SIZE, INTEGER,
TRUE)
  ENDKEYWORD
};
const char * oberon_abbreviations []= {
  "\0"
};
const uchar  oberon_description [] = "";
#define oberon_style_def { oberon_style, "oberon",				\
  oberon_abbreviations, oberon_description, 				\
  CASE_SENSITIVE, oberon_characters, oberon_characters, oberon_keywords, \
  oberon_regulars, oberon_specials, oberon_sequences, sh_verbatims, EMPTY }
