/*
 *		caml
 */
const sequence caml_sequences [] = {
  a2_sequence(`(*', COMMENT, COMMENT,  `*)', COMMENT),
  a2_sequence(\", PLAIN, string,  \", PLAIN),
  /* a2_sequence(\', PLAIN, string,  \', PLAIN),*/
  ENDSEQUENCE
};
const uchar caml_characters_1 [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '!', '!',
  '\0'
};
const uchar caml_characters_2 [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\'', '\'',
  '!', '!',
  '\0'
};
const symbol caml_regulars [] = {
  a2_not(not),
  a2_and(and),
  a2_or(or),
  ENDSYMBOL
};
const symbol caml_specials [] = {
  a2_neq(<>),
  a2_rightarrow(->),
  a2_leq(<=),
  a2_geq(>=),
  ENDSYMBOL
};
const keyword caml_keywords [] = {
  a2_keyword(KEYWORD_STRONG, and, else, as, begin, do, done, downto,
end, exception, for, fun, function, if, in, let, match, mutable, not,
of, or, prefix, rec, then, to, try, type, value, where, while, with,
int, char, string, float, unit, list, raise, bool, vect)
   ENDKEYWORD
};
const char * caml_abbreviations []= {
  "ml", "mli", "mll", "\0"
};
const uchar  caml_description [] =
  "This style should also suit other versions of ML (caml light, SML etc.)";
#define caml_style_def { caml_style, "caml",			\
  caml_abbreviations, caml_description, CASE_SENSITIVE,		\
  caml_characters_1, caml_characters_2, caml_keywords,		\
  caml_regulars, caml_specials, caml_sequences, sh_verbatims, EMPTY }

/*
 *		common-lisp
 */
const sequence clisp_sequences [] = {
  /* comments */
  a2_line_sequences(comment, ;),
  /* function declaration */
  a2_sequence(`(defun ', keyword_strong, label_strong, ` ', PLAIN),
  /* strings*/
  a2_sequence(\", PLAIN, string, \", PLAIN),
  ENDSEQUENCE
};
const uchar clisp_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '-', '-',
  '\0'
};
const symbol clisp_regulars [] = {
  a2_Symbol(lambda, l),
  ENDSYMBOL
};
const keyword clisp_keywords [] = {
  a2_keyword(KEYWORD_STRONG, or, and, cond, let, when, if, unless,
defvar, setf, progn)
   ENDKEYWORD
};
const char * clisp_abbreviations []= {
  "el", "l", "lisp", "lsp", "clisp", "\0"
};
const uchar  clisp_description [] = "";
#define clisp_style_def { clisp_style, "common-lisp",			\
  clisp_abbreviations, clisp_description, 				\
  CASE_INSENSITIVE, clisp_characters, clisp_characters, clisp_keywords,	\
  clisp_regulars, NOSYMBOL, clisp_sequences, sh_verbatims, EMPTY }

/*
 *		Scheme as defined at 
 * http://www-swiss.ai.mit.edu/emacs-html.local/scheme_toc.html
 */
const sequence scheme_sequences [] = {
  /* comments */
  a2_line_sequences(comment, ;),
  /* multiple line comments */
  a2_sequence(#|, COMMENT, COMMENT,  |#, comment),
  /* strings*/
  a2_sequence(\", PLAIN, string, \", PLAIN),
  ENDSEQUENCE
};
const uchar scheme_characters [] = {
  'A', 'Z',
  'a', 'z',
  '!', '!',
  '#', '&',	/* # $ % & */
  '*', '+', 	/* * + */
  '-', '/',	/* - . / */
  '<', '@', 	/* < = > ? @ */
  '_', '_',
  '\0'
};
const symbol scheme_regulars [] = {
  a2_Symbol(lambda, l),
  ENDSYMBOL
};
const keyword scheme_keywords [] = {
  a2_keyword(KEYWORD_STRONG, access, define-syntax, macro, and, delay,
make-environment, begin, do, named-lambda, bkpt, fluid-let, or, case,
if, quasiquote, cond, in-package, quote, cons-stream, lambda,
scode-quote, declare, let, sequence, default-object?, let*, set!,
define, let-syntax, the-environment, define-integrable, letrec,
unassigned?, define-macro, local-declare, using-syntax,
define-structure)
  /* truth values */
  a2_keyword(keyword, #f, #t)
   ENDKEYWORD
};
const char * scheme_abbreviations []= {
  "scm", "\0"
};
const uchar scheme_description [] = "";
#define scheme_style_def { scheme_style, "scheme",			\
  scheme_abbreviations, scheme_description, 				\
  CASE_INSENSITIVE, scheme_characters, scheme_characters, scheme_keywords,\
  scheme_regulars, NOSYMBOL, scheme_sequences, sh_verbatims, EMPTY }

/*
 *		coq 5.10
 */
const sequence coq_sequences [] = {
  a2_sequence(`(*', PLAIN, COMMENT, `*)', PLAIN),
  a2_sequence(\", PLAIN, string, \", PLAIN),
  /*  "\'", "\'", FONT_PLAIN, FONT_TIMES, "\'", "\'", FONT_PLAIN,*/

  /* Definition of the section is emphasized */
  a2_sequence(Section , keyword_strong, 
               LABEL_STRONG, ., PLAIN),
  a2_sequence(End , keyword_strong,  
              LABEL_STRONG, ., PLAIN),
  ENDSEQUENCE
};
const uchar coq_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '!', '!',
  '\0'
};
const symbol coq_regulars [] = {
  a2_not(not),
  a2_and(and),
  a2_or(or),
  ENDSYMBOL
};
const symbol coq_specials [] = {
  a2_neq(<>),
  a2_rightarrow(->),
  a2_leq(<=),
  a2_geq(>=),
  ENDSYMBOL
};
const keyword coq_keywords [] = {
  a2_keyword(KEYWORD_STRONG, Require, Declare)

  a2_keyword(KEYWORD, with)
  
  a2_keyword(KEYWORD_STRONG, Variable, Inductive, CoInductive,
Fixpoint, CoFixpoint, Definition, Lemma, Theorem, Axiom, Local, Save,
Grammar, Syntax)
  /* Tactics */
  a2_keyword(KEYWORD_STRONG, Intro, Trivial, Qed, Intros, Symmetry,
Simpl, Rewrite, Apply, Elim, Assumption, Left, Cut, Case, Auto,
Unfold, Exact, Right)
  /* Types */
  a2_keyword(KEYWORD, Set)
   ENDKEYWORD
};
const char * coq_abbreviations [] = {
  "coq", "\0"
};
const uchar coq_description [] =
"This style is devoted to the Coq v 5.10 vernacular language.\n\
It is insufficiant, please send comments to demaille@inf.enst.fr.";
#define coq_style_def { coq_style, "coq-vernacular",		\
  coq_abbreviations, coq_description, 				\
  CASE_SENSITIVE, coq_characters, coq_characters, coq_keywords,	\
  coq_regulars, coq_specials, coq_sequences, sh_verbatims, EMPTY }
