/*
 *		Claire
 */
const sequence claire_sequences [] = {
  a2_sequence(//*, COMMENT, COMMENT_STRONG,   *//, COMMENT),
  a2_line_sequences(comment, ;;, //),
  a2_sequence(\", PLAIN, string,  \", PLAIN),
  a2_sequence(\', PLAIN, string,  \', PLAIN),

  /* this is strange ;) */
  a2_sequence(^[, PLAIN, label_strong, `<:', PLAIN),
  a2_sequence(^[, PLAIN, label, `[', PLAIN),
  a2_sequence(^[, PLAIN, label, `(', PLAIN),
  ENDSEQUENCE
};
const uchar claire_first_characters [] = {
  'A', 'Z',
  'a', 'z',
  '!', '!', 
  '%', '&',
  '*', '+',
  '-', '-',
  '/', '/',
  ':', ':',
  '^', '_',
  '<', '>',
  '|', '|', 
  '\0'
};
const uchar claire_following_characters [] = {
  'A', 'Z',
  'a', 'z',
  '!', '!', 
  '%', '\'', /* ' may be used like x' := x + 1 */
  '*', '+',
  '-', '-',
  '/', '/',
  ':', ':',
  '^', '_',
  '<', '>',
  '|', '|', 
  '\0'
};
const symbol claire_regulars [] = {
  a2_Symbol(forall, \"),
  a2_Symbol(exists, $),
  a2_Symbol(%, \316),
  a2_not_symbol(:=, PLAIN),
  a2_equiv(=),
  a2_neq(!=),
  a2_leq(<=),
  a2_geq(>=),
  a2_rightarrow(->),
  a2_imply(=>),
  a2_Symbol(U, \310),
  a2_not(not),
  ENDSYMBOL
};
const symbol claire_specials [] = {
  a2_Symbol({}, \306),	/* empty set */
  ENDSYMBOL
};
const keyword claire_keywords [] = {
  a2_keyword(KEYWORD_STRONG, forall, none, catch, in, as, printf,
assert, return, break, trace, else, for, case, while, until, let,
when, try, if, Zif, exists, <:, =>, ->, ::)
  ENDKEYWORD
};
const char * claire_abbreviations []= {
  "cl", "\0"
};
const uchar claire_description [] = "\
CLAIRE is a high-level functional and object-oriented language with \
advanced rule processing capabilities. It is intended to allow the \
programmer to express complex algorithms with fewer lines and in an \
elegant and readable manner. \n\
To provide a high degree of expressivity, CLAIRE uses: \n\
 - A very rich type system including type intervals and second-order types (with dual static/dynamic typing),\n\
 - Parametric classes and methods, \n\
 - An object-oriented logic with set extensions, \n\
 - Dynamic versioning that supports easy exploration of search spaces. \n\
 To achieve its goal of readability, CLAIRE uses \n\
 - set-based programming with an intuitive syntax, \n\
 - simple-minded object-oriented programming, \n\
 - truly polymorphic and parametric functional programming, \n\
 - a powerful-yet-readable extension of DATALOG to express logical conditions, \n\
 - an entity-relation approach with explicit relations, inverses, unknown values and relational\n\
 - operations. \n\
More information on claire can be found on:\n\
http://www.ens.fr/\\verb+~+laburthe/claire.html\n";
#define claire_style_def {claire_style, "claire",			\
  claire_abbreviations, claire_description, 			\
  CASE_SENSITIVE, claire_first_characters, 			\
  claire_following_characters,	claire_keywords,		\
  claire_regulars, claire_specials, claire_sequences, sh_verbatims, EMPTY }

/*
 *		Java
 */
const uchar java_characters_1 [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '#', '%',
  '\0'
};
const uchar java_characters_2 [] = {
  'A', 'Z',
  'a', 'z',
  '.', '.', 
  '_', '_',
  '#', '%',
  '\0'
};
const sequence java_sequences [] = {
  /* doc. comments */
  a2_sequence(/**, comment_strong, comment_strong,  */, comment_strong),
  a2_sequence(/*, COMMENT, COMMENT, */, COMMENT),
  a2_line_sequences(comment, //),
  a2_sequence(\", PLAIN, string, \", PLAIN),

  /* Declaration of a class */
  a2_sequence(class , keyword_strong, label_strong, ` extends ', keyword_strong),
  a2_sequence(class , keyword_strong, label_strong, {, plain),
  a2_sequence(class , keyword_strong, label_strong, $, plain),
  ENDSEQUENCE
};
const keyword java_keywords [] = {
  a2_keyword(keyword, byte, float, int, short, char, void, boolean,
double, long, null, this)

  a2_keyword(KEYWORD_STRONG, one, of, abstract, default, if, private,
throw, do, implements, protected, throws, break, import, public,
transient,else, instanceof, return, try, case, extends, catch, final,
interface, static, volatile, finally, super, while, class, native,
switch, const, for, new, synchronized, continue, goto, package)
  ENDKEYWORD
};
const char * java_abbreviations []= {
  "\0"
};
const uchar  java_description [] = "";
#define java_style_def {java_style, "java",				\
  java_abbreviations, java_description,			 		\
  CASE_SENSITIVE, java_characters_1, java_characters_2,	java_keywords,	\
  NOSYMBOL, c_specials, java_sequences, sh_verbatims, EMPTY }


/*
 *		Ada
 */
const sequence ada_sequences [] = {
  a2_line_sequences(comment, --),
  a2_sequence(\", PLAIN, string,	\", PLAIN),
  a2_sequence(\', PLAIN, string,	\', PLAIN),
  a2_sequence(\', PLAIN, string,	\'\', PLAIN),

  /* Declarations of packages */
  a2_sequence(package body , keyword_strong, 
              label_strong, ` is', keyword_strong),
  a2_sequence(package , keyword_strong, 
	      label_strong, ` is', keyword_strong),
  a2_sequence(package , keyword_strong,
              label_strong, ` renames', keyword_strong),


  /* Declaration of procedures */
  a2_sequence(procedure , keyword_strong, label, ` renames', keyword_strong),
  a2_sequence(procedure , keyword_strong, label, ` is', keyword_strong),
  a2_sequence(procedure , keyword_strong, label, ` (', plain),
  a2_sequence(procedure , keyword_strong, label, `(', plain),
  a2_sequence(procedure , keyword_strong, label, `$', plain),
  a2_sequence(procedure , keyword_strong, label, `;', plain),

  /* Declaration of functions */
  a2_sequence(function , keyword_strong, label, ` return ', keyword_strong),
  a2_sequence(function , keyword_strong, label, ` renames', keyword_strong),
  a2_sequence(function , keyword_strong, label, ` is', keyword_strong),
  a2_sequence(function , keyword_strong, label, ` (', plain),
  a2_sequence(function , keyword_strong, label, `(', plain),
  a2_sequence(function , keyword_strong, label, `$', plain),
  a2_sequence(function , keyword_strong, label, `;', plain),
  ENDSEQUENCE
};
const uchar* ada_escapes [] = {
  (ustring) "\"\"", UNULL
};
const uchar ada_1_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  ')', ')', 		/* L(1)'First is not opening either	*/
  '\0'
};
const uchar ada_2_characters [] = {
  '0', '9', 		/* S1'Length is not opening */
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\'', '\'',           /*  L'First  is not opening in ada 	*/
  '\0'
};
const symbol ada_regulars [] = {
#if 0	/* most people do not want them */
  a2_not_symbol(and then, keyword_strong),	/* protect these two */
  a2_not_symbol(or else, keyword_strong),
  a2_and(and),
  a2_or(or),
  a2_not(not),
#endif
  ENDSYMBOL
};
const symbol ada_specials [] = {
  a2_neq(!=),
  a2_equiv(==),
  a2_leq(<=),
  a2_geq(>=),
  a2_imply(=>),
  ENDSYMBOL
};
/* access procedure/function are here to protect the sequences
 * procedure/function */
const keyword ada_keywords [] = {
  a2_keyword(KEYWORD_STRONG,
abort, abs, abstract, accept, access, access function, 
access procedure, aliased, all, and, array, at, begin, body, case,
constant, declare, delay, delta, digits, do, else, elsif, end, entry,
exception, exit, for, function, generic, goto, if, in, is, limited,
loop, mod, new, not, null, of, or, others, out, package, pragma,
private, procedure, protected, raise, range, record, rem, renames,
requeue, return, reverse, select, separate, subtype, tagged, task,
terminate, then, type, until, use, when, while, with, xor)
   ENDKEYWORD
}; 
const char * ada_abbreviations []= {
  "adb", "ads", "\0"
};
const uchar  ada_description [] = "";
#define ada_style_def { ada_style, "ada",				\
  ada_abbreviations, ada_description, 					\
  CASE_INSENSITIVE, ada_1_characters, ada_2_characters, ada_keywords,	\
  ada_regulars, ada_specials, ada_sequences, EMPTY, ada_escapes }

/*
 *		Sather
 */
const sequence sather_sequences [] = {
  a2_line_sequences(comment, --),
  a2_sequence(\", PLAIN, string, \", PLAIN),
  a2_sequence(\', PLAIN, string, \', PLAIN),
  ENDSEQUENCE
};
const uchar sather_1_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\0'
};
const uchar sather_2_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '!', '!',
  '\0'
};
const keyword sather_keywords [] = {
  /* keywords */
  a2_keyword(KEYWORD_STRONG, abstract, and, any, assert, attr, bind,
break!, builtin, case, class, clusters, clusters!, cohort, const,
else, elsif, end, exception, external, false, far, fork, guard, if,
immutable, inout, include, initial, is, ITER, lock, loop, near, new,
once, or, out, par, parloop, post, pre, private, protect, quit, raise,
readonly, result, return, ROUT, SAME, self, shared, sync, then, true,
typecase, unlock, until!, void, when, while!, with, yield)

  /* Built-in classes */
 a2_keyword(KEYWORD, BOOL, CHAR, STR, INT, INTI, FLT, FLTD, FLTI)

  /* Interfacing with fortran */
  a2_keyword(KEYWORD, F_REAL, F_DOUBLE, F_INTEGER, F_COMPLEX,
F_DOUBLE_COMPLEX, F_LOGICAL, F_CHARACTER, F_REAL_ARR, F_DOUBLE_ARR,
F_INTEGER_ARR, F_COMPEX_ARR, F_DOUBLE_COMPLEX_ARR, F_LOGICAL_ARR)

  /* Interfacing with ANSI C */
  a2_keyword(KEYWORD, C_CHAR, C_UNSIGNED_CHAR_PTR, C_UNSIGNED_CHAR,
C_SIGNED_CHAR_PTR, C_SIGNED_CHAR, C_SHORT_PTR, C_SHORT, C_INT_PTR,
C_INT, C_LONG_PTR, C_LONG, C_UNSIGNED_SHORT_PTR, C_UNSIGNED_SHORT,
C_UNSIGNED_INT_PTR, C_UNSIGNED_INT, C_UNSIGNED_LONG_PTR,
C_UNSIGNED_LONG, C_FLOAT_PTR, C_FLOAT, C_DOUBLE_PTR, C_DOUBLE,
C_LONG_DOUBLE_PTR, C_LONG_DOUBLE, C_SIZE_T, C_PTR, C_PTRDIFF_T,
C_CHAR_PTR)
  ENDKEYWORD
}; 
const symbol sather_regulars [] = {
  a2_and(and),
  a2_or(or),
  ENDSYMBOL
};
const symbol sather_specials [] = {
  a2_neq(/=),
  a2_leq(<=),
  a2_geq(>=),
  ENDSYMBOL
};
const char * sather_abbreviations []= {
  "sa", "\0"
};
const uchar sather_description [] = "";
#define sather_style_def { sather_style, "sather", 				\
  sather_abbreviations, sather_description, 				\
  CASE_SENSITIVE, sather_1_characters, sather_2_characters, sather_keywords, \
  sather_regulars, sather_specials, sather_sequences, sh_verbatims, EMPTY }

/*
 *		Python
 */
const sequence python_sequences [] = {
  a2_line_sequences(comment, #),
  a2_sequence(\"\"\", PLAIN, string, \"\"\", PLAIN),
  a2_sequence(\", PLAIN, string, \", PLAIN),
  a2_sequence(\', PLAIN, string, \', PLAIN),
  ENDSEQUENCE
};
const uchar python_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\0'
};
const symbol python_regulars [] = {
  a2_not(not),
  a2_and(and),
  a2_or(or),
  ENDSYMBOL
};
const symbol python_specials [] = {
  a2_neq(<>),
  a2_neq(!=),
  a2_leq(<=),
  a2_geq(>=),
  a2_equiv(==),
  ENDSYMBOL
};
const keyword python_keywords [] = {
 a2_keyword(KEYWORD_STRONG, and, elif, from, lambda, return, break, else, global,
not, try, class, except, if, or, while, continue, exec, import, pass,
def, finally, in, print, del, is, raise, for)
  ENDKEYWORD
}; 
const char * python_abbreviations []= {
  "pythonscript", "py", "\0"
};
const uchar  python_description [] = "";
#define python_style_def { python_style, "python",				\
  python_abbreviations, python_description, 				\
  CASE_SENSITIVE, python_characters, python_characters, python_keywords, \
  python_regulars, python_specials, python_sequences, sh_verbatims, EMPTY }
