m4_divert(-1)
#
# Definition of some common stuff between c-like languages
#
m4_define(`a2_preprocessor_keywords',
`/* Preprocessor */
  a2_keyword(KEYWORD_STRONG, #include, #define, #undef, #pragma, #if, #ifdef,
#ifndef, #elif, #else, #error, #line, #ex, #endif, defined, 
# define, # include, # if, # ifdef, # endif, #import, # import, #  import,
#  define, #  include, #  if, #  ifdef, #  endif)') m4_dnl
m4_define(`c_basic_keywords',
`a2_preprocessor_keywords

  /* simple types */
  a2_keyword(KEYWORD, double, enum, void, int, long, FILE, struct, char,
signed, float, short, unsigned)

  /* core of the keywords */
  a2_keyword(KEYWORD_STRONG, inline, extern, const, register, return,
continue, for, auto, switch, typedef, union, goto, sizeof, volatile,
do, static, NULL, case, default, break, if, while, else)')m4_dnl

m4_divert`'m4_dnl 
/*
 *		C
 */
const sequence c_sequences [] = {
  /* Regular sequences */
  a2_sequence(/*, COMMENT, COMMENT, */, COMMENT),
  a2_line_sequences(comment, //),
  a2_sequence(\", PLAIN, string, \", PLAIN),
  a2_sequence(\', PLAIN, string, \', PLAIN),

  /* The special case of case :) */
  /* Note that it will not work well for case ':'... */
  a2_sequence(case , KEYWORD_STRONG, LABEL, :, PLAIN),
  ENDSEQUENCE
};
const uchar c_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '#', '%',
  '\0'
};
const symbol c_specials [] = {
  a2_rightarrow(->),
  a2_and(&&),
  a2_or(||),
  a2_neq(!=),
  a2_equiv(==),
  a2_not_symbol(<<=),
  a2_not_symbol(>>=),
  a2_leq(<=),
  a2_geq(>=),
  a2_not(!),
  ENDSYMBOL
};
const keyword c_keywords [] = {
  c_basic_keywords
  ENDKEYWORD
}; 
const char * c_abbreviations []= {
  "c", "h", "i", "\0"
};
const uchar  c_description [] = "";
#define c_style_def {c_style, "C", 				\
  c_abbreviations, c_description, 				\
  CASE_SENSITIVE, c_characters, c_characters, c_keywords,	\
  NOSYMBOL, c_specials, c_sequences, sh_verbatims, EMPTY }

/*
 *		c++
 */
const sequence cpp_sequences [] = {
  a2_sequence(/*, COMMENT, COMMENT, */, COMMENT),
  a2_line_sequences(comment, //),
  a2_sequence(\", PLAIN, string, \", PLAIN),
  a2_sequence(\', PLAIN, string, \', PLAIN),
  ENDSEQUENCE
};
const keyword cpp_keywords [] = {
  c_basic_keywords

  /* c++'s own keywords */
  a2_keyword(KEYWORD_STRONG, new, delete, this, operator, class,
public, protected, private, virtual, friend, template, dynamic,
typeof, all, except, exception, raise, raises, reraises, try, asm,
catch, overload, and, and_eq, bitand, bitor, compl, not, not_eq, or,
or_eq, xor, xor_eq)

  a2_keyword(KEYWORD, bool, const_cast, dynamic_cast, explicit, false,
mutable, namespace, reinterpret_cast, static_cast, true, typeid,
typename, using, wchar_t)
  ENDKEYWORD
};
const char * cpp_abbreviations []= {
  "c++", "h++", "C", "H", "cc", "hh", "cpp", "hpp", "cxx", "hxx", "pdb", "\0"
};
const uchar  cpp_description [] = "";
#define cpp_style_def { cpp_style, "C++",				\
  cpp_abbreviations, cpp_description, 					\
  CASE_SENSITIVE, c_characters, c_characters, cpp_keywords,		\
  NOSYMBOL, c_specials, cpp_sequences, sh_verbatims, EMPTY }

/*
 *		o2c
 */
const sequence o2c_sequences [] = {
  /* "real" sequences */
  a2_sequence(/*, COMMENT, COMMENT, */, COMMENT),
  a2_sequence(\", PLAIN, string,  \", PLAIN),
  a2_sequence(\', PLAIN, string,  \', PLAIN),

  /* Highlight special labels */
  a2_sequence(application , keyword_strong,  
              label_strong, \n, PLAIN),
  a2_sequence(class , keyword_strong,  
              label_strong, \n, PLAIN),
  a2_sequence(method body , keyword_strong,  
              label_strong, ` in ', keyword_strong),
  a2_sequence(transaction body , keyword_strong,  
              label_strong, ` in ', keyword_strong),
  a2_sequence(program body , keyword_strong,  
              label_strong, ` in ', keyword_strong),
  a2_sequence(program public , keyword_strong,  
              label_strong, ` in ', keyword_strong),
  ENDSEQUENCE
};
const keyword o2c_keywords [] = {
  c_basic_keywords

  /* o2c's own keywords */
  a2_keyword(KEYWORD_STRONG, class, inherit, public, application, modify,
end, program, body, method, o2, in, new, o2query, name, function,
abort, commit, quit, validate, schema, base)
ENDKEYWORD
};
const char * o2c_abbreviations [] = {
  "o2", "\0"
};
const uchar  o2c_description [] = "";
#define o2c_style_def { o2c_style, "o2c",				\
  o2c_abbreviations, o2c_description, 					\
  CASE_SENSITIVE, c_characters, c_characters, o2c_keywords,		\
  NOSYMBOL, c_specials, o2c_sequences, sh_verbatims, EMPTY }


/*
 *              objc
 */
const uchar objc_characters [] = {
  '@', '@',
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '#', '%',
  '\0'
};
const sequence objc_sequences [] = {
  a2_sequence(/*, COMMENT, COMMENT, */, COMMENT),
  a2_line_sequences(comment, //),
  a2_sequence(\", PLAIN, string, \", PLAIN),
  a2_sequence(\', PLAIN, string, \', PLAIN),
  a2_sequence(^+, KEYWORD_STRONG, KEYWORD_STRONG, {, plain),
  a2_sequence(^+, KEYWORD_STRONG, KEYWORD_STRONG, ;, plain),
  a2_sequence(^-, KEYWORD_STRONG, KEYWORD_STRONG, {, plain),
  a2_sequence(^-, KEYWORD_STRONG, KEYWORD_STRONG, ;, plain),
  ENDSEQUENCE
};
const keyword objc_keywords [] = {
  c_basic_keywords

  /* objc's simple type */
  a2_keyword(KEYWORD, id)

  /* objc's own keywords */
  a2_keyword(KEYWORD_STRONG, @interface, @end, @implementation, @protocol,
@class, @public, @protected, @private, in, out, inout, bycopy, oneway, self,
_cmd, super, @selector, @encode, @defs)
  ENDKEYWORD
};
const char * objc_abbreviations []= {
  "objc", "m", "\0"
};
const uchar  objc_description [] = "";
#define objc_style_def { objc_style, "ObjectiveC",    		\
  objc_abbreviations, objc_description,         		\
  CASE_SENSITIVE, objc_characters, c_characters, objc_keywords,	\
  NOSYMBOL, c_specials, objc_sequences, sh_verbatims, EMPTY }


/*
 *		Octave/MATLAB added by C.P. Earls March 1997
 */
const sequence octave_sequences [] = {
  a2_line_sequences(comment, #),
  a2_sequence(\", PLAIN, string, \", PLAIN),
  ENDSEQUENCE
};
const uchar octave_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\0'
};
const symbol octave_regulars [] = {
  a2_not(not),
  a2_and(and),
  a2_or(or),
  ENDSYMBOL
};
const symbol octave_specials [] = {
  a2_neq(<>),
  a2_neq(!=),
  a2_leq(<=),
  a2_geq(>=),
  a2_equiv(==),
  ENDSYMBOL
};
const keyword octave_keywords [] = {
 a2_keyword(KEYWORD_STRONG, all_va_args, endwhile, break, for, case, function,
 catch, global, continue, gplot, else, gsplot, elseif, if, end, otherwise,
 end_try_catch, return, end_unwind_protect, switch, endfor, try, endfunction,
 unwind_protect, endif, unwind_protect_cleanup, endswitch, while)
  ENDKEYWORD
};

const char * octave_abbreviations []= {
  "octavescript", "m", "\0"
};
const uchar  octave_description [] = "";
#define octave_style_def { octave_style, "octave",			\
  octave_abbreviations, octave_description, 				\
  CASE_SENSITIVE, octave_characters, octave_characters, octave_keywords, \
  octave_regulars, octave_specials, octave_sequences, sh_verbatims, EMPTY }
