/*
 *		sh
 */
const sequence sh_sequences [] = { 
  a2_line_sequences(COMMENT, #),
  a2_sequence(\", PLAIN, string, \", PLAIN),
  a2_sequence(\', PLAIN, string, \', PLAIN),
  ENDSEQUENCE
};
const uchar* sh_verbatims [] = {
  (ustring) "\\\\", (ustring) "\\\"", (ustring) "\\\'", UNULL
};
const uchar sh_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '-', '-',
  '/', '/', 
  '$', '$', 
  '\0'
};
const uchar sh_following_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '/', '/', 
  '$', '$', 
  '#', '#', /* to avoid $# be understood as the beginning of a comment */
  '\0'
};
const keyword sh_keywords [] = {
  a2_keyword(KEYWORD_STRONG, break, case, cd, continue, done, do, echo, elif,
else, esac, eval, exec, exit, export, fi, for, if, in, readonly, read,
return, set, shift, stop, test, then, times, trap, type, umask, unset,
until, wait, while)
   ENDKEYWORD
};
const char * sh_abbreviations []= {
  "Bourneshell", "c-shell", "jsh", "csh", "ksh", "bash", "shell", "\0"
};
const uchar  sh_description [] = "";
#define sh_style_def { sh_style, "sh",					\
  sh_abbreviations, sh_description, 				\
  CASE_SENSITIVE, sh_characters, sh_following_characters,   	\
  sh_keywords, NOSYMBOL, NOSYMBOL, sh_sequences, sh_verbatims, EMPTY }

/*
 *		zsh
 */
const symbol zsh_regulars [] = {
  a2_and(&&),
  a2_or(||),
  a2_oplus(^^),
  a2_neq(!=),
  a2_equiv(==),
  a2_leq(<=),
  a2_geq(>=),
  ENDSYMBOL
};
const symbol zsh_specials [] = {
  a2_not(!),
  ENDSYMBOL
};
const keyword zsh_keywords [] = {
   a2_keyword(KEYWORD_STRONG, alias, autoload, bg, bindkey, break,
builtin, bye, cd, chdir, compctl, continue, declare, dirs, disable,
disown, echo, echotc, emulate, enable, eval, exit, export, false, fc,
fg, functions, getln, getopts, hash, history, integer, jobs, kill,
let, limit, local, log, logout, popd, print, pushd, pushln, pwd, r,
read, readonly, rehash, return, sched, set, setopt, shift, source,
suspend, test, times, trap, true, ttyctl, type, typeset, ulimit,
umask, inalias, unfunction, unhash, unlimit, unset, unsetopt, vared,
wait, whence, where, which, noglob, nocorrect, exec, command, if,
then, elif, fi, for, in, do, done, foreach, end, while, until, repeat,
case, esac, select, function, time, coproc)
  ENDKEYWORD
};
const char * zsh_abbreviations []= {
  "\0"
};
const uchar  zsh_description [] = "";
#define zsh_style_def { zsh_style, "zsh",				\
  zsh_abbreviations, zsh_description, 					\
  CASE_SENSITIVE, sh_characters, sh_following_characters,	       	\
  zsh_keywords, zsh_regulars, zsh_specials, sh_sequences, sh_verbatims, EMPTY }

/*
 *		Perl
 */
const sequence perl_sequences [] = {
  a2_line_sequences(COMMENT, #),
  a2_sequence(\", PLAIN, string,  \", PLAIN),
  a2_sequence(\', PLAIN, string,  \', PLAIN),
  a2_sequence(`use ', keyword_strong, label_strong + dec1, ` ', plain),
  a2_sequence(`sub ', keyword_strong, label_strong + dec1, `(', plain),
  a2_sequence(`sub ', keyword_strong, label_strong + dec1, ` ', plain),
  a2_sequence(`&', keyword_strong, label_strong + dec1, ` ', plain),
  a2_sequence(`&', keyword_strong, label_strong + dec1, `;', plain),
  a2_sequence(`&', keyword_strong, label_strong + dec1, `(', plain),
  a2_homo_sequence(^=, comment_strong, ^=cut),
  ENDSEQUENCE
};
const uchar perl_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\0'
};
const keyword perl_keywords [] = {
   a2_keyword(KEYWORD_STRONG, if, until, while, elsif, else, unless, for,
foreach, last, goto, next, redo, return, local, sub, do, dump, use,
package, eval, my, BEGIN, END, CORE, __FILE__, __LINE__, abs,
accept, alarm, and, atan, bind, binmode, bless, caller, chdir, chmod,
chown, chr, chroot, close, closedir, cmp, connect, continue, cos,
crypt, dbmclose, dbmopen, die, endgrent, endhostent, endnetent,
endprotoent, endpwent, endservent, eof, eq, exec, exit, exp, fcntl,
fileno, flock, fork, formline, ge, getc, getgrent, getgrgid, getgrnam,
gethostbyaddr, gethostbyname, gethostent, getlogin, getnetbyaddr,
getnetbyname, getnetent, getpeername, getpgrp, getppid, getpriority,
getprotobyname, getprotobynumber, getprotoent, getpwent, getpwnam,
getpwuid, getservbyname, getservbyport, getservent, getsockname,
getsockopt, glob, gmtime, gt, hex, index, int, ioctl, join, kill, lc,
lcfirst, le, length, link, listen, localtime, log, lstat, lt, mkdir,
msgctl, msgget, msgrcv, msgsnd, ne, not, oct, open, opendir, or, ord,
pack, pipe, quotemeta, rand, read, readdir, readline, readlink,
readpipe, recv, ref, rename, require, reset, reverse, rewinddir,
rindex, rmdir, seek, seekdir, select, semctl, semget, semop, send,
setgrent, sethostent, setnetent, setpgrp, setpriority, setprotoent,
setpwent, setservent, setsockopt, shmctl, shmget, shmread, shmwrite,
shutdown, sin, sleep, socket, socketpair, sprintf, sqrt, srand, stat,
substr, symlink, syscall, sysread, system, syswrite, tell, telldir,
time, times, truncate, uc, ucfirst, umask, unlink, unpack, utime,
values, vec, wait, waitpid, wantarray, warn, write, x, xor, print)
   ENDKEYWORD
};
const char * perl_abbreviations []= {
  "pl", "pm", "\0"
};
const uchar  perl_description [] = "";
#define perl_style_def { perl_style, "perl", 				\
  perl_abbreviations, perl_description, 				\
  CASE_SENSITIVE, perl_characters, perl_characters, perl_keywords,	\
  NOSYMBOL, NOSYMBOL, perl_sequences, sh_verbatims, EMPTY }
