/************************************************************************/
/*			Misceleanous					*/
/************************************************************************/
/*
 *		mail
 */
const sequence mail_sequences [] = { 
  /* We don't want these to be comments, because of --strip */
  a2_sequence(`^> ', PLAIN, keyword, $, keyword),
  a2_sequence(^Subject:, keyword_strong, label_strong | TAG1, $, plain),
  a2_sequence(^From:, keyword_strong, label_strong | TAG2, $, plain),
  a2_sequence(^X-Sun-Data-Name:, keyword_strong, label, $, plain),

  /* headers of big interest */
  a2_line_sequences(comment_strong, ^To:, ^Date:, ^Date, ^Lines:,
^Organization:, ^Address:),

  /* headers of small interest */
  a2_line_sequences(comment, ^Approved:, ^Article-, ^Autoforwarded:,
^Buzzword, ^Content-Identifier:, ^Content-Transfer-Encoding:,
^Content-Type:, ^Distribution: , ^Email-Version:, ^Errors-To:, ^From,
^Fruit, ^In-Reply-To:, ^Lat, ^Libi, ^Message-, ^Message-Id:,
^Mime-Version:, ^Mmdf, ^Mood, ^Newsgroups: , ^Network-, ^Neuron,
^Nntp-Posting-Host:, ^Organisation:, ^Origin, ^Original, ^Path: ,
^Phase, ^Phone:, ^Post, ^Really-, ^Received:, ^References: , ^Relay-,
^Reply-To:, ^Resent, ^Return, ^Return-Path:, ^Sender: , ^Sensitivity:,
^Sent:, ^Source, ^Status:, ^Sun, ^Telefax:, ^Telephone,
^Transport-Options:, ^Ua-Content-Id:, ^Via:, ^Warnings-To:,
^X-Char-Esc:, ^X-Comment:, ^X-Face, ^X-Facsimile:, ^X-Filter:,
^X-How-To-Reach-Us:, ^X-Hpmail, ^X-Lines, ^X-Lines:, ^X-Location,
^X-Mailer:, ^X-Mts:, ^X-Newsreader:, ^X-Sent-By-Nmail-V, ^X-Sequence:,
^X-Sun-Charset:, ^X-Sun-Content-Lines:, ^X-Sun-Data-Description:,
^X-Sun-Data-Type:, ^X-Telephone:, ^X-Vm-V5-Data:, ^X400-Content-Type:,
^X400-Mts-Identifiers:, ^X400-Received:, ^X400-Recipients:, ^Xref:),

  ENDSEQUENCE
};
const uchar mail_characters [] = {
  'A', 'Z',
  'a', 'z',
  ':', ':',
  '_', '_',
  '-', '-',
  '\0'
};
const keyword mail_keywords [] = {
  ENDKEYWORD
};
const symbol mail_specials [] = {
  a2_symbol(=E0, `', PLAIN),
  a2_symbol(=E1, `', PLAIN),
  a2_symbol(=E2, `', PLAIN),
  a2_symbol(=E8, `', PLAIN),
  a2_symbol(=E9, `', PLAIN),
  a2_symbol(=EA, `', PLAIN),
  a2_symbol(=F4, `', PLAIN),
  a2_symbol(=F9, `', PLAIN),
  a2_symbol(=\n, `', INVISIBLE),
  ENDSYMBOL
};
const char * mail_abbreviations []= {
  "news", "mailfolder", "\0"
};
const uchar  mail_description [] = "\
To use from elm and others, it is better to specify -gEmail, \
since the file sent to printer is no longer trully a mailfolder.  \
This style also suits to news.  --strip options are also useful \
(they strip \"useless\" headers).";
#define mail_style_def { mail_style, "mail",	  			\
  mail_abbreviations, mail_description, 				\
  CASE_SENSITIVE, mail_characters, mail_characters, mail_keywords,	\
  NOSYMBOL, mail_specials, mail_sequences, EMPTY, EMPTY }

/*
 *		Postscript
 */
const sequence postscript_sequences [] = { 
  a2_sequence(%!, comment, comment_strong, $, comment),
  a2_sequence(%%, comment, comment_strong, $, comment),
  a2_sequence(%,  comment, comment, $, comment),
  a2_sequence(`(', plain, string, `)', plain),
  ENDSEQUENCE
};
const uchar* postscript_verbatims [] = {
  (ustring) "\\\\", (ustring) "\\(", (ustring) "\\)", UNULL
};
const uchar postscript_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\\', '\\',
  '\0'
};
const keyword postscript_keywords [] = {
  a2_keyword(KEYWORD_STRONG, add, arc, array, begin, bind, clip,
charpath, closepath, copy, currentdict, currentfont, curveto, def,
definefont, dict, div, dup, end, eq, exch, fill, for, forall,
findfont, get, ge, grestore, gsave, gt, if, ifelse, index, known,
length, le, lineto, lt, moveto, mul, neg, newpath, pop, put, restore,
rlineto, rmoveto, roll, rotate, save, scale, scalefont,
setcachedevice, setfont, setgray, setlinewidth, show, showpage,
stringwidth, stroke, sub, translate, where, xor)

  a2_keyword(keyword, true, false)
   ENDKEYWORD
};
const symbol postscript_regulars [] = {
#if 0
  a2_and(&&),
  a2_or(||),
  a2_oplus(^^),
#endif
  a2_leq(le),
  a2_geq(ge),
  a2_equiv(eq),
  a2_neq(ne),
  ENDSYMBOL
};
const char * postscript_abbreviations []= {
  "postscript", "ps", "\0"
};
const uchar  postscript_description [] = "";
#define postscript_style_def { postscript_style, "PostScript",		\
  postscript_abbreviations, postscript_description,			\
  CASE_SENSITIVE, postscript_characters, postscript_characters,		\
  postscript_keywords, postscript_regulars, NOSYMBOL, postscript_sequences,\
  EMPTY, postscript_verbatims }
