/*
 *		prescript
 */
const sequence prescript_sequences [] = { 
  /* Dynamic switch of the encoding */
  a2_sequence(\\\\encoding{, invisible, 
              encoding_tag | invisible, }, invisible),

  /* Skip portions destined to LaTeX only */
  a2_sequence(%%prescript:skip, INVISIBLE,
  INVISIBLE,
  %%prescript:piks$, INVISIBLE),
  a2_line_sequences(invisible, %),

  /* lists */
  a2_sequence(\\\\item[, 	INVISIBLE, label, ], INVISIBLE),
  /* titles */
  a2_sequence(\\\\section{,	INVISIBLE, label_strong, }, INVISIBLE),
  a2_sequence(\\\\subsection{, 	INVISIBLE, LABEL, }, INVISIBLE),
  a2_sequence(\\\\subsubsection{, INVISIBLE, LABEL, }, INVISIBLE),
  /* header and footer. Not supported this way by LaTeX */
  a2_sequence(\\\\header{, INVISIBLE, TAG1|INVISIBLE,   }$, INVISIBLE),
  a2_sequence(\\\\footer{, INVISIBLE, TAG2|INVISIBLE,   }$, INVISIBLE),
  /* change of font */
  a2_sequence(\\\\textbf{, INVISIBLE, KEYWORD_STRONG,   }, INVISIBLE),
  a2_sequence(\\\\textit{, INVISIBLE, KEYWORD, }, INVISIBLE),
  a2_sequence(\\\\textbi{, INVISIBLE, keyword_strong,   }, INVISIBLE),
  a2_sequence(\\\\textrm{, INVISIBLE, STRING,  }, INVISIBLE),
  a2_sequence(\\\\textsy{, INVISIBLE, SYMBOL, }, INVISIBLE),
  a2_sequence(\\\\texttt{, INVISIBLE, PLAIN,}, INVISIBLE),
  a2_sequence(\\\\keyword{, invisible, keyword, }, invisible),
  a2_sequence(\\\\Keyword{, invisible, keyword_strong, }, invisible),
  a2_sequence(\\\\comment{, invisible, comment, }, invisible),
  a2_sequence(\\\\Comment{, invisible, comment_strong, }, invisible),
  a2_sequence(\\\\label{, invisible, label, }, invisible),
  a2_sequence(\\\\Label{, invisible, label_strong, }, invisible),
  a2_sequence(\\\\string{, invisible, string, }, invisible),

  /* change of font but invisible in LaTeX */
  a2_sequence(\\\\magicbf{, INVISIBLE, KEYWORD_STRONG,   }, INVISIBLE),
  a2_sequence(\\\\magicit{, INVISIBLE, KEYWORD, }, INVISIBLE),
  a2_sequence(\\\\magicbi{, INVISIBLE, KEYWORD_STRONG,   }, INVISIBLE),
  a2_sequence(\\\\magicrm{, INVISIBLE, STRING,  }, INVISIBLE),
  a2_sequence(\\\\magicsy{, INVISIBLE, SYMBOL, }, INVISIBLE),
  a2_sequence(\\\\magictt{, INVISIBLE, PLAIN,}, INVISIBLE),
  /* Verbatims */
  a2_sequence(\\\\verb+, INVISIBLE, PLAIN, +, INVISIBLE),
  a2_sequence(\\\\verb!, INVISIBLE, PLAIN, !, INVISIBLE),
  a2_sequence(\\\\verb|, INVISIBLE, PLAIN, |, INVISIBLE),
  a2_sequence(\\\\verb#, INVISIBLE, PLAIN, #, INVISIBLE),
  a2_sequence(\\\\verb=, INVISIBLE, PLAIN, =, INVISIBLE),
  ENDSEQUENCE
};
const uchar prescript_chars_1 [] = {
  'A', 'Z',
  'a', 'z',
  '\\', '\\',
  '_', '_',
  '\0'
};
const uchar prescript_chars_2 [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\0'
};
const symbol prescript_regulars [] = {
  /* Characters from LaTeX */
  a2_Symbol(\\to, \256),
  a2_Symbol(\\item, \267),
  a2_symbol(\\backslash, \\, PLAIN),
  /* Things that must disapear */
  a2_invisible(\\begin{document}, \\end{document},
   \\begin{itemize}, \\end{itemize},
   \\begin{enumerate}, \\end{enumerate},
   \\begin{description}, \\end{description})

  /*
   * This is taken from the correspondance between font symbol
   * and LaTeX commands
   */
  /* 34: universal */   	a2_Symbol(\\forall, \42),
  /* 36: existential */ 	a2_Symbol(\\exists, \44),
  /* 39: suchthat */    	a2_Symbol(\\suchthat, \47),
  /* 64: congruent */   	a2_Symbol(\\cong, \100),
  /* 65: Alpha */       	a2_Symbol(\\Alpha, \101),
  /* 66: Beta */        	a2_Symbol(\\Beta, \102),
  /* 67: Chi */ 		a2_Symbol(\\Chi, \103),
  /* 68: Delta */       	a2_Symbol(\\Delta, \104),
  /* 69: Epsilon */     	a2_Symbol(\\Epsilon, \105),
  /* 70: Phi */ 		a2_Symbol(\\Phi, \106),
  /* 71: Gamma */       	a2_Symbol(\\Gamma, \107),
  /* 72: Eta */ 		a2_Symbol(\\Eta, \110),
  /* 73: Iota */        	a2_Symbol(\\Iota, \111),
  /* 74: theta1 */      	a2_Symbol(\\vartheta, \112),
  /* 75: Kappa */       	a2_Symbol(\\Kappa, \113),
  /* 76: Lambda */      	a2_Symbol(\\Lambda, \114),
  /* 77: Mu */  		a2_Symbol(\\Mu, \115),
  /* 78: Nu */  		a2_Symbol(\\Nu, \116),
  /* 79: Omicron */     	a2_Symbol(\\Omicron, \117),
  /* 80: Pi */  		a2_Symbol(\\Pi, \120),
  /* 81: Theta */       	a2_Symbol(\\Theta, \121),
  /* 82: Rho */ 		a2_Symbol(\\Rho, \122),
  /* 83: Sigma */       	a2_Symbol(\\Sigma, \123),
  /* 84: Tau */ 		a2_Symbol(\\Tau, \124),
  /* 85: Upsilon */     	a2_Symbol(\\Upsilon, \125),
  /* 86: sigma1 */      	a2_Symbol(\\varsigma, \126),
  /* 87: Omega */       	a2_Symbol(\\Omega, \127),
  /* 88: Xi */ 		 	a2_Symbol(\\Xi, \130),
  /* 89: Psi */ 		a2_Symbol(\\Psi, \131),
  /* 90: Zeta */        	a2_Symbol(\\Zeta, \132),
  /* 92: therefore */   	a2_Symbol(\\therefore, \134),
  /* 94: perpendicular */       a2_Symbol(\\perp, \136),
  /* 96: radicalex */   	a2_Symbol(\\radicalex, \140),
  /* 97: alpha */       	a2_Symbol(\\alpha, \141),
  /* 98: beta */        	a2_Symbol(\\beta, \142),
  /* 99: chi */ 	 	a2_Symbol(\\chi, \143),
  /* 100: delta */      	a2_Symbol(\\delta, \144),
  /* 101: epsilon */    	a2_Symbol(\\epsilon, \145),
  /* 102: phi */        	a2_Symbol(\\phi, \146),
  /* 103: gamma */      	a2_Symbol(\\gamma, \147),
  /* 104: eta */        	a2_Symbol(\\eta, \150),
  /* 105: iota */       	a2_Symbol(\\iota, \151),
  /* 106: phi1 */       	a2_Symbol(\\varphi, \152),
  /* 107: kappa */      	a2_Symbol(\\kappa, \153),
  /* 108: lambda */     	a2_Symbol(\\lambda, \154),
  /* 109: mu */	 		a2_Symbol(\\mu, \155),
  /* 110: nu */	 		a2_Symbol(\\nu, \156),
  /* 111: omicron */    	a2_Symbol(\\omicron, \157),
  /* 112: pi */	 		a2_Symbol(\\pi, \160),
  /* 113: theta */      	a2_Symbol(\\theta, \161),
  /* 114: rho */        	a2_Symbol(\\rho, \162),
  /* 115: sigma */      	a2_Symbol(\\sigma, \163),
  /* 116: tau */        	a2_Symbol(\\tau, \164),
  /* 117: upsilon */    	a2_Symbol(\\upsilon, \165),
  /* 118: omega1 */     	a2_Symbol(\\varpi, \166),
  /* 119: omega */      	a2_Symbol(\\omega, \167),
  /* 120: xi */	 		a2_Symbol(\\xi, \170),
  /* 121: psi */        	a2_Symbol(\\psi, \171),
  /* 122: zeta */       	a2_Symbol(\\zeta, \172),
  /* 126: similar */    	a2_Symbol(\\sim, \176),
  /* 161: Upsilon1 */   	a2_Symbol(\\varUpsilon, \241),
  /* 162: minute */     	a2_Symbol(\\prime, \242),
  /* 163: lessequal */  	a2_Symbol(\\leq, \243),
  /* 165: infinity */   	a2_Symbol(\\infty, \245),
  /* 166: florin **********/   	a2_Symbol(\\florin, \246),
  /* 167: club */       	a2_Symbol(\\clubsuit, \247),
  /* 168: diamond */    	a2_Symbol(\\diamondsuit, \250),
  /* 169: heart */      	a2_Symbol(\\heartsuit, \251),
  /* 170: spade */      	a2_Symbol(\\spadesuit, \252),
  /* 171: arrowboth */  	a2_Symbol(\\leftrightarrow, \253),
  /* 172: arrowleft */  	a2_Symbol(\\leftarrow, \254),
  /* 173: arrowup */    	a2_Symbol(\\uparrow, \255),
  /* 174: arrowright */ 	a2_Symbol(\\rightarrow, \256),
  /* 175: arrowdown */  	a2_Symbol(\\downarrow, \257),
  /* 176: degree ********/     	a2_Symbol(\\circ, \260),
  /* 177: plusminus */		a2_Symbol(\\pm, \261),
  /* 179: greaterequal */       a2_Symbol(\\geq, \263),
  /* 180: multiply */   	a2_Symbol(\\times, \264),
  /* 181: proportional */       a2_Symbol(\\propto, \265),
  /* 182: partialdiff */        a2_Symbol(\\partial, \266),
  /* 183: bullet */    		a2_Symbol(\\bullet, \267),
  /* 184: divide */     	a2_Symbol(\\div, \270),
  /* 185: notequal */   	a2_Symbol(\\neq, \271),
  /* 186: equivalence */        a2_Symbol(\\equiv, \272),
  /* 187: approxequal */        a2_Symbol(\\approx, \273),
  /* 188: ellipsis */   	a2_Symbol(\\ldots, \274),
  /* 190: arrowhorizex */	a2_Symbol(---, \276),
  /* 191: carriagereturn */     a2_Symbol(\\carriagereturn, \277),
  /* 192: aleph */      	a2_Symbol(\\aleph, \300),
  /* 193: Ifraktur */   	a2_Symbol(\\Im, \301),
  /* 194: Rfraktur */   	a2_Symbol(\\Re, \302),
  /* 195: weierstrass */        a2_Symbol(\\wp, \303),
  /* 196: circlemultiply */     a2_Symbol(\\otimes, \304),
  /* 197: circleplus */ 	a2_Symbol(\\oplus, \305),
  /* 198: emptyset */  		a2_Symbol(\\emptyset, \306),
  /* 199: intersection */       a2_Symbol(\\cap, \307),
  /* 200: union */      	a2_Symbol(\\cup, \310),
  /* 201: propersuperset */     a2_Symbol(\\supset, \311),
  /* 202: reflexsuperset */     a2_Symbol(\\supseteq, \312),
  /* 203: notsubset */  	a2_Symbol(\\not\\subset, \313),
  /* 204: propersubset */       a2_Symbol(\\subset, \314),
  /* 205: reflexsubset */       a2_Symbol(\\subseteq, \315),
  /* 206: element */    	a2_Symbol(\\in, \316),
  /* 207: notelement */ 	a2_Symbol(\\not\\in, \317),
  /* 208: angle */      	a2_Symbol(\\angle, \320),
  /* 209: gradient */   	a2_Symbol(\\nabla, \321),
  /* 210: registerserif *****/  a2_Symbol(\\varregister, \322),
  /* 211: copyrightserif ****/  a2_Symbol(\\varcopyright, \323),
  /* 212: trademarkserif ****/  a2_Symbol(\\vartrademark, \324),
  /* 213: product */    	a2_Symbol(\\prod, \325),
  /* 214: radical */    	a2_Symbol(\\surd, \326),
  /* 215: dotmath */    	a2_Symbol(\\cdot, \327),
  /* 216: logicalnot */ 	a2_Symbol(\\not, \330),
  /* 217: logicaland */ 	a2_Symbol(\\wedge, \331),
  /* 218: logicalor */  	a2_Symbol(\\vee, \332),
  /* 219: arrowdblboth */       a2_Symbol(\\Leftrightarrow, \333),
  /* 220: arrowdblleft */       a2_Symbol(\\Leftarrow, \334),
  /* 221: arrowdblup */ 	a2_Symbol(\\Uparrow, \335),
  /* 222: arrowdblright */      a2_Symbol(\\Rightarrow, \336),
  /* 223: arrowdbldown */       a2_Symbol(\\Downarrow, \337),
  /* 224: lozenge *****/	a2_Symbol(\\lozenge, \340),
  /* 225: angleleft */  	a2_Symbol(\\langle, \341),
  /* 226: registersans ****/   	a2_Symbol(\\register, \342),
  /* 227: copyrightsans ****/  	a2_Symbol(\\copyright, \343),
  /* 228: trademarksans ****/  	a2_Symbol(\\trademark, \344),
  /* 229: summation */  	a2_Symbol(\\sum, \345),
  /* 233: bracketlefttp */      a2_Symbol(\\lceil, \351),
  /* 235: bracketleftbt */      a2_Symbol(\\lfloor, \353),
  /* 240: .notdef */    	a2_Symbol(\\apple, \360),
  /* 241: angleright */ 	a2_Symbol(\\rangle, \361),
  /* 242: integral */   	a2_Symbol(\\int, \362),
  /* 249: bracketrighttp */     a2_Symbol(\\rceil, \371),
  /* 251: bracketrightbt */     a2_Symbol(\\rfloor, \373),
  ENDSYMBOL
};
const symbol prescript_specials [] = {
  /* There is no mode math in prescript */
  a2_symbol(\\$, $, 	PLAIN),
  a2_invisible1($),
  a2_symbol(\\_, _,	PLAIN),
  a2_symbol(\\%, %, 	PLAIN),
  a2_symbol(\\&, &, 	PLAIN),
  a2_symbol(\\#, #, 	PLAIN),
  /*
   * This is taken from the correspondance between font symbol
   * and LaTeX commands
   */
  /* 35: numbersign   		a2_Symbol(\\#, \43),*/
  /* 37: percent      		a2_Symbol(\\%, \45),*/
  /* 38: ampersand   		a2_Symbol(\\&, \46),*/
  /* 40: parenleft */   	a2_symbol(`\\(', `(', plain),
  /* 41: parenright */  	a2_symbol(`\\)', `)', plain),
  /* 91: bracketleft */ 	a2_symbol(\\[, [, plain),
  /* 93: bracketright */        a2_symbol(\\], ], plain),
  /* 95: underscore		a2_symbol(\\_, _, plain),*/
  /* 123: braceleft */  	a2_symbol(\\{, {, plain),
  /* 124: bar */        	a2_symbol(\\|, |, plain),
  /* 125: braceright */ 	a2_symbol(\\}, }, plain),
  /* 189: arrowvertex		a2_symbol(\\|, \275),*/
  ENDSYMBOL
};
const char *  prescript_abbreviations [] = {
  "prescript", "biftex", "bif", "pre", "ptf", "\0"
};
const uchar prescript_description [] = "\
This is prescript, a language of description of textual pages. \
It provides by the use of LaTeX like commands, a way to describe the \
pages that this program should produce. It can be a very good choice of \
destination language for people who want to produce text to print \
(e.g. pretty-printing, automating documentation etc.) \
but who definitely do not want to learn postscript, nor to require \
the use of LaTeX.\
\n\
It is also known as BifTeX (Basic Instruction From LaTeX), of ptf \
(Poor Text Format).\
\n\
Symbol translation is always enabled in this mode.";
#define prescript_style_def { prescript_style, "PreScript", 		\
  prescript_abbreviations, prescript_description, 			\
  CASE_SENSITIVE, prescript_chars_1, prescript_chars_2, NOKEYWORDS,	\
  prescript_regulars, prescript_specials, prescript_sequences, EMPTY, EMPTY }
