/*
 * styles.h
 *
 * definition of the languages style sheets
 * Copyright (c) 1988, 89, 90, 91, 92, 93 Miguel Santana
 * Copyright (c) 1995, 96, 97 Akim Demaille, Miguel Santana
 * $Id: styles.h,v 1.18.2.1 1997/04/30 10:21:11 demaille Exp $
 */

/*
 * This file is part of a2ps.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _STYLES_H_
#define _STYLES_H_
#include "faces.h"

typedef enum { 
  unknown_style = -2,
  plain_style = -1, 

  ada_style, c_style, cpp_style, caml_style, claire_style, coq_style,
  clisp_style, eiffel_style, fortran_style, initora_style, java_style,
  lace_style, m68000_style, mail_style, modula3_style, o2c_style,
  oberon_style, objc_style, octave_style, oracle_style, pascal_style,
  perl_style, plsql_style, postscript_style, prescript_style,
  prolog_style, promela_style, python_style, sather_style, scheme_style,
  sdl_style, sh_style, sql_style, sql92_style, tcl_style, tk_style,
  unity_style, verilog_style, vhdl_style, zsh_style

} STYLE;

typedef enum { 
  CASE_SENSITIVE, CASE_INSENSITIVE
} CASE_SENSITIVENESS; 

typedef struct keyword {
  uchar * theKeyword;
  FACE theFont;
} keyword;

typedef struct symbol {
  uchar * theKeyword;
  uchar * theSymbol;
  FACE theFont;
} symbol;

typedef struct sequence {
  uchar * theOpening;
  FACE theOpeningFont;
  FACE theInsideFont;
  uchar * theClosing;
  FACE theClosingFont;
} sequence;

struct style_sheets {
  /* Reference of th current style */
  const STYLE style;

  /* name of the language (compare with command-line option) */
  const char* name; 

  /* What are the abbreviations admited for the language (eg modula-3
     -> m3 */
  const char ** abbreviations;

  /* Note describing the mode or the language */
  const uchar * description;
  
  /* case sensitiveness for keywords and symbols */
  const CASE_SENSITIVENESS sensitiveness;

  /* definition of the "words" (keywords and symbols):
   * a char belonging to a first alphabet (first_characters),
   * and any number of chars belonging to the second (following_characters).
   * The definition of those alphabet is alphanumerical plus 
   * ascii intervals */

  /* First characters alphabet:
     begin_char_1, end_char_1,	ie ascii code between char 1 & char 2
     begin_char_2, end_char_2, ...
     \0 */
  const uchar *first_characters;

  /* the other than first letter may be: */
  const uchar *following_characters;

  /* list of keywords for this language
     keyword_1, font_1,
     keyword_2, font_2, ...*/
  const keyword * keywords;

  /* keywords to be converted into symbols in another font
     keyword_1, symbol_1, font_1, 
     keyword_2, symbol_2, font_2, ... */
  const symbol * regulars;

  /* same as symbols BUT there is no need to be preceded and followed
     by not in extended alphabet characters. In other words, these are
     not "words" of the alphabet, but any sequence of chars */
  const symbol * specials;

  /* type of sequences (strings, comments, etc.) :
     begin_string_1, font_for_begin_string_1, font_for_inside_sequence_1, 
     	end_string_1, font_for_end_string_1, 
     begin_string_2, font_for_begin_string_2, font_for_inside_sequence_2, 
     	end_string_2, font_for_end_string_2, ...
     \0 */
  const sequence * sequences;

  /* type of verbatims: strings that are written "verbatim" */
  const uchar ** verbatims;

  /* type of escapes: strings that are written "verbatim" when in a
     sequence */
  const uchar ** escapes;
};

/*	Notes
 *
 * - verbatims is made for languages such as tcl where, whereever the
 * symbol appears, it must not be "understood", e.g. \" and \\ are
 * written directly.
 *
 * - escapes is made for ! languages such as ada where "" is the
 * empty string, but appearing in a string, "" denotes ".
 */


extern struct style_sheets languages[];
extern int nbr_languages;

#endif /* not defined _STYLES_H_ */
