#line 134 "styles.c.in"
/*
 * styles.c
 *
 * style sheets for the languages supported
 * $Id: styles.c.in,v 1.42.2.1 1997/04/30 10:21:06 demaille Exp $
 */

/*
 * This file is part of a2ps.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/***************************************************************
 *			styles.c
 *
 * Please do not edit this file by hand: it has been
 * generated from styles.c.in through (GNU) m4 with option
 * --prefix-builtins
 * This file describes different languages : their words alphabet,
 * their keywords, their symbols, their special symbols,
 * their sequences type (eg. strings, comments), their exceptions
 * in the sequences, ...
 *
 * You can add new features to this program simply by modifying
 * this file.
 * All you have to do is to add a new item to the global
 * variable languages.
 *
 ****************************************************************/

/************************************************************************/
/*									*/
/* Description: Ascii to PostScript printer program.			*/
/* Created: Oct, 20 1996, by  demaille@inf.enst.fr (Demaille Akim)	*/
/* $Id								$	*/
/*									*/
/* Edit history:							*/
/* Modified by Emmanuel Briot (Emmanuel.Briot@enst-bretagne.fr)         */
/*  1) Built the keyword highlight mode					*/
/*  2) Added C/C++, Perl, Ada and Caml modes				*/
/* Modified by Akim Demaille (demaille@inf.enst.fr)                     */
/*  3) Added eiffel, sh, claire, lace key word Highligting              */
/*  4) Adding description of the alphabet for the keywords		*/
/*  5) Added the symbol translation (-t, -nt)				*/
/*  6) Case sensitiveness according to the language			*/
/*  7) Added sdl, and distinguished c from c++				*/
/*  8) Added specials, double-set alphabet description, and zsh style	*/
/*  9) Added promela, mail and java style				*/
/* 10) Sequences now have three fonts (open, in, close)			*/
/* 11) Changed handling of lexical exceptions: verbatims and escapes	*/
/* 12) Added tcl, tk and o2c style					*/
/* 13) Keywords are now defined with their font type			*/
/* 14) Added Sather, python, postscript, html, modula3 styles		*/
/* 15) Added the invisible font, possibilities with sequences augmented	*/
/* 16) Description for languages, and automatic recognition		*/
/* 17) Added Pascal, used m4						*/
/* Modified by Denis Girou (Denis.Girou@idris.fr)			*/
/* 18) Added Fortran 95							*/
/* Modified by Thomas Parmelan (Thomas.Parmelan@efrei.fr)		*/
/* 18) Added VHDL							*/
/* Modified by Akim Demaille (demaille@inf.enst.fr)                     */
/* 18) Added Prolog, ASM 68000						*/
/* Modified by Edward Arthur 						*/
/* 19) Added VERILOG style    						*/
/* Modified by Akim Demaille and J-Ph Cottin (cottin@inf.enst.fr)       */
/* 20) Added Unity            						*/
/* Modified by Craig P. Earls (cpearls@mit.edu)				*/
/* 21) Added Octave/MATLAB mode						*/
/************************************************************************/
#include "a2ps.h"
#include "styles.h"

const uchar * EMPTY [] = {
  UNULL
};

#define ENDKEYWORD {UNULL, 0}
const keyword NOKEYWORDS [] = {
  ENDKEYWORD
};

#define ENDSYMBOL {UNULL, UNULL, 0}
const symbol NOSYMBOL [] = {
  ENDSYMBOL
};

#define ENDSEQUENCE {UNULL, 0, 0, UNULL, 0}

/*
 * Map of the file
 *
 * 1. Prescript
 * 2. Misceleanous
 *   mail, postscript, html
 * 3. Shell-scripts
 *   sh, zsh, perl
 * 4. Eiffel family
 *   eiffel, lace
 * 5. C family
 *   c, cpp, o2c
 * 6. TCL family
 *   tcl, tk
 * 7. Object-oriented languages
 *   claire, java, ada, sather, python
 * 8. Functional languages
 *   caml, clisp, scheme, coq
 * 9. Modula family
 *   pascal, modula3, oberon
 * 10. Specification languages
 *   promela, sdl, vhdl, verilog, Unity
 * 11. Fortran
 * 12. Assembly languages
 *    M68000
 * 13. Logical languages
 *    prolog
 * 14. Database query languages
 *    sql92, sql, plsql, ora
 */


/************************************************************************/
/*									*/
/* 		Definition of the various styles			*/
/*									*/
/************************************************************************/
/*
 *		prescript
 */
#line 1 "styles01.m4"
/*
 *		prescript
 */
const sequence prescript_sequences [] = { 
  /* Dynamic switch of the encoding */
  {(ustring)"\\\\encoding{", INVISIBLE, ENCODING_TAG | INVISIBLE, (ustring)"}", INVISIBLE},
#line 8

  /* Skip portions destined to LaTeX only */
  {(ustring)"%%prescript:skip", INVISIBLE, INVISIBLE, (ustring)"%%prescript:piks$", INVISIBLE},
#line 13
  {(ustring)"%", INVISIBLE, INVISIBLE, (ustring)"$", INVISIBLE},

  /* lists */
  {(ustring)"\\\\item[", INVISIBLE, LABEL, (ustring)"]", INVISIBLE},
  /* titles */
  {(ustring)"\\\\section{", INVISIBLE, LABEL_STRONG, (ustring)"}", INVISIBLE},
  {(ustring)"\\\\subsection{", INVISIBLE, LABEL, (ustring)"}", INVISIBLE},
  {(ustring)"\\\\subsubsection{", INVISIBLE, LABEL, (ustring)"}", INVISIBLE},
  /* header and footer. Not supported this way by LaTeX */
  {(ustring)"\\\\header{", INVISIBLE, TAG1|INVISIBLE, (ustring)"}$", INVISIBLE},
  {(ustring)"\\\\footer{", INVISIBLE, TAG2|INVISIBLE, (ustring)"}$", INVISIBLE},
  /* change of font */
  {(ustring)"\\\\textbf{", INVISIBLE, KEYWORD_STRONG, (ustring)"}", INVISIBLE},
  {(ustring)"\\\\textit{", INVISIBLE, KEYWORD, (ustring)"}", INVISIBLE},
  {(ustring)"\\\\textbi{", INVISIBLE, KEYWORD_STRONG, (ustring)"}", INVISIBLE},
  {(ustring)"\\\\textrm{", INVISIBLE, STRING, (ustring)"}", INVISIBLE},
  {(ustring)"\\\\textsy{", INVISIBLE, SYMBOL, (ustring)"}", INVISIBLE},
  {(ustring)"\\\\texttt{", INVISIBLE, PLAIN, (ustring)"}", INVISIBLE},
  {(ustring)"\\\\keyword{", INVISIBLE, KEYWORD, (ustring)"}", INVISIBLE},
  {(ustring)"\\\\Keyword{", INVISIBLE, KEYWORD_STRONG, (ustring)"}", INVISIBLE},
  {(ustring)"\\\\comment{", INVISIBLE, COMMENT, (ustring)"}", INVISIBLE},
  {(ustring)"\\\\Comment{", INVISIBLE, COMMENT_STRONG, (ustring)"}", INVISIBLE},
  {(ustring)"\\\\label{", INVISIBLE, LABEL, (ustring)"}", INVISIBLE},
  {(ustring)"\\\\Label{", INVISIBLE, LABEL_STRONG, (ustring)"}", INVISIBLE},
  {(ustring)"\\\\string{", INVISIBLE, STRING, (ustring)"}", INVISIBLE},

  /* change of font but invisible in LaTeX */
  {(ustring)"\\\\magicbf{", INVISIBLE, KEYWORD_STRONG, (ustring)"}", INVISIBLE},
  {(ustring)"\\\\magicit{", INVISIBLE, KEYWORD, (ustring)"}", INVISIBLE},
  {(ustring)"\\\\magicbi{", INVISIBLE, KEYWORD_STRONG, (ustring)"}", INVISIBLE},
  {(ustring)"\\\\magicrm{", INVISIBLE, STRING, (ustring)"}", INVISIBLE},
  {(ustring)"\\\\magicsy{", INVISIBLE, SYMBOL, (ustring)"}", INVISIBLE},
  {(ustring)"\\\\magictt{", INVISIBLE, PLAIN, (ustring)"}", INVISIBLE},
  /* Verbatims */
  {(ustring)"\\\\verb+", INVISIBLE, PLAIN, (ustring)"+", INVISIBLE},
  {(ustring)"\\\\verb!", INVISIBLE, PLAIN, (ustring)"!", INVISIBLE},
  {(ustring)"\\\\verb|", INVISIBLE, PLAIN, (ustring)"|", INVISIBLE},
  {(ustring)"\\\\verb#", INVISIBLE, PLAIN, (ustring)"#", INVISIBLE},
  {(ustring)"\\\\verb=", INVISIBLE, PLAIN, (ustring)"=", INVISIBLE},
  ENDSEQUENCE
};
const uchar prescript_chars_1 [] = {
  'A', 'Z',
  'a', 'z',
  '\\', '\\',
  '_', '_',
  '\0'
};
const uchar prescript_chars_2 [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\0'
};
const symbol prescript_regulars [] = {
  /* Characters from LaTeX */
  {(ustring) "\\to", (ustring) "\256", SYMBOL},
  {(ustring) "\\item", (ustring) "\267", SYMBOL},
  {(ustring) "\\backslash", (ustring) "\\", PLAIN},
  /* Things that must disapear */
  {(ustring) "\\begin{document}", (ustring) "\0", INVISIBLE},
#line 76
{(ustring) "\\end{document}", (ustring) "\0", INVISIBLE},
#line 76
{(ustring) "\\begin{itemize}", (ustring) "\0", INVISIBLE},
#line 76
{(ustring) "\\end{itemize}", (ustring) "\0", INVISIBLE},
#line 76
{(ustring) "\\begin{enumerate}", (ustring) "\0", INVISIBLE},
#line 76
{(ustring) "\\end{enumerate}", (ustring) "\0", INVISIBLE},
#line 76
{(ustring) "\\begin{description}", (ustring) "\0", INVISIBLE},
#line 76
{(ustring) "\\end{description}", (ustring) "\0", INVISIBLE},
#line 76


  /*
   * This is taken from the correspondance between font symbol
   * and LaTeX commands
   */
  /* 34: universal */   	{(ustring) "\\forall", (ustring) "\42", SYMBOL},
  /* 36: existential */ 	{(ustring) "\\exists", (ustring) "\44", SYMBOL},
  /* 39: suchthat */    	{(ustring) "\\suchthat", (ustring) "\47", SYMBOL},
  /* 64: congruent */   	{(ustring) "\\cong", (ustring) "\100", SYMBOL},
  /* 65: Alpha */       	{(ustring) "\\Alpha", (ustring) "\101", SYMBOL},
  /* 66: Beta */        	{(ustring) "\\Beta", (ustring) "\102", SYMBOL},
  /* 67: Chi */ 		{(ustring) "\\Chi", (ustring) "\103", SYMBOL},
  /* 68: Delta */       	{(ustring) "\\Delta", (ustring) "\104", SYMBOL},
  /* 69: Epsilon */     	{(ustring) "\\Epsilon", (ustring) "\105", SYMBOL},
  /* 70: Phi */ 		{(ustring) "\\Phi", (ustring) "\106", SYMBOL},
  /* 71: Gamma */       	{(ustring) "\\Gamma", (ustring) "\107", SYMBOL},
  /* 72: Eta */ 		{(ustring) "\\Eta", (ustring) "\110", SYMBOL},
  /* 73: Iota */        	{(ustring) "\\Iota", (ustring) "\111", SYMBOL},
  /* 74: theta1 */      	{(ustring) "\\vartheta", (ustring) "\112", SYMBOL},
  /* 75: Kappa */       	{(ustring) "\\Kappa", (ustring) "\113", SYMBOL},
  /* 76: Lambda */      	{(ustring) "\\Lambda", (ustring) "\114", SYMBOL},
  /* 77: Mu */  		{(ustring) "\\Mu", (ustring) "\115", SYMBOL},
  /* 78: Nu */  		{(ustring) "\\Nu", (ustring) "\116", SYMBOL},
  /* 79: Omicron */     	{(ustring) "\\Omicron", (ustring) "\117", SYMBOL},
  /* 80: Pi */  		{(ustring) "\\Pi", (ustring) "\120", SYMBOL},
  /* 81: Theta */       	{(ustring) "\\Theta", (ustring) "\121", SYMBOL},
  /* 82: Rho */ 		{(ustring) "\\Rho", (ustring) "\122", SYMBOL},
  /* 83: Sigma */       	{(ustring) "\\Sigma", (ustring) "\123", SYMBOL},
  /* 84: Tau */ 		{(ustring) "\\Tau", (ustring) "\124", SYMBOL},
  /* 85: Upsilon */     	{(ustring) "\\Upsilon", (ustring) "\125", SYMBOL},
  /* 86: sigma1 */      	{(ustring) "\\varsigma", (ustring) "\126", SYMBOL},
  /* 87: Omega */       	{(ustring) "\\Omega", (ustring) "\127", SYMBOL},
  /* 88: Xi */ 		 	{(ustring) "\\Xi", (ustring) "\130", SYMBOL},
  /* 89: Psi */ 		{(ustring) "\\Psi", (ustring) "\131", SYMBOL},
  /* 90: Zeta */        	{(ustring) "\\Zeta", (ustring) "\132", SYMBOL},
  /* 92: therefore */   	{(ustring) "\\therefore", (ustring) "\134", SYMBOL},
  /* 94: perpendicular */       {(ustring) "\\perp", (ustring) "\136", SYMBOL},
  /* 96: radicalex */   	{(ustring) "\\radicalex", (ustring) "\140", SYMBOL},
  /* 97: alpha */       	{(ustring) "\\alpha", (ustring) "\141", SYMBOL},
  /* 98: beta */        	{(ustring) "\\beta", (ustring) "\142", SYMBOL},
  /* 99: chi */ 	 	{(ustring) "\\chi", (ustring) "\143", SYMBOL},
  /* 100: delta */      	{(ustring) "\\delta", (ustring) "\144", SYMBOL},
  /* 101: epsilon */    	{(ustring) "\\epsilon", (ustring) "\145", SYMBOL},
  /* 102: phi */        	{(ustring) "\\phi", (ustring) "\146", SYMBOL},
  /* 103: gamma */      	{(ustring) "\\gamma", (ustring) "\147", SYMBOL},
  /* 104: eta */        	{(ustring) "\\eta", (ustring) "\150", SYMBOL},
  /* 105: iota */       	{(ustring) "\\iota", (ustring) "\151", SYMBOL},
  /* 106: phi1 */       	{(ustring) "\\varphi", (ustring) "\152", SYMBOL},
  /* 107: kappa */      	{(ustring) "\\kappa", (ustring) "\153", SYMBOL},
  /* 108: lambda */     	{(ustring) "\\lambda", (ustring) "\154", SYMBOL},
  /* 109: mu */	 		{(ustring) "\\mu", (ustring) "\155", SYMBOL},
  /* 110: nu */	 		{(ustring) "\\nu", (ustring) "\156", SYMBOL},
  /* 111: omicron */    	{(ustring) "\\omicron", (ustring) "\157", SYMBOL},
  /* 112: pi */	 		{(ustring) "\\pi", (ustring) "\160", SYMBOL},
  /* 113: theta */      	{(ustring) "\\theta", (ustring) "\161", SYMBOL},
  /* 114: rho */        	{(ustring) "\\rho", (ustring) "\162", SYMBOL},
  /* 115: sigma */      	{(ustring) "\\sigma", (ustring) "\163", SYMBOL},
  /* 116: tau */        	{(ustring) "\\tau", (ustring) "\164", SYMBOL},
  /* 117: upsilon */    	{(ustring) "\\upsilon", (ustring) "\165", SYMBOL},
  /* 118: omega1 */     	{(ustring) "\\varpi", (ustring) "\166", SYMBOL},
  /* 119: omega */      	{(ustring) "\\omega", (ustring) "\167", SYMBOL},
  /* 120: xi */	 		{(ustring) "\\xi", (ustring) "\170", SYMBOL},
  /* 121: psi */        	{(ustring) "\\psi", (ustring) "\171", SYMBOL},
  /* 122: zeta */       	{(ustring) "\\zeta", (ustring) "\172", SYMBOL},
  /* 126: similar */    	{(ustring) "\\sim", (ustring) "\176", SYMBOL},
  /* 161: Upsilon1 */   	{(ustring) "\\varUpsilon", (ustring) "\241", SYMBOL},
  /* 162: minute */     	{(ustring) "\\prime", (ustring) "\242", SYMBOL},
  /* 163: lessequal */  	{(ustring) "\\leq", (ustring) "\243", SYMBOL},
  /* 165: infinity */   	{(ustring) "\\infty", (ustring) "\245", SYMBOL},
  /* 166: florin **********/   	{(ustring) "\\florin", (ustring) "\246", SYMBOL},
  /* 167: club */       	{(ustring) "\\clubsuit", (ustring) "\247", SYMBOL},
  /* 168: diamond */    	{(ustring) "\\diamondsuit", (ustring) "\250", SYMBOL},
  /* 169: heart */      	{(ustring) "\\heartsuit", (ustring) "\251", SYMBOL},
  /* 170: spade */      	{(ustring) "\\spadesuit", (ustring) "\252", SYMBOL},
  /* 171: arrowboth */  	{(ustring) "\\leftrightarrow", (ustring) "\253", SYMBOL},
  /* 172: arrowleft */  	{(ustring) "\\leftarrow", (ustring) "\254", SYMBOL},
  /* 173: arrowup */    	{(ustring) "\\uparrow", (ustring) "\255", SYMBOL},
  /* 174: arrowright */ 	{(ustring) "\\rightarrow", (ustring) "\256", SYMBOL},
  /* 175: arrowdown */  	{(ustring) "\\downarrow", (ustring) "\257", SYMBOL},
  /* 176: degree ********/     	{(ustring) "\\circ", (ustring) "\260", SYMBOL},
  /* 177: plusminus */		{(ustring) "\\pm", (ustring) "\261", SYMBOL},
  /* 179: greaterequal */       {(ustring) "\\geq", (ustring) "\263", SYMBOL},
  /* 180: multiply */   	{(ustring) "\\times", (ustring) "\264", SYMBOL},
  /* 181: proportional */       {(ustring) "\\propto", (ustring) "\265", SYMBOL},
  /* 182: partialdiff */        {(ustring) "\\partial", (ustring) "\266", SYMBOL},
  /* 183: bullet */    		{(ustring) "\\bullet", (ustring) "\267", SYMBOL},
  /* 184: divide */     	{(ustring) "\\div", (ustring) "\270", SYMBOL},
  /* 185: notequal */   	{(ustring) "\\neq", (ustring) "\271", SYMBOL},
  /* 186: equivalence */        {(ustring) "\\equiv", (ustring) "\272", SYMBOL},
  /* 187: approxequal */        {(ustring) "\\approx", (ustring) "\273", SYMBOL},
  /* 188: ellipsis */   	{(ustring) "\\ldots", (ustring) "\274", SYMBOL},
  /* 190: arrowhorizex */	{(ustring) "---", (ustring) "\276", SYMBOL},
  /* 191: carriagereturn */     {(ustring) "\\carriagereturn", (ustring) "\277", SYMBOL},
  /* 192: aleph */      	{(ustring) "\\aleph", (ustring) "\300", SYMBOL},
  /* 193: Ifraktur */   	{(ustring) "\\Im", (ustring) "\301", SYMBOL},
  /* 194: Rfraktur */   	{(ustring) "\\Re", (ustring) "\302", SYMBOL},
  /* 195: weierstrass */        {(ustring) "\\wp", (ustring) "\303", SYMBOL},
  /* 196: circlemultiply */     {(ustring) "\\otimes", (ustring) "\304", SYMBOL},
  /* 197: circleplus */ 	{(ustring) "\\oplus", (ustring) "\305", SYMBOL},
  /* 198: emptyset */  		{(ustring) "\\emptyset", (ustring) "\306", SYMBOL},
  /* 199: intersection */       {(ustring) "\\cap", (ustring) "\307", SYMBOL},
  /* 200: union */      	{(ustring) "\\cup", (ustring) "\310", SYMBOL},
  /* 201: propersuperset */     {(ustring) "\\supset", (ustring) "\311", SYMBOL},
  /* 202: reflexsuperset */     {(ustring) "\\supseteq", (ustring) "\312", SYMBOL},
  /* 203: notsubset */  	{(ustring) "\\not\\subset", (ustring) "\313", SYMBOL},
  /* 204: propersubset */       {(ustring) "\\subset", (ustring) "\314", SYMBOL},
  /* 205: reflexsubset */       {(ustring) "\\subseteq", (ustring) "\315", SYMBOL},
  /* 206: element */    	{(ustring) "\\in", (ustring) "\316", SYMBOL},
  /* 207: notelement */ 	{(ustring) "\\not\\in", (ustring) "\317", SYMBOL},
  /* 208: angle */      	{(ustring) "\\angle", (ustring) "\320", SYMBOL},
  /* 209: gradient */   	{(ustring) "\\nabla", (ustring) "\321", SYMBOL},
  /* 210: registerserif *****/  {(ustring) "\\varregister", (ustring) "\322", SYMBOL},
  /* 211: copyrightserif ****/  {(ustring) "\\varcopyright", (ustring) "\323", SYMBOL},
  /* 212: trademarkserif ****/  {(ustring) "\\vartrademark", (ustring) "\324", SYMBOL},
  /* 213: product */    	{(ustring) "\\prod", (ustring) "\325", SYMBOL},
  /* 214: radical */    	{(ustring) "\\surd", (ustring) "\326", SYMBOL},
  /* 215: dotmath */    	{(ustring) "\\cdot", (ustring) "\327", SYMBOL},
  /* 216: logicalnot */ 	{(ustring) "\\not", (ustring) "\330", SYMBOL},
  /* 217: logicaland */ 	{(ustring) "\\wedge", (ustring) "\331", SYMBOL},
  /* 218: logicalor */  	{(ustring) "\\vee", (ustring) "\332", SYMBOL},
  /* 219: arrowdblboth */       {(ustring) "\\Leftrightarrow", (ustring) "\333", SYMBOL},
  /* 220: arrowdblleft */       {(ustring) "\\Leftarrow", (ustring) "\334", SYMBOL},
  /* 221: arrowdblup */ 	{(ustring) "\\Uparrow", (ustring) "\335", SYMBOL},
  /* 222: arrowdblright */      {(ustring) "\\Rightarrow", (ustring) "\336", SYMBOL},
  /* 223: arrowdbldown */       {(ustring) "\\Downarrow", (ustring) "\337", SYMBOL},
  /* 224: lozenge *****/	{(ustring) "\\lozenge", (ustring) "\340", SYMBOL},
  /* 225: angleleft */  	{(ustring) "\\langle", (ustring) "\341", SYMBOL},
  /* 226: registersans ****/   	{(ustring) "\\register", (ustring) "\342", SYMBOL},
  /* 227: copyrightsans ****/  	{(ustring) "\\copyright", (ustring) "\343", SYMBOL},
  /* 228: trademarksans ****/  	{(ustring) "\\trademark", (ustring) "\344", SYMBOL},
  /* 229: summation */  	{(ustring) "\\sum", (ustring) "\345", SYMBOL},
  /* 233: bracketlefttp */      {(ustring) "\\lceil", (ustring) "\351", SYMBOL},
  /* 235: bracketleftbt */      {(ustring) "\\lfloor", (ustring) "\353", SYMBOL},
  /* 240: .notdef */    	{(ustring) "\\apple", (ustring) "\360", SYMBOL},
  /* 241: angleright */ 	{(ustring) "\\rangle", (ustring) "\361", SYMBOL},
  /* 242: integral */   	{(ustring) "\\int", (ustring) "\362", SYMBOL},
  /* 249: bracketrighttp */     {(ustring) "\\rceil", (ustring) "\371", SYMBOL},
  /* 251: bracketrightbt */     {(ustring) "\\rfloor", (ustring) "\373", SYMBOL},
  ENDSYMBOL
};
const symbol prescript_specials [] = {
  /* There is no mode math in prescript */
  {(ustring) "\\$", (ustring) "$", PLAIN},
  {(ustring) "$", (ustring) "\0", INVISIBLE},
  {(ustring) "\\_", (ustring) "_", PLAIN},
  {(ustring) "\\%", (ustring) "%", PLAIN},
  {(ustring) "\\&", (ustring) "&", PLAIN},
  {(ustring) "\\#", (ustring) "#", PLAIN},
  /*
   * This is taken from the correspondance between font symbol
   * and LaTeX commands
   */
  /* 35: numbersign   		{(ustring) "\\#", (ustring) "\43", SYMBOL},*/
  /* 37: percent      		{(ustring) "\\%", (ustring) "\45", SYMBOL},*/
  /* 38: ampersand   		{(ustring) "\\&", (ustring) "\46", SYMBOL},*/
  /* 40: parenleft */   	{(ustring) "\\(", (ustring) "(", PLAIN},
  /* 41: parenright */  	{(ustring) "\\)", (ustring) ")", PLAIN},
  /* 91: bracketleft */ 	{(ustring) "\\[", (ustring) "[", PLAIN},
  /* 93: bracketright */        {(ustring) "\\]", (ustring) "]", PLAIN},
  /* 95: underscore		{(ustring) "\\_", (ustring) "_", PLAIN},*/
  /* 123: braceleft */  	{(ustring) "\\{", (ustring) "{", PLAIN},
  /* 124: bar */        	{(ustring) "\\|", (ustring) "|", PLAIN},
  /* 125: braceright */ 	{(ustring) "\\}", (ustring) "}", PLAIN},
  /* 189: arrowvertex		{(ustring) "\\|", (ustring) "\275", },*/
  ENDSYMBOL
};
const char *  prescript_abbreviations [] = {
  "prescript", "biftex", "bif", "pre", "ptf", "\0"
};
const uchar prescript_description [] = "\
This is prescript, a language of description of textual pages. \
It provides by the use of LaTeX like commands, a way to describe the \
pages that this program should produce. It can be a very good choice of \
destination language for people who want to produce text to print \
(e.g. pretty-printing, automating documentation etc.) \
but who definitely do not want to learn postscript, nor to require \
the use of LaTeX.\
\n\
It is also known as BifTeX (Basic Instruction From LaTeX), of ptf \
(Poor Text Format).\
\n\
Symbol translation is always enabled in this mode.";
#define prescript_style_def { prescript_style, "PreScript", 		\
  prescript_abbreviations, prescript_description, 			\
  CASE_SENSITIVE, prescript_chars_1, prescript_chars_2, NOKEYWORDS,	\
  prescript_regulars, prescript_specials, prescript_sequences, EMPTY, EMPTY }
#line 275 "styles.c.in"

/************************************************************************/
/*			Misceleanous				   	*/
/************************************************************************/
/*
 *  mail
 *  Postscript
 *  HTML note: this is almost a joke since it does not work very well.
 */
#line 1 "styles02.m4"
/************************************************************************/
/*			Misceleanous					*/
/************************************************************************/
/*
 *		mail
 */
const sequence mail_sequences [] = { 
  /* We don't want these to be comments, because of --strip */
  {(ustring)"^> ", PLAIN, KEYWORD, (ustring)"$", KEYWORD},
  {(ustring)"^Subject:", KEYWORD_STRONG, LABEL_STRONG | TAG1, (ustring)"$", PLAIN},
  {(ustring)"^From:", KEYWORD_STRONG, LABEL_STRONG | TAG2, (ustring)"$", PLAIN},
  {(ustring)"^X-Sun-Data-Name:", KEYWORD_STRONG, LABEL, (ustring)"$", PLAIN},

  /* headers of big interest */
  {(ustring)"^To:", COMMENT_STRONG, COMMENT_STRONG, (ustring)"$", COMMENT_STRONG},
  {(ustring)"^Date:", COMMENT_STRONG, COMMENT_STRONG, (ustring)"$", COMMENT_STRONG},
#line 16
  {(ustring)"^Date", COMMENT_STRONG, COMMENT_STRONG, (ustring)"$", COMMENT_STRONG},
#line 16
  {(ustring)"^Lines:", COMMENT_STRONG, COMMENT_STRONG, (ustring)"$", COMMENT_STRONG},
#line 16
  {(ustring)"^Organization:", COMMENT_STRONG, COMMENT_STRONG, (ustring)"$", COMMENT_STRONG},
#line 16
  {(ustring)"^Address:", COMMENT_STRONG, COMMENT_STRONG, (ustring)"$", COMMENT_STRONG},

  /* headers of small interest */
  {(ustring)"^Approved:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Article-", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Autoforwarded:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Buzzword", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Content-Identifier:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Content-Transfer-Encoding:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Content-Type:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Distribution: ", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Email-Version:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Errors-To:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^From", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Fruit", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^In-Reply-To:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Lat", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Libi", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Message-", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Message-Id:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Mime-Version:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Mmdf", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Mood", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Newsgroups: ", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Network-", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Neuron", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Nntp-Posting-Host:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Organisation:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Origin", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Original", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Path: ", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Phase", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Phone:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Post", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Really-", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Received:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^References: ", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Relay-", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Reply-To:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Resent", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Return", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Return-Path:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Sender: ", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Sensitivity:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Sent:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Source", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Status:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Sun", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Telefax:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Telephone", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Transport-Options:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Ua-Content-Id:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Via:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Warnings-To:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^X-Char-Esc:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^X-Comment:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^X-Face", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^X-Facsimile:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^X-Filter:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^X-How-To-Reach-Us:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^X-Hpmail", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^X-Lines", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^X-Lines:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^X-Location", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^X-Mailer:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^X-Mts:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^X-Newsreader:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^X-Sent-By-Nmail-V", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^X-Sequence:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^X-Sun-Charset:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^X-Sun-Content-Lines:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^X-Sun-Data-Description:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^X-Sun-Data-Type:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^X-Telephone:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^X-Vm-V5-Data:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^X400-Content-Type:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^X400-Mts-Identifiers:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^X400-Received:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^X400-Recipients:", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 34
  {(ustring)"^Xref:", COMMENT, COMMENT, (ustring)"$", COMMENT},

  ENDSEQUENCE
};
const uchar mail_characters [] = {
  'A', 'Z',
  'a', 'z',
  ':', ':',
  '_', '_',
  '-', '-',
  '\0'
};
const keyword mail_keywords [] = {
  ENDKEYWORD
};
const symbol mail_specials [] = {
  {(ustring) "=E0", (ustring) "", PLAIN},
  {(ustring) "=E1", (ustring) "", PLAIN},
  {(ustring) "=E2", (ustring) "", PLAIN},
  {(ustring) "=E8", (ustring) "", PLAIN},
  {(ustring) "=E9", (ustring) "", PLAIN},
  {(ustring) "=EA", (ustring) "", PLAIN},
  {(ustring) "=F4", (ustring) "", PLAIN},
  {(ustring) "=F9", (ustring) "", PLAIN},
  {(ustring) "=\n", (ustring) "", INVISIBLE},
  ENDSYMBOL
};
const char * mail_abbreviations []= {
  "news", "mailfolder", "\0"
};
const uchar  mail_description [] = "\
To use from elm and others, it is better to specify -gEmail, \
since the file sent to printer is no longer trully a mailfolder.  \
This style also suits to news.  --strip options are also useful \
(they strip \"useless\" headers).";
#define mail_style_def { mail_style, "mail",	  			\
  mail_abbreviations, mail_description, 				\
  CASE_SENSITIVE, mail_characters, mail_characters, mail_keywords,	\
  NOSYMBOL, mail_specials, mail_sequences, EMPTY, EMPTY }

/*
 *		Postscript
 */
const sequence postscript_sequences [] = { 
  {(ustring)"%!", COMMENT, COMMENT_STRONG, (ustring)"$", COMMENT},
  {(ustring)"%%", COMMENT, COMMENT_STRONG, (ustring)"$", COMMENT},
  {(ustring)"%", COMMENT, COMMENT, (ustring)"$", COMMENT},
  {(ustring)"(", PLAIN, STRING, (ustring)")", PLAIN},
  ENDSEQUENCE
};
const uchar* postscript_verbatims [] = {
  (ustring) "\\\\", (ustring) "\\(", (ustring) "\\)", UNULL
};
const uchar postscript_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\\', '\\',
  '\0'
};
const keyword postscript_keywords [] = {
  {(ustring)"add", KEYWORD_STRONG},
#line 102
  {(ustring)"arc", KEYWORD_STRONG},
#line 102
  {(ustring)"array", KEYWORD_STRONG},
#line 102
  {(ustring)"begin", KEYWORD_STRONG},
#line 102
  {(ustring)"bind", KEYWORD_STRONG},
#line 102
  {(ustring)"clip", KEYWORD_STRONG},
#line 102
  {(ustring)"charpath", KEYWORD_STRONG},
#line 102
  {(ustring)"closepath", KEYWORD_STRONG},
#line 102
  {(ustring)"copy", KEYWORD_STRONG},
#line 102
  {(ustring)"currentdict", KEYWORD_STRONG},
#line 102
  {(ustring)"currentfont", KEYWORD_STRONG},
#line 102
  {(ustring)"curveto", KEYWORD_STRONG},
#line 102
  {(ustring)"def", KEYWORD_STRONG},
#line 102
  {(ustring)"definefont", KEYWORD_STRONG},
#line 102
  {(ustring)"dict", KEYWORD_STRONG},
#line 102
  {(ustring)"div", KEYWORD_STRONG},
#line 102
  {(ustring)"dup", KEYWORD_STRONG},
#line 102
  {(ustring)"end", KEYWORD_STRONG},
#line 102
  {(ustring)"eq", KEYWORD_STRONG},
#line 102
  {(ustring)"exch", KEYWORD_STRONG},
#line 102
  {(ustring)"fill", KEYWORD_STRONG},
#line 102
  {(ustring)"for", KEYWORD_STRONG},
#line 102
  {(ustring)"forall", KEYWORD_STRONG},
#line 102
  {(ustring)"findfont", KEYWORD_STRONG},
#line 102
  {(ustring)"get", KEYWORD_STRONG},
#line 102
  {(ustring)"ge", KEYWORD_STRONG},
#line 102
  {(ustring)"grestore", KEYWORD_STRONG},
#line 102
  {(ustring)"gsave", KEYWORD_STRONG},
#line 102
  {(ustring)"gt", KEYWORD_STRONG},
#line 102
  {(ustring)"if", KEYWORD_STRONG},
#line 102
  {(ustring)"ifelse", KEYWORD_STRONG},
#line 102
  {(ustring)"index", KEYWORD_STRONG},
#line 102
  {(ustring)"known", KEYWORD_STRONG},
#line 102
  {(ustring)"length", KEYWORD_STRONG},
#line 102
  {(ustring)"le", KEYWORD_STRONG},
#line 102
  {(ustring)"lineto", KEYWORD_STRONG},
#line 102
  {(ustring)"lt", KEYWORD_STRONG},
#line 102
  {(ustring)"moveto", KEYWORD_STRONG},
#line 102
  {(ustring)"mul", KEYWORD_STRONG},
#line 102
  {(ustring)"neg", KEYWORD_STRONG},
#line 102
  {(ustring)"newpath", KEYWORD_STRONG},
#line 102
  {(ustring)"pop", KEYWORD_STRONG},
#line 102
  {(ustring)"put", KEYWORD_STRONG},
#line 102
  {(ustring)"restore", KEYWORD_STRONG},
#line 102
  {(ustring)"rlineto", KEYWORD_STRONG},
#line 102
  {(ustring)"rmoveto", KEYWORD_STRONG},
#line 102
  {(ustring)"roll", KEYWORD_STRONG},
#line 102
  {(ustring)"rotate", KEYWORD_STRONG},
#line 102
  {(ustring)"save", KEYWORD_STRONG},
#line 102
  {(ustring)"scale", KEYWORD_STRONG},
#line 102
  {(ustring)"scalefont", KEYWORD_STRONG},
#line 102
  {(ustring)"setcachedevice", KEYWORD_STRONG},
#line 102
  {(ustring)"setfont", KEYWORD_STRONG},
#line 102
  {(ustring)"setgray", KEYWORD_STRONG},
#line 102
  {(ustring)"setlinewidth", KEYWORD_STRONG},
#line 102
  {(ustring)"show", KEYWORD_STRONG},
#line 102
  {(ustring)"showpage", KEYWORD_STRONG},
#line 102
  {(ustring)"stringwidth", KEYWORD_STRONG},
#line 102
  {(ustring)"stroke", KEYWORD_STRONG},
#line 102
  {(ustring)"sub", KEYWORD_STRONG},
#line 102
  {(ustring)"translate", KEYWORD_STRONG},
#line 102
  {(ustring)"where", KEYWORD_STRONG},
#line 102
  {(ustring)"xor", KEYWORD_STRONG},
#line 102


  {(ustring)"true", KEYWORD},
#line 104
  {(ustring)"false", KEYWORD},
#line 104

   ENDKEYWORD
};
const symbol postscript_regulars [] = {
#if 0
  {(ustring)"&&", (ustring)"\331", SYMBOL},
  {(ustring)"||", (ustring)"\332", SYMBOL},
  {(ustring)"^^", (ustring)"\305", SYMBOL},
#endif
  {(ustring)"le", (ustring)"\243", SYMBOL},
  {(ustring)"ge", (ustring)"\263", SYMBOL},
  {(ustring)"eq", (ustring)"\272", SYMBOL},
  {(ustring)"ne", (ustring)"\271", SYMBOL},
  ENDSYMBOL
};
const char * postscript_abbreviations []= {
  "postscript", "ps", "\0"
};
const uchar  postscript_description [] = "";
#define postscript_style_def { postscript_style, "PostScript",		\
  postscript_abbreviations, postscript_description,			\
  CASE_SENSITIVE, postscript_characters, postscript_characters,		\
  postscript_keywords, postscript_regulars, NOSYMBOL, postscript_sequences,\
  EMPTY, postscript_verbatims }
#line 284 "styles.c.in"

/************************************************************************/
/*				Shell-scripts			   	*/
/************************************************************************/
/*
 *		sh
 *		zsh
 *		Perl
 */
#line 1 "styles03.m4"
/*
 *		sh
 */
const sequence sh_sequences [] = { 
  {(ustring)"#", COMMENT, COMMENT, (ustring)"$", COMMENT},
  {(ustring)"\"", PLAIN, STRING, (ustring)"\"", PLAIN},
  {(ustring)"\'", PLAIN, STRING, (ustring)"\'", PLAIN},
  ENDSEQUENCE
};
const uchar* sh_verbatims [] = {
  (ustring) "\\\\", (ustring) "\\\"", (ustring) "\\\'", UNULL
};
const uchar sh_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '-', '-',
  '/', '/', 
  '$', '$', 
  '\0'
};
const uchar sh_following_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '/', '/', 
  '$', '$', 
  '#', '#', /* to avoid $# be understood as the beginning of a comment */
  '\0'
};
const keyword sh_keywords [] = {
  {(ustring)"break", KEYWORD_STRONG},
#line 35
  {(ustring)"case", KEYWORD_STRONG},
#line 35
  {(ustring)"cd", KEYWORD_STRONG},
#line 35
  {(ustring)"continue", KEYWORD_STRONG},
#line 35
  {(ustring)"done", KEYWORD_STRONG},
#line 35
  {(ustring)"do", KEYWORD_STRONG},
#line 35
  {(ustring)"echo", KEYWORD_STRONG},
#line 35
  {(ustring)"elif", KEYWORD_STRONG},
#line 35
  {(ustring)"else", KEYWORD_STRONG},
#line 35
  {(ustring)"esac", KEYWORD_STRONG},
#line 35
  {(ustring)"eval", KEYWORD_STRONG},
#line 35
  {(ustring)"exec", KEYWORD_STRONG},
#line 35
  {(ustring)"exit", KEYWORD_STRONG},
#line 35
  {(ustring)"export", KEYWORD_STRONG},
#line 35
  {(ustring)"fi", KEYWORD_STRONG},
#line 35
  {(ustring)"for", KEYWORD_STRONG},
#line 35
  {(ustring)"if", KEYWORD_STRONG},
#line 35
  {(ustring)"in", KEYWORD_STRONG},
#line 35
  {(ustring)"readonly", KEYWORD_STRONG},
#line 35
  {(ustring)"read", KEYWORD_STRONG},
#line 35
  {(ustring)"return", KEYWORD_STRONG},
#line 35
  {(ustring)"set", KEYWORD_STRONG},
#line 35
  {(ustring)"shift", KEYWORD_STRONG},
#line 35
  {(ustring)"stop", KEYWORD_STRONG},
#line 35
  {(ustring)"test", KEYWORD_STRONG},
#line 35
  {(ustring)"then", KEYWORD_STRONG},
#line 35
  {(ustring)"times", KEYWORD_STRONG},
#line 35
  {(ustring)"trap", KEYWORD_STRONG},
#line 35
  {(ustring)"type", KEYWORD_STRONG},
#line 35
  {(ustring)"umask", KEYWORD_STRONG},
#line 35
  {(ustring)"unset", KEYWORD_STRONG},
#line 35
  {(ustring)"until", KEYWORD_STRONG},
#line 35
  {(ustring)"wait", KEYWORD_STRONG},
#line 35
  {(ustring)"while", KEYWORD_STRONG},
#line 35

   ENDKEYWORD
};
const char * sh_abbreviations []= {
  "Bourneshell", "c-shell", "jsh", "csh", "ksh", "bash", "shell", "\0"
};
const uchar  sh_description [] = "";
#define sh_style_def { sh_style, "sh",					\
  sh_abbreviations, sh_description, 				\
  CASE_SENSITIVE, sh_characters, sh_following_characters,   	\
  sh_keywords, NOSYMBOL, NOSYMBOL, sh_sequences, sh_verbatims, EMPTY }

/*
 *		zsh
 */
const symbol zsh_regulars [] = {
  {(ustring)"&&", (ustring)"\331", SYMBOL},
  {(ustring)"||", (ustring)"\332", SYMBOL},
  {(ustring)"^^", (ustring)"\305", SYMBOL},
  {(ustring)"!=", (ustring)"\271", SYMBOL},
  {(ustring)"==", (ustring)"\272", SYMBOL},
  {(ustring)"<=", (ustring)"\243", SYMBOL},
  {(ustring)">=", (ustring)"\263", SYMBOL},
  ENDSYMBOL
};
const symbol zsh_specials [] = {
  {(ustring)"!", (ustring)"\330", SYMBOL},
  ENDSYMBOL
};
const keyword zsh_keywords [] = {
   {(ustring)"alias", KEYWORD_STRONG},
#line 75
  {(ustring)"autoload", KEYWORD_STRONG},
#line 75
  {(ustring)"bg", KEYWORD_STRONG},
#line 75
  {(ustring)"bindkey", KEYWORD_STRONG},
#line 75
  {(ustring)"break", KEYWORD_STRONG},
#line 75
  {(ustring)"builtin", KEYWORD_STRONG},
#line 75
  {(ustring)"bye", KEYWORD_STRONG},
#line 75
  {(ustring)"cd", KEYWORD_STRONG},
#line 75
  {(ustring)"chdir", KEYWORD_STRONG},
#line 75
  {(ustring)"compctl", KEYWORD_STRONG},
#line 75
  {(ustring)"continue", KEYWORD_STRONG},
#line 75
  {(ustring)"declare", KEYWORD_STRONG},
#line 75
  {(ustring)"dirs", KEYWORD_STRONG},
#line 75
  {(ustring)"disable", KEYWORD_STRONG},
#line 75
  {(ustring)"disown", KEYWORD_STRONG},
#line 75
  {(ustring)"echo", KEYWORD_STRONG},
#line 75
  {(ustring)"echotc", KEYWORD_STRONG},
#line 75
  {(ustring)"emulate", KEYWORD_STRONG},
#line 75
  {(ustring)"enable", KEYWORD_STRONG},
#line 75
  {(ustring)"eval", KEYWORD_STRONG},
#line 75
  {(ustring)"exit", KEYWORD_STRONG},
#line 75
  {(ustring)"export", KEYWORD_STRONG},
#line 75
  {(ustring)"false", KEYWORD_STRONG},
#line 75
  {(ustring)"fc", KEYWORD_STRONG},
#line 75
  {(ustring)"fg", KEYWORD_STRONG},
#line 75
  {(ustring)"functions", KEYWORD_STRONG},
#line 75
  {(ustring)"getln", KEYWORD_STRONG},
#line 75
  {(ustring)"getopts", KEYWORD_STRONG},
#line 75
  {(ustring)"hash", KEYWORD_STRONG},
#line 75
  {(ustring)"history", KEYWORD_STRONG},
#line 75
  {(ustring)"integer", KEYWORD_STRONG},
#line 75
  {(ustring)"jobs", KEYWORD_STRONG},
#line 75
  {(ustring)"kill", KEYWORD_STRONG},
#line 75
  {(ustring)"let", KEYWORD_STRONG},
#line 75
  {(ustring)"limit", KEYWORD_STRONG},
#line 75
  {(ustring)"local", KEYWORD_STRONG},
#line 75
  {(ustring)"log", KEYWORD_STRONG},
#line 75
  {(ustring)"logout", KEYWORD_STRONG},
#line 75
  {(ustring)"popd", KEYWORD_STRONG},
#line 75
  {(ustring)"print", KEYWORD_STRONG},
#line 75
  {(ustring)"pushd", KEYWORD_STRONG},
#line 75
  {(ustring)"pushln", KEYWORD_STRONG},
#line 75
  {(ustring)"pwd", KEYWORD_STRONG},
#line 75
  {(ustring)"r", KEYWORD_STRONG},
#line 75
  {(ustring)"read", KEYWORD_STRONG},
#line 75
  {(ustring)"readonly", KEYWORD_STRONG},
#line 75
  {(ustring)"rehash", KEYWORD_STRONG},
#line 75
  {(ustring)"return", KEYWORD_STRONG},
#line 75
  {(ustring)"sched", KEYWORD_STRONG},
#line 75
  {(ustring)"set", KEYWORD_STRONG},
#line 75
  {(ustring)"setopt", KEYWORD_STRONG},
#line 75
  {(ustring)"shift", KEYWORD_STRONG},
#line 75
  {(ustring)"source", KEYWORD_STRONG},
#line 75
  {(ustring)"suspend", KEYWORD_STRONG},
#line 75
  {(ustring)"test", KEYWORD_STRONG},
#line 75
  {(ustring)"times", KEYWORD_STRONG},
#line 75
  {(ustring)"trap", KEYWORD_STRONG},
#line 75
  {(ustring)"true", KEYWORD_STRONG},
#line 75
  {(ustring)"ttyctl", KEYWORD_STRONG},
#line 75
  {(ustring)"type", KEYWORD_STRONG},
#line 75
  {(ustring)"typeset", KEYWORD_STRONG},
#line 75
  {(ustring)"ulimit", KEYWORD_STRONG},
#line 75
  {(ustring)"umask", KEYWORD_STRONG},
#line 75
  {(ustring)"inalias", KEYWORD_STRONG},
#line 75
  {(ustring)"unfunction", KEYWORD_STRONG},
#line 75
  {(ustring)"unhash", KEYWORD_STRONG},
#line 75
  {(ustring)"unlimit", KEYWORD_STRONG},
#line 75
  {(ustring)"unset", KEYWORD_STRONG},
#line 75
  {(ustring)"unsetopt", KEYWORD_STRONG},
#line 75
  {(ustring)"vared", KEYWORD_STRONG},
#line 75
  {(ustring)"wait", KEYWORD_STRONG},
#line 75
  {(ustring)"whence", KEYWORD_STRONG},
#line 75
  {(ustring)"where", KEYWORD_STRONG},
#line 75
  {(ustring)"which", KEYWORD_STRONG},
#line 75
  {(ustring)"noglob", KEYWORD_STRONG},
#line 75
  {(ustring)"nocorrect", KEYWORD_STRONG},
#line 75
  {(ustring)"exec", KEYWORD_STRONG},
#line 75
  {(ustring)"command", KEYWORD_STRONG},
#line 75
  {(ustring)"if", KEYWORD_STRONG},
#line 75
  {(ustring)"then", KEYWORD_STRONG},
#line 75
  {(ustring)"elif", KEYWORD_STRONG},
#line 75
  {(ustring)"fi", KEYWORD_STRONG},
#line 75
  {(ustring)"for", KEYWORD_STRONG},
#line 75
  {(ustring)"in", KEYWORD_STRONG},
#line 75
  {(ustring)"do", KEYWORD_STRONG},
#line 75
  {(ustring)"done", KEYWORD_STRONG},
#line 75
  {(ustring)"foreach", KEYWORD_STRONG},
#line 75
  {(ustring)"end", KEYWORD_STRONG},
#line 75
  {(ustring)"while", KEYWORD_STRONG},
#line 75
  {(ustring)"until", KEYWORD_STRONG},
#line 75
  {(ustring)"repeat", KEYWORD_STRONG},
#line 75
  {(ustring)"case", KEYWORD_STRONG},
#line 75
  {(ustring)"esac", KEYWORD_STRONG},
#line 75
  {(ustring)"select", KEYWORD_STRONG},
#line 75
  {(ustring)"function", KEYWORD_STRONG},
#line 75
  {(ustring)"time", KEYWORD_STRONG},
#line 75
  {(ustring)"coproc", KEYWORD_STRONG},
#line 75

  ENDKEYWORD
};
const char * zsh_abbreviations []= {
  "\0"
};
const uchar  zsh_description [] = "";
#define zsh_style_def { zsh_style, "zsh",				\
  zsh_abbreviations, zsh_description, 					\
  CASE_SENSITIVE, sh_characters, sh_following_characters,	       	\
  zsh_keywords, zsh_regulars, zsh_specials, sh_sequences, sh_verbatims, EMPTY }

/*
 *		Perl
 */
const sequence perl_sequences [] = {
  {(ustring)"#", COMMENT, COMMENT, (ustring)"$", COMMENT},
  {(ustring)"\"", PLAIN, STRING, (ustring)"\"", PLAIN},
  {(ustring)"\'", PLAIN, STRING, (ustring)"\'", PLAIN},
  {(ustring)"use ", KEYWORD_STRONG, LABEL_STRONG + DEC1, (ustring)" ", PLAIN},
  {(ustring)"sub ", KEYWORD_STRONG, LABEL_STRONG + DEC1, (ustring)"(", PLAIN},
  {(ustring)"sub ", KEYWORD_STRONG, LABEL_STRONG + DEC1, (ustring)" ", PLAIN},
  {(ustring)"&", KEYWORD_STRONG, LABEL_STRONG + DEC1, (ustring)" ", PLAIN},
  {(ustring)"&", KEYWORD_STRONG, LABEL_STRONG + DEC1, (ustring)";", PLAIN},
  {(ustring)"&", KEYWORD_STRONG, LABEL_STRONG + DEC1, (ustring)"(", PLAIN},
  {(ustring)"^=", COMMENT_STRONG, COMMENT_STRONG, (ustring)"^=cut", COMMENT_STRONG},
  ENDSEQUENCE
};
const uchar perl_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\0'
};
const keyword perl_keywords [] = {
   {(ustring)"if", KEYWORD_STRONG},
#line 133
  {(ustring)"until", KEYWORD_STRONG},
#line 133
  {(ustring)"while", KEYWORD_STRONG},
#line 133
  {(ustring)"elsif", KEYWORD_STRONG},
#line 133
  {(ustring)"else", KEYWORD_STRONG},
#line 133
  {(ustring)"unless", KEYWORD_STRONG},
#line 133
  {(ustring)"for", KEYWORD_STRONG},
#line 133
  {(ustring)"foreach", KEYWORD_STRONG},
#line 133
  {(ustring)"last", KEYWORD_STRONG},
#line 133
  {(ustring)"goto", KEYWORD_STRONG},
#line 133
  {(ustring)"next", KEYWORD_STRONG},
#line 133
  {(ustring)"redo", KEYWORD_STRONG},
#line 133
  {(ustring)"return", KEYWORD_STRONG},
#line 133
  {(ustring)"local", KEYWORD_STRONG},
#line 133
  {(ustring)"sub", KEYWORD_STRONG},
#line 133
  {(ustring)"do", KEYWORD_STRONG},
#line 133
  {(ustring)"dump", KEYWORD_STRONG},
#line 133
  {(ustring)"use", KEYWORD_STRONG},
#line 133
  {(ustring)"package", KEYWORD_STRONG},
#line 133
  {(ustring)"eval", KEYWORD_STRONG},
#line 133
  {(ustring)"my", KEYWORD_STRONG},
#line 133
  {(ustring)"BEGIN", KEYWORD_STRONG},
#line 133
  {(ustring)"END", KEYWORD_STRONG},
#line 133
  {(ustring)"CORE", KEYWORD_STRONG},
#line 133
  {(ustring)"__FILE__", KEYWORD_STRONG},
#line 133
  {(ustring)"__LINE__", KEYWORD_STRONG},
#line 133
  {(ustring)"abs", KEYWORD_STRONG},
#line 133
  {(ustring)"accept", KEYWORD_STRONG},
#line 133
  {(ustring)"alarm", KEYWORD_STRONG},
#line 133
  {(ustring)"and", KEYWORD_STRONG},
#line 133
  {(ustring)"atan", KEYWORD_STRONG},
#line 133
  {(ustring)"bind", KEYWORD_STRONG},
#line 133
  {(ustring)"binmode", KEYWORD_STRONG},
#line 133
  {(ustring)"bless", KEYWORD_STRONG},
#line 133
  {(ustring)"caller", KEYWORD_STRONG},
#line 133
  {(ustring)"chdir", KEYWORD_STRONG},
#line 133
  {(ustring)"chmod", KEYWORD_STRONG},
#line 133
  {(ustring)"chown", KEYWORD_STRONG},
#line 133
  {(ustring)"chr", KEYWORD_STRONG},
#line 133
  {(ustring)"chroot", KEYWORD_STRONG},
#line 133
  {(ustring)"close", KEYWORD_STRONG},
#line 133
  {(ustring)"closedir", KEYWORD_STRONG},
#line 133
  {(ustring)"cmp", KEYWORD_STRONG},
#line 133
  {(ustring)"connect", KEYWORD_STRONG},
#line 133
  {(ustring)"continue", KEYWORD_STRONG},
#line 133
  {(ustring)"cos", KEYWORD_STRONG},
#line 133
  {(ustring)"crypt", KEYWORD_STRONG},
#line 133
  {(ustring)"dbmclose", KEYWORD_STRONG},
#line 133
  {(ustring)"dbmopen", KEYWORD_STRONG},
#line 133
  {(ustring)"die", KEYWORD_STRONG},
#line 133
  {(ustring)"endgrent", KEYWORD_STRONG},
#line 133
  {(ustring)"endhostent", KEYWORD_STRONG},
#line 133
  {(ustring)"endnetent", KEYWORD_STRONG},
#line 133
  {(ustring)"endprotoent", KEYWORD_STRONG},
#line 133
  {(ustring)"endpwent", KEYWORD_STRONG},
#line 133
  {(ustring)"endservent", KEYWORD_STRONG},
#line 133
  {(ustring)"eof", KEYWORD_STRONG},
#line 133
  {(ustring)"eq", KEYWORD_STRONG},
#line 133
  {(ustring)"exec", KEYWORD_STRONG},
#line 133
  {(ustring)"exit", KEYWORD_STRONG},
#line 133
  {(ustring)"exp", KEYWORD_STRONG},
#line 133
  {(ustring)"fcntl", KEYWORD_STRONG},
#line 133
  {(ustring)"fileno", KEYWORD_STRONG},
#line 133
  {(ustring)"flock", KEYWORD_STRONG},
#line 133
  {(ustring)"fork", KEYWORD_STRONG},
#line 133
  {(ustring)"formline", KEYWORD_STRONG},
#line 133
  {(ustring)"ge", KEYWORD_STRONG},
#line 133
  {(ustring)"getc", KEYWORD_STRONG},
#line 133
  {(ustring)"getgrent", KEYWORD_STRONG},
#line 133
  {(ustring)"getgrgid", KEYWORD_STRONG},
#line 133
  {(ustring)"getgrnam", KEYWORD_STRONG},
#line 133
  {(ustring)"gethostbyaddr", KEYWORD_STRONG},
#line 133
  {(ustring)"gethostbyname", KEYWORD_STRONG},
#line 133
  {(ustring)"gethostent", KEYWORD_STRONG},
#line 133
  {(ustring)"getlogin", KEYWORD_STRONG},
#line 133
  {(ustring)"getnetbyaddr", KEYWORD_STRONG},
#line 133
  {(ustring)"getnetbyname", KEYWORD_STRONG},
#line 133
  {(ustring)"getnetent", KEYWORD_STRONG},
#line 133
  {(ustring)"getpeername", KEYWORD_STRONG},
#line 133
  {(ustring)"getpgrp", KEYWORD_STRONG},
#line 133
  {(ustring)"getppid", KEYWORD_STRONG},
#line 133
  {(ustring)"getpriority", KEYWORD_STRONG},
#line 133
  {(ustring)"getprotobyname", KEYWORD_STRONG},
#line 133
  {(ustring)"getprotobynumber", KEYWORD_STRONG},
#line 133
  {(ustring)"getprotoent", KEYWORD_STRONG},
#line 133
  {(ustring)"getpwent", KEYWORD_STRONG},
#line 133
  {(ustring)"getpwnam", KEYWORD_STRONG},
#line 133
  {(ustring)"getpwuid", KEYWORD_STRONG},
#line 133
  {(ustring)"getservbyname", KEYWORD_STRONG},
#line 133
  {(ustring)"getservbyport", KEYWORD_STRONG},
#line 133
  {(ustring)"getservent", KEYWORD_STRONG},
#line 133
  {(ustring)"getsockname", KEYWORD_STRONG},
#line 133
  {(ustring)"getsockopt", KEYWORD_STRONG},
#line 133
  {(ustring)"glob", KEYWORD_STRONG},
#line 133
  {(ustring)"gmtime", KEYWORD_STRONG},
#line 133
  {(ustring)"gt", KEYWORD_STRONG},
#line 133
  {(ustring)"hex", KEYWORD_STRONG},
#line 133
  {(ustring)"index", KEYWORD_STRONG},
#line 133
  {(ustring)"int", KEYWORD_STRONG},
#line 133
  {(ustring)"ioctl", KEYWORD_STRONG},
#line 133
  {(ustring)"join", KEYWORD_STRONG},
#line 133
  {(ustring)"kill", KEYWORD_STRONG},
#line 133
  {(ustring)"lc", KEYWORD_STRONG},
#line 133
  {(ustring)"lcfirst", KEYWORD_STRONG},
#line 133
  {(ustring)"le", KEYWORD_STRONG},
#line 133
  {(ustring)"length", KEYWORD_STRONG},
#line 133
  {(ustring)"link", KEYWORD_STRONG},
#line 133
  {(ustring)"listen", KEYWORD_STRONG},
#line 133
  {(ustring)"localtime", KEYWORD_STRONG},
#line 133
  {(ustring)"log", KEYWORD_STRONG},
#line 133
  {(ustring)"lstat", KEYWORD_STRONG},
#line 133
  {(ustring)"lt", KEYWORD_STRONG},
#line 133
  {(ustring)"mkdir", KEYWORD_STRONG},
#line 133
  {(ustring)"msgctl", KEYWORD_STRONG},
#line 133
  {(ustring)"msgget", KEYWORD_STRONG},
#line 133
  {(ustring)"msgrcv", KEYWORD_STRONG},
#line 133
  {(ustring)"msgsnd", KEYWORD_STRONG},
#line 133
  {(ustring)"ne", KEYWORD_STRONG},
#line 133
  {(ustring)"not", KEYWORD_STRONG},
#line 133
  {(ustring)"oct", KEYWORD_STRONG},
#line 133
  {(ustring)"open", KEYWORD_STRONG},
#line 133
  {(ustring)"opendir", KEYWORD_STRONG},
#line 133
  {(ustring)"or", KEYWORD_STRONG},
#line 133
  {(ustring)"ord", KEYWORD_STRONG},
#line 133
  {(ustring)"pack", KEYWORD_STRONG},
#line 133
  {(ustring)"pipe", KEYWORD_STRONG},
#line 133
  {(ustring)"quotemeta", KEYWORD_STRONG},
#line 133
  {(ustring)"rand", KEYWORD_STRONG},
#line 133
  {(ustring)"read", KEYWORD_STRONG},
#line 133
  {(ustring)"readdir", KEYWORD_STRONG},
#line 133
  {(ustring)"readline", KEYWORD_STRONG},
#line 133
  {(ustring)"readlink", KEYWORD_STRONG},
#line 133
  {(ustring)"readpipe", KEYWORD_STRONG},
#line 133
  {(ustring)"recv", KEYWORD_STRONG},
#line 133
  {(ustring)"ref", KEYWORD_STRONG},
#line 133
  {(ustring)"rename", KEYWORD_STRONG},
#line 133
  {(ustring)"require", KEYWORD_STRONG},
#line 133
  {(ustring)"reset", KEYWORD_STRONG},
#line 133
  {(ustring)"reverse", KEYWORD_STRONG},
#line 133
  {(ustring)"rewinddir", KEYWORD_STRONG},
#line 133
  {(ustring)"rindex", KEYWORD_STRONG},
#line 133
  {(ustring)"rmdir", KEYWORD_STRONG},
#line 133
  {(ustring)"seek", KEYWORD_STRONG},
#line 133
  {(ustring)"seekdir", KEYWORD_STRONG},
#line 133
  {(ustring)"select", KEYWORD_STRONG},
#line 133
  {(ustring)"semctl", KEYWORD_STRONG},
#line 133
  {(ustring)"semget", KEYWORD_STRONG},
#line 133
  {(ustring)"semop", KEYWORD_STRONG},
#line 133
  {(ustring)"send", KEYWORD_STRONG},
#line 133
  {(ustring)"setgrent", KEYWORD_STRONG},
#line 133
  {(ustring)"sethostent", KEYWORD_STRONG},
#line 133
  {(ustring)"setnetent", KEYWORD_STRONG},
#line 133
  {(ustring)"setpgrp", KEYWORD_STRONG},
#line 133
  {(ustring)"setpriority", KEYWORD_STRONG},
#line 133
  {(ustring)"setprotoent", KEYWORD_STRONG},
#line 133
  {(ustring)"setpwent", KEYWORD_STRONG},
#line 133
  {(ustring)"setservent", KEYWORD_STRONG},
#line 133
  {(ustring)"setsockopt", KEYWORD_STRONG},
#line 133
  {(ustring)"shmctl", KEYWORD_STRONG},
#line 133
  {(ustring)"shmget", KEYWORD_STRONG},
#line 133
  {(ustring)"shmread", KEYWORD_STRONG},
#line 133
  {(ustring)"shmwrite", KEYWORD_STRONG},
#line 133
  {(ustring)"shutdown", KEYWORD_STRONG},
#line 133
  {(ustring)"sin", KEYWORD_STRONG},
#line 133
  {(ustring)"sleep", KEYWORD_STRONG},
#line 133
  {(ustring)"socket", KEYWORD_STRONG},
#line 133
  {(ustring)"socketpair", KEYWORD_STRONG},
#line 133
  {(ustring)"sprintf", KEYWORD_STRONG},
#line 133
  {(ustring)"sqrt", KEYWORD_STRONG},
#line 133
  {(ustring)"srand", KEYWORD_STRONG},
#line 133
  {(ustring)"stat", KEYWORD_STRONG},
#line 133
  {(ustring)"substr", KEYWORD_STRONG},
#line 133
  {(ustring)"symlink", KEYWORD_STRONG},
#line 133
  {(ustring)"syscall", KEYWORD_STRONG},
#line 133
  {(ustring)"sysread", KEYWORD_STRONG},
#line 133
  {(ustring)"system", KEYWORD_STRONG},
#line 133
  {(ustring)"syswrite", KEYWORD_STRONG},
#line 133
  {(ustring)"tell", KEYWORD_STRONG},
#line 133
  {(ustring)"telldir", KEYWORD_STRONG},
#line 133
  {(ustring)"time", KEYWORD_STRONG},
#line 133
  {(ustring)"times", KEYWORD_STRONG},
#line 133
  {(ustring)"truncate", KEYWORD_STRONG},
#line 133
  {(ustring)"uc", KEYWORD_STRONG},
#line 133
  {(ustring)"ucfirst", KEYWORD_STRONG},
#line 133
  {(ustring)"umask", KEYWORD_STRONG},
#line 133
  {(ustring)"unlink", KEYWORD_STRONG},
#line 133
  {(ustring)"unpack", KEYWORD_STRONG},
#line 133
  {(ustring)"utime", KEYWORD_STRONG},
#line 133
  {(ustring)"values", KEYWORD_STRONG},
#line 133
  {(ustring)"vec", KEYWORD_STRONG},
#line 133
  {(ustring)"wait", KEYWORD_STRONG},
#line 133
  {(ustring)"waitpid", KEYWORD_STRONG},
#line 133
  {(ustring)"wantarray", KEYWORD_STRONG},
#line 133
  {(ustring)"warn", KEYWORD_STRONG},
#line 133
  {(ustring)"write", KEYWORD_STRONG},
#line 133
  {(ustring)"x", KEYWORD_STRONG},
#line 133
  {(ustring)"xor", KEYWORD_STRONG},
#line 133
  {(ustring)"print", KEYWORD_STRONG},
#line 133

   ENDKEYWORD
};
const char * perl_abbreviations []= {
  "pl", "pm", "\0"
};
const uchar  perl_description [] = "";
#define perl_style_def { perl_style, "perl", 				\
  perl_abbreviations, perl_description, 				\
  CASE_SENSITIVE, perl_characters, perl_characters, perl_keywords,	\
  NOSYMBOL, NOSYMBOL, perl_sequences, sh_verbatims, EMPTY }
#line 293 "styles.c.in"

/************************************************************************/
/*			  Eiffel and eiffel-like	       	   	*/
/************************************************************************/
/*
 *		Eiffel
 *		Language of Assembly for Classes of Eiffel
 */
#line 1 "styles04.m4"
/*
 *		Eiffel
 */
const sequence eiffel_sequences [] = {
  {(ustring)"--", COMMENT, COMMENT, (ustring)"$", COMMENT},
  {(ustring)"\"", PLAIN, STRING, (ustring)"\"", PLAIN},
  {(ustring)"\'", PLAIN, STRING, (ustring)"\'", PLAIN},
  ENDSEQUENCE
};
const uchar* eiffel_verbatims [] = {
  (ustring) "%%", (ustring) "%\"", (ustring) "%'", UNULL
};
const uchar eiffel_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\0'
};
const symbol eiffel_regulars [] = {
  {(ustring) "or else", (ustring) "or else", KEYWORD_STRONG},
  {(ustring) "and then", (ustring) "and then", KEYWORD_STRONG},
  {(ustring)"not", (ustring)"\330", SYMBOL}, {(ustring)"or", (ustring)"\332", SYMBOL}, {(ustring)"and", (ustring)"\331", SYMBOL}, {(ustring)"implies", (ustring)"\336", SYMBOL},
  ENDSYMBOL
};
const symbol eiffel_specials [] = {
  {(ustring) ":=", (ustring) ":=", PLAIN},
  {(ustring)"=", (ustring)"\272", SYMBOL},
  {(ustring)"/=", (ustring)"\271", SYMBOL},
  {(ustring)"<=", (ustring)"\243", SYMBOL},
  {(ustring)">=", (ustring)"\263", SYMBOL},
  ENDSYMBOL
};
const keyword eiffel_keywords [] = {
  /* keywords */
  {(ustring)"all", KEYWORD_STRONG},
#line 41
  {(ustring)"alias", KEYWORD_STRONG},
#line 41
  {(ustring)"as", KEYWORD_STRONG},
#line 41
  {(ustring)"and", KEYWORD_STRONG},
#line 41
  {(ustring)"check", KEYWORD_STRONG},
#line 41
  {(ustring)"class", KEYWORD_STRONG},
#line 41
  {(ustring)"current", KEYWORD_STRONG},
#line 41
  {(ustring)"debug", KEYWORD_STRONG},
#line 41
  {(ustring)"deferred", KEYWORD_STRONG},
#line 41
  {(ustring)"do", KEYWORD_STRONG},
#line 41
  {(ustring)"else", KEYWORD_STRONG},
#line 41
  {(ustring)"elseif", KEYWORD_STRONG},
#line 41
  {(ustring)"end", KEYWORD_STRONG},
#line 41
  {(ustring)"ensure", KEYWORD_STRONG},
#line 41
  {(ustring)"expanded", KEYWORD_STRONG},
#line 41
  {(ustring)"export", KEYWORD_STRONG},
#line 41
  {(ustring)"external", KEYWORD_STRONG},
#line 41
  {(ustring)"false", KEYWORD_STRONG},
#line 41
  {(ustring)"feature", KEYWORD_STRONG},
#line 41
  {(ustring)"from", KEYWORD_STRONG},
#line 41
  {(ustring)"if", KEYWORD_STRONG},
#line 41
  {(ustring)"implies", KEYWORD_STRONG},
#line 41
  {(ustring)"indexing", KEYWORD_STRONG},
#line 41
  {(ustring)"infix", KEYWORD_STRONG},
#line 41
  {(ustring)"inherit", KEYWORD_STRONG},
#line 41
  {(ustring)"inspect", KEYWORD_STRONG},
#line 41
  {(ustring)"invariant", KEYWORD_STRONG},
#line 41
  {(ustring)"is", KEYWORD_STRONG},
#line 41
  {(ustring)"language", KEYWORD_STRONG},
#line 41
  {(ustring)"like", KEYWORD_STRONG},
#line 41
  {(ustring)"local", KEYWORD_STRONG},
#line 41
  {(ustring)"loop", KEYWORD_STRONG},
#line 41
  {(ustring)"none", KEYWORD_STRONG},
#line 41
  {(ustring)"not", KEYWORD_STRONG},
#line 41
  {(ustring)"creation", KEYWORD_STRONG},
#line 41
  {(ustring)"obsolete", KEYWORD_STRONG},
#line 41
  {(ustring)"old", KEYWORD_STRONG},
#line 41
  {(ustring)"once", KEYWORD_STRONG},
#line 41
  {(ustring)"or", KEYWORD_STRONG},
#line 41
  {(ustring)"prefix", KEYWORD_STRONG},
#line 41
  {(ustring)"redefine", KEYWORD_STRONG},
#line 41
  {(ustring)"require", KEYWORD_STRONG},
#line 41
  {(ustring)"rename", KEYWORD_STRONG},
#line 41
  {(ustring)"rescue", KEYWORD_STRONG},
#line 41
  {(ustring)"result", KEYWORD_STRONG},
#line 41
  {(ustring)"retry", KEYWORD_STRONG},
#line 41
  {(ustring)"select", KEYWORD_STRONG},
#line 41
  {(ustring)"separate", KEYWORD_STRONG},
#line 41
  {(ustring)"strip", KEYWORD_STRONG},
#line 41
  {(ustring)"then", KEYWORD_STRONG},
#line 41
  {(ustring)"true", KEYWORD_STRONG},
#line 41
  {(ustring)"undefine", KEYWORD_STRONG},
#line 41
  {(ustring)"unique", KEYWORD_STRONG},
#line 41
  {(ustring)"until", KEYWORD_STRONG},
#line 41
  {(ustring)"variant", KEYWORD_STRONG},
#line 41
  {(ustring)"void", KEYWORD_STRONG},
#line 41
  {(ustring)"when", KEYWORD_STRONG},
#line 41
  {(ustring)"xor", KEYWORD_STRONG},
#line 41


   /* some basic types */
 {(ustring)"bit", KEYWORD},
  {(ustring)"boolean", KEYWORD},
#line 45
  {(ustring)"character", KEYWORD},
#line 45
  {(ustring)"double", KEYWORD},
#line 45
  {(ustring)"integer", KEYWORD},
#line 45
  {(ustring)"pointer", KEYWORD},
#line 45
  {(ustring)"real", KEYWORD},
#line 45
  {(ustring)"string", KEYWORD},
#line 45

   ENDKEYWORD
};
const char * eiffel_abbreviations [] = {
  "e", "\0"
};
const uchar  eiffel_description [] = "";
#define eiffel_style_def { eiffel_style, "eiffel",			\
  eiffel_abbreviations, eiffel_description, 				\
  CASE_INSENSITIVE, eiffel_characters,	eiffel_characters,		\
  eiffel_keywords,                                                     	\
  eiffel_regulars, eiffel_specials, eiffel_sequences, EMPTY, eiffel_verbatims }

/*
 *		Language of Assembly for Classes of Eiffel
 */
const keyword lace_keywords [] = { 
  /* keywords */
  {(ustring)"end", KEYWORD_STRONG},
#line 67
  {(ustring)"system", KEYWORD_STRONG},
#line 67
  {(ustring)"root", KEYWORD_STRONG},
#line 67
  {(ustring)"cluster", KEYWORD_STRONG},
#line 67
  {(ustring)"use", KEYWORD_STRONG},
#line 67
  {(ustring)"include", KEYWORD_STRONG},
#line 67
  {(ustring)"precompiled", KEYWORD_STRONG},
#line 67
  {(ustring)"exclude", KEYWORD_STRONG},
#line 67
  {(ustring)"adapt", KEYWORD_STRONG},
#line 67
  {(ustring)"ignore", KEYWORD_STRONG},
#line 67
  {(ustring)"rename", KEYWORD_STRONG},
#line 67
  {(ustring)"as", KEYWORD_STRONG},
#line 67
  {(ustring)"default", KEYWORD_STRONG},
#line 67
  {(ustring)"option", KEYWORD_STRONG},
#line 67
  {(ustring)"collect", KEYWORD_STRONG},
#line 67
  {(ustring)"assertion", KEYWORD_STRONG},
#line 67
  {(ustring)"debug", KEYWORD_STRONG},
#line 67
  {(ustring)"optimize", KEYWORD_STRONG},
#line 67
  {(ustring)"trace", KEYWORD_STRONG},
#line 67
  {(ustring)"yes", KEYWORD_STRONG},
#line 67
  {(ustring)"no", KEYWORD_STRONG},
#line 67
  {(ustring)"all", KEYWORD_STRONG},
#line 67
  {(ustring)"require", KEYWORD_STRONG},
#line 67
  {(ustring)"ensure", KEYWORD_STRONG},
#line 67
  {(ustring)"invariant", KEYWORD_STRONG},
#line 67
  {(ustring)"loop", KEYWORD_STRONG},
#line 67
  {(ustring)"check", KEYWORD_STRONG},
#line 67
  {(ustring)"external", KEYWORD_STRONG},
#line 67
  {(ustring)"object", KEYWORD_STRONG},
#line 67
  {(ustring)"make", KEYWORD_STRONG},
#line 67
  {(ustring)"generate", KEYWORD_STRONG},
#line 67
  {(ustring)"visible", KEYWORD_STRONG},
#line 67
  {(ustring)"creation", KEYWORD_STRONG},
#line 67
  {(ustring)"export", KEYWORD_STRONG},
#line 67


   /* Languages */
  {(ustring)"eiffel", KEYWORD},
#line 70
  {(ustring)"ada", KEYWORD},
#line 70
  {(ustring)"pascal", KEYWORD},
#line 70
  {(ustring)"fortran", KEYWORD},
#line 70
  {(ustring)"c", KEYWORD},
#line 70

   ENDKEYWORD
};
const char * lace_abbreviations [] = {
  "ace", "\0"
};
const uchar  lace_description [] = "";
#define lace_style_def { lace_style, "lace",				\
  lace_abbreviations, lace_description, 				\
  CASE_INSENSITIVE, eiffel_characters, eiffel_characters,		\
  lace_keywords, NOSYMBOL, NOSYMBOL, eiffel_sequences, EMPTY, eiffel_verbatims }
#line 301 "styles.c.in"

/************************************************************************/
/*				C and C-like			   	*/
/************************************************************************/
/*
 *		C
 *		c++
 *		o2c
 *		Octave/MATLAB
 *              objc
 */
#line 24 "styles05.m4"
/*
 *		C
 */
const sequence c_sequences [] = {
  /* Regular sequences */
  {(ustring)"/*", COMMENT, COMMENT, (ustring)"*/", COMMENT},
  {(ustring)"//", COMMENT, COMMENT, (ustring)"$", COMMENT},
  {(ustring)"\"", PLAIN, STRING, (ustring)"\"", PLAIN},
  {(ustring)"\'", PLAIN, STRING, (ustring)"\'", PLAIN},

  /* The special case of case :) */
  /* Note that it will not work well for case ':'... */
  {(ustring)"case ", KEYWORD_STRONG, LABEL, (ustring)":", PLAIN},
  ENDSEQUENCE
};
const uchar c_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '#', '%',
  '\0'
};
const symbol c_specials [] = {
  {(ustring)"->", (ustring)"\256", SYMBOL},
  {(ustring)"&&", (ustring)"\331", SYMBOL},
  {(ustring)"||", (ustring)"\332", SYMBOL},
  {(ustring)"!=", (ustring)"\271", SYMBOL},
  {(ustring)"==", (ustring)"\272", SYMBOL},
  {(ustring) "<<=", (ustring) "<<=", },
  {(ustring) ">>=", (ustring) ">>=", },
  {(ustring)"<=", (ustring)"\243", SYMBOL},
  {(ustring)">=", (ustring)"\263", SYMBOL},
  {(ustring)"!", (ustring)"\330", SYMBOL},
  ENDSYMBOL
};
const keyword c_keywords [] = {
  /* Preprocessor */
#line 60
  {(ustring)"#include", KEYWORD_STRONG},
#line 60
  {(ustring)"#define", KEYWORD_STRONG},
#line 60
  {(ustring)"#undef", KEYWORD_STRONG},
#line 60
  {(ustring)"#pragma", KEYWORD_STRONG},
#line 60
  {(ustring)"#if", KEYWORD_STRONG},
#line 60
  {(ustring)"#ifdef", KEYWORD_STRONG},
#line 60
  {(ustring)"#ifndef", KEYWORD_STRONG},
#line 60
  {(ustring)"#elif", KEYWORD_STRONG},
#line 60
  {(ustring)"#else", KEYWORD_STRONG},
#line 60
  {(ustring)"#error", KEYWORD_STRONG},
#line 60
  {(ustring)"#line", KEYWORD_STRONG},
#line 60
  {(ustring)"#ex", KEYWORD_STRONG},
#line 60
  {(ustring)"#endif", KEYWORD_STRONG},
#line 60
  {(ustring)"defined", KEYWORD_STRONG},
#line 60
  {(ustring)"# define", KEYWORD_STRONG},
#line 60
  {(ustring)"# include", KEYWORD_STRONG},
#line 60
  {(ustring)"# if", KEYWORD_STRONG},
#line 60
  {(ustring)"# ifdef", KEYWORD_STRONG},
#line 60
  {(ustring)"# endif", KEYWORD_STRONG},
#line 60
  {(ustring)"#import", KEYWORD_STRONG},
#line 60
  {(ustring)"# import", KEYWORD_STRONG},
#line 60
  {(ustring)"#  import", KEYWORD_STRONG},
#line 60
  {(ustring)"#  define", KEYWORD_STRONG},
#line 60
  {(ustring)"#  include", KEYWORD_STRONG},
#line 60
  {(ustring)"#  if", KEYWORD_STRONG},
#line 60
  {(ustring)"#  ifdef", KEYWORD_STRONG},
#line 60
  {(ustring)"#  endif", KEYWORD_STRONG},
#line 60

#line 60

#line 60
  /* simple types */
#line 60
  {(ustring)"double", KEYWORD},
#line 60
  {(ustring)"enum", KEYWORD},
#line 60
  {(ustring)"void", KEYWORD},
#line 60
  {(ustring)"int", KEYWORD},
#line 60
  {(ustring)"long", KEYWORD},
#line 60
  {(ustring)"FILE", KEYWORD},
#line 60
  {(ustring)"struct", KEYWORD},
#line 60
  {(ustring)"char", KEYWORD},
#line 60
  {(ustring)"signed", KEYWORD},
#line 60
  {(ustring)"float", KEYWORD},
#line 60
  {(ustring)"short", KEYWORD},
#line 60
  {(ustring)"unsigned", KEYWORD},
#line 60

#line 60

#line 60
  /* core of the keywords */
#line 60
  {(ustring)"inline", KEYWORD_STRONG},
#line 60
  {(ustring)"extern", KEYWORD_STRONG},
#line 60
  {(ustring)"const", KEYWORD_STRONG},
#line 60
  {(ustring)"register", KEYWORD_STRONG},
#line 60
  {(ustring)"return", KEYWORD_STRONG},
#line 60
  {(ustring)"continue", KEYWORD_STRONG},
#line 60
  {(ustring)"for", KEYWORD_STRONG},
#line 60
  {(ustring)"auto", KEYWORD_STRONG},
#line 60
  {(ustring)"switch", KEYWORD_STRONG},
#line 60
  {(ustring)"typedef", KEYWORD_STRONG},
#line 60
  {(ustring)"union", KEYWORD_STRONG},
#line 60
  {(ustring)"goto", KEYWORD_STRONG},
#line 60
  {(ustring)"sizeof", KEYWORD_STRONG},
#line 60
  {(ustring)"volatile", KEYWORD_STRONG},
#line 60
  {(ustring)"do", KEYWORD_STRONG},
#line 60
  {(ustring)"static", KEYWORD_STRONG},
#line 60
  {(ustring)"NULL", KEYWORD_STRONG},
#line 60
  {(ustring)"case", KEYWORD_STRONG},
#line 60
  {(ustring)"default", KEYWORD_STRONG},
#line 60
  {(ustring)"break", KEYWORD_STRONG},
#line 60
  {(ustring)"if", KEYWORD_STRONG},
#line 60
  {(ustring)"while", KEYWORD_STRONG},
#line 60
  {(ustring)"else", KEYWORD_STRONG},
#line 60

  ENDKEYWORD
}; 
const char * c_abbreviations []= {
  "c", "h", "i", "\0"
};
const uchar  c_description [] = "";
#define c_style_def {c_style, "C", 				\
  c_abbreviations, c_description, 				\
  CASE_SENSITIVE, c_characters, c_characters, c_keywords,	\
  NOSYMBOL, c_specials, c_sequences, sh_verbatims, EMPTY }

/*
 *		c++
 */
const sequence cpp_sequences [] = {
  {(ustring)"/*", COMMENT, COMMENT, (ustring)"*/", COMMENT},
  {(ustring)"//", COMMENT, COMMENT, (ustring)"$", COMMENT},
  {(ustring)"\"", PLAIN, STRING, (ustring)"\"", PLAIN},
  {(ustring)"\'", PLAIN, STRING, (ustring)"\'", PLAIN},
  ENDSEQUENCE
};
const keyword cpp_keywords [] = {
  /* Preprocessor */
#line 83
  {(ustring)"#include", KEYWORD_STRONG},
#line 83
  {(ustring)"#define", KEYWORD_STRONG},
#line 83
  {(ustring)"#undef", KEYWORD_STRONG},
#line 83
  {(ustring)"#pragma", KEYWORD_STRONG},
#line 83
  {(ustring)"#if", KEYWORD_STRONG},
#line 83
  {(ustring)"#ifdef", KEYWORD_STRONG},
#line 83
  {(ustring)"#ifndef", KEYWORD_STRONG},
#line 83
  {(ustring)"#elif", KEYWORD_STRONG},
#line 83
  {(ustring)"#else", KEYWORD_STRONG},
#line 83
  {(ustring)"#error", KEYWORD_STRONG},
#line 83
  {(ustring)"#line", KEYWORD_STRONG},
#line 83
  {(ustring)"#ex", KEYWORD_STRONG},
#line 83
  {(ustring)"#endif", KEYWORD_STRONG},
#line 83
  {(ustring)"defined", KEYWORD_STRONG},
#line 83
  {(ustring)"# define", KEYWORD_STRONG},
#line 83
  {(ustring)"# include", KEYWORD_STRONG},
#line 83
  {(ustring)"# if", KEYWORD_STRONG},
#line 83
  {(ustring)"# ifdef", KEYWORD_STRONG},
#line 83
  {(ustring)"# endif", KEYWORD_STRONG},
#line 83
  {(ustring)"#import", KEYWORD_STRONG},
#line 83
  {(ustring)"# import", KEYWORD_STRONG},
#line 83
  {(ustring)"#  import", KEYWORD_STRONG},
#line 83
  {(ustring)"#  define", KEYWORD_STRONG},
#line 83
  {(ustring)"#  include", KEYWORD_STRONG},
#line 83
  {(ustring)"#  if", KEYWORD_STRONG},
#line 83
  {(ustring)"#  ifdef", KEYWORD_STRONG},
#line 83
  {(ustring)"#  endif", KEYWORD_STRONG},
#line 83

#line 83

#line 83
  /* simple types */
#line 83
  {(ustring)"double", KEYWORD},
#line 83
  {(ustring)"enum", KEYWORD},
#line 83
  {(ustring)"void", KEYWORD},
#line 83
  {(ustring)"int", KEYWORD},
#line 83
  {(ustring)"long", KEYWORD},
#line 83
  {(ustring)"FILE", KEYWORD},
#line 83
  {(ustring)"struct", KEYWORD},
#line 83
  {(ustring)"char", KEYWORD},
#line 83
  {(ustring)"signed", KEYWORD},
#line 83
  {(ustring)"float", KEYWORD},
#line 83
  {(ustring)"short", KEYWORD},
#line 83
  {(ustring)"unsigned", KEYWORD},
#line 83

#line 83

#line 83
  /* core of the keywords */
#line 83
  {(ustring)"inline", KEYWORD_STRONG},
#line 83
  {(ustring)"extern", KEYWORD_STRONG},
#line 83
  {(ustring)"const", KEYWORD_STRONG},
#line 83
  {(ustring)"register", KEYWORD_STRONG},
#line 83
  {(ustring)"return", KEYWORD_STRONG},
#line 83
  {(ustring)"continue", KEYWORD_STRONG},
#line 83
  {(ustring)"for", KEYWORD_STRONG},
#line 83
  {(ustring)"auto", KEYWORD_STRONG},
#line 83
  {(ustring)"switch", KEYWORD_STRONG},
#line 83
  {(ustring)"typedef", KEYWORD_STRONG},
#line 83
  {(ustring)"union", KEYWORD_STRONG},
#line 83
  {(ustring)"goto", KEYWORD_STRONG},
#line 83
  {(ustring)"sizeof", KEYWORD_STRONG},
#line 83
  {(ustring)"volatile", KEYWORD_STRONG},
#line 83
  {(ustring)"do", KEYWORD_STRONG},
#line 83
  {(ustring)"static", KEYWORD_STRONG},
#line 83
  {(ustring)"NULL", KEYWORD_STRONG},
#line 83
  {(ustring)"case", KEYWORD_STRONG},
#line 83
  {(ustring)"default", KEYWORD_STRONG},
#line 83
  {(ustring)"break", KEYWORD_STRONG},
#line 83
  {(ustring)"if", KEYWORD_STRONG},
#line 83
  {(ustring)"while", KEYWORD_STRONG},
#line 83
  {(ustring)"else", KEYWORD_STRONG},
#line 83


  /* c++'s own keywords */
  {(ustring)"new", KEYWORD_STRONG},
#line 90
  {(ustring)"delete", KEYWORD_STRONG},
#line 90
  {(ustring)"this", KEYWORD_STRONG},
#line 90
  {(ustring)"operator", KEYWORD_STRONG},
#line 90
  {(ustring)"class", KEYWORD_STRONG},
#line 90
  {(ustring)"public", KEYWORD_STRONG},
#line 90
  {(ustring)"protected", KEYWORD_STRONG},
#line 90
  {(ustring)"private", KEYWORD_STRONG},
#line 90
  {(ustring)"virtual", KEYWORD_STRONG},
#line 90
  {(ustring)"friend", KEYWORD_STRONG},
#line 90
  {(ustring)"template", KEYWORD_STRONG},
#line 90
  {(ustring)"dynamic", KEYWORD_STRONG},
#line 90
  {(ustring)"typeof", KEYWORD_STRONG},
#line 90
  {(ustring)"all", KEYWORD_STRONG},
#line 90
  {(ustring)"except", KEYWORD_STRONG},
#line 90
  {(ustring)"exception", KEYWORD_STRONG},
#line 90
  {(ustring)"raise", KEYWORD_STRONG},
#line 90
  {(ustring)"raises", KEYWORD_STRONG},
#line 90
  {(ustring)"reraises", KEYWORD_STRONG},
#line 90
  {(ustring)"try", KEYWORD_STRONG},
#line 90
  {(ustring)"asm", KEYWORD_STRONG},
#line 90
  {(ustring)"catch", KEYWORD_STRONG},
#line 90
  {(ustring)"overload", KEYWORD_STRONG},
#line 90
  {(ustring)"and", KEYWORD_STRONG},
#line 90
  {(ustring)"and_eq", KEYWORD_STRONG},
#line 90
  {(ustring)"bitand", KEYWORD_STRONG},
#line 90
  {(ustring)"bitor", KEYWORD_STRONG},
#line 90
  {(ustring)"compl", KEYWORD_STRONG},
#line 90
  {(ustring)"not", KEYWORD_STRONG},
#line 90
  {(ustring)"not_eq", KEYWORD_STRONG},
#line 90
  {(ustring)"or", KEYWORD_STRONG},
#line 90
  {(ustring)"or_eq", KEYWORD_STRONG},
#line 90
  {(ustring)"xor", KEYWORD_STRONG},
#line 90
  {(ustring)"xor_eq", KEYWORD_STRONG},
#line 90


  {(ustring)"bool", KEYWORD},
#line 94
  {(ustring)"const_cast", KEYWORD},
#line 94
  {(ustring)"dynamic_cast", KEYWORD},
#line 94
  {(ustring)"explicit", KEYWORD},
#line 94
  {(ustring)"false", KEYWORD},
#line 94
  {(ustring)"mutable", KEYWORD},
#line 94
  {(ustring)"namespace", KEYWORD},
#line 94
  {(ustring)"reinterpret_cast", KEYWORD},
#line 94
  {(ustring)"static_cast", KEYWORD},
#line 94
  {(ustring)"true", KEYWORD},
#line 94
  {(ustring)"typeid", KEYWORD},
#line 94
  {(ustring)"typename", KEYWORD},
#line 94
  {(ustring)"using", KEYWORD},
#line 94
  {(ustring)"wchar_t", KEYWORD},
#line 94

  ENDKEYWORD
};
const char * cpp_abbreviations []= {
  "c++", "h++", "C", "H", "cc", "hh", "cpp", "hpp", "cxx", "hxx", "pdb", "\0"
};
const uchar  cpp_description [] = "";
#define cpp_style_def { cpp_style, "C++",				\
  cpp_abbreviations, cpp_description, 					\
  CASE_SENSITIVE, c_characters, c_characters, cpp_keywords,		\
  NOSYMBOL, c_specials, cpp_sequences, sh_verbatims, EMPTY }

/*
 *		o2c
 */
const sequence o2c_sequences [] = {
  /* "real" sequences */
  {(ustring)"/*", COMMENT, COMMENT, (ustring)"*/", COMMENT},
  {(ustring)"\"", PLAIN, STRING, (ustring)"\"", PLAIN},
  {(ustring)"\'", PLAIN, STRING, (ustring)"\'", PLAIN},

  /* Highlight special labels */
  {(ustring)"application ", KEYWORD_STRONG, LABEL_STRONG, (ustring)"\n", PLAIN},
#line 118
  {(ustring)"class ", KEYWORD_STRONG, LABEL_STRONG, (ustring)"\n", PLAIN},
#line 120
  {(ustring)"method body ", KEYWORD_STRONG, LABEL_STRONG, (ustring)" in ", KEYWORD_STRONG},
#line 122
  {(ustring)"transaction body ", KEYWORD_STRONG, LABEL_STRONG, (ustring)" in ", KEYWORD_STRONG},
#line 124
  {(ustring)"program body ", KEYWORD_STRONG, LABEL_STRONG, (ustring)" in ", KEYWORD_STRONG},
#line 126
  {(ustring)"program public ", KEYWORD_STRONG, LABEL_STRONG, (ustring)" in ", KEYWORD_STRONG},
#line 128
  ENDSEQUENCE
};
const keyword o2c_keywords [] = {
  /* Preprocessor */
#line 131
  {(ustring)"#include", KEYWORD_STRONG},
#line 131
  {(ustring)"#define", KEYWORD_STRONG},
#line 131
  {(ustring)"#undef", KEYWORD_STRONG},
#line 131
  {(ustring)"#pragma", KEYWORD_STRONG},
#line 131
  {(ustring)"#if", KEYWORD_STRONG},
#line 131
  {(ustring)"#ifdef", KEYWORD_STRONG},
#line 131
  {(ustring)"#ifndef", KEYWORD_STRONG},
#line 131
  {(ustring)"#elif", KEYWORD_STRONG},
#line 131
  {(ustring)"#else", KEYWORD_STRONG},
#line 131
  {(ustring)"#error", KEYWORD_STRONG},
#line 131
  {(ustring)"#line", KEYWORD_STRONG},
#line 131
  {(ustring)"#ex", KEYWORD_STRONG},
#line 131
  {(ustring)"#endif", KEYWORD_STRONG},
#line 131
  {(ustring)"defined", KEYWORD_STRONG},
#line 131
  {(ustring)"# define", KEYWORD_STRONG},
#line 131
  {(ustring)"# include", KEYWORD_STRONG},
#line 131
  {(ustring)"# if", KEYWORD_STRONG},
#line 131
  {(ustring)"# ifdef", KEYWORD_STRONG},
#line 131
  {(ustring)"# endif", KEYWORD_STRONG},
#line 131
  {(ustring)"#import", KEYWORD_STRONG},
#line 131
  {(ustring)"# import", KEYWORD_STRONG},
#line 131
  {(ustring)"#  import", KEYWORD_STRONG},
#line 131
  {(ustring)"#  define", KEYWORD_STRONG},
#line 131
  {(ustring)"#  include", KEYWORD_STRONG},
#line 131
  {(ustring)"#  if", KEYWORD_STRONG},
#line 131
  {(ustring)"#  ifdef", KEYWORD_STRONG},
#line 131
  {(ustring)"#  endif", KEYWORD_STRONG},
#line 131

#line 131

#line 131
  /* simple types */
#line 131
  {(ustring)"double", KEYWORD},
#line 131
  {(ustring)"enum", KEYWORD},
#line 131
  {(ustring)"void", KEYWORD},
#line 131
  {(ustring)"int", KEYWORD},
#line 131
  {(ustring)"long", KEYWORD},
#line 131
  {(ustring)"FILE", KEYWORD},
#line 131
  {(ustring)"struct", KEYWORD},
#line 131
  {(ustring)"char", KEYWORD},
#line 131
  {(ustring)"signed", KEYWORD},
#line 131
  {(ustring)"float", KEYWORD},
#line 131
  {(ustring)"short", KEYWORD},
#line 131
  {(ustring)"unsigned", KEYWORD},
#line 131

#line 131

#line 131
  /* core of the keywords */
#line 131
  {(ustring)"inline", KEYWORD_STRONG},
#line 131
  {(ustring)"extern", KEYWORD_STRONG},
#line 131
  {(ustring)"const", KEYWORD_STRONG},
#line 131
  {(ustring)"register", KEYWORD_STRONG},
#line 131
  {(ustring)"return", KEYWORD_STRONG},
#line 131
  {(ustring)"continue", KEYWORD_STRONG},
#line 131
  {(ustring)"for", KEYWORD_STRONG},
#line 131
  {(ustring)"auto", KEYWORD_STRONG},
#line 131
  {(ustring)"switch", KEYWORD_STRONG},
#line 131
  {(ustring)"typedef", KEYWORD_STRONG},
#line 131
  {(ustring)"union", KEYWORD_STRONG},
#line 131
  {(ustring)"goto", KEYWORD_STRONG},
#line 131
  {(ustring)"sizeof", KEYWORD_STRONG},
#line 131
  {(ustring)"volatile", KEYWORD_STRONG},
#line 131
  {(ustring)"do", KEYWORD_STRONG},
#line 131
  {(ustring)"static", KEYWORD_STRONG},
#line 131
  {(ustring)"NULL", KEYWORD_STRONG},
#line 131
  {(ustring)"case", KEYWORD_STRONG},
#line 131
  {(ustring)"default", KEYWORD_STRONG},
#line 131
  {(ustring)"break", KEYWORD_STRONG},
#line 131
  {(ustring)"if", KEYWORD_STRONG},
#line 131
  {(ustring)"while", KEYWORD_STRONG},
#line 131
  {(ustring)"else", KEYWORD_STRONG},
#line 131


  /* o2c's own keywords */
  {(ustring)"class", KEYWORD_STRONG},
#line 136
  {(ustring)"inherit", KEYWORD_STRONG},
#line 136
  {(ustring)"public", KEYWORD_STRONG},
#line 136
  {(ustring)"application", KEYWORD_STRONG},
#line 136
  {(ustring)"modify", KEYWORD_STRONG},
#line 136
  {(ustring)"end", KEYWORD_STRONG},
#line 136
  {(ustring)"program", KEYWORD_STRONG},
#line 136
  {(ustring)"body", KEYWORD_STRONG},
#line 136
  {(ustring)"method", KEYWORD_STRONG},
#line 136
  {(ustring)"o2", KEYWORD_STRONG},
#line 136
  {(ustring)"in", KEYWORD_STRONG},
#line 136
  {(ustring)"new", KEYWORD_STRONG},
#line 136
  {(ustring)"o2query", KEYWORD_STRONG},
#line 136
  {(ustring)"name", KEYWORD_STRONG},
#line 136
  {(ustring)"function", KEYWORD_STRONG},
#line 136
  {(ustring)"abort", KEYWORD_STRONG},
#line 136
  {(ustring)"commit", KEYWORD_STRONG},
#line 136
  {(ustring)"quit", KEYWORD_STRONG},
#line 136
  {(ustring)"validate", KEYWORD_STRONG},
#line 136
  {(ustring)"schema", KEYWORD_STRONG},
#line 136
  {(ustring)"base", KEYWORD_STRONG},
#line 136

ENDKEYWORD
};
const char * o2c_abbreviations [] = {
  "o2", "\0"
};
const uchar  o2c_description [] = "";
#define o2c_style_def { o2c_style, "o2c",				\
  o2c_abbreviations, o2c_description, 					\
  CASE_SENSITIVE, c_characters, c_characters, o2c_keywords,		\
  NOSYMBOL, c_specials, o2c_sequences, sh_verbatims, EMPTY }


/*
 *              objc
 */
const uchar objc_characters [] = {
  '@', '@',
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '#', '%',
  '\0'
};
const sequence objc_sequences [] = {
  {(ustring)"/*", COMMENT, COMMENT, (ustring)"*/", COMMENT},
  {(ustring)"//", COMMENT, COMMENT, (ustring)"$", COMMENT},
  {(ustring)"\"", PLAIN, STRING, (ustring)"\"", PLAIN},
  {(ustring)"\'", PLAIN, STRING, (ustring)"\'", PLAIN},
  {(ustring)"^+", KEYWORD_STRONG, KEYWORD_STRONG, (ustring)"{", PLAIN},
  {(ustring)"^+", KEYWORD_STRONG, KEYWORD_STRONG, (ustring)";", PLAIN},
  {(ustring)"^-", KEYWORD_STRONG, KEYWORD_STRONG, (ustring)"{", PLAIN},
  {(ustring)"^-", KEYWORD_STRONG, KEYWORD_STRONG, (ustring)";", PLAIN},
  ENDSEQUENCE
};
const keyword objc_keywords [] = {
  /* Preprocessor */
#line 172
  {(ustring)"#include", KEYWORD_STRONG},
#line 172
  {(ustring)"#define", KEYWORD_STRONG},
#line 172
  {(ustring)"#undef", KEYWORD_STRONG},
#line 172
  {(ustring)"#pragma", KEYWORD_STRONG},
#line 172
  {(ustring)"#if", KEYWORD_STRONG},
#line 172
  {(ustring)"#ifdef", KEYWORD_STRONG},
#line 172
  {(ustring)"#ifndef", KEYWORD_STRONG},
#line 172
  {(ustring)"#elif", KEYWORD_STRONG},
#line 172
  {(ustring)"#else", KEYWORD_STRONG},
#line 172
  {(ustring)"#error", KEYWORD_STRONG},
#line 172
  {(ustring)"#line", KEYWORD_STRONG},
#line 172
  {(ustring)"#ex", KEYWORD_STRONG},
#line 172
  {(ustring)"#endif", KEYWORD_STRONG},
#line 172
  {(ustring)"defined", KEYWORD_STRONG},
#line 172
  {(ustring)"# define", KEYWORD_STRONG},
#line 172
  {(ustring)"# include", KEYWORD_STRONG},
#line 172
  {(ustring)"# if", KEYWORD_STRONG},
#line 172
  {(ustring)"# ifdef", KEYWORD_STRONG},
#line 172
  {(ustring)"# endif", KEYWORD_STRONG},
#line 172
  {(ustring)"#import", KEYWORD_STRONG},
#line 172
  {(ustring)"# import", KEYWORD_STRONG},
#line 172
  {(ustring)"#  import", KEYWORD_STRONG},
#line 172
  {(ustring)"#  define", KEYWORD_STRONG},
#line 172
  {(ustring)"#  include", KEYWORD_STRONG},
#line 172
  {(ustring)"#  if", KEYWORD_STRONG},
#line 172
  {(ustring)"#  ifdef", KEYWORD_STRONG},
#line 172
  {(ustring)"#  endif", KEYWORD_STRONG},
#line 172

#line 172

#line 172
  /* simple types */
#line 172
  {(ustring)"double", KEYWORD},
#line 172
  {(ustring)"enum", KEYWORD},
#line 172
  {(ustring)"void", KEYWORD},
#line 172
  {(ustring)"int", KEYWORD},
#line 172
  {(ustring)"long", KEYWORD},
#line 172
  {(ustring)"FILE", KEYWORD},
#line 172
  {(ustring)"struct", KEYWORD},
#line 172
  {(ustring)"char", KEYWORD},
#line 172
  {(ustring)"signed", KEYWORD},
#line 172
  {(ustring)"float", KEYWORD},
#line 172
  {(ustring)"short", KEYWORD},
#line 172
  {(ustring)"unsigned", KEYWORD},
#line 172

#line 172

#line 172
  /* core of the keywords */
#line 172
  {(ustring)"inline", KEYWORD_STRONG},
#line 172
  {(ustring)"extern", KEYWORD_STRONG},
#line 172
  {(ustring)"const", KEYWORD_STRONG},
#line 172
  {(ustring)"register", KEYWORD_STRONG},
#line 172
  {(ustring)"return", KEYWORD_STRONG},
#line 172
  {(ustring)"continue", KEYWORD_STRONG},
#line 172
  {(ustring)"for", KEYWORD_STRONG},
#line 172
  {(ustring)"auto", KEYWORD_STRONG},
#line 172
  {(ustring)"switch", KEYWORD_STRONG},
#line 172
  {(ustring)"typedef", KEYWORD_STRONG},
#line 172
  {(ustring)"union", KEYWORD_STRONG},
#line 172
  {(ustring)"goto", KEYWORD_STRONG},
#line 172
  {(ustring)"sizeof", KEYWORD_STRONG},
#line 172
  {(ustring)"volatile", KEYWORD_STRONG},
#line 172
  {(ustring)"do", KEYWORD_STRONG},
#line 172
  {(ustring)"static", KEYWORD_STRONG},
#line 172
  {(ustring)"NULL", KEYWORD_STRONG},
#line 172
  {(ustring)"case", KEYWORD_STRONG},
#line 172
  {(ustring)"default", KEYWORD_STRONG},
#line 172
  {(ustring)"break", KEYWORD_STRONG},
#line 172
  {(ustring)"if", KEYWORD_STRONG},
#line 172
  {(ustring)"while", KEYWORD_STRONG},
#line 172
  {(ustring)"else", KEYWORD_STRONG},
#line 172


  /* objc's simple type */
  {(ustring)"id", KEYWORD},
#line 175


  /* objc's own keywords */
  {(ustring)"@interface", KEYWORD_STRONG},
#line 180
  {(ustring)"@end", KEYWORD_STRONG},
#line 180
  {(ustring)"@implementation", KEYWORD_STRONG},
#line 180
  {(ustring)"@protocol", KEYWORD_STRONG},
#line 180
  {(ustring)"@class", KEYWORD_STRONG},
#line 180
  {(ustring)"@public", KEYWORD_STRONG},
#line 180
  {(ustring)"@protected", KEYWORD_STRONG},
#line 180
  {(ustring)"@private", KEYWORD_STRONG},
#line 180
  {(ustring)"in", KEYWORD_STRONG},
#line 180
  {(ustring)"out", KEYWORD_STRONG},
#line 180
  {(ustring)"inout", KEYWORD_STRONG},
#line 180
  {(ustring)"bycopy", KEYWORD_STRONG},
#line 180
  {(ustring)"oneway", KEYWORD_STRONG},
#line 180
  {(ustring)"self", KEYWORD_STRONG},
#line 180
  {(ustring)"_cmd", KEYWORD_STRONG},
#line 180
  {(ustring)"super", KEYWORD_STRONG},
#line 180
  {(ustring)"@selector", KEYWORD_STRONG},
#line 180
  {(ustring)"@encode", KEYWORD_STRONG},
#line 180
  {(ustring)"@defs", KEYWORD_STRONG},
#line 180

  ENDKEYWORD
};
const char * objc_abbreviations []= {
  "objc", "m", "\0"
};
const uchar  objc_description [] = "";
#define objc_style_def { objc_style, "ObjectiveC",    		\
  objc_abbreviations, objc_description,         		\
  CASE_SENSITIVE, objc_characters, c_characters, objc_keywords,	\
  NOSYMBOL, c_specials, objc_sequences, sh_verbatims, EMPTY }


/*
 *		Octave/MATLAB added by C.P. Earls March 1997
 */
const sequence octave_sequences [] = {
  {(ustring)"#", COMMENT, COMMENT, (ustring)"$", COMMENT},
  {(ustring)"\"", PLAIN, STRING, (ustring)"\"", PLAIN},
  ENDSEQUENCE
};
const uchar octave_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\0'
};
const symbol octave_regulars [] = {
  {(ustring)"not", (ustring)"\330", SYMBOL},
  {(ustring)"and", (ustring)"\331", SYMBOL},
  {(ustring)"or", (ustring)"\332", SYMBOL},
  ENDSYMBOL
};
const symbol octave_specials [] = {
  {(ustring)"<>", (ustring)"\271", SYMBOL},
  {(ustring)"!=", (ustring)"\271", SYMBOL},
  {(ustring)"<=", (ustring)"\243", SYMBOL},
  {(ustring)">=", (ustring)"\263", SYMBOL},
  {(ustring)"==", (ustring)"\272", SYMBOL},
  ENDSYMBOL
};
const keyword octave_keywords [] = {
 {(ustring)"all_va_args", KEYWORD_STRONG},
#line 225
  {(ustring)"endwhile", KEYWORD_STRONG},
#line 225
  {(ustring)"break", KEYWORD_STRONG},
#line 225
  {(ustring)"for", KEYWORD_STRONG},
#line 225
  {(ustring)"case", KEYWORD_STRONG},
#line 225
  {(ustring)"function", KEYWORD_STRONG},
#line 225
  {(ustring)"catch", KEYWORD_STRONG},
#line 225
  {(ustring)"global", KEYWORD_STRONG},
#line 225
  {(ustring)"continue", KEYWORD_STRONG},
#line 225
  {(ustring)"gplot", KEYWORD_STRONG},
#line 225
  {(ustring)"else", KEYWORD_STRONG},
#line 225
  {(ustring)"gsplot", KEYWORD_STRONG},
#line 225
  {(ustring)"elseif", KEYWORD_STRONG},
#line 225
  {(ustring)"if", KEYWORD_STRONG},
#line 225
  {(ustring)"end", KEYWORD_STRONG},
#line 225
  {(ustring)"otherwise", KEYWORD_STRONG},
#line 225
  {(ustring)"end_try_catch", KEYWORD_STRONG},
#line 225
  {(ustring)"return", KEYWORD_STRONG},
#line 225
  {(ustring)"end_unwind_protect", KEYWORD_STRONG},
#line 225
  {(ustring)"switch", KEYWORD_STRONG},
#line 225
  {(ustring)"endfor", KEYWORD_STRONG},
#line 225
  {(ustring)"try", KEYWORD_STRONG},
#line 225
  {(ustring)"endfunction", KEYWORD_STRONG},
#line 225
  {(ustring)"unwind_protect", KEYWORD_STRONG},
#line 225
  {(ustring)"endif", KEYWORD_STRONG},
#line 225
  {(ustring)"unwind_protect_cleanup", KEYWORD_STRONG},
#line 225
  {(ustring)"endswitch", KEYWORD_STRONG},
#line 225
  {(ustring)"while", KEYWORD_STRONG},
#line 225

  ENDKEYWORD
};

const char * octave_abbreviations []= {
  "octavescript", "m", "\0"
};
const uchar  octave_description [] = "";
#define octave_style_def { octave_style, "octave",			\
  octave_abbreviations, octave_description, 				\
  CASE_SENSITIVE, octave_characters, octave_characters, octave_keywords, \
  octave_regulars, octave_specials, octave_sequences, sh_verbatims, EMPTY }
#line 312 "styles.c.in"

/************************************************************************/
/*				Tcl & Tk			   	*/
/************************************************************************/
/*
 * 		TCL
 * 		tk
 */
#line 1 "styles06.m4"
/*
 * 		TCL
 */
const symbol tcl_specials [] = {
  {(ustring)"&&", (ustring)"\331", SYMBOL},
  {(ustring)"||", (ustring)"\332", SYMBOL},
  {(ustring)"!=", (ustring)"\271", SYMBOL},
  {(ustring)"==", (ustring)"\272", SYMBOL},
  {(ustring)"<=", (ustring)"\243", SYMBOL},
  {(ustring)">=", (ustring)"\263", SYMBOL},
  {(ustring)"!", (ustring)"\330", SYMBOL},
  ENDSYMBOL
};
const uchar tcl_characters [] = {
  'A', 'Z',
  'a', 'z',
  '-', '.',
  '_', '_',
  '#', '%',
  '\0'
};
const sequence tcl_sequences [] = { 
  {(ustring)"#", COMMENT, COMMENT, (ustring)"$", COMMENT},
  {(ustring)"\"", PLAIN, STRING, (ustring)"\"", PLAIN},
  ENDSEQUENCE
};
const keyword tcl_keywords [] = {
  {(ustring)"append", KEYWORD_STRONG},
#line 35
  {(ustring)"array", KEYWORD_STRONG},
#line 35
  {(ustring)"break", KEYWORD_STRONG},
#line 35
  {(ustring)"case", KEYWORD_STRONG},
#line 35
  {(ustring)"catch", KEYWORD_STRONG},
#line 35
  {(ustring)"cd", KEYWORD_STRONG},
#line 35
  {(ustring)"close", KEYWORD_STRONG},
#line 35
  {(ustring)"concat", KEYWORD_STRONG},
#line 35
  {(ustring)"continue", KEYWORD_STRONG},
#line 35
  {(ustring)"eof", KEYWORD_STRONG},
#line 35
  {(ustring)"error", KEYWORD_STRONG},
#line 35
  {(ustring)"eval", KEYWORD_STRONG},
#line 35
  {(ustring)"exec", KEYWORD_STRONG},
#line 35
  {(ustring)"exit", KEYWORD_STRONG},
#line 35
  {(ustring)"expr", KEYWORD_STRONG},
#line 35
  {(ustring)"file", KEYWORD_STRONG},
#line 35
  {(ustring)"flush", KEYWORD_STRONG},
#line 35
  {(ustring)"for", KEYWORD_STRONG},
#line 35
  {(ustring)"foreach", KEYWORD_STRONG},
#line 35
  {(ustring)"format", KEYWORD_STRONG},
#line 35
  {(ustring)"gets", KEYWORD_STRONG},
#line 35
  {(ustring)"glob", KEYWORD_STRONG},
#line 35
  {(ustring)"global", KEYWORD_STRONG},
#line 35
  {(ustring)"history", KEYWORD_STRONG},
#line 35
  {(ustring)"if", KEYWORD_STRONG},
#line 35
  {(ustring)"incr", KEYWORD_STRONG},
#line 35
  {(ustring)"info", KEYWORD_STRONG},
#line 35
  {(ustring)"join", KEYWORD_STRONG},
#line 35
  {(ustring)"lappend", KEYWORD_STRONG},
#line 35
  {(ustring)"library", KEYWORD_STRONG},
#line 35
  {(ustring)"lindex", KEYWORD_STRONG},
#line 35
  {(ustring)"linsert", KEYWORD_STRONG},
#line 35
  {(ustring)"list", KEYWORD_STRONG},
#line 35
  {(ustring)"llength", KEYWORD_STRONG},
#line 35
  {(ustring)"lrange", KEYWORD_STRONG},
#line 35
  {(ustring)"lreplace", KEYWORD_STRONG},
#line 35
  {(ustring)"lsearch", KEYWORD_STRONG},
#line 35
  {(ustring)"lsort", KEYWORD_STRONG},
#line 35
  {(ustring)"open", KEYWORD_STRONG},
#line 35
  {(ustring)"pid", KEYWORD_STRONG},
#line 35
  {(ustring)"proc", KEYWORD_STRONG},
#line 35
  {(ustring)"puts", KEYWORD_STRONG},
#line 35
  {(ustring)"pwd", KEYWORD_STRONG},
#line 35
  {(ustring)"read", KEYWORD_STRONG},
#line 35
  {(ustring)"regexp", KEYWORD_STRONG},
#line 35
  {(ustring)"regsub", KEYWORD_STRONG},
#line 35
  {(ustring)"rename", KEYWORD_STRONG},
#line 35
  {(ustring)"return", KEYWORD_STRONG},
#line 35
  {(ustring)"scan", KEYWORD_STRONG},
#line 35
  {(ustring)"seek", KEYWORD_STRONG},
#line 35
  {(ustring)"set", KEYWORD_STRONG},
#line 35
  {(ustring)"source", KEYWORD_STRONG},
#line 35
  {(ustring)"split", KEYWORD_STRONG},
#line 35
  {(ustring)"string", KEYWORD_STRONG},
#line 35
  {(ustring)"switch", KEYWORD_STRONG},
#line 35
  {(ustring)"tell", KEYWORD_STRONG},
#line 35
  {(ustring)"then", KEYWORD_STRONG},
#line 35
  {(ustring)"time", KEYWORD_STRONG},
#line 35
  {(ustring)"trace", KEYWORD_STRONG},
#line 35
  {(ustring)"unknown", KEYWORD_STRONG},
#line 35
  {(ustring)"unset", KEYWORD_STRONG},
#line 35
  {(ustring)"uplevel", KEYWORD_STRONG},
#line 35
  {(ustring)"upvar", KEYWORD_STRONG},
#line 35
  {(ustring)"while", KEYWORD_STRONG},
#line 35
  {(ustring)"elseif", KEYWORD_STRONG},
#line 35
  {(ustring)"else", KEYWORD_STRONG},
#line 35
  {(ustring)"default", KEYWORD_STRONG},
#line 35

  ENDKEYWORD
};
const char * tcl_abbreviations []= {
  "tclscript", "\0"
};
const uchar  tcl_description [] = "";
#define tcl_style_def { tcl_style, "tcl",					\
  tcl_abbreviations, tcl_description, 					\
  CASE_SENSITIVE, tcl_characters, tcl_characters, tcl_keywords, 	\
  NOSYMBOL, tcl_specials, tcl_sequences, sh_verbatims, EMPTY }

/*
 * 		tk
 */
const keyword tk_keywords [] = {
  {(ustring)"append", KEYWORD_STRONG},
#line 62
  {(ustring)"array", KEYWORD_STRONG},
#line 62
  {(ustring)"break", KEYWORD_STRONG},
#line 62
  {(ustring)"case", KEYWORD_STRONG},
#line 62
  {(ustring)"catch", KEYWORD_STRONG},
#line 62
  {(ustring)"cd", KEYWORD_STRONG},
#line 62
  {(ustring)"close", KEYWORD_STRONG},
#line 62
  {(ustring)"concat", KEYWORD_STRONG},
#line 62
  {(ustring)"continue", KEYWORD_STRONG},
#line 62
  {(ustring)"eof", KEYWORD_STRONG},
#line 62
  {(ustring)"error", KEYWORD_STRONG},
#line 62
  {(ustring)"eval", KEYWORD_STRONG},
#line 62
  {(ustring)"exec", KEYWORD_STRONG},
#line 62
  {(ustring)"exit", KEYWORD_STRONG},
#line 62
  {(ustring)"expr", KEYWORD_STRONG},
#line 62
  {(ustring)"file", KEYWORD_STRONG},
#line 62
  {(ustring)"flush", KEYWORD_STRONG},
#line 62
  {(ustring)"for", KEYWORD_STRONG},
#line 62
  {(ustring)"foreach", KEYWORD_STRONG},
#line 62
  {(ustring)"format", KEYWORD_STRONG},
#line 62
  {(ustring)"gets", KEYWORD_STRONG},
#line 62
  {(ustring)"glob", KEYWORD_STRONG},
#line 62
  {(ustring)"global", KEYWORD_STRONG},
#line 62
  {(ustring)"history", KEYWORD_STRONG},
#line 62
  {(ustring)"if", KEYWORD_STRONG},
#line 62
  {(ustring)"incr", KEYWORD_STRONG},
#line 62
  {(ustring)"info", KEYWORD_STRONG},
#line 62
  {(ustring)"join", KEYWORD_STRONG},
#line 62
  {(ustring)"lappend", KEYWORD_STRONG},
#line 62
  {(ustring)"library", KEYWORD_STRONG},
#line 62
  {(ustring)"lindex", KEYWORD_STRONG},
#line 62
  {(ustring)"linsert", KEYWORD_STRONG},
#line 62
  {(ustring)"list", KEYWORD_STRONG},
#line 62
  {(ustring)"llength", KEYWORD_STRONG},
#line 62
  {(ustring)"lrange", KEYWORD_STRONG},
#line 62
  {(ustring)"lreplace", KEYWORD_STRONG},
#line 62
  {(ustring)"lsearch", KEYWORD_STRONG},
#line 62
  {(ustring)"lsort", KEYWORD_STRONG},
#line 62
  {(ustring)"open", KEYWORD_STRONG},
#line 62
  {(ustring)"pid", KEYWORD_STRONG},
#line 62
  {(ustring)"proc", KEYWORD_STRONG},
#line 62
  {(ustring)"puts", KEYWORD_STRONG},
#line 62
  {(ustring)"pwd", KEYWORD_STRONG},
#line 62
  {(ustring)"read", KEYWORD_STRONG},
#line 62
  {(ustring)"regexp", KEYWORD_STRONG},
#line 62
  {(ustring)"regsub", KEYWORD_STRONG},
#line 62
  {(ustring)"rename", KEYWORD_STRONG},
#line 62
  {(ustring)"return", KEYWORD_STRONG},
#line 62
  {(ustring)"scan", KEYWORD_STRONG},
#line 62
  {(ustring)"seek", KEYWORD_STRONG},
#line 62
  {(ustring)"set", KEYWORD_STRONG},
#line 62
  {(ustring)"source", KEYWORD_STRONG},
#line 62
  {(ustring)"split", KEYWORD_STRONG},
#line 62
  {(ustring)"string", KEYWORD_STRONG},
#line 62
  {(ustring)"switch", KEYWORD_STRONG},
#line 62
  {(ustring)"tell", KEYWORD_STRONG},
#line 62
  {(ustring)"then", KEYWORD_STRONG},
#line 62
  {(ustring)"time", KEYWORD_STRONG},
#line 62
  {(ustring)"trace", KEYWORD_STRONG},
#line 62
  {(ustring)"unknown", KEYWORD_STRONG},
#line 62
  {(ustring)"unset", KEYWORD_STRONG},
#line 62
  {(ustring)"uplevel", KEYWORD_STRONG},
#line 62
  {(ustring)"upvar", KEYWORD_STRONG},
#line 62
  {(ustring)"while", KEYWORD_STRONG},
#line 62
  {(ustring)"elseif", KEYWORD_STRONG},
#line 62
  {(ustring)"else", KEYWORD_STRONG},
#line 62
  {(ustring)"default", KEYWORD_STRONG},
#line 62
  {(ustring)"after", KEYWORD_STRONG},
#line 62
  {(ustring)"bind", KEYWORD_STRONG},
#line 62
  {(ustring)"button", KEYWORD_STRONG},
#line 62
  {(ustring)"canvas", KEYWORD_STRONG},
#line 62
  {(ustring)"checkbutton", KEYWORD_STRONG},
#line 62
  {(ustring)"destroy", KEYWORD_STRONG},
#line 62
  {(ustring)"dialog", KEYWORD_STRONG},
#line 62
  {(ustring)"entry", KEYWORD_STRONG},
#line 62
  {(ustring)"focus", KEYWORD_STRONG},
#line 62
  {(ustring)"frame", KEYWORD_STRONG},
#line 62
  {(ustring)"grab", KEYWORD_STRONG},
#line 62
  {(ustring)"label", KEYWORD_STRONG},
#line 62
  {(ustring)"lbSingSel", KEYWORD_STRONG},
#line 62
  {(ustring)"listbox", KEYWORD_STRONG},
#line 62
  {(ustring)"lower", KEYWORD_STRONG},
#line 62
  {(ustring)"menu", KEYWORD_STRONG},
#line 62
  {(ustring)"menubar", KEYWORD_STRONG},
#line 62
  {(ustring)"menubutton", KEYWORD_STRONG},
#line 62
  {(ustring)"message", KEYWORD_STRONG},
#line 62
  {(ustring)"option", KEYWORD_STRONG},
#line 62
  {(ustring)"options", KEYWORD_STRONG},
#line 62
  {(ustring)"pack", KEYWORD_STRONG},
#line 62
  {(ustring)"place", KEYWORD_STRONG},
#line 62
  {(ustring)"radiobutton", KEYWORD_STRONG},
#line 62
  {(ustring)"raise", KEYWORD_STRONG},
#line 62
  {(ustring)"scale", KEYWORD_STRONG},
#line 62
  {(ustring)"scrollbar", KEYWORD_STRONG},
#line 62
  {(ustring)"selection", KEYWORD_STRONG},
#line 62
  {(ustring)"send", KEYWORD_STRONG},
#line 62
  {(ustring)"text", KEYWORD_STRONG},
#line 62
  {(ustring)"tkerror", KEYWORD_STRONG},
#line 62
  {(ustring)"tkwait", KEYWORD_STRONG},
#line 62
  {(ustring)"toplevel", KEYWORD_STRONG},
#line 62
  {(ustring)"update", KEYWORD_STRONG},
#line 62
  {(ustring)"winfo", KEYWORD_STRONG},
#line 62
  {(ustring)"wm", KEYWORD_STRONG},
#line 62

   ENDKEYWORD
};
const char * tk_abbreviations []= {
  "wish", "\0"
};
const uchar  tk_description [] = "";
#define tk_style_def { tk_style, "tk", 					\
  tk_abbreviations, tk_description, 					\
  CASE_SENSITIVE, tcl_characters, tcl_characters, tk_keywords, 		\
  NOSYMBOL, c_specials, tcl_sequences, sh_verbatims, EMPTY }
#line 320 "styles.c.in"

/************************************************************************/
/*			Object-oriented languages		   	*/
/************************************************************************/
/*
 *		Claire
 *		Java
 *		Ada
 *		Sather
 *		Python
 */
#line 1 "styles07.m4"
/*
 *		Claire
 */
const sequence claire_sequences [] = {
  {(ustring)"//*", COMMENT, COMMENT_STRONG, (ustring)"*//", COMMENT},
  {(ustring)";;", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 6
  {(ustring)"//", COMMENT, COMMENT, (ustring)"$", COMMENT},
  {(ustring)"\"", PLAIN, STRING, (ustring)"\"", PLAIN},
  {(ustring)"\'", PLAIN, STRING, (ustring)"\'", PLAIN},

  /* this is strange ;) */
  {(ustring)"^[", PLAIN, LABEL_STRONG, (ustring)"<:", PLAIN},
  {(ustring)"^[", PLAIN, LABEL, (ustring)"[", PLAIN},
  {(ustring)"^[", PLAIN, LABEL, (ustring)"(", PLAIN},
  ENDSEQUENCE
};
const uchar claire_first_characters [] = {
  'A', 'Z',
  'a', 'z',
  '!', '!', 
  '%', '&',
  '*', '+',
  '-', '-',
  '/', '/',
  ':', ':',
  '^', '_',
  '<', '>',
  '|', '|', 
  '\0'
};
const uchar claire_following_characters [] = {
  'A', 'Z',
  'a', 'z',
  '!', '!', 
  '%', '\'', /* ' may be used like x' := x + 1 */
  '*', '+',
  '-', '-',
  '/', '/',
  ':', ':',
  '^', '_',
  '<', '>',
  '|', '|', 
  '\0'
};
const symbol claire_regulars [] = {
  {(ustring) "forall", (ustring) "\"", SYMBOL},
  {(ustring) "exists", (ustring) "$", SYMBOL},
  {(ustring) "%", (ustring) "\316", SYMBOL},
  {(ustring) ":=", (ustring) ":=", PLAIN},
  {(ustring)"=", (ustring)"\272", SYMBOL},
  {(ustring)"!=", (ustring)"\271", SYMBOL},
  {(ustring)"<=", (ustring)"\243", SYMBOL},
  {(ustring)">=", (ustring)"\263", SYMBOL},
  {(ustring)"->", (ustring)"\256", SYMBOL},
  {(ustring)"=>", (ustring)"\336", SYMBOL},
  {(ustring) "U", (ustring) "\310", SYMBOL},
  {(ustring)"not", (ustring)"\330", SYMBOL},
  ENDSYMBOL
};
const symbol claire_specials [] = {
  {(ustring) "{}", (ustring) "\306", SYMBOL},	/* empty set */
  ENDSYMBOL
};
const keyword claire_keywords [] = {
  {(ustring)"forall", KEYWORD_STRONG},
#line 66
  {(ustring)"none", KEYWORD_STRONG},
#line 66
  {(ustring)"catch", KEYWORD_STRONG},
#line 66
  {(ustring)"in", KEYWORD_STRONG},
#line 66
  {(ustring)"as", KEYWORD_STRONG},
#line 66
  {(ustring)"printf", KEYWORD_STRONG},
#line 66
  {(ustring)"assert", KEYWORD_STRONG},
#line 66
  {(ustring)"return", KEYWORD_STRONG},
#line 66
  {(ustring)"break", KEYWORD_STRONG},
#line 66
  {(ustring)"trace", KEYWORD_STRONG},
#line 66
  {(ustring)"else", KEYWORD_STRONG},
#line 66
  {(ustring)"for", KEYWORD_STRONG},
#line 66
  {(ustring)"case", KEYWORD_STRONG},
#line 66
  {(ustring)"while", KEYWORD_STRONG},
#line 66
  {(ustring)"until", KEYWORD_STRONG},
#line 66
  {(ustring)"let", KEYWORD_STRONG},
#line 66
  {(ustring)"when", KEYWORD_STRONG},
#line 66
  {(ustring)"try", KEYWORD_STRONG},
#line 66
  {(ustring)"if", KEYWORD_STRONG},
#line 66
  {(ustring)"Zif", KEYWORD_STRONG},
#line 66
  {(ustring)"exists", KEYWORD_STRONG},
#line 66
  {(ustring)"<:", KEYWORD_STRONG},
#line 66
  {(ustring)"=>", KEYWORD_STRONG},
#line 66
  {(ustring)"->", KEYWORD_STRONG},
#line 66
  {(ustring)"::", KEYWORD_STRONG},
#line 66

  ENDKEYWORD
};
const char * claire_abbreviations []= {
  "cl", "\0"
};
const uchar claire_description [] = "\
CLAIRE is a high-level functional and object-oriented language with \
advanced rule processing capabilities. It is intended to allow the \
programmer to express complex algorithms with fewer lines and in an \
elegant and readable manner. \n\
To provide a high degree of expressivity, CLAIRE uses: \n\
 - A very rich type system including type intervals and second-order types (with dual static/dynamic typing),\n\
 - Parametric classes and methods, \n\
 - An object-oriented logic with set extensions, \n\
 - Dynamic versioning that supports easy exploration of search spaces. \n\
 To achieve its goal of readability, CLAIRE uses \n\
 - set-based programming with an intuitive syntax, \n\
 - simple-minded object-oriented programming, \n\
 - truly polymorphic and parametric functional programming, \n\
 - a powerful-yet-readable extension of DATALOG to express logical conditions, \n\
 - an entity-relation approach with explicit relations, inverses, unknown values and relational\n\
 - operations. \n\
More information on claire can be found on:\n\
http://www.ens.fr/\\verb+~+laburthe/claire.html\n";
#define claire_style_def {claire_style, "claire",			\
  claire_abbreviations, claire_description, 			\
  CASE_SENSITIVE, claire_first_characters, 			\
  claire_following_characters,	claire_keywords,		\
  claire_regulars, claire_specials, claire_sequences, sh_verbatims, EMPTY }

/*
 *		Java
 */
const uchar java_characters_1 [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '#', '%',
  '\0'
};
const uchar java_characters_2 [] = {
  'A', 'Z',
  'a', 'z',
  '.', '.', 
  '_', '_',
  '#', '%',
  '\0'
};
const sequence java_sequences [] = {
  /* doc. comments */
  {(ustring)"/**", COMMENT_STRONG, COMMENT_STRONG, (ustring)"*/", COMMENT_STRONG},
  {(ustring)"/*", COMMENT, COMMENT, (ustring)"*/", COMMENT},
  {(ustring)"//", COMMENT, COMMENT, (ustring)"$", COMMENT},
  {(ustring)"\"", PLAIN, STRING, (ustring)"\"", PLAIN},

  /* Declaration of a class */
  {(ustring)"class ", KEYWORD_STRONG, LABEL_STRONG, (ustring)" extends ", KEYWORD_STRONG},
  {(ustring)"class ", KEYWORD_STRONG, LABEL_STRONG, (ustring)"{", PLAIN},
  {(ustring)"class ", KEYWORD_STRONG, LABEL_STRONG, (ustring)"$", PLAIN},
  ENDSEQUENCE
};
const keyword java_keywords [] = {
  {(ustring)"byte", KEYWORD},
  {(ustring)"float", KEYWORD},
#line 130
  {(ustring)"int", KEYWORD},
#line 130
  {(ustring)"short", KEYWORD},
#line 130
  {(ustring)"char", KEYWORD},
#line 130
  {(ustring)"void", KEYWORD},
#line 130
  {(ustring)"boolean", KEYWORD},
#line 130
  {(ustring)"double", KEYWORD},
#line 130
  {(ustring)"long", KEYWORD},
#line 130
  {(ustring)"null", KEYWORD},
#line 130
  {(ustring)"this", KEYWORD},
#line 130


  {(ustring)"one", KEYWORD_STRONG},
#line 136
  {(ustring)"of", KEYWORD_STRONG},
#line 136
  {(ustring)"abstract", KEYWORD_STRONG},
#line 136
  {(ustring)"default", KEYWORD_STRONG},
#line 136
  {(ustring)"if", KEYWORD_STRONG},
#line 136
  {(ustring)"private", KEYWORD_STRONG},
#line 136
  {(ustring)"throw", KEYWORD_STRONG},
#line 136
  {(ustring)"do", KEYWORD_STRONG},
#line 136
  {(ustring)"implements", KEYWORD_STRONG},
#line 136
  {(ustring)"protected", KEYWORD_STRONG},
#line 136
  {(ustring)"throws", KEYWORD_STRONG},
#line 136
  {(ustring)"break", KEYWORD_STRONG},
#line 136
  {(ustring)"import", KEYWORD_STRONG},
#line 136
  {(ustring)"public", KEYWORD_STRONG},
#line 136
  {(ustring)"transient", KEYWORD_STRONG},
#line 136
  {(ustring)"else", KEYWORD_STRONG},
#line 136
  {(ustring)"instanceof", KEYWORD_STRONG},
#line 136
  {(ustring)"return", KEYWORD_STRONG},
#line 136
  {(ustring)"try", KEYWORD_STRONG},
#line 136
  {(ustring)"case", KEYWORD_STRONG},
#line 136
  {(ustring)"extends", KEYWORD_STRONG},
#line 136
  {(ustring)"catch", KEYWORD_STRONG},
#line 136
  {(ustring)"final", KEYWORD_STRONG},
#line 136
  {(ustring)"interface", KEYWORD_STRONG},
#line 136
  {(ustring)"static", KEYWORD_STRONG},
#line 136
  {(ustring)"volatile", KEYWORD_STRONG},
#line 136
  {(ustring)"finally", KEYWORD_STRONG},
#line 136
  {(ustring)"super", KEYWORD_STRONG},
#line 136
  {(ustring)"while", KEYWORD_STRONG},
#line 136
  {(ustring)"class", KEYWORD_STRONG},
#line 136
  {(ustring)"native", KEYWORD_STRONG},
#line 136
  {(ustring)"switch", KEYWORD_STRONG},
#line 136
  {(ustring)"const", KEYWORD_STRONG},
#line 136
  {(ustring)"for", KEYWORD_STRONG},
#line 136
  {(ustring)"new", KEYWORD_STRONG},
#line 136
  {(ustring)"synchronized", KEYWORD_STRONG},
#line 136
  {(ustring)"continue", KEYWORD_STRONG},
#line 136
  {(ustring)"goto", KEYWORD_STRONG},
#line 136
  {(ustring)"package", KEYWORD_STRONG},
#line 136

  ENDKEYWORD
};
const char * java_abbreviations []= {
  "\0"
};
const uchar  java_description [] = "";
#define java_style_def {java_style, "java",				\
  java_abbreviations, java_description,			 		\
  CASE_SENSITIVE, java_characters_1, java_characters_2,	java_keywords,	\
  NOSYMBOL, c_specials, java_sequences, sh_verbatims, EMPTY }


/*
 *		Ada
 */
const sequence ada_sequences [] = {
  {(ustring)"--", COMMENT, COMMENT, (ustring)"$", COMMENT},
  {(ustring)"\"", PLAIN, STRING, (ustring)"\"", PLAIN},
  {(ustring)"\'", PLAIN, STRING, (ustring)"\'", PLAIN},
  {(ustring)"\'", PLAIN, STRING, (ustring)"\'\'", PLAIN},

  /* Declarations of packages */
  {(ustring)"package body ", KEYWORD_STRONG, LABEL_STRONG, (ustring)" is", KEYWORD_STRONG},
#line 161
  {(ustring)"package ", KEYWORD_STRONG, LABEL_STRONG, (ustring)" is", KEYWORD_STRONG},
#line 163
  {(ustring)"package ", KEYWORD_STRONG, LABEL_STRONG, (ustring)" renames", KEYWORD_STRONG},
#line 165


  /* Declaration of procedures */
  {(ustring)"procedure ", KEYWORD_STRONG, LABEL, (ustring)" renames", KEYWORD_STRONG},
  {(ustring)"procedure ", KEYWORD_STRONG, LABEL, (ustring)" is", KEYWORD_STRONG},
  {(ustring)"procedure ", KEYWORD_STRONG, LABEL, (ustring)" (", PLAIN},
  {(ustring)"procedure ", KEYWORD_STRONG, LABEL, (ustring)"(", PLAIN},
  {(ustring)"procedure ", KEYWORD_STRONG, LABEL, (ustring)"$", PLAIN},
  {(ustring)"procedure ", KEYWORD_STRONG, LABEL, (ustring)";", PLAIN},

  /* Declaration of functions */
  {(ustring)"function ", KEYWORD_STRONG, LABEL, (ustring)" return ", KEYWORD_STRONG},
  {(ustring)"function ", KEYWORD_STRONG, LABEL, (ustring)" renames", KEYWORD_STRONG},
  {(ustring)"function ", KEYWORD_STRONG, LABEL, (ustring)" is", KEYWORD_STRONG},
  {(ustring)"function ", KEYWORD_STRONG, LABEL, (ustring)" (", PLAIN},
  {(ustring)"function ", KEYWORD_STRONG, LABEL, (ustring)"(", PLAIN},
  {(ustring)"function ", KEYWORD_STRONG, LABEL, (ustring)"$", PLAIN},
  {(ustring)"function ", KEYWORD_STRONG, LABEL, (ustring)";", PLAIN},
  ENDSEQUENCE
};
const uchar* ada_escapes [] = {
  (ustring) "\"\"", UNULL
};
const uchar ada_1_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  ')', ')', 		/* L(1)'First is not opening either	*/
  '\0'
};
const uchar ada_2_characters [] = {
  '0', '9', 		/* S1'Length is not opening */
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\'', '\'',           /*  L'First  is not opening in ada 	*/
  '\0'
};
const symbol ada_regulars [] = {
#if 0	/* most people do not want them */
  {(ustring) "and then", (ustring) "and then", KEYWORD_STRONG},	/* protect these two */
  {(ustring) "or else", (ustring) "or else", KEYWORD_STRONG},
  {(ustring)"and", (ustring)"\331", SYMBOL},
  {(ustring)"or", (ustring)"\332", SYMBOL},
  {(ustring)"not", (ustring)"\330", SYMBOL},
#endif
  ENDSYMBOL
};
const symbol ada_specials [] = {
  {(ustring)"!=", (ustring)"\271", SYMBOL},
  {(ustring)"==", (ustring)"\272", SYMBOL},
  {(ustring)"<=", (ustring)"\243", SYMBOL},
  {(ustring)">=", (ustring)"\263", SYMBOL},
  {(ustring)"=>", (ustring)"\336", SYMBOL},
  ENDSYMBOL
};
/* access procedure/function are here to protect the sequences
 * procedure/function */
const keyword ada_keywords [] = {
  {(ustring)"abort", KEYWORD_STRONG},
#line 232
  {(ustring)"abs", KEYWORD_STRONG},
#line 232
  {(ustring)"abstract", KEYWORD_STRONG},
#line 232
  {(ustring)"accept", KEYWORD_STRONG},
#line 232
  {(ustring)"access", KEYWORD_STRONG},
#line 232
  {(ustring)"access function", KEYWORD_STRONG},
#line 232
  {(ustring)"access procedure", KEYWORD_STRONG},
#line 232
  {(ustring)"aliased", KEYWORD_STRONG},
#line 232
  {(ustring)"all", KEYWORD_STRONG},
#line 232
  {(ustring)"and", KEYWORD_STRONG},
#line 232
  {(ustring)"array", KEYWORD_STRONG},
#line 232
  {(ustring)"at", KEYWORD_STRONG},
#line 232
  {(ustring)"begin", KEYWORD_STRONG},
#line 232
  {(ustring)"body", KEYWORD_STRONG},
#line 232
  {(ustring)"case", KEYWORD_STRONG},
#line 232
  {(ustring)"constant", KEYWORD_STRONG},
#line 232
  {(ustring)"declare", KEYWORD_STRONG},
#line 232
  {(ustring)"delay", KEYWORD_STRONG},
#line 232
  {(ustring)"delta", KEYWORD_STRONG},
#line 232
  {(ustring)"digits", KEYWORD_STRONG},
#line 232
  {(ustring)"do", KEYWORD_STRONG},
#line 232
  {(ustring)"else", KEYWORD_STRONG},
#line 232
  {(ustring)"elsif", KEYWORD_STRONG},
#line 232
  {(ustring)"end", KEYWORD_STRONG},
#line 232
  {(ustring)"entry", KEYWORD_STRONG},
#line 232
  {(ustring)"exception", KEYWORD_STRONG},
#line 232
  {(ustring)"exit", KEYWORD_STRONG},
#line 232
  {(ustring)"for", KEYWORD_STRONG},
#line 232
  {(ustring)"function", KEYWORD_STRONG},
#line 232
  {(ustring)"generic", KEYWORD_STRONG},
#line 232
  {(ustring)"goto", KEYWORD_STRONG},
#line 232
  {(ustring)"if", KEYWORD_STRONG},
#line 232
  {(ustring)"in", KEYWORD_STRONG},
#line 232
  {(ustring)"is", KEYWORD_STRONG},
#line 232
  {(ustring)"limited", KEYWORD_STRONG},
#line 232
  {(ustring)"loop", KEYWORD_STRONG},
#line 232
  {(ustring)"mod", KEYWORD_STRONG},
#line 232
  {(ustring)"new", KEYWORD_STRONG},
#line 232
  {(ustring)"not", KEYWORD_STRONG},
#line 232
  {(ustring)"null", KEYWORD_STRONG},
#line 232
  {(ustring)"of", KEYWORD_STRONG},
#line 232
  {(ustring)"or", KEYWORD_STRONG},
#line 232
  {(ustring)"others", KEYWORD_STRONG},
#line 232
  {(ustring)"out", KEYWORD_STRONG},
#line 232
  {(ustring)"package", KEYWORD_STRONG},
#line 232
  {(ustring)"pragma", KEYWORD_STRONG},
#line 232
  {(ustring)"private", KEYWORD_STRONG},
#line 232
  {(ustring)"procedure", KEYWORD_STRONG},
#line 232
  {(ustring)"protected", KEYWORD_STRONG},
#line 232
  {(ustring)"raise", KEYWORD_STRONG},
#line 232
  {(ustring)"range", KEYWORD_STRONG},
#line 232
  {(ustring)"record", KEYWORD_STRONG},
#line 232
  {(ustring)"rem", KEYWORD_STRONG},
#line 232
  {(ustring)"renames", KEYWORD_STRONG},
#line 232
  {(ustring)"requeue", KEYWORD_STRONG},
#line 232
  {(ustring)"return", KEYWORD_STRONG},
#line 232
  {(ustring)"reverse", KEYWORD_STRONG},
#line 232
  {(ustring)"select", KEYWORD_STRONG},
#line 232
  {(ustring)"separate", KEYWORD_STRONG},
#line 232
  {(ustring)"subtype", KEYWORD_STRONG},
#line 232
  {(ustring)"tagged", KEYWORD_STRONG},
#line 232
  {(ustring)"task", KEYWORD_STRONG},
#line 232
  {(ustring)"terminate", KEYWORD_STRONG},
#line 232
  {(ustring)"then", KEYWORD_STRONG},
#line 232
  {(ustring)"type", KEYWORD_STRONG},
#line 232
  {(ustring)"until", KEYWORD_STRONG},
#line 232
  {(ustring)"use", KEYWORD_STRONG},
#line 232
  {(ustring)"when", KEYWORD_STRONG},
#line 232
  {(ustring)"while", KEYWORD_STRONG},
#line 232
  {(ustring)"with", KEYWORD_STRONG},
#line 232
  {(ustring)"xor", KEYWORD_STRONG},
#line 232

   ENDKEYWORD
}; 
const char * ada_abbreviations []= {
  "adb", "ads", "\0"
};
const uchar  ada_description [] = "";
#define ada_style_def { ada_style, "ada",				\
  ada_abbreviations, ada_description, 					\
  CASE_INSENSITIVE, ada_1_characters, ada_2_characters, ada_keywords,	\
  ada_regulars, ada_specials, ada_sequences, EMPTY, ada_escapes }

/*
 *		Sather
 */
const sequence sather_sequences [] = {
  {(ustring)"--", COMMENT, COMMENT, (ustring)"$", COMMENT},
  {(ustring)"\"", PLAIN, STRING, (ustring)"\"", PLAIN},
  {(ustring)"\'", PLAIN, STRING, (ustring)"\'", PLAIN},
  ENDSEQUENCE
};
const uchar sather_1_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\0'
};
const uchar sather_2_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '!', '!',
  '\0'
};
const keyword sather_keywords [] = {
  /* keywords */
  {(ustring)"abstract", KEYWORD_STRONG},
#line 274
  {(ustring)"and", KEYWORD_STRONG},
#line 274
  {(ustring)"any", KEYWORD_STRONG},
#line 274
  {(ustring)"assert", KEYWORD_STRONG},
#line 274
  {(ustring)"attr", KEYWORD_STRONG},
#line 274
  {(ustring)"bind", KEYWORD_STRONG},
#line 274
  {(ustring)"break!", KEYWORD_STRONG},
#line 274
  {(ustring)"builtin", KEYWORD_STRONG},
#line 274
  {(ustring)"case", KEYWORD_STRONG},
#line 274
  {(ustring)"class", KEYWORD_STRONG},
#line 274
  {(ustring)"clusters", KEYWORD_STRONG},
#line 274
  {(ustring)"clusters!", KEYWORD_STRONG},
#line 274
  {(ustring)"cohort", KEYWORD_STRONG},
#line 274
  {(ustring)"const", KEYWORD_STRONG},
#line 274
  {(ustring)"else", KEYWORD_STRONG},
#line 274
  {(ustring)"elsif", KEYWORD_STRONG},
#line 274
  {(ustring)"end", KEYWORD_STRONG},
#line 274
  {(ustring)"exception", KEYWORD_STRONG},
#line 274
  {(ustring)"external", KEYWORD_STRONG},
#line 274
  {(ustring)"false", KEYWORD_STRONG},
#line 274
  {(ustring)"far", KEYWORD_STRONG},
#line 274
  {(ustring)"fork", KEYWORD_STRONG},
#line 274
  {(ustring)"guard", KEYWORD_STRONG},
#line 274
  {(ustring)"if", KEYWORD_STRONG},
#line 274
  {(ustring)"immutable", KEYWORD_STRONG},
#line 274
  {(ustring)"inout", KEYWORD_STRONG},
#line 274
  {(ustring)"include", KEYWORD_STRONG},
#line 274
  {(ustring)"initial", KEYWORD_STRONG},
#line 274
  {(ustring)"is", KEYWORD_STRONG},
#line 274
  {(ustring)"ITER", KEYWORD_STRONG},
#line 274
  {(ustring)"lock", KEYWORD_STRONG},
#line 274
  {(ustring)"loop", KEYWORD_STRONG},
#line 274
  {(ustring)"near", KEYWORD_STRONG},
#line 274
  {(ustring)"new", KEYWORD_STRONG},
#line 274
  {(ustring)"once", KEYWORD_STRONG},
#line 274
  {(ustring)"or", KEYWORD_STRONG},
#line 274
  {(ustring)"out", KEYWORD_STRONG},
#line 274
  {(ustring)"par", KEYWORD_STRONG},
#line 274
  {(ustring)"parloop", KEYWORD_STRONG},
#line 274
  {(ustring)"post", KEYWORD_STRONG},
#line 274
  {(ustring)"pre", KEYWORD_STRONG},
#line 274
  {(ustring)"private", KEYWORD_STRONG},
#line 274
  {(ustring)"protect", KEYWORD_STRONG},
#line 274
  {(ustring)"quit", KEYWORD_STRONG},
#line 274
  {(ustring)"raise", KEYWORD_STRONG},
#line 274
  {(ustring)"readonly", KEYWORD_STRONG},
#line 274
  {(ustring)"result", KEYWORD_STRONG},
#line 274
  {(ustring)"return", KEYWORD_STRONG},
#line 274
  {(ustring)"ROUT", KEYWORD_STRONG},
#line 274
  {(ustring)"SAME", KEYWORD_STRONG},
#line 274
  {(ustring)"self", KEYWORD_STRONG},
#line 274
  {(ustring)"shared", KEYWORD_STRONG},
#line 274
  {(ustring)"sync", KEYWORD_STRONG},
#line 274
  {(ustring)"then", KEYWORD_STRONG},
#line 274
  {(ustring)"true", KEYWORD_STRONG},
#line 274
  {(ustring)"typecase", KEYWORD_STRONG},
#line 274
  {(ustring)"unlock", KEYWORD_STRONG},
#line 274
  {(ustring)"until!", KEYWORD_STRONG},
#line 274
  {(ustring)"void", KEYWORD_STRONG},
#line 274
  {(ustring)"when", KEYWORD_STRONG},
#line 274
  {(ustring)"while!", KEYWORD_STRONG},
#line 274
  {(ustring)"with", KEYWORD_STRONG},
#line 274
  {(ustring)"yield", KEYWORD_STRONG},
#line 274


  /* Built-in classes */
 {(ustring)"BOOL", KEYWORD},
#line 277
  {(ustring)"CHAR", KEYWORD},
#line 277
  {(ustring)"STR", KEYWORD},
#line 277
  {(ustring)"INT", KEYWORD},
#line 277
  {(ustring)"INTI", KEYWORD},
#line 277
  {(ustring)"FLT", KEYWORD},
#line 277
  {(ustring)"FLTD", KEYWORD},
#line 277
  {(ustring)"FLTI", KEYWORD},
#line 277


  /* Interfacing with fortran */
  {(ustring)"F_REAL", KEYWORD},
#line 282
  {(ustring)"F_DOUBLE", KEYWORD},
#line 282
  {(ustring)"F_INTEGER", KEYWORD},
#line 282
  {(ustring)"F_COMPLEX", KEYWORD},
#line 282
  {(ustring)"F_DOUBLE_COMPLEX", KEYWORD},
#line 282
  {(ustring)"F_LOGICAL", KEYWORD},
#line 282
  {(ustring)"F_CHARACTER", KEYWORD},
#line 282
  {(ustring)"F_REAL_ARR", KEYWORD},
#line 282
  {(ustring)"F_DOUBLE_ARR", KEYWORD},
#line 282
  {(ustring)"F_INTEGER_ARR", KEYWORD},
#line 282
  {(ustring)"F_COMPEX_ARR", KEYWORD},
#line 282
  {(ustring)"F_DOUBLE_COMPLEX_ARR", KEYWORD},
#line 282
  {(ustring)"F_LOGICAL_ARR", KEYWORD},
#line 282


  /* Interfacing with ANSI C */
  {(ustring)"C_CHAR", KEYWORD},
#line 291
  {(ustring)"C_UNSIGNED_CHAR_PTR", KEYWORD},
#line 291
  {(ustring)"C_UNSIGNED_CHAR", KEYWORD},
#line 291
  {(ustring)"C_SIGNED_CHAR_PTR", KEYWORD},
#line 291
  {(ustring)"C_SIGNED_CHAR", KEYWORD},
#line 291
  {(ustring)"C_SHORT_PTR", KEYWORD},
#line 291
  {(ustring)"C_SHORT", KEYWORD},
#line 291
  {(ustring)"C_INT_PTR", KEYWORD},
#line 291
  {(ustring)"C_INT", KEYWORD},
#line 291
  {(ustring)"C_LONG_PTR", KEYWORD},
#line 291
  {(ustring)"C_LONG", KEYWORD},
#line 291
  {(ustring)"C_UNSIGNED_SHORT_PTR", KEYWORD},
#line 291
  {(ustring)"C_UNSIGNED_SHORT", KEYWORD},
#line 291
  {(ustring)"C_UNSIGNED_INT_PTR", KEYWORD},
#line 291
  {(ustring)"C_UNSIGNED_INT", KEYWORD},
#line 291
  {(ustring)"C_UNSIGNED_LONG_PTR", KEYWORD},
#line 291
  {(ustring)"C_UNSIGNED_LONG", KEYWORD},
#line 291
  {(ustring)"C_FLOAT_PTR", KEYWORD},
#line 291
  {(ustring)"C_FLOAT", KEYWORD},
#line 291
  {(ustring)"C_DOUBLE_PTR", KEYWORD},
#line 291
  {(ustring)"C_DOUBLE", KEYWORD},
#line 291
  {(ustring)"C_LONG_DOUBLE_PTR", KEYWORD},
#line 291
  {(ustring)"C_LONG_DOUBLE", KEYWORD},
#line 291
  {(ustring)"C_SIZE_T", KEYWORD},
#line 291
  {(ustring)"C_PTR", KEYWORD},
#line 291
  {(ustring)"C_PTRDIFF_T", KEYWORD},
#line 291
  {(ustring)"C_CHAR_PTR", KEYWORD},
#line 291

  ENDKEYWORD
}; 
const symbol sather_regulars [] = {
  {(ustring)"and", (ustring)"\331", SYMBOL},
  {(ustring)"or", (ustring)"\332", SYMBOL},
  ENDSYMBOL
};
const symbol sather_specials [] = {
  {(ustring)"/=", (ustring)"\271", SYMBOL},
  {(ustring)"<=", (ustring)"\243", SYMBOL},
  {(ustring)">=", (ustring)"\263", SYMBOL},
  ENDSYMBOL
};
const char * sather_abbreviations []= {
  "sa", "\0"
};
const uchar sather_description [] = "";
#define sather_style_def { sather_style, "sather", 				\
  sather_abbreviations, sather_description, 				\
  CASE_SENSITIVE, sather_1_characters, sather_2_characters, sather_keywords, \
  sather_regulars, sather_specials, sather_sequences, sh_verbatims, EMPTY }

/*
 *		Python
 */
const sequence python_sequences [] = {
  {(ustring)"#", COMMENT, COMMENT, (ustring)"$", COMMENT},
  {(ustring)"\"\"\"", PLAIN, STRING, (ustring)"\"\"\"", PLAIN},
  {(ustring)"\"", PLAIN, STRING, (ustring)"\"", PLAIN},
  {(ustring)"\'", PLAIN, STRING, (ustring)"\'", PLAIN},
  ENDSEQUENCE
};
const uchar python_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\0'
};
const symbol python_regulars [] = {
  {(ustring)"not", (ustring)"\330", SYMBOL},
  {(ustring)"and", (ustring)"\331", SYMBOL},
  {(ustring)"or", (ustring)"\332", SYMBOL},
  ENDSYMBOL
};
const symbol python_specials [] = {
  {(ustring)"<>", (ustring)"\271", SYMBOL},
  {(ustring)"!=", (ustring)"\271", SYMBOL},
  {(ustring)"<=", (ustring)"\243", SYMBOL},
  {(ustring)">=", (ustring)"\263", SYMBOL},
  {(ustring)"==", (ustring)"\272", SYMBOL},
  ENDSYMBOL
};
const keyword python_keywords [] = {
 {(ustring)"and", KEYWORD_STRONG},
#line 347
  {(ustring)"elif", KEYWORD_STRONG},
#line 347
  {(ustring)"from", KEYWORD_STRONG},
#line 347
  {(ustring)"lambda", KEYWORD_STRONG},
#line 347
  {(ustring)"return", KEYWORD_STRONG},
#line 347
  {(ustring)"break", KEYWORD_STRONG},
#line 347
  {(ustring)"else", KEYWORD_STRONG},
#line 347
  {(ustring)"global", KEYWORD_STRONG},
#line 347
  {(ustring)"not", KEYWORD_STRONG},
#line 347
  {(ustring)"try", KEYWORD_STRONG},
#line 347
  {(ustring)"class", KEYWORD_STRONG},
#line 347
  {(ustring)"except", KEYWORD_STRONG},
#line 347
  {(ustring)"if", KEYWORD_STRONG},
#line 347
  {(ustring)"or", KEYWORD_STRONG},
#line 347
  {(ustring)"while", KEYWORD_STRONG},
#line 347
  {(ustring)"continue", KEYWORD_STRONG},
#line 347
  {(ustring)"exec", KEYWORD_STRONG},
#line 347
  {(ustring)"import", KEYWORD_STRONG},
#line 347
  {(ustring)"pass", KEYWORD_STRONG},
#line 347
  {(ustring)"def", KEYWORD_STRONG},
#line 347
  {(ustring)"finally", KEYWORD_STRONG},
#line 347
  {(ustring)"in", KEYWORD_STRONG},
#line 347
  {(ustring)"print", KEYWORD_STRONG},
#line 347
  {(ustring)"del", KEYWORD_STRONG},
#line 347
  {(ustring)"is", KEYWORD_STRONG},
#line 347
  {(ustring)"raise", KEYWORD_STRONG},
#line 347
  {(ustring)"for", KEYWORD_STRONG},
#line 347

  ENDKEYWORD
}; 
const char * python_abbreviations []= {
  "pythonscript", "py", "\0"
};
const uchar  python_description [] = "";
#define python_style_def { python_style, "python",				\
  python_abbreviations, python_description, 				\
  CASE_SENSITIVE, python_characters, python_characters, python_keywords, \
  python_regulars, python_specials, python_sequences, sh_verbatims, EMPTY }
#line 331 "styles.c.in"

/************************************************************************/
/*			Functional languages			   	*/
/************************************************************************/
/*
 *		caml
 *		common-lisp
 *		Scheme as defined at 
 * http://www-swiss.ai.mit.edu/emacs-html.local/scheme_toc.html
 *		coq 5.10
 */
#line 1 "styles08.m4"
/*
 *		caml
 */
const sequence caml_sequences [] = {
  {(ustring)"(*", COMMENT, COMMENT, (ustring)"*)", COMMENT},
  {(ustring)"\"", PLAIN, STRING, (ustring)"\"", PLAIN},
  /* {(ustring)"\'", PLAIN, STRING, (ustring)"\'", PLAIN},*/
  ENDSEQUENCE
};
const uchar caml_characters_1 [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '!', '!',
  '\0'
};
const uchar caml_characters_2 [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\'', '\'',
  '!', '!',
  '\0'
};
const symbol caml_regulars [] = {
  {(ustring)"not", (ustring)"\330", SYMBOL},
  {(ustring)"and", (ustring)"\331", SYMBOL},
  {(ustring)"or", (ustring)"\332", SYMBOL},
  ENDSYMBOL
};
const symbol caml_specials [] = {
  {(ustring)"<>", (ustring)"\271", SYMBOL},
  {(ustring)"->", (ustring)"\256", SYMBOL},
  {(ustring)"<=", (ustring)"\243", SYMBOL},
  {(ustring)">=", (ustring)"\263", SYMBOL},
  ENDSYMBOL
};
const keyword caml_keywords [] = {
  {(ustring)"and", KEYWORD_STRONG},
#line 42
  {(ustring)"else", KEYWORD_STRONG},
#line 42
  {(ustring)"as", KEYWORD_STRONG},
#line 42
  {(ustring)"begin", KEYWORD_STRONG},
#line 42
  {(ustring)"do", KEYWORD_STRONG},
#line 42
  {(ustring)"done", KEYWORD_STRONG},
#line 42
  {(ustring)"downto", KEYWORD_STRONG},
#line 42
  {(ustring)"end", KEYWORD_STRONG},
#line 42
  {(ustring)"exception", KEYWORD_STRONG},
#line 42
  {(ustring)"for", KEYWORD_STRONG},
#line 42
  {(ustring)"fun", KEYWORD_STRONG},
#line 42
  {(ustring)"function", KEYWORD_STRONG},
#line 42
  {(ustring)"if", KEYWORD_STRONG},
#line 42
  {(ustring)"in", KEYWORD_STRONG},
#line 42
  {(ustring)"let", KEYWORD_STRONG},
#line 42
  {(ustring)"match", KEYWORD_STRONG},
#line 42
  {(ustring)"mutable", KEYWORD_STRONG},
#line 42
  {(ustring)"not", KEYWORD_STRONG},
#line 42
  {(ustring)"of", KEYWORD_STRONG},
#line 42
  {(ustring)"or", KEYWORD_STRONG},
#line 42
  {(ustring)"prefix", KEYWORD_STRONG},
#line 42
  {(ustring)"rec", KEYWORD_STRONG},
#line 42
  {(ustring)"then", KEYWORD_STRONG},
#line 42
  {(ustring)"to", KEYWORD_STRONG},
#line 42
  {(ustring)"try", KEYWORD_STRONG},
#line 42
  {(ustring)"type", KEYWORD_STRONG},
#line 42
  {(ustring)"value", KEYWORD_STRONG},
#line 42
  {(ustring)"where", KEYWORD_STRONG},
#line 42
  {(ustring)"while", KEYWORD_STRONG},
#line 42
  {(ustring)"with", KEYWORD_STRONG},
#line 42
  {(ustring)"int", KEYWORD_STRONG},
#line 42
  {(ustring)"char", KEYWORD_STRONG},
#line 42
  {(ustring)"string", KEYWORD_STRONG},
#line 42
  {(ustring)"float", KEYWORD_STRONG},
#line 42
  {(ustring)"unit", KEYWORD_STRONG},
#line 42
  {(ustring)"list", KEYWORD_STRONG},
#line 42
  {(ustring)"raise", KEYWORD_STRONG},
#line 42
  {(ustring)"bool", KEYWORD_STRONG},
#line 42
  {(ustring)"vect", KEYWORD_STRONG},
#line 42

   ENDKEYWORD
};
const char * caml_abbreviations []= {
  "ml", "mli", "mll", "\0"
};
const uchar  caml_description [] =
  "This style should also suit other versions of ML (caml light, SML etc.)";
#define caml_style_def { caml_style, "caml",			\
  caml_abbreviations, caml_description, CASE_SENSITIVE,		\
  caml_characters_1, caml_characters_2, caml_keywords,		\
  caml_regulars, caml_specials, caml_sequences, sh_verbatims, EMPTY }

/*
 *		common-lisp
 */
const sequence clisp_sequences [] = {
  /* comments */
  {(ustring)";", COMMENT, COMMENT, (ustring)"$", COMMENT},
  /* function declaration */
  {(ustring)"(defun ", KEYWORD_STRONG, LABEL_STRONG, (ustring)" ", PLAIN},
  /* strings*/
  {(ustring)"\"", PLAIN, STRING, (ustring)"\"", PLAIN},
  ENDSEQUENCE
};
const uchar clisp_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '-', '-',
  '\0'
};
const symbol clisp_regulars [] = {
  {(ustring) "lambda", (ustring) "l", SYMBOL},
  ENDSYMBOL
};
const keyword clisp_keywords [] = {
  {(ustring)"or", KEYWORD_STRONG},
  {(ustring)"and", KEYWORD_STRONG},
#line 80
  {(ustring)"cond", KEYWORD_STRONG},
#line 80
  {(ustring)"let", KEYWORD_STRONG},
#line 80
  {(ustring)"when", KEYWORD_STRONG},
#line 80
  {(ustring)"if", KEYWORD_STRONG},
#line 80
  {(ustring)"unless", KEYWORD_STRONG},
#line 80
  {(ustring)"defvar", KEYWORD_STRONG},
#line 80
  {(ustring)"setf", KEYWORD_STRONG},
#line 80
  {(ustring)"progn", KEYWORD_STRONG},
#line 80

   ENDKEYWORD
};
const char * clisp_abbreviations []= {
  "el", "l", "lisp", "lsp", "clisp", "\0"
};
const uchar  clisp_description [] = "";
#define clisp_style_def { clisp_style, "common-lisp",			\
  clisp_abbreviations, clisp_description, 				\
  CASE_INSENSITIVE, clisp_characters, clisp_characters, clisp_keywords,	\
  clisp_regulars, NOSYMBOL, clisp_sequences, sh_verbatims, EMPTY }

/*
 *		Scheme as defined at 
 * http://www-swiss.ai.mit.edu/emacs-html.local/scheme_toc.html
 */
const sequence scheme_sequences [] = {
  /* comments */
  {(ustring)";", COMMENT, COMMENT, (ustring)"$", COMMENT},
  /* multiple line comments */
  {(ustring)"#|", COMMENT, COMMENT, (ustring)"|#", COMMENT},
  /* strings*/
  {(ustring)"\"", PLAIN, STRING, (ustring)"\"", PLAIN},
  ENDSEQUENCE
};
const uchar scheme_characters [] = {
  'A', 'Z',
  'a', 'z',
  '!', '!',
  '#', '&',	/* # $ % & */
  '*', '+', 	/* * + */
  '-', '/',	/* - . / */
  '<', '@', 	/* < = > ? @ */
  '_', '_',
  '\0'
};
const symbol scheme_regulars [] = {
  {(ustring) "lambda", (ustring) "l", SYMBOL},
  ENDSYMBOL
};
const keyword scheme_keywords [] = {
  {(ustring)"access", KEYWORD_STRONG},
#line 127
  {(ustring)"define-syntax", KEYWORD_STRONG},
#line 127
  {(ustring)"macro", KEYWORD_STRONG},
#line 127
  {(ustring)"and", KEYWORD_STRONG},
#line 127
  {(ustring)"delay", KEYWORD_STRONG},
#line 127
  {(ustring)"make-environment", KEYWORD_STRONG},
#line 127
  {(ustring)"begin", KEYWORD_STRONG},
#line 127
  {(ustring)"do", KEYWORD_STRONG},
#line 127
  {(ustring)"named-lambda", KEYWORD_STRONG},
#line 127
  {(ustring)"bkpt", KEYWORD_STRONG},
#line 127
  {(ustring)"fluid-let", KEYWORD_STRONG},
#line 127
  {(ustring)"or", KEYWORD_STRONG},
#line 127
  {(ustring)"case", KEYWORD_STRONG},
#line 127
  {(ustring)"if", KEYWORD_STRONG},
#line 127
  {(ustring)"quasiquote", KEYWORD_STRONG},
#line 127
  {(ustring)"cond", KEYWORD_STRONG},
#line 127
  {(ustring)"in-package", KEYWORD_STRONG},
#line 127
  {(ustring)"quote", KEYWORD_STRONG},
#line 127
  {(ustring)"cons-stream", KEYWORD_STRONG},
#line 127
  {(ustring)"lambda", KEYWORD_STRONG},
#line 127
  {(ustring)"scode-quote", KEYWORD_STRONG},
#line 127
  {(ustring)"declare", KEYWORD_STRONG},
#line 127
  {(ustring)"let", KEYWORD_STRONG},
#line 127
  {(ustring)"sequence", KEYWORD_STRONG},
#line 127
  {(ustring)"default-object?", KEYWORD_STRONG},
#line 127
  {(ustring)"let*", KEYWORD_STRONG},
#line 127
  {(ustring)"set!", KEYWORD_STRONG},
#line 127
  {(ustring)"define", KEYWORD_STRONG},
#line 127
  {(ustring)"let-syntax", KEYWORD_STRONG},
#line 127
  {(ustring)"the-environment", KEYWORD_STRONG},
#line 127
  {(ustring)"define-integrable", KEYWORD_STRONG},
#line 127
  {(ustring)"letrec", KEYWORD_STRONG},
#line 127
  {(ustring)"unassigned?", KEYWORD_STRONG},
#line 127
  {(ustring)"define-macro", KEYWORD_STRONG},
#line 127
  {(ustring)"local-declare", KEYWORD_STRONG},
#line 127
  {(ustring)"using-syntax", KEYWORD_STRONG},
#line 127
  {(ustring)"define-structure", KEYWORD_STRONG},
#line 127

  /* truth values */
  {(ustring)"#f", KEYWORD},
#line 129
  {(ustring)"#t", KEYWORD},
#line 129

   ENDKEYWORD
};
const char * scheme_abbreviations []= {
  "scm", "\0"
};
const uchar scheme_description [] = "";
#define scheme_style_def { scheme_style, "scheme",			\
  scheme_abbreviations, scheme_description, 				\
  CASE_INSENSITIVE, scheme_characters, scheme_characters, scheme_keywords,\
  scheme_regulars, NOSYMBOL, scheme_sequences, sh_verbatims, EMPTY }

/*
 *		coq 5.10
 */
const sequence coq_sequences [] = {
  {(ustring)"(*", PLAIN, COMMENT, (ustring)"*)", PLAIN},
  {(ustring)"\"", PLAIN, STRING, (ustring)"\"", PLAIN},
  /*  "\'", "\'", FONT_PLAIN, FONT_TIMES, "\'", "\'", FONT_PLAIN,*/

  /* Definition of the section is emphasized */
  {(ustring)"Section ", KEYWORD_STRONG, LABEL_STRONG, (ustring)".", PLAIN},
#line 152
  {(ustring)"End ", KEYWORD_STRONG, LABEL_STRONG, (ustring)".", PLAIN},
#line 154
  ENDSEQUENCE
};
const uchar coq_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '!', '!',
  '\0'
};
const symbol coq_regulars [] = {
  {(ustring)"not", (ustring)"\330", SYMBOL},
  {(ustring)"and", (ustring)"\331", SYMBOL},
  {(ustring)"or", (ustring)"\332", SYMBOL},
  ENDSYMBOL
};
const symbol coq_specials [] = {
  {(ustring)"<>", (ustring)"\271", SYMBOL},
  {(ustring)"->", (ustring)"\256", SYMBOL},
  {(ustring)"<=", (ustring)"\243", SYMBOL},
  {(ustring)">=", (ustring)"\263", SYMBOL},
  ENDSYMBOL
};
const keyword coq_keywords [] = {
  {(ustring)"Require", KEYWORD_STRONG},
#line 177
  {(ustring)"Declare", KEYWORD_STRONG},
#line 177


  {(ustring)"with", KEYWORD},
#line 179

  
  {(ustring)"Variable", KEYWORD_STRONG},
#line 183
  {(ustring)"Inductive", KEYWORD_STRONG},
#line 183
  {(ustring)"CoInductive", KEYWORD_STRONG},
#line 183
  {(ustring)"Fixpoint", KEYWORD_STRONG},
#line 183
  {(ustring)"CoFixpoint", KEYWORD_STRONG},
#line 183
  {(ustring)"Definition", KEYWORD_STRONG},
#line 183
  {(ustring)"Lemma", KEYWORD_STRONG},
#line 183
  {(ustring)"Theorem", KEYWORD_STRONG},
#line 183
  {(ustring)"Axiom", KEYWORD_STRONG},
#line 183
  {(ustring)"Local", KEYWORD_STRONG},
#line 183
  {(ustring)"Save", KEYWORD_STRONG},
#line 183
  {(ustring)"Grammar", KEYWORD_STRONG},
#line 183
  {(ustring)"Syntax", KEYWORD_STRONG},
#line 183

  /* Tactics */
  {(ustring)"Intro", KEYWORD_STRONG},
#line 187
  {(ustring)"Trivial", KEYWORD_STRONG},
#line 187
  {(ustring)"Qed", KEYWORD_STRONG},
#line 187
  {(ustring)"Intros", KEYWORD_STRONG},
#line 187
  {(ustring)"Symmetry", KEYWORD_STRONG},
#line 187
  {(ustring)"Simpl", KEYWORD_STRONG},
#line 187
  {(ustring)"Rewrite", KEYWORD_STRONG},
#line 187
  {(ustring)"Apply", KEYWORD_STRONG},
#line 187
  {(ustring)"Elim", KEYWORD_STRONG},
#line 187
  {(ustring)"Assumption", KEYWORD_STRONG},
#line 187
  {(ustring)"Left", KEYWORD_STRONG},
#line 187
  {(ustring)"Cut", KEYWORD_STRONG},
#line 187
  {(ustring)"Case", KEYWORD_STRONG},
#line 187
  {(ustring)"Auto", KEYWORD_STRONG},
#line 187
  {(ustring)"Unfold", KEYWORD_STRONG},
#line 187
  {(ustring)"Exact", KEYWORD_STRONG},
#line 187
  {(ustring)"Right", KEYWORD_STRONG},
#line 187

  /* Types */
  {(ustring)"Set", KEYWORD},
#line 189

   ENDKEYWORD
};
const char * coq_abbreviations [] = {
  "coq", "\0"
};
const uchar coq_description [] =
"This style is devoted to the Coq v 5.10 vernacular language.\n\
It is insufficiant, please send comments to demaille@inf.enst.fr.";
#define coq_style_def { coq_style, "coq-vernacular",		\
  coq_abbreviations, coq_description, 				\
  CASE_SENSITIVE, coq_characters, coq_characters, coq_keywords,	\
  coq_regulars, coq_specials, coq_sequences, sh_verbatims, EMPTY }
#line 342 "styles.c.in"

/************************************************************************/
/*			  Modula              			   	*/
/************************************************************************/
/*
 *		Pascal
 *		Modula-3
 *		Oberon
 */
#line 1 "styles09.m4"
/************************************************************************/
/*			  Modula              			   	*/
/************************************************************************/
/*
 *		Pascal
 */
const sequence pascal_sequences [] = {
  /* comments */
  {(ustring)"(*", COMMENT_STRONG, COMMENT_STRONG, (ustring)"*)", COMMENT_STRONG}, 
  {(ustring)"{", COMMENT, COMMENT, (ustring)"}", COMMENT}, 
  /* char and strings litteral */
  {(ustring)"\'", PLAIN, STRING, (ustring)"\'", PLAIN},
  /* Sections in the source file */
  {(ustring)"unit ", KEYWORD_STRONG, LABEL_STRONG, (ustring)"$", PLAIN},
  {(ustring)"interface ", KEYWORD_STRONG, LABEL_STRONG, (ustring)"$", PLAIN},
  {(ustring)"implementation ", KEYWORD_STRONG, LABEL_STRONG, (ustring)"$", PLAIN},
  {(ustring)"program ", KEYWORD_STRONG, LABEL_STRONG, (ustring)"$", PLAIN},
  ENDSEQUENCE
};
const uchar pascal_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\0'
};
const symbol pascal_regulars [] = {
  {(ustring) "in", (ustring) "\316", SYMBOL},
  {(ustring)"not", (ustring)"\330", SYMBOL},
  {(ustring)"and", (ustring)"\331", SYMBOL},
  {(ustring)"or", (ustring)"\332", SYMBOL},
  ENDSYMBOL
};
const symbol pascal_specials [] = {
  {(ustring)"->", (ustring)"\256", SYMBOL},
  {(ustring)"<=", (ustring)"\243", SYMBOL},
  {(ustring)">=", (ustring)"\263", SYMBOL},
  {(ustring) ":=", (ustring) ":=", PLAIN},	/* to avoid the change of = in := */
  {(ustring)"<>", (ustring)"\271", SYMBOL},
  {(ustring)"=", (ustring)"\272", SYMBOL},
  ENDSYMBOL
};
const keyword pascal_keywords [] = {
  /* Pascal keywords */
  {(ustring)"and", KEYWORD_STRONG},
#line 48
  {(ustring)"array", KEYWORD_STRONG},
#line 48
  {(ustring)"begin", KEYWORD_STRONG},
#line 48
  {(ustring)"constructor", KEYWORD_STRONG},
#line 48
  {(ustring)"const", KEYWORD_STRONG},
#line 48
  {(ustring)"dec", KEYWORD_STRONG},
#line 48
  {(ustring)"downto", KEYWORD_STRONG},
#line 48
  {(ustring)"do", KEYWORD_STRONG},
#line 48
  {(ustring)"else", KEYWORD_STRONG},
#line 48
  {(ustring)"end", KEYWORD_STRONG},
#line 48
  {(ustring)"exit", KEYWORD_STRONG},
#line 48
  {(ustring)"false", KEYWORD_STRONG},
#line 48
  {(ustring)"file", KEYWORD_STRONG},
#line 48
  {(ustring)"forward", KEYWORD_STRONG},
#line 48
  {(ustring)"for", KEYWORD_STRONG},
#line 48
  {(ustring)"function", KEYWORD_STRONG},
#line 48
  {(ustring)"goto", KEYWORD_STRONG},
#line 48
  {(ustring)"halt", KEYWORD_STRONG},
#line 48
  {(ustring)"if", KEYWORD_STRONG},
#line 48
  {(ustring)"inc", KEYWORD_STRONG},
#line 48
  {(ustring)"in", KEYWORD_STRONG},
#line 48
  {(ustring)"label", KEYWORD_STRONG},
#line 48
  {(ustring)"new", KEYWORD_STRONG},
#line 48
  {(ustring)"nil", KEYWORD_STRONG},
#line 48
  {(ustring)"not", KEYWORD_STRONG},
#line 48
  {(ustring)"object", KEYWORD_STRONG},
#line 48
  {(ustring)"of", KEYWORD_STRONG},
#line 48
  {(ustring)"or", KEYWORD_STRONG},
#line 48
  {(ustring)"packed", KEYWORD_STRONG},
#line 48
  {(ustring)"procedure", KEYWORD_STRONG},
#line 48
  {(ustring)"readln", KEYWORD_STRONG},
#line 48
  {(ustring)"read", KEYWORD_STRONG},
#line 48
  {(ustring)"record", KEYWORD_STRONG},
#line 48
  {(ustring)"repeat", KEYWORD_STRONG},
#line 48
  {(ustring)"set", KEYWORD_STRONG},
#line 48
  {(ustring)"shl", KEYWORD_STRONG},
#line 48
  {(ustring)"shr", KEYWORD_STRONG},
#line 48
  {(ustring)"then", KEYWORD_STRONG},
#line 48
  {(ustring)"to", KEYWORD_STRONG},
#line 48
  {(ustring)"true", KEYWORD_STRONG},
#line 48
  {(ustring)"type", KEYWORD_STRONG},
#line 48
  {(ustring)"until", KEYWORD_STRONG},
#line 48
  {(ustring)"uses", KEYWORD_STRONG},
#line 48
  {(ustring)"var", KEYWORD_STRONG},
#line 48
  {(ustring)"while", KEYWORD_STRONG},
#line 48
  {(ustring)"with", KEYWORD_STRONG},
#line 48
  {(ustring)"write", KEYWORD_STRONG},
#line 48
  {(ustring)"writeln", KEYWORD_STRONG},
#line 48
  {(ustring)"xor", KEYWORD_STRONG},
#line 48


  /* Pascal reserved identifiers */
  {(ustring)"abs", KEYWORD},
  {(ustring)"boolean", KEYWORD},
#line 52
  {(ustring)"byte", KEYWORD},
#line 52
  {(ustring)"div", KEYWORD},
#line 52
  {(ustring)"integer", KEYWORD},
#line 52
  {(ustring)"length", KEYWORD},
#line 52
  {(ustring)"mod", KEYWORD},
#line 52
  {(ustring)"odd", KEYWORD},
#line 52
  {(ustring)"pointer", KEYWORD},
#line 52
  {(ustring)"real", KEYWORD},
#line 52
  {(ustring)"registers", KEYWORD},
#line 52
  {(ustring)"string", KEYWORD},
#line 52
  {(ustring)"text", KEYWORD},
#line 52
  {(ustring)"trunc", KEYWORD},
#line 52
  {(ustring)"word", KEYWORD},
#line 52

  ENDKEYWORD
};
const char * pascal_abbreviations []= {
  "pascal", "pas", "p", "\0"
};
const uchar  pascal_description [] = "\
The standard Pascal is covered by this style. But some extension have been \
added too, hence modern Pascal programs should be correctly handled.";
#define pascal_style_def { pascal_style, "Pascal",				\
  pascal_abbreviations, pascal_description, 				\
  CASE_INSENSITIVE, pascal_characters, pascal_characters, pascal_keywords, \
  pascal_regulars, pascal_specials, pascal_sequences, sh_verbatims, EMPTY }

/*
 *		Modula-3
 */
const sequence modula3_sequences [] = {
  /* comments */
  {(ustring)"(*", PLAIN, COMMENT, (ustring)"*)", PLAIN}, 
  /* strings litteral */
  {(ustring)"\"", PLAIN, STRING, (ustring)"\"", PLAIN},
  /* char litteral */
  {(ustring)"\'", PLAIN, STRING, (ustring)"\'", PLAIN},
  ENDSEQUENCE
};
const uchar modula3_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\0'
};
const symbol modula3_regulars [] = {
  {(ustring) "IN", (ustring) "\316", SYMBOL}, 	/* is member of */
  {(ustring)"NOT", (ustring)"\330", SYMBOL},
  {(ustring)"AND", (ustring)"\331", SYMBOL},
  {(ustring)"OR", (ustring)"\332", SYMBOL},
  ENDSYMBOL
};
const symbol modula3_specials [] = {
  {(ustring)"->", (ustring)"\256", SYMBOL},
  {(ustring)"<=", (ustring)"\243", SYMBOL},
  {(ustring)">=", (ustring)"\263", SYMBOL},
  {(ustring) ":=", (ustring) ":=", PLAIN},	/* to avoid the change of = in := */
  {(ustring)"#", (ustring)"\271", SYMBOL},
  {(ustring)"=", (ustring)"\272", SYMBOL},
  ENDSYMBOL
};
const keyword modula3_keywords [] = {
  /* Modula 3 keywords */
  {(ustring)"AND", KEYWORD_STRONG},
#line 108
  {(ustring)"DO", KEYWORD_STRONG},
#line 108
  {(ustring)"FROM", KEYWORD_STRONG},
#line 108
  {(ustring)"NOT", KEYWORD_STRONG},
#line 108
  {(ustring)"REPEAT", KEYWORD_STRONG},
#line 108
  {(ustring)"UNTIL", KEYWORD_STRONG},
#line 108
  {(ustring)"ANY", KEYWORD_STRONG},
#line 108
  {(ustring)"ELSE", KEYWORD_STRONG},
#line 108
  {(ustring)"GENERIC", KEYWORD_STRONG},
#line 108
  {(ustring)"OBJECT", KEYWORD_STRONG},
#line 108
  {(ustring)"RETURN", KEYWORD_STRONG},
#line 108
  {(ustring)"UNTRACED", KEYWORD_STRONG},
#line 108
  {(ustring)"ARRAY", KEYWORD_STRONG},
#line 108
  {(ustring)"ELSIF", KEYWORD_STRONG},
#line 108
  {(ustring)"IF", KEYWORD_STRONG},
#line 108
  {(ustring)"OF", KEYWORD_STRONG},
#line 108
  {(ustring)"REVEAL", KEYWORD_STRONG},
#line 108
  {(ustring)"VALUE", KEYWORD_STRONG},
#line 108
  {(ustring)"AS", KEYWORD_STRONG},
#line 108
  {(ustring)"END", KEYWORD_STRONG},
#line 108
  {(ustring)"IMPORT", KEYWORD_STRONG},
#line 108
  {(ustring)"OR", KEYWORD_STRONG},
#line 108
  {(ustring)"ROOT", KEYWORD_STRONG},
#line 108
  {(ustring)"VAR", KEYWORD_STRONG},
#line 108
  {(ustring)"BEGIN", KEYWORD_STRONG},
#line 108
  {(ustring)"EVAL", KEYWORD_STRONG},
#line 108
  {(ustring)"IN", KEYWORD_STRONG},
#line 108
  {(ustring)"OVERRIDES", KEYWORD_STRONG},
#line 108
  {(ustring)"SET", KEYWORD_STRONG},
#line 108
  {(ustring)"WHILE", KEYWORD_STRONG},
#line 108
  {(ustring)"BITS", KEYWORD_STRONG},
#line 108
  {(ustring)"EXCEPT", KEYWORD_STRONG},
#line 108
  {(ustring)"INTERFACE", KEYWORD_STRONG},
#line 108
  {(ustring)"PROCEDURE", KEYWORD_STRONG},
#line 108
  {(ustring)"THEN", KEYWORD_STRONG},
#line 108
  {(ustring)"WITH", KEYWORD_STRONG},
#line 108
  {(ustring)"BRANDED", KEYWORD_STRONG},
#line 108
  {(ustring)"EXCEPTION", KEYWORD_STRONG},
#line 108
  {(ustring)"LOCK", KEYWORD_STRONG},
#line 108
  {(ustring)"RAISE", KEYWORD_STRONG},
#line 108
  {(ustring)"TO", KEYWORD_STRONG},
#line 108
  {(ustring)"BY", KEYWORD_STRONG},
#line 108
  {(ustring)"EXIT", KEYWORD_STRONG},
#line 108
  {(ustring)"LOOP", KEYWORD_STRONG},
#line 108
  {(ustring)"RAISES", KEYWORD_STRONG},
#line 108
  {(ustring)"TRY", KEYWORD_STRONG},
#line 108
  {(ustring)"CASE", KEYWORD_STRONG},
#line 108
  {(ustring)"EXPORTS", KEYWORD_STRONG},
#line 108
  {(ustring)"METHODS", KEYWORD_STRONG},
#line 108
  {(ustring)"READONLY", KEYWORD_STRONG},
#line 108
  {(ustring)"TYPE", KEYWORD_STRONG},
#line 108
  {(ustring)"CONST", KEYWORD_STRONG},
#line 108
  {(ustring)"FINALLY", KEYWORD_STRONG},
#line 108
  {(ustring)"MOD", KEYWORD_STRONG},
#line 108
  {(ustring)"RECORD", KEYWORD_STRONG},
#line 108
  {(ustring)"TYPECASE", KEYWORD_STRONG},
#line 108
  {(ustring)"DIV", KEYWORD_STRONG},
#line 108
  {(ustring)"FOR", KEYWORD_STRONG},
#line 108
  {(ustring)"MODULE", KEYWORD_STRONG},
#line 108
  {(ustring)"REF", KEYWORD_STRONG},
#line 108
  {(ustring)"UNSAFE", KEYWORD_STRONG},
#line 108

  /* Modula 3 reserved identifiers */
  {(ustring)"ABS", KEYWORD},
#line 114
  {(ustring)"BYTESIZE", KEYWORD},
#line 114
  {(ustring)"EXTENDED", KEYWORD},
#line 114
  {(ustring)"INTEGER", KEYWORD},
#line 114
  {(ustring)"MIN", KEYWORD},
#line 114
  {(ustring)"NUMBER", KEYWORD},
#line 114
  {(ustring)"TEXT", KEYWORD},
#line 114
  {(ustring)"ADDRESS", KEYWORD},
#line 114
  {(ustring)"CARDINAL", KEYWORD},
#line 114
  {(ustring)"FALSE", KEYWORD},
#line 114
  {(ustring)"ISTYPE", KEYWORD},
#line 114
  {(ustring)"MUTEX", KEYWORD},
#line 114
  {(ustring)"ORD", KEYWORD},
#line 114
  {(ustring)"TRUE", KEYWORD},
#line 114
  {(ustring)"ADR", KEYWORD},
#line 114
  {(ustring)"CEILING", KEYWORD},
#line 114
  {(ustring)"FIRST", KEYWORD},
#line 114
  {(ustring)"LAST", KEYWORD},
#line 114
  {(ustring)"NARROW", KEYWORD},
#line 114
  {(ustring)"REAL", KEYWORD},
#line 114
  {(ustring)"TRUNC", KEYWORD},
#line 114
  {(ustring)"ADRSIZE", KEYWORD},
#line 114
  {(ustring)"CHAR", KEYWORD},
#line 114
  {(ustring)"FLOAT", KEYWORD},
#line 114
  {(ustring)"LONGREAL", KEYWORD},
#line 114
  {(ustring)"NEW", KEYWORD},
#line 114
  {(ustring)"REFANY", KEYWORD},
#line 114
  {(ustring)"TYPECODE", KEYWORD},
#line 114
  {(ustring)"BITSIZE", KEYWORD},
#line 114
  {(ustring)"DEC", KEYWORD},
#line 114
  {(ustring)"FLOOR", KEYWORD},
#line 114
  {(ustring)"LOOPHOLE", KEYWORD},
#line 114
  {(ustring)"NIL", KEYWORD},
#line 114
  {(ustring)"ROUND", KEYWORD},
#line 114
  {(ustring)"VAL", KEYWORD},
#line 114
  {(ustring)"BOOLEAN", KEYWORD},
#line 114
  {(ustring)"DISPOSE", KEYWORD},
#line 114
  {(ustring)"INC", KEYWORD},
#line 114
  {(ustring)"MAX", KEYWORD},
#line 114
  {(ustring)"NULL", KEYWORD},
#line 114
  {(ustring)"SUBARRAY", KEYWORD},
#line 114

  ENDKEYWORD
};
const char * modula3_abbreviations []= {
  "m3", "\0"
};
const uchar  modula3_description [] = "";
#define modula3_style_def { modula3_style, "modula-3",			\
  modula3_abbreviations, modula3_description, 				\
  CASE_SENSITIVE, modula3_characters, modula3_characters, modula3_keywords, \
  modula3_regulars, modula3_specials, modula3_sequences, sh_verbatims, EMPTY }

/*
 *		Oberon
 */
const sequence oberon_sequences [] = {
  /* comments */
  {(ustring)"(*", PLAIN, COMMENT, (ustring)"*)", PLAIN}, 
  /* strings litteral */
  {(ustring)"\"", PLAIN, STRING, (ustring)"\"", PLAIN},
  /* char litteral */
  {(ustring)"\'", PLAIN, STRING, (ustring)"\'", PLAIN},
  ENDSEQUENCE
};
const uchar oberon_characters [] = {
  'A', 'Z',
  'a', 'z',
  '\0'
};
const symbol oberon_regulars [] = {
  {(ustring) "IN", (ustring) "\316", SYMBOL},
  {(ustring)"NOT", (ustring)"\330", SYMBOL},
  {(ustring)"AND", (ustring)"\331", SYMBOL},
  {(ustring)"OR", (ustring)"\332", SYMBOL},
  ENDSYMBOL
};
const symbol oberon_specials [] = {
  {(ustring)"->", (ustring)"\256", SYMBOL},
  {(ustring)"<=", (ustring)"\243", SYMBOL},
  {(ustring)">=", (ustring)"\263", SYMBOL},
  {(ustring) ":=", (ustring) ":=", PLAIN},	/* to avoid the change of = in := */
  {(ustring)"#", (ustring)"\271", SYMBOL},
  {(ustring)"=", (ustring)"\272", SYMBOL},
  ENDSYMBOL
};
const keyword oberon_keywords [] = {
  {(ustring)"ARRAY", KEYWORD_STRONG},
#line 163
  {(ustring)"IS", KEYWORD_STRONG},
#line 163
  {(ustring)"TO", KEYWORD_STRONG},
#line 163
  {(ustring)"BEGIN", KEYWORD_STRONG},
#line 163
  {(ustring)"LOOP", KEYWORD_STRONG},
#line 163
  {(ustring)"TYPE", KEYWORD_STRONG},
#line 163
  {(ustring)"CASE", KEYWORD_STRONG},
#line 163
  {(ustring)"MOD", KEYWORD_STRONG},
#line 163
  {(ustring)"UNTIL", KEYWORD_STRONG},
#line 163
  {(ustring)"CONST", KEYWORD_STRONG},
#line 163
  {(ustring)"MODULE", KEYWORD_STRONG},
#line 163
  {(ustring)"VAR", KEYWORD_STRONG},
#line 163
  {(ustring)"DIV", KEYWORD_STRONG},
#line 163
  {(ustring)"NIL", KEYWORD_STRONG},
#line 163
  {(ustring)"WHILE", KEYWORD_STRONG},
#line 163
  {(ustring)"DO", KEYWORD_STRONG},
#line 163
  {(ustring)"OF", KEYWORD_STRONG},
#line 163
  {(ustring)"WITH", KEYWORD_STRONG},
#line 163
  {(ustring)"ELSE", KEYWORD_STRONG},
#line 163
  {(ustring)"OR", KEYWORD_STRONG},
#line 163
  {(ustring)"ELSIF", KEYWORD_STRONG},
#line 163
  {(ustring)"POINTER", KEYWORD_STRONG},
#line 163
  {(ustring)"END", KEYWORD_STRONG},
#line 163
  {(ustring)"PROCEDURE", KEYWORD_STRONG},
#line 163
  {(ustring)"EXIT", KEYWORD_STRONG},
#line 163
  {(ustring)"RECORD", KEYWORD_STRONG},
#line 163
  {(ustring)"IF", KEYWORD_STRONG},
#line 163
  {(ustring)"REPEAT", KEYWORD_STRONG},
#line 163
  {(ustring)"IMPORT", KEYWORD_STRONG},
#line 163
  {(ustring)"RETURN", KEYWORD_STRONG},
#line 163
  {(ustring)"IN", KEYWORD_STRONG},
#line 163
  {(ustring)"THEN", KEYWORD_STRONG},
#line 163

  /* builtins */
  {(ustring)"ABS", KEYWORD},
#line 168
  {(ustring)"LEN", KEYWORD},
#line 168
  {(ustring)"ASH", KEYWORD},
#line 168
  {(ustring)"LONG", KEYWORD},
#line 168
  {(ustring)"BOOLEAN", KEYWORD},
#line 168
  {(ustring)"LONGINT", KEYWORD},
#line 168
  {(ustring)"BYTE", KEYWORD},
#line 168
  {(ustring)"LONGREAL", KEYWORD},
#line 168
  {(ustring)"CAP", KEYWORD},
#line 168
  {(ustring)"MAX", KEYWORD},
#line 168
  {(ustring)"CHAR", KEYWORD},
#line 168
  {(ustring)"MIN", KEYWORD},
#line 168
  {(ustring)"CHR", KEYWORD},
#line 168
  {(ustring)"NEW", KEYWORD},
#line 168
  {(ustring)"DEC", KEYWORD},
#line 168
  {(ustring)"ODD", KEYWORD},
#line 168
  {(ustring)"ENTIER", KEYWORD},
#line 168
  {(ustring)"ORD", KEYWORD},
#line 168
  {(ustring)"EXCL", KEYWORD},
#line 168
  {(ustring)"REAL", KEYWORD},
#line 168
  {(ustring)"FALSE", KEYWORD},
#line 168
  {(ustring)"SET", KEYWORD},
#line 168
  {(ustring)"HALT", KEYWORD},
#line 168
  {(ustring)"SHORT", KEYWORD},
#line 168
  {(ustring)"INC", KEYWORD},
#line 168
  {(ustring)"SHORTINT", KEYWORD},
#line 168
  {(ustring)"INCL", KEYWORD},
#line 168
  {(ustring)"SIZE", KEYWORD},
#line 168
  {(ustring)"INTEGER", KEYWORD},
#line 168
  {(ustring)"TRUE", KEYWORD},
#line 168

  ENDKEYWORD
};
const char * oberon_abbreviations []= {
  "\0"
};
const uchar  oberon_description [] = "";
#define oberon_style_def { oberon_style, "oberon",				\
  oberon_abbreviations, oberon_description, 				\
  CASE_SENSITIVE, oberon_characters, oberon_characters, oberon_keywords, \
  oberon_regulars, oberon_specials, oberon_sequences, sh_verbatims, EMPTY }
#line 351 "styles.c.in"

/************************************************************************/
/*			Specification languages			   	*/
/************************************************************************/
/*
 *		Promela
 *		SDL 88
 *             VHDL
 * Implemented by Thomas.Parmelan@efrei.fr
 *             Verilog
 * Implemented by Edward S. Arthur eda@ultranet.com
 *             UNITY
 * Implemented by cottin@inf.enst.fr & demaille@inf.enst.fr
 */
#line 1 "styles10.m4"
/*
 *		Promela
 */
const symbol promela_specials [] = {
  {(ustring)"->", (ustring)"\256", SYMBOL},
  {(ustring)"&&", (ustring)"\331", SYMBOL},
  {(ustring)"||", (ustring)"\332", SYMBOL},
  {(ustring)"!=", (ustring)"\271", SYMBOL},
  {(ustring)"==", (ustring)"\272", SYMBOL},
  {(ustring)"<=", (ustring)"\243", SYMBOL},
  {(ustring)">=", (ustring)"\263", SYMBOL},
  /* ! cannot be translated as not, since it is used for "send" */
  ENDSYMBOL
};
const keyword promela_keywords [] = {
  {(ustring)"bit", KEYWORD},
#line 16
  {(ustring)"bool", KEYWORD},
#line 16
  {(ustring)"byte", KEYWORD},
#line 16
  {(ustring)"chan", KEYWORD},
#line 16


  {(ustring)"active", KEYWORD_STRONG},
#line 22
  {(ustring)"assert", KEYWORD_STRONG},
#line 22
  {(ustring)"atomic", KEYWORD_STRONG},
#line 22
  {(ustring)"break", KEYWORD_STRONG},
#line 22
  {(ustring)"d_step", KEYWORD_STRONG},
#line 22
  {(ustring)"progress", KEYWORD_STRONG},
#line 22
  {(ustring)"do", KEYWORD_STRONG},
#line 22
  {(ustring)"else", KEYWORD_STRONG},
#line 22
  {(ustring)"empty", KEYWORD_STRONG},
#line 22
  {(ustring)"enabled", KEYWORD_STRONG},
#line 22
  {(ustring)"fi", KEYWORD_STRONG},
#line 22
  {(ustring)"full", KEYWORD_STRONG},
#line 22
  {(ustring)"goto", KEYWORD_STRONG},
#line 22
  {(ustring)"hidden", KEYWORD_STRONG},
#line 22
  {(ustring)"if", KEYWORD_STRONG},
#line 22
  {(ustring)"init", KEYWORD_STRONG},
#line 22
  {(ustring)"int", KEYWORD_STRONG},
#line 22
  {(ustring)"len", KEYWORD_STRONG},
#line 22
  {(ustring)"accept", KEYWORD_STRONG},
#line 22
  {(ustring)"mtype", KEYWORD_STRONG},
#line 22
  {(ustring)"nempty", KEYWORD_STRONG},
#line 22
  {(ustring)"never", KEYWORD_STRONG},
#line 22
  {(ustring)"nfull", KEYWORD_STRONG},
#line 22
  {(ustring)"od", KEYWORD_STRONG},
#line 22
  {(ustring)"of", KEYWORD_STRONG},
#line 22
  {(ustring)"pc_value", KEYWORD_STRONG},
#line 22
  {(ustring)"printf", KEYWORD_STRONG},
#line 22
  {(ustring)"proctype", KEYWORD_STRONG},
#line 22
  {(ustring)"run", KEYWORD_STRONG},
#line 22
  {(ustring)"short", KEYWORD_STRONG},
#line 22
  {(ustring)"skip", KEYWORD_STRONG},
#line 22
  {(ustring)"timeout", KEYWORD_STRONG},
#line 22
  {(ustring)"typedef", KEYWORD_STRONG},
#line 22
  {(ustring)"unless", KEYWORD_STRONG},
#line 22
  {(ustring)"xr", KEYWORD_STRONG},
#line 22
  {(ustring)"xs", KEYWORD_STRONG},
#line 22
  {(ustring)"priority", KEYWORD_STRONG},
#line 22

  /* Preprocessor */
  {(ustring)"#define", KEYWORD_STRONG},
#line 24
  {(ustring)"#if", KEYWORD_STRONG},
#line 24
  {(ustring)"#endif", KEYWORD_STRONG},
#line 24

   ENDKEYWORD
};
const char * promela_abbreviations []= {
  "pml", "\0"
};
const uchar  promela_description [] =
  "There is no way for this program to highlight send and receive primitives.";
#define promela_style_def { promela_style, "Promela", 			\
  promela_abbreviations, promela_description, 				\
  CASE_INSENSITIVE, c_characters, c_characters,	promela_keywords,	\
  NOSYMBOL, promela_specials, c_sequences, sh_verbatims, EMPTY }

/*
 *		SDL 88
 */
const sequence sdl_sequences [] = {
  {(ustring)"/*", COMMENT, COMMENT, (ustring)"*/", COMMENT},
  {(ustring)"\"", PLAIN, STRING, (ustring)"\"", PLAIN},
  {(ustring)"\'", PLAIN, STRING, (ustring)"\'", PLAIN},
  {(ustring)"(.", PLAIN, PLAIN, (ustring)".)", PLAIN},
  {(ustring)"<<", PLAIN, PLAIN, (ustring)">>", PLAIN},
  ENDSEQUENCE
};
const uchar sdl_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\0'
};
const symbol sdl_specials [] = {
  {(ustring)"->", (ustring)"\256", SYMBOL},
  {(ustring)"=>", (ustring)"\336", SYMBOL},
  {(ustring)"/=", (ustring)"\271", SYMBOL},
  {(ustring)"==", (ustring)"\272", SYMBOL},
  {(ustring)"<=", (ustring)"\243", SYMBOL},
  {(ustring)">=", (ustring)"\263", SYMBOL},
  {(ustring)"!", (ustring)"\330", SYMBOL},
  ENDSYMBOL
};
const keyword sdl_keywords [] = {
  {(ustring)"active", KEYWORD_STRONG},
#line 83
  {(ustring)"adding", KEYWORD_STRONG},
#line 83
  {(ustring)"all", KEYWORD_STRONG},
#line 83
  {(ustring)"alternative", KEYWORD_STRONG},
#line 83
  {(ustring)"any", KEYWORD_STRONG},
#line 83
  {(ustring)"as", KEYWORD_STRONG},
#line 83
  {(ustring)"atleast", KEYWORD_STRONG},
#line 83
  {(ustring)"axioms", KEYWORD_STRONG},
#line 83
  {(ustring)"block", KEYWORD_STRONG},
#line 83
  {(ustring)"call", KEYWORD_STRONG},
#line 83
  {(ustring)"channel", KEYWORD_STRONG},
#line 83
  {(ustring)"comment", KEYWORD_STRONG},
#line 83
  {(ustring)"connect", KEYWORD_STRONG},
#line 83
  {(ustring)"connection", KEYWORD_STRONG},
#line 83
  {(ustring)"constant", KEYWORD_STRONG},
#line 83
  {(ustring)"constants", KEYWORD_STRONG},
#line 83
  {(ustring)"create", KEYWORD_STRONG},
#line 83
  {(ustring)"dcl", KEYWORD_STRONG},
#line 83
  {(ustring)"decision", KEYWORD_STRONG},
#line 83
  {(ustring)"default", KEYWORD_STRONG},
#line 83
  {(ustring)"else", KEYWORD_STRONG},
#line 83
  {(ustring)"endalternative", KEYWORD_STRONG},
#line 83
  {(ustring)"endblock", KEYWORD_STRONG},
#line 83
  {(ustring)"endchannel", KEYWORD_STRONG},
#line 83
  {(ustring)"endconnection", KEYWORD_STRONG},
#line 83
  {(ustring)"enddecision", KEYWORD_STRONG},
#line 83
  {(ustring)"endgenerator", KEYWORD_STRONG},
#line 83
  {(ustring)"endnewtype", KEYWORD_STRONG},
#line 83
  {(ustring)"endoperator", KEYWORD_STRONG},
#line 83
  {(ustring)"endpackage", KEYWORD_STRONG},
#line 83
  {(ustring)"endprocedure", KEYWORD_STRONG},
#line 83
  {(ustring)"endprocess", KEYWORD_STRONG},
#line 83
  {(ustring)"endrefinement", KEYWORD_STRONG},
#line 83
  {(ustring)"endselect", KEYWORD_STRONG},
#line 83
  {(ustring)"endservice", KEYWORD_STRONG},
#line 83
  {(ustring)"endstate", KEYWORD_STRONG},
#line 83
  {(ustring)"endsubstructure", KEYWORD_STRONG},
#line 83
  {(ustring)"endsyntype", KEYWORD_STRONG},
#line 83
  {(ustring)"endsystem", KEYWORD_STRONG},
#line 83
  {(ustring)"enum", KEYWORD_STRONG},
#line 83
  {(ustring)"env", KEYWORD_STRONG},
#line 83
  {(ustring)"error", KEYWORD_STRONG},
#line 83
  {(ustring)"export", KEYWORD_STRONG},
#line 83
  {(ustring)"exported", KEYWORD_STRONG},
#line 83
  {(ustring)"external", KEYWORD_STRONG},
#line 83
  {(ustring)"fi", KEYWORD_STRONG},
#line 83
  {(ustring)"finalized", KEYWORD_STRONG},
#line 83
  {(ustring)"for", KEYWORD_STRONG},
#line 83
  {(ustring)"fpar", KEYWORD_STRONG},
#line 83
  {(ustring)"from", KEYWORD_STRONG},
#line 83
  {(ustring)"gate", KEYWORD_STRONG},
#line 83
  {(ustring)"generator", KEYWORD_STRONG},
#line 83
  {(ustring)"if", KEYWORD_STRONG},
#line 83
  {(ustring)"import", KEYWORD_STRONG},
#line 83
  {(ustring)"imported", KEYWORD_STRONG},
#line 83
  {(ustring)"in", KEYWORD_STRONG},
#line 83
  {(ustring)"inherits", KEYWORD_STRONG},
#line 83
  {(ustring)"input", KEYWORD_STRONG},
#line 83
  {(ustring)"interface", KEYWORD_STRONG},
#line 83
  {(ustring)"join", KEYWORD_STRONG},
#line 83
  {(ustring)"literal", KEYWORD_STRONG},
#line 83
  {(ustring)"literals", KEYWORD_STRONG},
#line 83
  {(ustring)"map", KEYWORD_STRONG},
#line 83
  {(ustring)"nameclass", KEYWORD_STRONG},
#line 83
  {(ustring)"newtype", KEYWORD_STRONG},
#line 83
  {(ustring)"nextstate", KEYWORD_STRONG},
#line 83
  {(ustring)"nodelay", KEYWORD_STRONG},
#line 83
  {(ustring)"noequality", KEYWORD_STRONG},
#line 83
  {(ustring)"none", KEYWORD_STRONG},
#line 83
  {(ustring)"now", KEYWORD_STRONG},
#line 83
  {(ustring)"offspring", KEYWORD_STRONG},
#line 83
  {(ustring)"operator", KEYWORD_STRONG},
#line 83
  {(ustring)"operators", KEYWORD_STRONG},
#line 83
  {(ustring)"ordering", KEYWORD_STRONG},
#line 83
  {(ustring)"out", KEYWORD_STRONG},
#line 83
  {(ustring)"output", KEYWORD_STRONG},
#line 83
  {(ustring)"package", KEYWORD_STRONG},
#line 83
  {(ustring)"parent", KEYWORD_STRONG},
#line 83
  {(ustring)"priority", KEYWORD_STRONG},
#line 83
  {(ustring)"procedure", KEYWORD_STRONG},
#line 83
  {(ustring)"process", KEYWORD_STRONG},
#line 83
  {(ustring)"provided", KEYWORD_STRONG},
#line 83
  {(ustring)"redefined", KEYWORD_STRONG},
#line 83
  {(ustring)"referenced", KEYWORD_STRONG},
#line 83
  {(ustring)"refinement", KEYWORD_STRONG},
#line 83
  {(ustring)"remote", KEYWORD_STRONG},
#line 83
  {(ustring)"reset", KEYWORD_STRONG},
#line 83
  {(ustring)"return", KEYWORD_STRONG},
#line 83
  {(ustring)"returns", KEYWORD_STRONG},
#line 83
  {(ustring)"revealed", KEYWORD_STRONG},
#line 83
  {(ustring)"reverse", KEYWORD_STRONG},
#line 83
  {(ustring)"save", KEYWORD_STRONG},
#line 83
  {(ustring)"select", KEYWORD_STRONG},
#line 83
  {(ustring)"self", KEYWORD_STRONG},
#line 83
  {(ustring)"sender", KEYWORD_STRONG},
#line 83
  {(ustring)"service", KEYWORD_STRONG},
#line 83
  {(ustring)"set", KEYWORD_STRONG},
#line 83
  {(ustring)"signal", KEYWORD_STRONG},
#line 83
  {(ustring)"signallist", KEYWORD_STRONG},
#line 83
  {(ustring)"signalroute", KEYWORD_STRONG},
#line 83
  {(ustring)"signalset", KEYWORD_STRONG},
#line 83
  {(ustring)"spelling", KEYWORD_STRONG},
#line 83
  {(ustring)"start", KEYWORD_STRONG},
#line 83
  {(ustring)"state", KEYWORD_STRONG},
#line 83
  {(ustring)"stop", KEYWORD_STRONG},
#line 83
  {(ustring)"struct", KEYWORD_STRONG},
#line 83
  {(ustring)"substructure", KEYWORD_STRONG},
#line 83
  {(ustring)"synonym", KEYWORD_STRONG},
#line 83
  {(ustring)"syntype", KEYWORD_STRONG},
#line 83
  {(ustring)"system", KEYWORD_STRONG},
#line 83
  {(ustring)"task", KEYWORD_STRONG},
#line 83
  {(ustring)"then", KEYWORD_STRONG},
#line 83
  {(ustring)"this", KEYWORD_STRONG},
#line 83
  {(ustring)"timer", KEYWORD_STRONG},
#line 83
  {(ustring)"to", KEYWORD_STRONG},
#line 83
  {(ustring)"type", KEYWORD_STRONG},
#line 83
  {(ustring)"use", KEYWORD_STRONG},
#line 83
  {(ustring)"variant", KEYWORD_STRONG},
#line 83
  {(ustring)"varstruct", KEYWORD_STRONG},
#line 83
  {(ustring)"via", KEYWORD_STRONG},
#line 83
  {(ustring)"view", KEYWORD_STRONG},
#line 83
  {(ustring)"viewed", KEYWORD_STRONG},
#line 83
  {(ustring)"virtual", KEYWORD_STRONG},
#line 83
  {(ustring)"with", KEYWORD_STRONG},
#line 83
  {(ustring)"or", KEYWORD_STRONG},
#line 83
  {(ustring)"xor", KEYWORD_STRONG},
#line 83
  {(ustring)"and", KEYWORD_STRONG},
#line 83
  {(ustring)"mod", KEYWORD_STRONG},
#line 83
  {(ustring)"rem", KEYWORD_STRONG},
#line 83
  {(ustring)"not", KEYWORD_STRONG},
#line 83
  {(ustring)"end", KEYWORD_STRONG},
#line 83
  {(ustring)"macrodefinition", KEYWORD_STRONG},
#line 83
  {(ustring)"=>", KEYWORD_STRONG},
#line 83
  {(ustring)"/=", KEYWORD_STRONG},
#line 83
  {(ustring)">", KEYWORD_STRONG},
#line 83
  {(ustring)">=", KEYWORD_STRONG},
#line 83
  {(ustring)"<", KEYWORD_STRONG},
#line 83
  {(ustring)"<=", KEYWORD_STRONG},
#line 83
  {(ustring)"+", KEYWORD_STRONG},
#line 83
  {(ustring)"-", KEYWORD_STRONG},
#line 83
  {(ustring)"//", KEYWORD_STRONG},
#line 83
  {(ustring)"==>", KEYWORD_STRONG},
#line 83
  {(ustring)"==", KEYWORD_STRONG},
#line 83
  {(ustring)"->", KEYWORD_STRONG},
#line 83
  {(ustring)":=", KEYWORD_STRONG},
#line 83
  {(ustring)"*", KEYWORD_STRONG},
#line 83
  {(ustring)":", KEYWORD_STRONG},
#line 83
  {(ustring)"/", KEYWORD_STRONG},
#line 83
  {(ustring)"=", KEYWORD_STRONG},
#line 83
  {(ustring)"!", KEYWORD_STRONG},
#line 83

   ENDKEYWORD
};
const char * sdl_abbreviations []= {
  "pr", "sdl", "\0"
};
const uchar  sdl_description [] = "";
#define sdl_style_def { sdl_style, "SDL-88",				\
  sdl_abbreviations, sdl_description, 					\
  CASE_INSENSITIVE, sdl_characters, sdl_characters, sdl_keywords,	\
  NOSYMBOL, sdl_specials, sdl_sequences, sh_verbatims, EMPTY }

/*
 *             VHDL
 * Implemented by Thomas.Parmelan@efrei.fr
 */
const sequence vhdl_sequences [] = {
  {(ustring)"--", COMMENT, COMMENT, (ustring)"$", COMMENT},
  {(ustring)"\"", PLAIN, STRING, (ustring)"\"", PLAIN},
  {(ustring)"\'", PLAIN, STRING, (ustring)"\'", PLAIN},
  ENDSEQUENCE
};
const uchar vhdl_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\0'
};
const symbol vhdl_regulars [] = {
  {(ustring)"not", (ustring)"\330", SYMBOL}, {(ustring)"or", (ustring)"\332", SYMBOL}, {(ustring)"and", (ustring)"\331", SYMBOL}, {(ustring)"implies", (ustring)"\336", SYMBOL},
  ENDSYMBOL
};
const keyword vhdl_keywords [] = {
   {(ustring)"abs", KEYWORD_STRONG},
#line 125
  {(ustring)"access", KEYWORD_STRONG},
#line 125
  {(ustring)"after", KEYWORD_STRONG},
#line 125
  {(ustring)"alias", KEYWORD_STRONG},
#line 125
  {(ustring)"all", KEYWORD_STRONG},
#line 125
  {(ustring)"and", KEYWORD_STRONG},
#line 125
  {(ustring)"architecture", KEYWORD_STRONG},
#line 125
  {(ustring)"array", KEYWORD_STRONG},
#line 125
  {(ustring)"assert", KEYWORD_STRONG},
#line 125
  {(ustring)"attribute", KEYWORD_STRONG},
#line 125
  {(ustring)"begin", KEYWORD_STRONG},
#line 125
  {(ustring)"block", KEYWORD_STRONG},
#line 125
  {(ustring)"body", KEYWORD_STRONG},
#line 125
  {(ustring)"buffer", KEYWORD_STRONG},
#line 125
  {(ustring)"bus", KEYWORD_STRONG},
#line 125
  {(ustring)"case", KEYWORD_STRONG},
#line 125
  {(ustring)"component", KEYWORD_STRONG},
#line 125
  {(ustring)"configuration", KEYWORD_STRONG},
#line 125
  {(ustring)"constant", KEYWORD_STRONG},
#line 125
  {(ustring)"disconnect", KEYWORD_STRONG},
#line 125
  {(ustring)"downto", KEYWORD_STRONG},
#line 125
  {(ustring)"else", KEYWORD_STRONG},
#line 125
  {(ustring)"elsif", KEYWORD_STRONG},
#line 125
  {(ustring)"end", KEYWORD_STRONG},
#line 125
  {(ustring)"entity", KEYWORD_STRONG},
#line 125
  {(ustring)"exit", KEYWORD_STRONG},
#line 125
  {(ustring)"file", KEYWORD_STRONG},
#line 125
  {(ustring)"for", KEYWORD_STRONG},
#line 125
  {(ustring)"function", KEYWORD_STRONG},
#line 125
  {(ustring)"generate", KEYWORD_STRONG},
#line 125
  {(ustring)"generic", KEYWORD_STRONG},
#line 125
  {(ustring)"guarded", KEYWORD_STRONG},
#line 125
  {(ustring)"if", KEYWORD_STRONG},
#line 125
  {(ustring)"inout", KEYWORD_STRONG},
#line 125
  {(ustring)"in", KEYWORD_STRONG},
#line 125
  {(ustring)"is", KEYWORD_STRONG},
#line 125
  {(ustring)"label", KEYWORD_STRONG},
#line 125
  {(ustring)"library", KEYWORD_STRONG},
#line 125
  {(ustring)"linkage", KEYWORD_STRONG},
#line 125
  {(ustring)"loop", KEYWORD_STRONG},
#line 125
  {(ustring)"map", KEYWORD_STRONG},
#line 125
  {(ustring)"mod", KEYWORD_STRONG},
#line 125
  {(ustring)"nand", KEYWORD_STRONG},
#line 125
  {(ustring)"new", KEYWORD_STRONG},
#line 125
  {(ustring)"next", KEYWORD_STRONG},
#line 125
  {(ustring)"nor", KEYWORD_STRONG},
#line 125
  {(ustring)"not", KEYWORD_STRONG},
#line 125
  {(ustring)"null", KEYWORD_STRONG},
#line 125
  {(ustring)"of", KEYWORD_STRONG},
#line 125
  {(ustring)"on", KEYWORD_STRONG},
#line 125
  {(ustring)"open", KEYWORD_STRONG},
#line 125
  {(ustring)"or", KEYWORD_STRONG},
#line 125
  {(ustring)"others", KEYWORD_STRONG},
#line 125
  {(ustring)"out", KEYWORD_STRONG},
#line 125
  {(ustring)"package", KEYWORD_STRONG},
#line 125
  {(ustring)"port", KEYWORD_STRONG},
#line 125
  {(ustring)"procedure", KEYWORD_STRONG},
#line 125
  {(ustring)"process", KEYWORD_STRONG},
#line 125
  {(ustring)"range", KEYWORD_STRONG},
#line 125
  {(ustring)"record", KEYWORD_STRONG},
#line 125
  {(ustring)"register", KEYWORD_STRONG},
#line 125
  {(ustring)"rem", KEYWORD_STRONG},
#line 125
  {(ustring)"report", KEYWORD_STRONG},
#line 125
  {(ustring)"return", KEYWORD_STRONG},
#line 125
  {(ustring)"select", KEYWORD_STRONG},
#line 125
  {(ustring)"severity", KEYWORD_STRONG},
#line 125
  {(ustring)"signal", KEYWORD_STRONG},
#line 125
  {(ustring)"subtype", KEYWORD_STRONG},
#line 125
  {(ustring)"then", KEYWORD_STRONG},
#line 125
  {(ustring)"to", KEYWORD_STRONG},
#line 125
  {(ustring)"transport", KEYWORD_STRONG},
#line 125
  {(ustring)"type", KEYWORD_STRONG},
#line 125
  {(ustring)"units", KEYWORD_STRONG},
#line 125
  {(ustring)"until", KEYWORD_STRONG},
#line 125
  {(ustring)"use", KEYWORD_STRONG},
#line 125
  {(ustring)"variable", KEYWORD_STRONG},
#line 125
  {(ustring)"wait", KEYWORD_STRONG},
#line 125
  {(ustring)"when", KEYWORD_STRONG},
#line 125
  {(ustring)"while", KEYWORD_STRONG},
#line 125
  {(ustring)"with", KEYWORD_STRONG},
#line 125
  {(ustring)"xor", KEYWORD_STRONG},
#line 125

   ENDKEYWORD
};
const char * vhdl_abbreviations []= {
  "vhdl", "vhd", "\0"
};
const uchar  vhdl_description [] = "\
This experimental style is devoted to the VHDL modelisation language. \
Please report comments to Thomas.Parmelan@efrei.fr";
#define vhdl_style_def { vhdl_style, "VHDL",				\
  vhdl_abbreviations, vhdl_description,					\
  CASE_INSENSITIVE, vhdl_characters, vhdl_characters, vhdl_keywords,	\
  vhdl_regulars, NOSYMBOL, vhdl_sequences, sh_verbatims, EMPTY }

/*
 *             Verilog
 * Implemented by Edward S. Arthur eda@ultranet.com
 */
/*
 tried to make TICK-define or TICK-MACRO a string font as well as HASH-NUMBER
*/

const sequence verilog_sequences [] = {
  {(ustring)"//", COMMENT, COMMENT, (ustring)"\n", COMMENT},
  {(ustring)"/*", COMMENT, COMMENT, (ustring)"*/", COMMENT},
  {(ustring)"\"", PLAIN, STRING, (ustring)"\"", PLAIN},

  /* We need to protect the starting $, so that they are not
     understood as "end of line" */
  {(ustring)"$\\", KEYWORD, KEYWORD, (ustring)" ", PLAIN},
  {(ustring)"$\\", KEYWORD, KEYWORD, (ustring)"$", PLAIN},
  {(ustring)"$\\", KEYWORD, KEYWORD, (ustring)"\t", PLAIN},
  {(ustring)"$\\", KEYWORD, KEYWORD, (ustring)";", PLAIN},
  {(ustring)"$\\", KEYWORD, KEYWORD, (ustring)"(", PLAIN},
  ENDSEQUENCE
};
/*
 added TICK and DOLLAR as a characters
*/
const uchar verilog_characters [] = {
  'A', 'Z',
  'a', 'z',

  '_', '`',

  '\'', '\'',
  '$', '$', 
  '0', '0',
  '\0'
};
const symbol verilog_regulars [] = {
  {(ustring)"not", (ustring)"\330", SYMBOL}, {(ustring)"or", (ustring)"\332", SYMBOL}, {(ustring)"and", (ustring)"\331", SYMBOL}, {(ustring)"implies", (ustring)"\336", SYMBOL},
  ENDSYMBOL
};
/*
 *	From OVI spec 1.0
 */
const keyword verilog_keywords [] = {
   /* keywords */
   {(ustring)"always", KEYWORD_STRONG},
#line 196
  {(ustring)"and", KEYWORD_STRONG},
#line 196
  {(ustring)"assign", KEYWORD_STRONG},
#line 196
  {(ustring)"begin", KEYWORD_STRONG},
#line 196
  {(ustring)"buf", KEYWORD_STRONG},
#line 196
  {(ustring)"bufif0", KEYWORD_STRONG},
#line 196
  {(ustring)"bufif1", KEYWORD_STRONG},
#line 196
  {(ustring)"case", KEYWORD_STRONG},
#line 196
  {(ustring)"casex", KEYWORD_STRONG},
#line 196
  {(ustring)"casez", KEYWORD_STRONG},
#line 196
  {(ustring)"cmos", KEYWORD_STRONG},
#line 196
  {(ustring)"deassign", KEYWORD_STRONG},
#line 196
  {(ustring)"default", KEYWORD_STRONG},
#line 196
  {(ustring)"defparam", KEYWORD_STRONG},
#line 196
  {(ustring)"disable", KEYWORD_STRONG},
#line 196
  {(ustring)"edge", KEYWORD_STRONG},
#line 196
  {(ustring)"else", KEYWORD_STRONG},
#line 196
  {(ustring)"end", KEYWORD_STRONG},
#line 196
  {(ustring)"endcase", KEYWORD_STRONG},
#line 196
  {(ustring)"endmodule", KEYWORD_STRONG},
#line 196
  {(ustring)"endfunction", KEYWORD_STRONG},
#line 196
  {(ustring)"endprimitive", KEYWORD_STRONG},
#line 196
  {(ustring)"endspecify", KEYWORD_STRONG},
#line 196
  {(ustring)"endtable", KEYWORD_STRONG},
#line 196
  {(ustring)"endtask", KEYWORD_STRONG},
#line 196
  {(ustring)"event", KEYWORD_STRONG},
#line 196
  {(ustring)"for", KEYWORD_STRONG},
#line 196
  {(ustring)"force", KEYWORD_STRONG},
#line 196
  {(ustring)"forever", KEYWORD_STRONG},
#line 196
  {(ustring)"fork", KEYWORD_STRONG},
#line 196
  {(ustring)"function", KEYWORD_STRONG},
#line 196
  {(ustring)"highz0", KEYWORD_STRONG},
#line 196
  {(ustring)"highz1", KEYWORD_STRONG},
#line 196
  {(ustring)"if", KEYWORD_STRONG},
#line 196
  {(ustring)"initial", KEYWORD_STRONG},
#line 196
  {(ustring)"inout", KEYWORD_STRONG},
#line 196
  {(ustring)"input", KEYWORD_STRONG},
#line 196
  {(ustring)"integer", KEYWORD_STRONG},
#line 196
  {(ustring)"join", KEYWORD_STRONG},
#line 196
  {(ustring)"large", KEYWORD_STRONG},
#line 196
  {(ustring)"macromodule", KEYWORD_STRONG},
#line 196
  {(ustring)"medium", KEYWORD_STRONG},
#line 196
  {(ustring)"module", KEYWORD_STRONG},
#line 196
  {(ustring)"nand", KEYWORD_STRONG},
#line 196
  {(ustring)"negedge", KEYWORD_STRONG},
#line 196
  {(ustring)"nmos", KEYWORD_STRONG},
#line 196
  {(ustring)"nor", KEYWORD_STRONG},
#line 196
  {(ustring)"not", KEYWORD_STRONG},
#line 196
  {(ustring)"notif0", KEYWORD_STRONG},
#line 196
  {(ustring)"notif1", KEYWORD_STRONG},
#line 196
  {(ustring)"or", KEYWORD_STRONG},
#line 196
  {(ustring)"output", KEYWORD_STRONG},
#line 196
  {(ustring)"parameter", KEYWORD_STRONG},
#line 196
  {(ustring)"pmos", KEYWORD_STRONG},
#line 196
  {(ustring)"posedge", KEYWORD_STRONG},
#line 196
  {(ustring)"primitive", KEYWORD_STRONG},
#line 196
  {(ustring)"pull0", KEYWORD_STRONG},
#line 196
  {(ustring)"pull1", KEYWORD_STRONG},
#line 196
  {(ustring)"pullup", KEYWORD_STRONG},
#line 196
  {(ustring)"pulldown", KEYWORD_STRONG},
#line 196
  {(ustring)"rcmos", KEYWORD_STRONG},
#line 196
  {(ustring)"reg", KEYWORD_STRONG},
#line 196
  {(ustring)"release", KEYWORD_STRONG},
#line 196
  {(ustring)"repeat", KEYWORD_STRONG},
#line 196
  {(ustring)"rnmos", KEYWORD_STRONG},
#line 196
  {(ustring)"rpmos", KEYWORD_STRONG},
#line 196
  {(ustring)"rtran", KEYWORD_STRONG},
#line 196
  {(ustring)"rtranif0", KEYWORD_STRONG},
#line 196
  {(ustring)"rtranif1", KEYWORD_STRONG},
#line 196
  {(ustring)"scalared", KEYWORD_STRONG},
#line 196
  {(ustring)"small", KEYWORD_STRONG},
#line 196
  {(ustring)"specify", KEYWORD_STRONG},
#line 196
  {(ustring)"specparam", KEYWORD_STRONG},
#line 196
  {(ustring)"strength", KEYWORD_STRONG},
#line 196
  {(ustring)"strong0", KEYWORD_STRONG},
#line 196
  {(ustring)"strong1", KEYWORD_STRONG},
#line 196
  {(ustring)"supply0", KEYWORD_STRONG},
#line 196
  {(ustring)"supply1", KEYWORD_STRONG},
#line 196
  {(ustring)"table", KEYWORD_STRONG},
#line 196
  {(ustring)"task", KEYWORD_STRONG},
#line 196
  {(ustring)"time", KEYWORD_STRONG},
#line 196
  {(ustring)"tran", KEYWORD_STRONG},
#line 196
  {(ustring)"tranif0", KEYWORD_STRONG},
#line 196
  {(ustring)"tranif1", KEYWORD_STRONG},
#line 196
  {(ustring)"tri", KEYWORD_STRONG},
#line 196
  {(ustring)"tri0", KEYWORD_STRONG},
#line 196
  {(ustring)"tri1", KEYWORD_STRONG},
#line 196
  {(ustring)"triand", KEYWORD_STRONG},
#line 196
  {(ustring)"trior", KEYWORD_STRONG},
#line 196
  {(ustring)"trireg", KEYWORD_STRONG},
#line 196
  {(ustring)"vectored", KEYWORD_STRONG},
#line 196
  {(ustring)"wait", KEYWORD_STRONG},
#line 196
  {(ustring)"wand", KEYWORD_STRONG},
#line 196
  {(ustring)"weak0", KEYWORD_STRONG},
#line 196
  {(ustring)"weak1", KEYWORD_STRONG},
#line 196
  {(ustring)"while", KEYWORD_STRONG},
#line 196
  {(ustring)"wire", KEYWORD_STRONG},
#line 196
  {(ustring)"wor", KEYWORD_STRONG},
#line 196
  {(ustring)"xnor", KEYWORD_STRONG},
#line 196
  {(ustring)"xor", KEYWORD_STRONG},
#line 196


  /* compiler directives */
#line 211
{(ustring)"`accelerate", KEYWORD},
#line 211
  {(ustring)"`autoexpand_vectornets", KEYWORD},
#line 211
  {(ustring)"`celldefine", KEYWORD},
#line 211
  {(ustring)"`default_nettype", KEYWORD},
#line 211
  {(ustring)"`define", KEYWORD},
#line 211
  {(ustring)"`else", KEYWORD},
#line 211
  {(ustring)"`endcelldefine", KEYWORD},
#line 211
  {(ustring)"`endif", KEYWORD},
#line 211
  {(ustring)"`endprotect", KEYWORD},
#line 211
  {(ustring)"`endprotected", KEYWORD},
#line 211
  {(ustring)"`expand_vectornets", KEYWORD},
#line 211
  {(ustring)"`ifdef", KEYWORD},
#line 211
  {(ustring)"`include", KEYWORD},
#line 211
  {(ustring)"`noaccelerate", KEYWORD},
#line 211
  {(ustring)"`noexpand_vectornets", KEYWORD},
#line 211
  {(ustring)"`noremove_gatenames", KEYWORD},
#line 211
  {(ustring)"`noremove_netnames", KEYWORD},
#line 211
  {(ustring)"`nounconnected_drive", KEYWORD},
#line 211
  {(ustring)"`protect", KEYWORD},
#line 211
  {(ustring)"`protected", KEYWORD},
#line 211
  {(ustring)"`remove_gatenames", KEYWORD},
#line 211
  {(ustring)"`remove_netnames", KEYWORD},
#line 211
  {(ustring)"`resetall", KEYWORD},
#line 211
  {(ustring)"`timescale", KEYWORD},
#line 211
  {(ustring)"`unconnected_drive", KEYWORD},
#line 211
  {(ustring)"`uselib", KEYWORD},
#line 211




   /* system tasks */
/* These make no sense this they are doubling the work done by
 * the sequences
   {(ustring)"$bitstoreal", KEYWORD},
#line 225
  {(ustring)"$countdrivers", KEYWORD},
#line 225
  {(ustring)"$display", KEYWORD},
#line 225
  {(ustring)"$fclose", KEYWORD},
#line 225
  {(ustring)"$fdisplay", KEYWORD},
#line 225
  {(ustring)"$fmonitor", KEYWORD},
#line 225
  {(ustring)"$fopen", KEYWORD},
#line 225
  {(ustring)"$fstrobe", KEYWORD},
#line 225
  {(ustring)"$fwrite", KEYWORD},
#line 225
  {(ustring)"$finish", KEYWORD},
#line 225
  {(ustring)"$getpattern", KEYWORD},
#line 225
  {(ustring)"$history", KEYWORD},
#line 225
  {(ustring)"$incsave", KEYWORD},
#line 225
  {(ustring)"$input", KEYWORD},
#line 225
  {(ustring)"$itor", KEYWORD},
#line 225
  {(ustring)"$key", KEYWORD},
#line 225
  {(ustring)"$list", KEYWORD},
#line 225
  {(ustring)"$log", KEYWORD},
#line 225
  {(ustring)"$monitor", KEYWORD},
#line 225
  {(ustring)"$monitoroff", KEYWORD},
#line 225
  {(ustring)"$monitoron", KEYWORD},
#line 225
  {(ustring)"$nokey", KEYWORD},
#line 225
  {(ustring)"$nolog", KEYWORD},
#line 225
  {(ustring)"$printtimescale", KEYWORD},
#line 225
  {(ustring)"$readmemb", KEYWORD},
#line 225
  {(ustring)"$readmemh", KEYWORD},
#line 225
  {(ustring)"$realtime", KEYWORD},
#line 225
  {(ustring)"$realtobits", KEYWORD},
#line 225
  {(ustring)"$reset", KEYWORD},
#line 225
  {(ustring)"$reset_count", KEYWORD},
#line 225
  {(ustring)"$reset_value", KEYWORD},
#line 225
  {(ustring)"$restart", KEYWORD},
#line 225
  {(ustring)"$rtoi", KEYWORD},
#line 225
  {(ustring)"$save", KEYWORD},
#line 225
  {(ustring)"$scale", KEYWORD},
#line 225
  {(ustring)"$scope", KEYWORD},
#line 225
  {(ustring)"$showscopes", KEYWORD},
#line 225
  {(ustring)"$showvariables", KEYWORD},
#line 225
  {(ustring)"$showvars", KEYWORD},
#line 225
  {(ustring)"$sreadmemb", KEYWORD},
#line 225
  {(ustring)"$sreadmemh", KEYWORD},
#line 225
  {(ustring)"$stime", KEYWORD},
#line 225
  {(ustring)"$stop", KEYWORD},
#line 225
  {(ustring)"$strobe", KEYWORD},
#line 225
  {(ustring)"$time", KEYWORD},
#line 225
  {(ustring)"$timeformat", KEYWORD},
#line 225
  {(ustring)"$write", KEYWORD},
#line 225
  {(ustring)"$vcdpluson", KEYWORD},
#line 225
  {(ustring)"$vcdplusoff", KEYWORD},
#line 225
  {(ustring)"$vcdplustraceon", KEYWORD},
#line 225
  {(ustring)"$vcdplustraceoff", KEYWORD},
#line 225
  {(ustring)"$dumpvars", KEYWORD},
#line 225

*/

ENDKEYWORD
};

const char * verilog_abbreviations []= {
  "verilog", "v", "vh", "\0"
};

const uchar  verilog_description [] = "\
This style is devoted to the VERILOG hardware description language. \
Please send hatemail or love letters to eda@ultranet.com";
#define verilog_style_def { verilog_style, "VERILOG",			\
  verilog_abbreviations, verilog_description,				\
  CASE_SENSITIVE, verilog_characters, verilog_characters, verilog_keywords, \
  verilog_regulars, NOSYMBOL, verilog_sequences, sh_verbatims, EMPTY }

/*
 *             UNITY
 * Implemented by cottin@inf.enst.fr & demaille@inf.enst.fr
 */
const sequence unity_sequences [] = {
  {(ustring)"//", COMMENT, COMMENT, (ustring)"$", COMMENT},
  {(ustring)"program ", KEYWORD_STRONG, LABEL_STRONG, (ustring)"$", PLAIN},
  ENDSEQUENCE
};
const uchar unity_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '<', '<',
  '>', '>',
  '=', '=',
  '/', '/',
  '\\', '\\',
  '|', '|',
  '\0'
};
const symbol unity_regulars [] = {
  {(ustring)"\\/", (ustring)"\332", SYMBOL}, {(ustring)"/\\", (ustring)"\331", SYMBOL}, {(ustring)"==>", (ustring)"\336", SYMBOL},
  {(ustring)"<=", (ustring)"\243", SYMBOL}, {(ustring)">=", (ustring)"\263", SYMBOL}, {(ustring)"<==", (ustring)"\335", SYMBOL},
  ENDSYMBOL
};
const symbol unity_symbols [] = {
  {(ustring)"~", (ustring)"\330", SYMBOL}, {(ustring)"~=", (ustring)"\271", SYMBOL},
  ENDSYMBOL
};
const keyword unity_keywords [] = {
   {(ustring)"assign", KEYWORD_STRONG},
#line 276
  {(ustring)"co", KEYWORD_STRONG},
#line 276
  {(ustring)"const", KEYWORD_STRONG},
#line 276
  {(ustring)"constant", KEYWORD_STRONG},
#line 276
  {(ustring)"declare", KEYWORD_STRONG},
#line 276
  {(ustring)"end", KEYWORD_STRONG},
#line 276
  {(ustring)"ensures", KEYWORD_STRONG},
#line 276
  {(ustring)"if", KEYWORD_STRONG},
#line 276
  {(ustring)"in", KEYWORD_STRONG},
#line 276
  {(ustring)"initially", KEYWORD_STRONG},
#line 276
  {(ustring)"invariant", KEYWORD_STRONG},
#line 276
  {(ustring)"program", KEYWORD_STRONG},
#line 276
  {(ustring)"stable", KEYWORD_STRONG},
#line 276
  {(ustring)"transient", KEYWORD_STRONG},
#line 276
  {(ustring)"type", KEYWORD_STRONG},
#line 276
  {(ustring)"unless", KEYWORD_STRONG},
#line 276
  {(ustring)"var", KEYWORD_STRONG},
#line 276


  {(ustring)"boolean", KEYWORD},
#line 278

   ENDKEYWORD
};
const char * unity_abbreviations []= {
  "unity", "\0"
};
const uchar unity_description [] = "\
This experimental style is devoted to UNITY. \
Please report comments to demaille@inf.enst.fr";
#define unity_style_def { unity_style, "Unity",				\
  unity_abbreviations, unity_description,				\
  CASE_SENSITIVE, unity_characters, unity_characters, unity_keywords,	\
  unity_regulars, unity_symbols, unity_sequences, sh_verbatims, EMPTY }
#line 365 "styles.c.in"

/************************************************************************/
/*			         Fortran      			   	*/
/************************************************************************/
/*
 *		Fortran (Fortran 95 - with some keywords of HPF)
 * Denis GIROU (CNRS/IDRIS - France) <Denis.Girou@idris.fr> - 10 Oct. 1996 */
#line 1 "styles11.m4"
/************************************************************************/
/*			         Fortran      			   	*/
/************************************************************************/
/*
 *		Fortran (Fortran 95 - with some keywords of HPF)
 *
 */
/* Denis GIROU (CNRS/IDRIS - France) <Denis.Girou@idris.fr> - 10 Oct. 1996 */

const sequence fortran_sequences [] = {
  /* comments */
  {(ustring)"!", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 12
  {(ustring)"^c", COMMENT, COMMENT, (ustring)"$", COMMENT},
#line 12
  {(ustring)"^*", COMMENT, COMMENT, (ustring)"$", COMMENT},

  /* char and strings litteral */
  {(ustring)"\'", PLAIN, STRING, (ustring)"\'", PLAIN},
  {(ustring)"\"", PLAIN, STRING, (ustring)"\"", PLAIN},

  /* Sections in the source file */
  {(ustring)"program ", KEYWORD_STRONG, LABEL_STRONG|DEC1, (ustring)" ", PLAIN},
  {(ustring)"program ", KEYWORD_STRONG, LABEL_STRONG|DEC1, (ustring)"(", PLAIN},
  {(ustring)"program ", KEYWORD_STRONG, LABEL_STRONG|DEC1, (ustring)"$", PLAIN},

  {(ustring)"end program ", KEYWORD_STRONG, LABEL_STRONG, (ustring)" ", PLAIN},
  {(ustring)"end program ", KEYWORD_STRONG, LABEL_STRONG, (ustring)"(", PLAIN},
  {(ustring)"end program ", KEYWORD_STRONG, LABEL_STRONG, (ustring)"$", PLAIN},

  {(ustring)"subroutine ", KEYWORD_STRONG, LABEL_STRONG, (ustring)" ", PLAIN},
  {(ustring)"subroutine ", KEYWORD_STRONG, LABEL_STRONG, (ustring)"(", PLAIN},
  {(ustring)"subroutine ", KEYWORD_STRONG, LABEL_STRONG, (ustring)"$", PLAIN},

  {(ustring)"end subroutine ", KEYWORD_STRONG, LABEL_STRONG, (ustring)" ", PLAIN},
  {(ustring)"end subroutine ", KEYWORD_STRONG, LABEL_STRONG, (ustring)"(", PLAIN},
  {(ustring)"end subroutine ", KEYWORD_STRONG, LABEL_STRONG, (ustring)"$", PLAIN},

  {(ustring)"function ", KEYWORD_STRONG, LABEL_STRONG, (ustring)" ", PLAIN},
  {(ustring)"function ", KEYWORD_STRONG, LABEL_STRONG, (ustring)"(", PLAIN},
  {(ustring)"function ", KEYWORD_STRONG, LABEL_STRONG, (ustring)"$", PLAIN},

  {(ustring)"end function ", KEYWORD_STRONG, LABEL_STRONG, (ustring)" ", PLAIN},
  {(ustring)"end function ", KEYWORD_STRONG, LABEL_STRONG, (ustring)"(", PLAIN},
  {(ustring)"end function ", KEYWORD_STRONG, LABEL_STRONG, (ustring)"$", PLAIN},

  {(ustring)"module procedure ", KEYWORD_STRONG, LABEL_STRONG, (ustring)" ", PLAIN},
  {(ustring)"module procedure ", KEYWORD_STRONG, LABEL_STRONG, (ustring)"(", PLAIN},
  {(ustring)"module procedure ", KEYWORD_STRONG, LABEL_STRONG, (ustring)"$", PLAIN},

  {(ustring)"module ", KEYWORD_STRONG, LABEL_STRONG, (ustring)" ", PLAIN},
  {(ustring)"module ", KEYWORD_STRONG, LABEL_STRONG, (ustring)"(", PLAIN},
  {(ustring)"module ", KEYWORD_STRONG, LABEL_STRONG, (ustring)"$", PLAIN},

  {(ustring)"end module ", KEYWORD_STRONG, LABEL_STRONG, (ustring)" ", PLAIN},
  {(ustring)"end module ", KEYWORD_STRONG, LABEL_STRONG, (ustring)"(", PLAIN},
  {(ustring)"end module ", KEYWORD_STRONG, LABEL_STRONG, (ustring)"$", PLAIN},


  /* Interface */
  {(ustring)"interface assignment(", KEYWORD_STRONG, LABEL_STRONG, (ustring)")", PLAIN},
#line 59
  {(ustring)"interface assignment (", KEYWORD_STRONG, LABEL_STRONG, (ustring)")", PLAIN},
#line 61
  {(ustring)"interface operator(", KEYWORD_STRONG, LABEL_STRONG, (ustring)")", PLAIN},
#line 63
  {(ustring)"interface operator (", KEYWORD_STRONG, LABEL_STRONG, (ustring)")", PLAIN},
#line 65

  /* Calls */
  {(ustring)"call ", KEYWORD, LABEL, (ustring)" ", PLAIN},
  {(ustring)"call ", KEYWORD, LABEL, (ustring)"(", PLAIN},
  {(ustring)"call ", KEYWORD, LABEL, (ustring)"$", PLAIN},

  ENDSEQUENCE
};
const uchar fortran_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '.', '.',
  '\0'
};
const symbol fortran_specials []  = {
  /* boolean operations */
  {(ustring)".not.", (ustring)"\330", SYMBOL},
  {(ustring)".or.", (ustring)"\332", SYMBOL},
  {(ustring)".and.", (ustring)"\331", SYMBOL},
  /* comparatives */
  {(ustring)".ge.", (ustring)"\263", SYMBOL},
  {(ustring) ".gt.", (ustring) ">", SYMBOL},
  {(ustring) ".lt.", (ustring) "<", SYMBOL},
  {(ustring)".le.", (ustring)"\243", SYMBOL},
  {(ustring)".eq.", (ustring)"\272", SYMBOL},
  {(ustring)".ne.", (ustring)"\271", SYMBOL},
  {(ustring)".eqv.", (ustring)"\272", SYMBOL},
  {(ustring)".neqv.", (ustring)"\271", SYMBOL},
  {(ustring)"/=", (ustring)"\271", SYMBOL},
  {(ustring)"=>", (ustring)"\336", SYMBOL},
  ENDSYMBOL
};
const keyword fortran_keywords [] = {
  /* Fortran keywords */
  {(ustring)"access", KEYWORD},
#line 111
  {(ustring)"action", KEYWORD},
#line 111
  {(ustring)"align", KEYWORD},
#line 111
  {(ustring)"allocate", KEYWORD},
#line 111
  {(ustring)"assign", KEYWORD},
#line 111
  {(ustring)"assignment", KEYWORD},
#line 111
  {(ustring)"backspace", KEYWORD},
#line 111
  {(ustring)"blanck", KEYWORD},
#line 111
  {(ustring)"block", KEYWORD},
#line 111
  {(ustring)"case", KEYWORD},
#line 111
  {(ustring)"close", KEYWORD},
#line 111
  {(ustring)"common", KEYWORD},
#line 111
  {(ustring)"contains", KEYWORD},
#line 111
  {(ustring)"continue", KEYWORD},
#line 111
  {(ustring)"cycle", KEYWORD},
#line 111
  {(ustring)"cyclic", KEYWORD},
#line 111
  {(ustring)"data", KEYWORD},
#line 111
  {(ustring)"deallocate", KEYWORD},
#line 111
  {(ustring)"default", KEYWORD},
#line 111
  {(ustring)"define", KEYWORD},
#line 111
  {(ustring)"direct", KEYWORD},
#line 111
  {(ustring)"distribute", KEYWORD},
#line 111
  {(ustring)"do", KEYWORD},
#line 111
  {(ustring)"dynamic", KEYWORD},
#line 111
  {(ustring)"elseif", KEYWORD},
#line 111
  {(ustring)"elemental", KEYWORD},
#line 111
  {(ustring)"elsewhere", KEYWORD},
#line 111
  {(ustring)"else", KEYWORD},
#line 111
  {(ustring)"endfile", KEYWORD},
#line 111
  {(ustring)"enddo", KEYWORD},
#line 111
  {(ustring)"endif", KEYWORD},
#line 111
  {(ustring)"end", KEYWORD},
#line 111
  {(ustring)"entry", KEYWORD},
#line 111
  {(ustring)"eor", KEYWORD},
#line 111
  {(ustring)"equivalence", KEYWORD},
#line 111
  {(ustring)"err", KEYWORD},
#line 111
  {(ustring)"exist", KEYWORD},
#line 111
  {(ustring)"exit", KEYWORD},
#line 111
  {(ustring)".false.", KEYWORD},
#line 111
  {(ustring)"file", KEYWORD},
#line 111
  {(ustring)"find", KEYWORD},
#line 111
  {(ustring)"forall", KEYWORD},
#line 111
  {(ustring)"form", KEYWORD},
#line 111
  {(ustring)"format", KEYWORD},
#line 111
  {(ustring)"formatted", KEYWORD},
#line 111
  {(ustring)"go", KEYWORD},
#line 111
  {(ustring)"goto", KEYWORD},
#line 111
  {(ustring)"hpf", KEYWORD},
#line 111
  {(ustring)"if", KEYWORD},
#line 111
  {(ustring)"include", KEYWORD},
#line 111
  {(ustring)"independent", KEYWORD},
#line 111
  {(ustring)"inherit", KEYWORD},
#line 111
  {(ustring)"inquire", KEYWORD},
#line 111
  {(ustring)"interface", KEYWORD},
#line 111
  {(ustring)"iolength", KEYWORD},
#line 111
  {(ustring)"iostat", KEYWORD},
#line 111
  {(ustring)"mask", KEYWORD},
#line 111
  {(ustring)"named", KEYWORD},
#line 111
  {(ustring)"namelist", KEYWORD},
#line 111
  {(ustring)"nextrec", KEYWORD},
#line 111
  {(ustring)"new", KEYWORD},
#line 111
  {(ustring)"nml", KEYWORD},
#line 111
  {(ustring)"no", KEYWORD},
#line 111
  {(ustring)"nullify", KEYWORD},
#line 111
  {(ustring)"number", KEYWORD},
#line 111
  {(ustring)"onto", KEYWORD},
#line 111
  {(ustring)"open", KEYWORD},
#line 111
  {(ustring)"operator", KEYWORD},
#line 111
  {(ustring)"pad", KEYWORD},
#line 111
  {(ustring)"pause", KEYWORD},
#line 111
  {(ustring)"position", KEYWORD},
#line 111
  {(ustring)"print", KEYWORD},
#line 111
  {(ustring)"processors", KEYWORD},
#line 111
  {(ustring)"pure", KEYWORD},
#line 111
  {(ustring)"read", KEYWORD},
#line 111
  {(ustring)"readwrite", KEYWORD},
#line 111
  {(ustring)"realign", KEYWORD},
#line 111
  {(ustring)"recl", KEYWORD},
#line 111
  {(ustring)"recursive", KEYWORD},
#line 111
  {(ustring)"redistribute", KEYWORD},
#line 111
  {(ustring)"result", KEYWORD},
#line 111
  {(ustring)"return", KEYWORD},
#line 111
  {(ustring)"rewind", KEYWORD},
#line 111
  {(ustring)"select", KEYWORD},
#line 111
  {(ustring)"sequential", KEYWORD},
#line 111
  {(ustring)"status", KEYWORD},
#line 111
  {(ustring)"stop", KEYWORD},
#line 111
  {(ustring)"template", KEYWORD},
#line 111
  {(ustring)"then", KEYWORD},
#line 111
  {(ustring)"to", KEYWORD},
#line 111
  {(ustring)".true.", KEYWORD},
#line 111
  {(ustring)"unformatted", KEYWORD},
#line 111
  {(ustring)"unit", KEYWORD},
#line 111
  {(ustring)"where", KEYWORD},
#line 111
  {(ustring)"while", KEYWORD},
#line 111
  {(ustring)"with", KEYWORD},
#line 111
  {(ustring)"write", KEYWORD},
#line 111


  /* Fortran intrinsic functions */
  {(ustring)"abs", KEYWORD},
#line 126
  {(ustring)"achar", KEYWORD},
#line 126
  {(ustring)"acos", KEYWORD},
#line 126
  {(ustring)"ajustl", KEYWORD},
#line 126
  {(ustring)"ajustr", KEYWORD},
#line 126
  {(ustring)"aimag", KEYWORD},
#line 126
  {(ustring)"aint", KEYWORD},
#line 126
  {(ustring)"all", KEYWORD},
#line 126
  {(ustring)"allocated", KEYWORD},
#line 126
  {(ustring)"anint", KEYWORD},
#line 126
  {(ustring)"any", KEYWORD},
#line 126
  {(ustring)"asin", KEYWORD},
#line 126
  {(ustring)"associated", KEYWORD},
#line 126
  {(ustring)"atan", KEYWORD},
#line 126
  {(ustring)"atan2", KEYWORD},
#line 126
  {(ustring)"bit_size", KEYWORD},
#line 126
  {(ustring)"btest", KEYWORD},
#line 126
  {(ustring)"ceiling", KEYWORD},
#line 126
  {(ustring)"char", KEYWORD},
#line 126
  {(ustring)"cmplx", KEYWORD},
#line 126
  {(ustring)"conjg", KEYWORD},
#line 126
  {(ustring)"cos", KEYWORD},
#line 126
  {(ustring)"cosh", KEYWORD},
#line 126
  {(ustring)"count", KEYWORD},
#line 126
  {(ustring)"cshift", KEYWORD},
#line 126
  {(ustring)"cpu_time", KEYWORD},
#line 126
  {(ustring)"date_and_time", KEYWORD},
#line 126
  {(ustring)"dble", KEYWORD},
#line 126
  {(ustring)"digits", KEYWORD},
#line 126
  {(ustring)"dim", KEYWORD},
#line 126
  {(ustring)"dimag", KEYWORD},
#line 126
  {(ustring)"dot_product", KEYWORD},
#line 126
  {(ustring)"dprod", KEYWORD},
#line 126
  {(ustring)"dreal", KEYWORD},
#line 126
  {(ustring)"eoshift", KEYWORD},
#line 126
  {(ustring)"epsilon", KEYWORD},
#line 126
  {(ustring)"exp", KEYWORD},
#line 126
  {(ustring)"exponent", KEYWORD},
#line 126
  {(ustring)"floor", KEYWORD},
#line 126
  {(ustring)"fraction", KEYWORD},
#line 126
  {(ustring)"huge", KEYWORD},
#line 126
  {(ustring)"iachar", KEYWORD},
#line 126
  {(ustring)"iand", KEYWORD},
#line 126
  {(ustring)"ibclr", KEYWORD},
#line 126
  {(ustring)"ibits", KEYWORD},
#line 126
  {(ustring)"ibset", KEYWORD},
#line 126
  {(ustring)"ichar", KEYWORD},
#line 126
  {(ustring)"ieor", KEYWORD},
#line 126
  {(ustring)"index", KEYWORD},
#line 126
  {(ustring)"int", KEYWORD},
#line 126
  {(ustring)"ior", KEYWORD},
#line 126
  {(ustring)"ishft", KEYWORD},
#line 126
  {(ustring)"ishftc", KEYWORD},
#line 126
  {(ustring)"lbound", KEYWORD},
#line 126
  {(ustring)"len", KEYWORD},
#line 126
  {(ustring)"len_trim", KEYWORD},
#line 126
  {(ustring)"lge", KEYWORD},
#line 126
  {(ustring)"lgt", KEYWORD},
#line 126
  {(ustring)"lle", KEYWORD},
#line 126
  {(ustring)"llt", KEYWORD},
#line 126
  {(ustring)"log", KEYWORD},
#line 126
  {(ustring)"log10", KEYWORD},
#line 126
  {(ustring)"matmul", KEYWORD},
#line 126
  {(ustring)"max", KEYWORD},
#line 126
  {(ustring)"maxexponent", KEYWORD},
#line 126
  {(ustring)"maxloc", KEYWORD},
#line 126
  {(ustring)"maxval", KEYWORD},
#line 126
  {(ustring)"merge", KEYWORD},
#line 126
  {(ustring)"min", KEYWORD},
#line 126
  {(ustring)"minexponent", KEYWORD},
#line 126
  {(ustring)"minloc", KEYWORD},
#line 126
  {(ustring)"minval", KEYWORD},
#line 126
  {(ustring)"mod", KEYWORD},
#line 126
  {(ustring)"modulo", KEYWORD},
#line 126
  {(ustring)"mvbits", KEYWORD},
#line 126
  {(ustring)"nearest", KEYWORD},
#line 126
  {(ustring)"nint", KEYWORD},
#line 126
  {(ustring)"not", KEYWORD},
#line 126
  {(ustring)"null", KEYWORD},
#line 126
  {(ustring)"pack", KEYWORD},
#line 126
  {(ustring)"precision", KEYWORD},
#line 126
  {(ustring)"present", KEYWORD},
#line 126
  {(ustring)"product", KEYWORD},
#line 126
  {(ustring)"radix", KEYWORD},
#line 126
  {(ustring)"random_number", KEYWORD},
#line 126
  {(ustring)"random_seed", KEYWORD},
#line 126
  {(ustring)"range", KEYWORD},
#line 126
  {(ustring)"repeat", KEYWORD},
#line 126
  {(ustring)"reshape", KEYWORD},
#line 126
  {(ustring)"rrspacing", KEYWORD},
#line 126
  {(ustring)"scale", KEYWORD},
#line 126
  {(ustring)"scan", KEYWORD},
#line 126
  {(ustring)"set_exponent", KEYWORD},
#line 126
  {(ustring)"shape", KEYWORD},
#line 126
  {(ustring)"sign", KEYWORD},
#line 126
  {(ustring)"sin", KEYWORD},
#line 126
  {(ustring)"sinh", KEYWORD},
#line 126
  {(ustring)"size", KEYWORD},
#line 126
  {(ustring)"spacing", KEYWORD},
#line 126
  {(ustring)"spread", KEYWORD},
#line 126
  {(ustring)"sqrt", KEYWORD},
#line 126
  {(ustring)"sum", KEYWORD},
#line 126
  {(ustring)"system_clock", KEYWORD},
#line 126
  {(ustring)"tan", KEYWORD},
#line 126
  {(ustring)"tanh", KEYWORD},
#line 126
  {(ustring)"tiny", KEYWORD},
#line 126
  {(ustring)"transfer", KEYWORD},
#line 126
  {(ustring)"transpose", KEYWORD},
#line 126
  {(ustring)"trim", KEYWORD},
#line 126
  {(ustring)"ubound", KEYWORD},
#line 126
  {(ustring)"unpack", KEYWORD},
#line 126
  {(ustring)"verify", KEYWORD},
#line 126


  /* Fortran keywords for declarations */
  {(ustring)"character", KEYWORD},
#line 133
  {(ustring)"complex", KEYWORD},
#line 133
  {(ustring)"double", KEYWORD},
#line 133
  {(ustring)"integer", KEYWORD},
#line 133
  {(ustring)"logical", KEYWORD},
#line 133
  {(ustring)"real", KEYWORD},
#line 133
  {(ustring)"allocatable", KEYWORD},
#line 133
  {(ustring)"dimension", KEYWORD},
#line 133
  {(ustring)"external", KEYWORD},
#line 133
  {(ustring)"implicit", KEYWORD},
#line 133
  {(ustring)"in", KEYWORD},
#line 133
  {(ustring)"inout", KEYWORD},
#line 133
  {(ustring)"intent", KEYWORD},
#line 133
  {(ustring)"intrinsic", KEYWORD},
#line 133
  {(ustring)"kind", KEYWORD},
#line 133
  {(ustring)"none", KEYWORD},
#line 133
  {(ustring)"only", KEYWORD},
#line 133
  {(ustring)"optional", KEYWORD},
#line 133
  {(ustring)"out", KEYWORD},
#line 133
  {(ustring)"parameter", KEYWORD},
#line 133
  {(ustring)"pointer", KEYWORD},
#line 133
  {(ustring)"private", KEYWORD},
#line 133
  {(ustring)"public", KEYWORD},
#line 133
  {(ustring)"save", KEYWORD},
#line 133
  {(ustring)"selected_int_kind", KEYWORD},
#line 133
  {(ustring)"selected_real_kind", KEYWORD},
#line 133
  {(ustring)"sequence", KEYWORD},
#line 133
  {(ustring)"target", KEYWORD},
#line 133
  {(ustring)"type", KEYWORD},
#line 133
  {(ustring)"use", KEYWORD},
#line 133


  /* The operators */
  {(ustring)".not.", KEYWORD},
  {(ustring)".or.", KEYWORD},
#line 137
  {(ustring)".and.", KEYWORD},
#line 137
  {(ustring)".ge.", KEYWORD},
#line 137
  {(ustring)".gt.", KEYWORD},
#line 137
  {(ustring)".lt.", KEYWORD},
#line 137
  {(ustring)".le.", KEYWORD},
#line 137
  {(ustring)".eq.", KEYWORD},
#line 137
  {(ustring)".ne.", KEYWORD},
#line 137
  {(ustring)".eqv.", KEYWORD},
#line 137
  {(ustring)".neqv.", KEYWORD},
#line 137


  ENDKEYWORD
};
const char * fortran_abbreviations []= {
  "f95", "f90", "f9", "f", "F", "\0"
};
const uchar fortran_description [] = "\
This style is to check.  \
Please report changes needed to Denis.Girou@idris.fr";
#define fortran_style_def { fortran_style, "Fortran",			\
  fortran_abbreviations, fortran_description, 				\
  CASE_INSENSITIVE, fortran_characters, fortran_characters, fortran_keywords, \
  NOSYMBOL, fortran_specials, fortran_sequences, sh_verbatims, EMPTY }
#line 372 "styles.c.in"

/************************************************************************/
/*			Assembly languages			   	*/
/************************************************************************/
/*
 *		Motorola 68000
 */
#line 1 "styles12.m4"
/************************************************************************/
/*			Assembly languages			   	*/
/************************************************************************/
/*
 *		Motorola 68000
 */
const uchar m68000_characters [] = {
  'A', 'Z',
  'a', 'z',
  '.', '.',
  '\0'
};
const keyword m68000_keywords [] = {
  /* Preprocessor */
  /* Preprocessor */
#line 15
  {(ustring)"#include", KEYWORD_STRONG},
#line 15
  {(ustring)"#define", KEYWORD_STRONG},
#line 15
  {(ustring)"#undef", KEYWORD_STRONG},
#line 15
  {(ustring)"#pragma", KEYWORD_STRONG},
#line 15
  {(ustring)"#if", KEYWORD_STRONG},
#line 15
  {(ustring)"#ifdef", KEYWORD_STRONG},
#line 15
  {(ustring)"#ifndef", KEYWORD_STRONG},
#line 15
  {(ustring)"#elif", KEYWORD_STRONG},
#line 15
  {(ustring)"#else", KEYWORD_STRONG},
#line 15
  {(ustring)"#error", KEYWORD_STRONG},
#line 15
  {(ustring)"#line", KEYWORD_STRONG},
#line 15
  {(ustring)"#ex", KEYWORD_STRONG},
#line 15
  {(ustring)"#endif", KEYWORD_STRONG},
#line 15
  {(ustring)"defined", KEYWORD_STRONG},
#line 15
  {(ustring)"# define", KEYWORD_STRONG},
#line 15
  {(ustring)"# include", KEYWORD_STRONG},
#line 15
  {(ustring)"# if", KEYWORD_STRONG},
#line 15
  {(ustring)"# ifdef", KEYWORD_STRONG},
#line 15
  {(ustring)"# endif", KEYWORD_STRONG},
#line 15
  {(ustring)"#import", KEYWORD_STRONG},
#line 15
  {(ustring)"# import", KEYWORD_STRONG},
#line 15
  {(ustring)"#  import", KEYWORD_STRONG},
#line 15
  {(ustring)"#  define", KEYWORD_STRONG},
#line 15
  {(ustring)"#  include", KEYWORD_STRONG},
#line 15
  {(ustring)"#  if", KEYWORD_STRONG},
#line 15
  {(ustring)"#  ifdef", KEYWORD_STRONG},
#line 15
  {(ustring)"#  endif", KEYWORD_STRONG},
#line 15


  {(ustring)".data", KEYWORD_STRONG},
#line 17
  {(ustring)".globl", KEYWORD_STRONG},
#line 17
  {(ustring)".long", KEYWORD_STRONG},
#line 17
  {(ustring)".skip", KEYWORD_STRONG},
#line 17
  {(ustring)".text", KEYWORD_STRONG},
#line 17


  {(ustring)"addw", KEYWORD_STRONG},
#line 21
  {(ustring)"beq", KEYWORD_STRONG},
#line 21
  {(ustring)"bgt", KEYWORD_STRONG},
#line 21
  {(ustring)"ble", KEYWORD_STRONG},
#line 21
  {(ustring)"bne", KEYWORD_STRONG},
#line 21
  {(ustring)"bra", KEYWORD_STRONG},
#line 21
  {(ustring)"bset", KEYWORD_STRONG},
#line 21
  {(ustring)"btst", KEYWORD_STRONG},
#line 21
  {(ustring)"clrl", KEYWORD_STRONG},
#line 21
  {(ustring)"cmpl", KEYWORD_STRONG},
#line 21
  {(ustring)"jmp", KEYWORD_STRONG},
#line 21
  {(ustring)"jsr", KEYWORD_STRONG},
#line 21
  {(ustring)"movel", KEYWORD_STRONG},
#line 21
  {(ustring)"moveb", KEYWORD_STRONG},
#line 21
  {(ustring)"moveml", KEYWORD_STRONG},
#line 21
  {(ustring)"movew", KEYWORD_STRONG},
#line 21
  {(ustring)"movw", KEYWORD_STRONG},
#line 21
  {(ustring)"rte", KEYWORD_STRONG},
#line 21
  {(ustring)"rts", KEYWORD_STRONG},
#line 21
  {(ustring)"subw", KEYWORD_STRONG},
#line 21
  {(ustring)"subql", KEYWORD_STRONG},
#line 21
  {(ustring)"tstl", KEYWORD_STRONG},
#line 21

   ENDKEYWORD
};
const sequence m68000_sequences [] = {
  /* comments */
  {(ustring)"|#", COMMENT_STRONG, COMMENT_STRONG, (ustring)"$", COMMENT_STRONG},
#line 26
  {(ustring)"|*", COMMENT_STRONG, COMMENT_STRONG, (ustring)"$", COMMENT_STRONG},
  {(ustring)"|", COMMENT, COMMENT, (ustring)"$", COMMENT},
  ENDSEQUENCE
};
const char * m68000_abbreviations []= {
  "68000", "S", "s", "\0"
};
const uchar m68000_description [] = "\
This style is devoted to the assembly language of the Motorola 68000. \
It is still experimental. Send comments to demaille@inf.enst.fr";
#define m68000_style_def { m68000_style, "68000", 				\
  m68000_abbreviations, m68000_description, 				\
  CASE_INSENSITIVE, m68000_characters, m68000_characters, m68000_keywords,\
  NOSYMBOL, NOSYMBOL, m68000_sequences, sh_verbatims, EMPTY }
#line 379 "styles.c.in"

/************************************************************************/
/*			Logical languages			   	*/
/************************************************************************/
/*
 *		Prolog
 */
#line 1 "styles13.m4"
/************************************************************************/
/*			Logical languages			   	*/
/************************************************************************/
/*
 *		Prolog
 */
const uchar prolog_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\0'
};
const keyword prolog_keywords [] = {
  {(ustring)"abort", KEYWORD_STRONG},
#line 21
  {(ustring)"ancestors", KEYWORD_STRONG},
#line 21
  {(ustring)"arg", KEYWORD_STRONG},
#line 21
  {(ustring)"ascii", KEYWORD_STRONG},
#line 21
  {(ustring)"ask", KEYWORD_STRONG},
#line 21
  {(ustring)"asserta", KEYWORD_STRONG},
#line 21
  {(ustring)"assertz", KEYWORD_STRONG},
#line 21
  {(ustring)"assert", KEYWORD_STRONG},
#line 21
  {(ustring)"atomic", KEYWORD_STRONG},
#line 21
  {(ustring)"atom", KEYWORD_STRONG},
#line 21
  {(ustring)"char", KEYWORD_STRONG},
#line 21
  {(ustring)"clause", KEYWORD_STRONG},
#line 21
  {(ustring)"close", KEYWORD_STRONG},
#line 21
  {(ustring)"concat", KEYWORD_STRONG},
#line 21
  {(ustring)"consult", KEYWORD_STRONG},
#line 21
  {(ustring)"ed", KEYWORD_STRONG},
#line 21
  {(ustring)"ef", KEYWORD_STRONG},
#line 21
  {(ustring)"em", KEYWORD_STRONG},
#line 21
  {(ustring)"eof", KEYWORD_STRONG},
#line 21
  {(ustring)"fail", KEYWORD_STRONG},
#line 21
  {(ustring)"file", KEYWORD_STRONG},
#line 21
  {(ustring)"findall", KEYWORD_STRONG},
#line 21
  {(ustring)"functor", KEYWORD_STRONG},
#line 21
  {(ustring)"getc", KEYWORD_STRONG},
#line 21
  {(ustring)"integer", KEYWORD_STRONG},
#line 21
  {(ustring)"is", KEYWORD_STRONG},
#line 21
  {(ustring)"length", KEYWORD_STRONG},
#line 21
  {(ustring)"listing", KEYWORD_STRONG},
#line 21
  {(ustring)"load", KEYWORD_STRONG},
#line 21
  {(ustring)"mod", KEYWORD_STRONG},
#line 21
  {(ustring)"name", KEYWORD_STRONG},
#line 21
  {(ustring)"nl", KEYWORD_STRONG},
#line 21
  {(ustring)"nonvar", KEYWORD_STRONG},
#line 21
  {(ustring)"not", KEYWORD_STRONG},
#line 21
  {(ustring)"numbervars", KEYWORD_STRONG},
#line 21
  {(ustring)"op", KEYWORD_STRONG},
#line 21
  {(ustring)"or", KEYWORD_STRONG},
#line 21
  {(ustring)"pp", KEYWORD_STRONG},
#line 21
  {(ustring)"print", KEYWORD_STRONG},
#line 21
  {(ustring)"prin", KEYWORD_STRONG},
#line 21
  {(ustring)"private", KEYWORD_STRONG},
#line 21
  {(ustring)"prompt", KEYWORD_STRONG},
#line 21
  {(ustring)"putc", KEYWORD_STRONG},
#line 21
  {(ustring)"ratom", KEYWORD_STRONG},
#line 21
  {(ustring)"read_from_this_file", KEYWORD_STRONG},
#line 21
  {(ustring)"read", KEYWORD_STRONG},
#line 21
  {(ustring)"rename", KEYWORD_STRONG},
#line 21
  {(ustring)"repeat", KEYWORD_STRONG},
#line 21
  {(ustring)"retractall", KEYWORD_STRONG},
#line 21
  {(ustring)"retract", KEYWORD_STRONG},
#line 21
  {(ustring)"save", KEYWORD_STRONG},
#line 21
  {(ustring)"seeing", KEYWORD_STRONG},
#line 21
  {(ustring)"seen", KEYWORD_STRONG},
#line 21
  {(ustring)"see", KEYWORD_STRONG},
#line 21
  {(ustring)"sh", KEYWORD_STRONG},
#line 21
  {(ustring)"skip", KEYWORD_STRONG},
#line 21
  {(ustring)"statistics", KEYWORD_STRONG},
#line 21
  {(ustring)"subgoal_of", KEYWORD_STRONG},
#line 21
  {(ustring)"system", KEYWORD_STRONG},
#line 21
  {(ustring)"tab", KEYWORD_STRONG},
#line 21
  {(ustring)"telling", KEYWORD_STRONG},
#line 21
  {(ustring)"tell", KEYWORD_STRONG},
#line 21
  {(ustring)"time", KEYWORD_STRONG},
#line 21
  {(ustring)"told", KEYWORD_STRONG},
#line 21
  {(ustring)"trace", KEYWORD_STRONG},
#line 21
  {(ustring)"true", KEYWORD_STRONG},
#line 21
  {(ustring)"unload", KEYWORD_STRONG},
#line 21
  {(ustring)"untrace", KEYWORD_STRONG},
#line 21
  {(ustring)"var", KEYWORD_STRONG},
#line 21
  {(ustring)"write", KEYWORD_STRONG},
#line 21

   ENDKEYWORD
};
const sequence prolog_sequences [] = {
  /* comments */
  {(ustring)"%", COMMENT, COMMENT, (ustring)"$", COMMENT},
  {(ustring)"/*", COMMENT, COMMENT, (ustring)"*/", COMMENT},
    
  {(ustring)"\"", PLAIN, STRING, (ustring)"\"", PLAIN},
  {(ustring)"\'", PLAIN, STRING, (ustring)"\'", PLAIN},
  ENDSEQUENCE
};
const char * prolog_abbreviations []= {
  "plg", "pro", "\0"
};
const uchar prolog_description [] =
"Under construction. Please send comments to demaille@inf.enst.fr.";
#define prolog_style_def { prolog_style, "prolog", 				\
  prolog_abbreviations, prolog_description, 				\
  CASE_INSENSITIVE, prolog_characters, prolog_characters, prolog_keywords,\
  NOSYMBOL, NOSYMBOL, prolog_sequences, sh_verbatims, EMPTY }
#line 386 "styles.c.in"

/*
 * 14. Database languages (but o2c which is in 5)
 * - sql92
 * - sql
 * - plsql
 * - ora
 */
#line 1 "styles14.m4"
/*************************************************************
 *
 * A2PS: Database Access Languages Styles
 *
 *
 * * * * S Q L   P R E T T Y   P R I N T I N G
 *
 *  # - Prefix -   Style Description                     - Test Files
 *  --  ------   -----------------                       ----------
 *  1.  sql92  - SQL92 Standard Keywords   sqlcrt92.sql, sqlpq92.sql
 *  2.  sql    - Oracle SQL                sqlcrtbl.sql, sqlpqry.pkb
 *  3.  plsql  - Oracle PL/SQL                           sqlspace.pkb
 *  4.  oracle - Oracle SQL, including PL/SQL and tools  sqlschema.sql
 *  5.  initora- Oracle initilization parameter file     sqlinit.ora
 *  6.  sql3   - SQL3 Standard Keyword                   When available
 *  7.         - Other DB systems.
 *
 *
 * * * * N O T E S
 *
 *    1. sql92: SQL92 Standard Keywords
 *                By: Pierre Mareschal <pmaresch@be.oracle.com>.
 *              From: SQL92 standards taken from SQL92 BNF syntax.
 *                  (Available in text format from several sources.)
 *    2. sql  : Oracle SQL
 *    3. pls  : Oracle PL/SQL (Later...)
 *    4. pls  : Oracle SQL, including PL/SQL and tools (SQL*Plus...)
 *    2,3,4       By: Pierre Mareschal <pmaresch@be.oracle.com>.
 *              From: - PL/SQL User's Guide and Reference Manual (V 2.3)
 *                    - Programmer's Guide to the Oracle Precompiler (V 1.6)
 *    5. ora  : Oracle initilization parameter file
 *                By: Pierre Mareschal <pmaresch@be.oracle.com>.
 *              From: Oracle7 Server Manuals (Version 7.3).
 *    6. sql3 : SQL3 Standard Keywords (when available)
 *    7.      : Yours. (Other DB systems.)
 *              by Someone, somewhere, in summertime.
 *
 *
 * * * * * R E A D   M E ' S
 *
 * Read Me for Language 1 to 6
 *
 * I primarly added SQL pretty printing for my work.
 * Since I work to Oracle, the SQL extension defaults to SQL
 * and PL/SQL at Oracle's flavour.
 * However, since not everybody uses Oracle as a database
 * (and I wonder why?), I also added support for SQL92 standard.
 * I'll add support for SQL3 as soon as a standard appears...
 * Also, I'll do my best to maintain and keep up to date with
 * Oracle versions.
 *
 * Please read the manual: Pretty printing in a2ps is "keyword" based
 * and there is not lexical or syntaxtical analysis.
 *
 * Pierre Mareschal <pmaresch@be.oracle.com> - 18-MAR-97
 *
 *
 *************************************************************/

/*************************************************************
 * 1. SQL92 Standard
 *    --------------
 */
const sequence sql92_sequences [] = {
  /* Comments         */
  {(ustring)"/*", COMMENT, COMMENT, (ustring)"*/", COMMENT},
  /* Literals         */
  {(ustring)"\"", PLAIN, STRING, (ustring)"\"", PLAIN},
  {(ustring)"\'", PLAIN, STRING, (ustring)"\'", PLAIN},
  ENDSEQUENCE
};
const uchar sql92_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\0'
};
const keyword sql92_keywords [] = {
   {(ustring)"action", KEYWORD_STRONG},
#line 106
  {(ustring)"add", KEYWORD_STRONG},
#line 106
  {(ustring)"all", KEYWORD_STRONG},
#line 106
  {(ustring)"allocate", KEYWORD_STRONG},
#line 106
  {(ustring)"alter", KEYWORD_STRONG},
#line 106
  {(ustring)"and", KEYWORD_STRONG},
#line 106
  {(ustring)"any", KEYWORD_STRONG},
#line 106
  {(ustring)"are", KEYWORD_STRONG},
#line 106
  {(ustring)"as", KEYWORD_STRONG},
#line 106
  {(ustring)"asc", KEYWORD_STRONG},
#line 106
  {(ustring)"assertion", KEYWORD_STRONG},
#line 106
  {(ustring)"at", KEYWORD_STRONG},
#line 106
  {(ustring)"authorization", KEYWORD_STRONG},
#line 106
  {(ustring)"avg", KEYWORD_STRONG},
#line 106
  {(ustring)"begin", KEYWORD_STRONG},
#line 106
  {(ustring)"between", KEYWORD_STRONG},
#line 106
  {(ustring)"bit", KEYWORD_STRONG},
#line 106
  {(ustring)"bit_length", KEYWORD_STRONG},
#line 106
  {(ustring)"both", KEYWORD_STRONG},
#line 106
  {(ustring)"by", KEYWORD_STRONG},
#line 106
  {(ustring)"cascade", KEYWORD_STRONG},
#line 106
  {(ustring)"cascaded", KEYWORD_STRONG},
#line 106
  {(ustring)"case", KEYWORD_STRONG},
#line 106
  {(ustring)"cast", KEYWORD_STRONG},
#line 106
  {(ustring)"catalog", KEYWORD_STRONG},
#line 106
  {(ustring)"char", KEYWORD_STRONG},
#line 106
  {(ustring)"char_length", KEYWORD_STRONG},
#line 106
  {(ustring)"character", KEYWORD_STRONG},
#line 106
  {(ustring)"character_length", KEYWORD_STRONG},
#line 106
  {(ustring)"check", KEYWORD_STRONG},
#line 106
  {(ustring)"close", KEYWORD_STRONG},
#line 106
  {(ustring)"coalesce", KEYWORD_STRONG},
#line 106
  {(ustring)"collate", KEYWORD_STRONG},
#line 106
  {(ustring)"collation", KEYWORD_STRONG},
#line 106
  {(ustring)"column", KEYWORD_STRONG},
#line 106
  {(ustring)"commit", KEYWORD_STRONG},
#line 106
  {(ustring)"connect", KEYWORD_STRONG},
#line 106
  {(ustring)"connection", KEYWORD_STRONG},
#line 106
  {(ustring)"constraint", KEYWORD_STRONG},
#line 106
  {(ustring)"constraints", KEYWORD_STRONG},
#line 106
  {(ustring)"continue", KEYWORD_STRONG},
#line 106
  {(ustring)"convert", KEYWORD_STRONG},
#line 106
  {(ustring)"corresponding", KEYWORD_STRONG},
#line 106
  {(ustring)"count", KEYWORD_STRONG},
#line 106
  {(ustring)"create", KEYWORD_STRONG},
#line 106
  {(ustring)"cross", KEYWORD_STRONG},
#line 106
  {(ustring)"current", KEYWORD_STRONG},
#line 106
  {(ustring)"current_date", KEYWORD_STRONG},
#line 106
  {(ustring)"current_time", KEYWORD_STRONG},
#line 106
  {(ustring)"current_timestamp", KEYWORD_STRONG},
#line 106
  {(ustring)"current_user", KEYWORD_STRONG},
#line 106
  {(ustring)"cursor", KEYWORD_STRONG},
#line 106
  {(ustring)"date", KEYWORD_STRONG},
#line 106
  {(ustring)"day", KEYWORD_STRONG},
#line 106
  {(ustring)"deallocate", KEYWORD_STRONG},
#line 106
  {(ustring)"dec", KEYWORD_STRONG},
#line 106
  {(ustring)"decimal", KEYWORD_STRONG},
#line 106
  {(ustring)"declare", KEYWORD_STRONG},
#line 106
  {(ustring)"default", KEYWORD_STRONG},
#line 106
  {(ustring)"deferrable", KEYWORD_STRONG},
#line 106
  {(ustring)"deferred", KEYWORD_STRONG},
#line 106
  {(ustring)"delete", KEYWORD_STRONG},
#line 106
  {(ustring)"desc", KEYWORD_STRONG},
#line 106
  {(ustring)"describe", KEYWORD_STRONG},
#line 106
  {(ustring)"descriptor", KEYWORD_STRONG},
#line 106
  {(ustring)"diagnostics", KEYWORD_STRONG},
#line 106
  {(ustring)"disconnect", KEYWORD_STRONG},
#line 106
  {(ustring)"distinct", KEYWORD_STRONG},
#line 106
  {(ustring)"domain", KEYWORD_STRONG},
#line 106
  {(ustring)"double", KEYWORD_STRONG},
#line 106
  {(ustring)"drop", KEYWORD_STRONG},
#line 106
  {(ustring)"else", KEYWORD_STRONG},
#line 106
  {(ustring)"end", KEYWORD_STRONG},
#line 106
  {(ustring)"end-exec", KEYWORD_STRONG},
#line 106
  {(ustring)"escape", KEYWORD_STRONG},
#line 106
  {(ustring)"except", KEYWORD_STRONG},
#line 106
  {(ustring)"exception", KEYWORD_STRONG},
#line 106
  {(ustring)"exec", KEYWORD_STRONG},
#line 106
  {(ustring)"execute", KEYWORD_STRONG},
#line 106
  {(ustring)"exists", KEYWORD_STRONG},
#line 106
  {(ustring)"external", KEYWORD_STRONG},
#line 106
  {(ustring)"extract", KEYWORD_STRONG},
#line 106
  {(ustring)"false", KEYWORD_STRONG},
#line 106
  {(ustring)"fetch", KEYWORD_STRONG},
#line 106
  {(ustring)"first", KEYWORD_STRONG},
#line 106
  {(ustring)"float", KEYWORD_STRONG},
#line 106
  {(ustring)"for", KEYWORD_STRONG},
#line 106
  {(ustring)"foreign", KEYWORD_STRONG},
#line 106
  {(ustring)"found", KEYWORD_STRONG},
#line 106
  {(ustring)"from", KEYWORD_STRONG},
#line 106
  {(ustring)"full", KEYWORD_STRONG},
#line 106
  {(ustring)"get", KEYWORD_STRONG},
#line 106
  {(ustring)"global", KEYWORD_STRONG},
#line 106
  {(ustring)"go", KEYWORD_STRONG},
#line 106
  {(ustring)"goto", KEYWORD_STRONG},
#line 106
  {(ustring)"grant", KEYWORD_STRONG},
#line 106
  {(ustring)"group", KEYWORD_STRONG},
#line 106
  {(ustring)"having", KEYWORD_STRONG},
#line 106
  {(ustring)"hour", KEYWORD_STRONG},
#line 106
  {(ustring)"identity", KEYWORD_STRONG},
#line 106
  {(ustring)"immediate", KEYWORD_STRONG},
#line 106
  {(ustring)"in", KEYWORD_STRONG},
#line 106
  {(ustring)"indicator", KEYWORD_STRONG},
#line 106
  {(ustring)"initially", KEYWORD_STRONG},
#line 106
  {(ustring)"inner", KEYWORD_STRONG},
#line 106
  {(ustring)"input", KEYWORD_STRONG},
#line 106
  {(ustring)"insensitive", KEYWORD_STRONG},
#line 106
  {(ustring)"insert", KEYWORD_STRONG},
#line 106
  {(ustring)"int", KEYWORD_STRONG},
#line 106
  {(ustring)"integer", KEYWORD_STRONG},
#line 106
  {(ustring)"intersect", KEYWORD_STRONG},
#line 106
  {(ustring)"interval", KEYWORD_STRONG},
#line 106
  {(ustring)"into", KEYWORD_STRONG},
#line 106
  {(ustring)"is", KEYWORD_STRONG},
#line 106
  {(ustring)"isolation", KEYWORD_STRONG},
#line 106
  {(ustring)"join", KEYWORD_STRONG},
#line 106
  {(ustring)"key", KEYWORD_STRONG},
#line 106
  {(ustring)"language", KEYWORD_STRONG},
#line 106
  {(ustring)"last", KEYWORD_STRONG},
#line 106
  {(ustring)"leading", KEYWORD_STRONG},
#line 106
  {(ustring)"left", KEYWORD_STRONG},
#line 106
  {(ustring)"level", KEYWORD_STRONG},
#line 106
  {(ustring)"like", KEYWORD_STRONG},
#line 106
  {(ustring)"local", KEYWORD_STRONG},
#line 106
  {(ustring)"lower", KEYWORD_STRONG},
#line 106
  {(ustring)"match", KEYWORD_STRONG},
#line 106
  {(ustring)"max", KEYWORD_STRONG},
#line 106
  {(ustring)"min", KEYWORD_STRONG},
#line 106
  {(ustring)"minute", KEYWORD_STRONG},
#line 106
  {(ustring)"module", KEYWORD_STRONG},
#line 106
  {(ustring)"month", KEYWORD_STRONG},
#line 106
  {(ustring)"names", KEYWORD_STRONG},
#line 106
  {(ustring)"national", KEYWORD_STRONG},
#line 106
  {(ustring)"natural", KEYWORD_STRONG},
#line 106
  {(ustring)"nchar", KEYWORD_STRONG},
#line 106
  {(ustring)"next", KEYWORD_STRONG},
#line 106
  {(ustring)"no", KEYWORD_STRONG},
#line 106
  {(ustring)"not", KEYWORD_STRONG},
#line 106
  {(ustring)"null", KEYWORD_STRONG},
#line 106
  {(ustring)"nullif", KEYWORD_STRONG},
#line 106
  {(ustring)"numeric", KEYWORD_STRONG},
#line 106
  {(ustring)"octet_length", KEYWORD_STRONG},
#line 106
  {(ustring)"of", KEYWORD_STRONG},
#line 106
  {(ustring)"on", KEYWORD_STRONG},
#line 106
  {(ustring)"only", KEYWORD_STRONG},
#line 106
  {(ustring)"open", KEYWORD_STRONG},
#line 106
  {(ustring)"option", KEYWORD_STRONG},
#line 106
  {(ustring)"or", KEYWORD_STRONG},
#line 106
  {(ustring)"order", KEYWORD_STRONG},
#line 106
  {(ustring)"outer", KEYWORD_STRONG},
#line 106
  {(ustring)"output", KEYWORD_STRONG},
#line 106
  {(ustring)"overlaps", KEYWORD_STRONG},
#line 106
  {(ustring)"pad", KEYWORD_STRONG},
#line 106
  {(ustring)"partial", KEYWORD_STRONG},
#line 106
  {(ustring)"position", KEYWORD_STRONG},
#line 106
  {(ustring)"precision", KEYWORD_STRONG},
#line 106
  {(ustring)"prepare", KEYWORD_STRONG},
#line 106
  {(ustring)"preserve", KEYWORD_STRONG},
#line 106
  {(ustring)"primary", KEYWORD_STRONG},
#line 106
  {(ustring)"prior", KEYWORD_STRONG},
#line 106
  {(ustring)"privileges", KEYWORD_STRONG},
#line 106
  {(ustring)"procedure", KEYWORD_STRONG},
#line 106
  {(ustring)"public", KEYWORD_STRONG},
#line 106
  {(ustring)"read", KEYWORD_STRONG},
#line 106
  {(ustring)"real", KEYWORD_STRONG},
#line 106
  {(ustring)"references", KEYWORD_STRONG},
#line 106
  {(ustring)"relative", KEYWORD_STRONG},
#line 106
  {(ustring)"restrict", KEYWORD_STRONG},
#line 106
  {(ustring)"revoke", KEYWORD_STRONG},
#line 106
  {(ustring)"right", KEYWORD_STRONG},
#line 106
  {(ustring)"rollback", KEYWORD_STRONG},
#line 106
  {(ustring)"rows", KEYWORD_STRONG},
#line 106
  {(ustring)"schema", KEYWORD_STRONG},
#line 106
  {(ustring)"scroll", KEYWORD_STRONG},
#line 106
  {(ustring)"second", KEYWORD_STRONG},
#line 106
  {(ustring)"section", KEYWORD_STRONG},
#line 106
  {(ustring)"select", KEYWORD_STRONG},
#line 106
  {(ustring)"session", KEYWORD_STRONG},
#line 106
  {(ustring)"session_user", KEYWORD_STRONG},
#line 106
  {(ustring)"set", KEYWORD_STRONG},
#line 106
  {(ustring)"size", KEYWORD_STRONG},
#line 106
  {(ustring)"smallint", KEYWORD_STRONG},
#line 106
  {(ustring)"some", KEYWORD_STRONG},
#line 106
  {(ustring)"space", KEYWORD_STRONG},
#line 106
  {(ustring)"sql", KEYWORD_STRONG},
#line 106
  {(ustring)"sqlcode", KEYWORD_STRONG},
#line 106
  {(ustring)"sqlerror", KEYWORD_STRONG},
#line 106
  {(ustring)"sqlstate", KEYWORD_STRONG},
#line 106
  {(ustring)"substring", KEYWORD_STRONG},
#line 106
  {(ustring)"sum", KEYWORD_STRONG},
#line 106
  {(ustring)"system_user", KEYWORD_STRONG},
#line 106
  {(ustring)"table", KEYWORD_STRONG},
#line 106
  {(ustring)"temporary", KEYWORD_STRONG},
#line 106
  {(ustring)"then", KEYWORD_STRONG},
#line 106
  {(ustring)"time", KEYWORD_STRONG},
#line 106
  {(ustring)"timestamp", KEYWORD_STRONG},
#line 106
  {(ustring)"timezone_hour", KEYWORD_STRONG},
#line 106
  {(ustring)"timezone_minute", KEYWORD_STRONG},
#line 106
  {(ustring)"to", KEYWORD_STRONG},
#line 106
  {(ustring)"trailing", KEYWORD_STRONG},
#line 106
  {(ustring)"transaction", KEYWORD_STRONG},
#line 106
  {(ustring)"translate", KEYWORD_STRONG},
#line 106
  {(ustring)"translation", KEYWORD_STRONG},
#line 106
  {(ustring)"trim", KEYWORD_STRONG},
#line 106
  {(ustring)"true", KEYWORD_STRONG},
#line 106
  {(ustring)"union", KEYWORD_STRONG},
#line 106
  {(ustring)"unique", KEYWORD_STRONG},
#line 106
  {(ustring)"unknown", KEYWORD_STRONG},
#line 106
  {(ustring)"update", KEYWORD_STRONG},
#line 106
  {(ustring)"upper", KEYWORD_STRONG},
#line 106
  {(ustring)"usage", KEYWORD_STRONG},
#line 106
  {(ustring)"user", KEYWORD_STRONG},
#line 106
  {(ustring)"using", KEYWORD_STRONG},
#line 106
  {(ustring)"value", KEYWORD_STRONG},
#line 106
  {(ustring)"values", KEYWORD_STRONG},
#line 106
  {(ustring)"varchar", KEYWORD_STRONG},
#line 106
  {(ustring)"varying", KEYWORD_STRONG},
#line 106
  {(ustring)"view", KEYWORD_STRONG},
#line 106
  {(ustring)"when", KEYWORD_STRONG},
#line 106
  {(ustring)"whenever", KEYWORD_STRONG},
#line 106
  {(ustring)"where", KEYWORD_STRONG},
#line 106
  {(ustring)"with", KEYWORD_STRONG},
#line 106
  {(ustring)"work", KEYWORD_STRONG},
#line 106
  {(ustring)"write", KEYWORD_STRONG},
#line 106
  {(ustring)"year", KEYWORD_STRONG},
#line 106
  {(ustring)"zone", KEYWORD_STRONG},
#line 106

   ENDKEYWORD
};

const char * sql92_abbreviations[]= {
  "sql92", "\0"
};

const uchar sql92_description[] = "\
a2ps-sql92 Pretty Printer Version 1.0.0 alpha - 18-MAR-97\
This style is to be checked.\n\
Please report changes needed to Pierre Mareschal <pmaresch@be.oracle.com>";

#define sql92_style_def { sql92_style, "sql92",				\
  sql92_abbreviations, sql92_description, 				\
  CASE_SENSITIVE, sql92_characters, sql92_characters, sql92_keywords,	\
  NOSYMBOL, NOSYMBOL, sql92_sequences, sh_verbatims, EMPTY }


/************************************************************
 * O r a c l e   P r e t t y   P r i n t e r s
 * ===========================================
 *
 *
 * G E N E R I C (Common to all Oracle Pretty Printers)
 * =============
 */

const sequence sql_sequences [] = {
  /* Optimizer Pragma */
  {(ustring)"/*+", COMMENT_STRONG, COMMENT_STRONG, (ustring)"*/", COMMENT_STRONG},
  /* Comments         */
  {(ustring)"--", COMMENT, COMMENT, (ustring)"$", COMMENT},
  {(ustring)"/*", COMMENT, COMMENT, (ustring)"*/", COMMENT},
  {(ustring)"//", COMMENT, COMMENT, (ustring)"$", COMMENT},
  /* Literals         */
  {(ustring)"\"", PLAIN, STRING, (ustring)"\"", PLAIN},
  {(ustring)"\'", PLAIN, STRING, (ustring)"\'", PLAIN},
  ENDSEQUENCE
};
const uchar sql_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\0'
};

/* C U S T O M (Custom for each Oracle language flavour)
 * ===========
 *
 *
 ************************************************************
 * 2. Oracle SQL
 *    ----------
 */
const keyword sql_keywords [] = {
   {(ustring)"access", KEYWORD_STRONG},
#line 176
  {(ustring)"add", KEYWORD_STRONG},
#line 176
  {(ustring)"all", KEYWORD_STRONG},
#line 176
  {(ustring)"alter", KEYWORD_STRONG},
#line 176
  {(ustring)"and", KEYWORD_STRONG},
#line 176
  {(ustring)"any", KEYWORD_STRONG},
#line 176
  {(ustring)"arraylen", KEYWORD_STRONG},
#line 176
  {(ustring)"as", KEYWORD_STRONG},
#line 176
  {(ustring)"asc", KEYWORD_STRONG},
#line 176
  {(ustring)"audit", KEYWORD_STRONG},
#line 176
  {(ustring)"between", KEYWORD_STRONG},
#line 176
  {(ustring)"by", KEYWORD_STRONG},
#line 176
  {(ustring)"char", KEYWORD_STRONG},
#line 176
  {(ustring)"check", KEYWORD_STRONG},
#line 176
  {(ustring)"cluster", KEYWORD_STRONG},
#line 176
  {(ustring)"column", KEYWORD_STRONG},
#line 176
  {(ustring)"comment", KEYWORD_STRONG},
#line 176
  {(ustring)"compress", KEYWORD_STRONG},
#line 176
  {(ustring)"connect", KEYWORD_STRONG},
#line 176
  {(ustring)"create", KEYWORD_STRONG},
#line 176
  {(ustring)"current", KEYWORD_STRONG},
#line 176
  {(ustring)"date", KEYWORD_STRONG},
#line 176
  {(ustring)"decimal", KEYWORD_STRONG},
#line 176
  {(ustring)"default", KEYWORD_STRONG},
#line 176
  {(ustring)"delete", KEYWORD_STRONG},
#line 176
  {(ustring)"desc", KEYWORD_STRONG},
#line 176
  {(ustring)"distinct", KEYWORD_STRONG},
#line 176
  {(ustring)"drop", KEYWORD_STRONG},
#line 176
  {(ustring)"else", KEYWORD_STRONG},
#line 176
  {(ustring)"exclusive", KEYWORD_STRONG},
#line 176
  {(ustring)"exists", KEYWORD_STRONG},
#line 176
  {(ustring)"file", KEYWORD_STRONG},
#line 176
  {(ustring)"float", KEYWORD_STRONG},
#line 176
  {(ustring)"for", KEYWORD_STRONG},
#line 176
  {(ustring)"from", KEYWORD_STRONG},
#line 176
  {(ustring)"grant", KEYWORD_STRONG},
#line 176
  {(ustring)"group", KEYWORD_STRONG},
#line 176
  {(ustring)"having", KEYWORD_STRONG},
#line 176
  {(ustring)"identified", KEYWORD_STRONG},
#line 176
  {(ustring)"immediate", KEYWORD_STRONG},
#line 176
  {(ustring)"in", KEYWORD_STRONG},
#line 176
  {(ustring)"increment", KEYWORD_STRONG},
#line 176
  {(ustring)"index", KEYWORD_STRONG},
#line 176
  {(ustring)"initial", KEYWORD_STRONG},
#line 176
  {(ustring)"insert", KEYWORD_STRONG},
#line 176
  {(ustring)"integer", KEYWORD_STRONG},
#line 176
  {(ustring)"intersect", KEYWORD_STRONG},
#line 176
  {(ustring)"into", KEYWORD_STRONG},
#line 176
  {(ustring)"is", KEYWORD_STRONG},
#line 176
  {(ustring)"level", KEYWORD_STRONG},
#line 176
  {(ustring)"like", KEYWORD_STRONG},
#line 176
  {(ustring)"lock", KEYWORD_STRONG},
#line 176
  {(ustring)"long", KEYWORD_STRONG},
#line 176
  {(ustring)"maxextents", KEYWORD_STRONG},
#line 176
  {(ustring)"minus", KEYWORD_STRONG},
#line 176
  {(ustring)"mode", KEYWORD_STRONG},
#line 176
  {(ustring)"modify", KEYWORD_STRONG},
#line 176
  {(ustring)"noaudit", KEYWORD_STRONG},
#line 176
  {(ustring)"nocompress", KEYWORD_STRONG},
#line 176
  {(ustring)"not", KEYWORD_STRONG},
#line 176
  {(ustring)"notfound", KEYWORD_STRONG},
#line 176
  {(ustring)"nowait", KEYWORD_STRONG},
#line 176
  {(ustring)"null", KEYWORD_STRONG},
#line 176
  {(ustring)"number", KEYWORD_STRONG},
#line 176
  {(ustring)"of", KEYWORD_STRONG},
#line 176
  {(ustring)"offline", KEYWORD_STRONG},
#line 176
  {(ustring)"on", KEYWORD_STRONG},
#line 176
  {(ustring)"online", KEYWORD_STRONG},
#line 176
  {(ustring)"option", KEYWORD_STRONG},
#line 176
  {(ustring)"or", KEYWORD_STRONG},
#line 176
  {(ustring)"order", KEYWORD_STRONG},
#line 176
  {(ustring)"pctfree", KEYWORD_STRONG},
#line 176
  {(ustring)"prior", KEYWORD_STRONG},
#line 176
  {(ustring)"privileges", KEYWORD_STRONG},
#line 176
  {(ustring)"public", KEYWORD_STRONG},
#line 176
  {(ustring)"raw", KEYWORD_STRONG},
#line 176
  {(ustring)"rename", KEYWORD_STRONG},
#line 176
  {(ustring)"resource", KEYWORD_STRONG},
#line 176
  {(ustring)"revoke", KEYWORD_STRONG},
#line 176
  {(ustring)"row", KEYWORD_STRONG},
#line 176
  {(ustring)"rowid", KEYWORD_STRONG},
#line 176
  {(ustring)"rowlabel", KEYWORD_STRONG},
#line 176
  {(ustring)"rownum", KEYWORD_STRONG},
#line 176
  {(ustring)"rows", KEYWORD_STRONG},
#line 176
  {(ustring)"select", KEYWORD_STRONG},
#line 176
  {(ustring)"session", KEYWORD_STRONG},
#line 176
  {(ustring)"set", KEYWORD_STRONG},
#line 176
  {(ustring)"share", KEYWORD_STRONG},
#line 176
  {(ustring)"size", KEYWORD_STRONG},
#line 176
  {(ustring)"smallint", KEYWORD_STRONG},
#line 176
  {(ustring)"sqlbuf", KEYWORD_STRONG},
#line 176
  {(ustring)"start", KEYWORD_STRONG},
#line 176
  {(ustring)"successful", KEYWORD_STRONG},
#line 176
  {(ustring)"synonym", KEYWORD_STRONG},
#line 176
  {(ustring)"sysdate", KEYWORD_STRONG},
#line 176
  {(ustring)"table", KEYWORD_STRONG},
#line 176
  {(ustring)"then", KEYWORD_STRONG},
#line 176
  {(ustring)"to", KEYWORD_STRONG},
#line 176
  {(ustring)"trigger", KEYWORD_STRONG},
#line 176
  {(ustring)"uid", KEYWORD_STRONG},
#line 176
  {(ustring)"union", KEYWORD_STRONG},
#line 176
  {(ustring)"unique", KEYWORD_STRONG},
#line 176
  {(ustring)"update", KEYWORD_STRONG},
#line 176
  {(ustring)"user", KEYWORD_STRONG},
#line 176
  {(ustring)"validate", KEYWORD_STRONG},
#line 176
  {(ustring)"values", KEYWORD_STRONG},
#line 176
  {(ustring)"varchar", KEYWORD_STRONG},
#line 176
  {(ustring)"varchar2", KEYWORD_STRONG},
#line 176
  {(ustring)"view", KEYWORD_STRONG},
#line 176
  {(ustring)"whenever", KEYWORD_STRONG},
#line 176
  {(ustring)"where", KEYWORD_STRONG},
#line 176
  {(ustring)"with", KEYWORD_STRONG},
#line 176

   ENDKEYWORD
};

const char * sql_abbreviations[]= {
  "sql", "\0"
};

const uchar sql_description[] = "\
a2ps-sql Pretty Printer Version 1.0.0 beta - 18-MAR-97\
For comments, support for -- /*..*/ and //.\n\
This style is to be checked.\n\
Please report changes needed to Pierre Mareschal <pmaresch@be.oracle.com>";

#define sql_style_def { sql_style, "sql",			\
  sql_abbreviations, sql_description, 				\
  CASE_SENSITIVE, sql_characters, sql_characters, sql_keywords,	\
  NOSYMBOL, NOSYMBOL, sql_sequences, sh_verbatims, EMPTY }



/************************************************************
 * 3. Oracle PL/SQL (v. 2.3)
 *    ----------------------
 */
const keyword plsql_keywords [] = {
   {(ustring)"abort", KEYWORD_STRONG},
#line 233
  {(ustring)"accept", KEYWORD_STRONG},
#line 233
  {(ustring)"access", KEYWORD_STRONG},
#line 233
  {(ustring)"add", KEYWORD_STRONG},
#line 233
  {(ustring)"all", KEYWORD_STRONG},
#line 233
  {(ustring)"alter", KEYWORD_STRONG},
#line 233
  {(ustring)"and", KEYWORD_STRONG},
#line 233
  {(ustring)"any", KEYWORD_STRONG},
#line 233
  {(ustring)"array", KEYWORD_STRONG},
#line 233
  {(ustring)"arraylen", KEYWORD_STRONG},
#line 233
  {(ustring)"as", KEYWORD_STRONG},
#line 233
  {(ustring)"asc", KEYWORD_STRONG},
#line 233
  {(ustring)"assert", KEYWORD_STRONG},
#line 233
  {(ustring)"assign", KEYWORD_STRONG},
#line 233
  {(ustring)"at", KEYWORD_STRONG},
#line 233
  {(ustring)"audit", KEYWORD_STRONG},
#line 233
  {(ustring)"authorization", KEYWORD_STRONG},
#line 233
  {(ustring)"avg", KEYWORD_STRONG},
#line 233
  {(ustring)"base_table", KEYWORD_STRONG},
#line 233
  {(ustring)"begin", KEYWORD_STRONG},
#line 233
  {(ustring)"between", KEYWORD_STRONG},
#line 233
  {(ustring)"binary_integer", KEYWORD_STRONG},
#line 233
  {(ustring)"body", KEYWORD_STRONG},
#line 233
  {(ustring)"boolean", KEYWORD_STRONG},
#line 233
  {(ustring)"by", KEYWORD_STRONG},
#line 233
  {(ustring)"case", KEYWORD_STRONG},
#line 233
  {(ustring)"char", KEYWORD_STRONG},
#line 233
  {(ustring)"char_base", KEYWORD_STRONG},
#line 233
  {(ustring)"check", KEYWORD_STRONG},
#line 233
  {(ustring)"close", KEYWORD_STRONG},
#line 233
  {(ustring)"cluster", KEYWORD_STRONG},
#line 233
  {(ustring)"clusters", KEYWORD_STRONG},
#line 233
  {(ustring)"colauth", KEYWORD_STRONG},
#line 233
  {(ustring)"column", KEYWORD_STRONG},
#line 233
  {(ustring)"comment", KEYWORD_STRONG},
#line 233
  {(ustring)"commit", KEYWORD_STRONG},
#line 233
  {(ustring)"compress", KEYWORD_STRONG},
#line 233
  {(ustring)"connect", KEYWORD_STRONG},
#line 233
  {(ustring)"constant", KEYWORD_STRONG},
#line 233
  {(ustring)"crash", KEYWORD_STRONG},
#line 233
  {(ustring)"create", KEYWORD_STRONG},
#line 233
  {(ustring)"current", KEYWORD_STRONG},
#line 233
  {(ustring)"currval", KEYWORD_STRONG},
#line 233
  {(ustring)"cursor", KEYWORD_STRONG},
#line 233
  {(ustring)"data_base", KEYWORD_STRONG},
#line 233
  {(ustring)"database", KEYWORD_STRONG},
#line 233
  {(ustring)"date", KEYWORD_STRONG},
#line 233
  {(ustring)"dba", KEYWORD_STRONG},
#line 233
  {(ustring)"debugoff", KEYWORD_STRONG},
#line 233
  {(ustring)"debugon", KEYWORD_STRONG},
#line 233
  {(ustring)"decimal", KEYWORD_STRONG},
#line 233
  {(ustring)"declare", KEYWORD_STRONG},
#line 233
  {(ustring)"default", KEYWORD_STRONG},
#line 233
  {(ustring)"definition", KEYWORD_STRONG},
#line 233
  {(ustring)"delay", KEYWORD_STRONG},
#line 233
  {(ustring)"delete", KEYWORD_STRONG},
#line 233
  {(ustring)"delta", KEYWORD_STRONG},
#line 233
  {(ustring)"desc", KEYWORD_STRONG},
#line 233
  {(ustring)"digits", KEYWORD_STRONG},
#line 233
  {(ustring)"dispose", KEYWORD_STRONG},
#line 233
  {(ustring)"distinct", KEYWORD_STRONG},
#line 233
  {(ustring)"do", KEYWORD_STRONG},
#line 233
  {(ustring)"drop", KEYWORD_STRONG},
#line 233
  {(ustring)"else", KEYWORD_STRONG},
#line 233
  {(ustring)"elsif", KEYWORD_STRONG},
#line 233
  {(ustring)"end", KEYWORD_STRONG},
#line 233
  {(ustring)"entry", KEYWORD_STRONG},
#line 233
  {(ustring)"exception", KEYWORD_STRONG},
#line 233
  {(ustring)"exception_init", KEYWORD_STRONG},
#line 233
  {(ustring)"exclusive", KEYWORD_STRONG},
#line 233
  {(ustring)"exists", KEYWORD_STRONG},
#line 233
  {(ustring)"exit", KEYWORD_STRONG},
#line 233
  {(ustring)"false", KEYWORD_STRONG},
#line 233
  {(ustring)"fetch", KEYWORD_STRONG},
#line 233
  {(ustring)"file", KEYWORD_STRONG},
#line 233
  {(ustring)"float", KEYWORD_STRONG},
#line 233
  {(ustring)"for", KEYWORD_STRONG},
#line 233
  {(ustring)"form", KEYWORD_STRONG},
#line 233
  {(ustring)"from", KEYWORD_STRONG},
#line 233
  {(ustring)"function", KEYWORD_STRONG},
#line 233
  {(ustring)"generic", KEYWORD_STRONG},
#line 233
  {(ustring)"goto", KEYWORD_STRONG},
#line 233
  {(ustring)"grant", KEYWORD_STRONG},
#line 233
  {(ustring)"group", KEYWORD_STRONG},
#line 233
  {(ustring)"having", KEYWORD_STRONG},
#line 233
  {(ustring)"identified", KEYWORD_STRONG},
#line 233
  {(ustring)"if", KEYWORD_STRONG},
#line 233
  {(ustring)"immediate", KEYWORD_STRONG},
#line 233
  {(ustring)"in", KEYWORD_STRONG},
#line 233
  {(ustring)"increment", KEYWORD_STRONG},
#line 233
  {(ustring)"index", KEYWORD_STRONG},
#line 233
  {(ustring)"indexes", KEYWORD_STRONG},
#line 233
  {(ustring)"indicator", KEYWORD_STRONG},
#line 233
  {(ustring)"initial", KEYWORD_STRONG},
#line 233
  {(ustring)"insert", KEYWORD_STRONG},
#line 233
  {(ustring)"integer", KEYWORD_STRONG},
#line 233
  {(ustring)"interface", KEYWORD_STRONG},
#line 233
  {(ustring)"intersect", KEYWORD_STRONG},
#line 233
  {(ustring)"into", KEYWORD_STRONG},
#line 233
  {(ustring)"is", KEYWORD_STRONG},
#line 233
  {(ustring)"level", KEYWORD_STRONG},
#line 233
  {(ustring)"like", KEYWORD_STRONG},
#line 233
  {(ustring)"limited", KEYWORD_STRONG},
#line 233
  {(ustring)"lock", KEYWORD_STRONG},
#line 233
  {(ustring)"long", KEYWORD_STRONG},
#line 233
  {(ustring)"loop", KEYWORD_STRONG},
#line 233
  {(ustring)"max", KEYWORD_STRONG},
#line 233
  {(ustring)"maxextents", KEYWORD_STRONG},
#line 233
  {(ustring)"min", KEYWORD_STRONG},
#line 233
  {(ustring)"minus", KEYWORD_STRONG},
#line 233
  {(ustring)"mlslabel", KEYWORD_STRONG},
#line 233
  {(ustring)"mod", KEYWORD_STRONG},
#line 233
  {(ustring)"mode", KEYWORD_STRONG},
#line 233
  {(ustring)"modify", KEYWORD_STRONG},
#line 233
  {(ustring)"natural", KEYWORD_STRONG},
#line 233
  {(ustring)"naturaln", KEYWORD_STRONG},
#line 233
  {(ustring)"new", KEYWORD_STRONG},
#line 233
  {(ustring)"nextval", KEYWORD_STRONG},
#line 233
  {(ustring)"noaudit", KEYWORD_STRONG},
#line 233
  {(ustring)"nocompress", KEYWORD_STRONG},
#line 233
  {(ustring)"not", KEYWORD_STRONG},
#line 233
  {(ustring)"nowait", KEYWORD_STRONG},
#line 233
  {(ustring)"null", KEYWORD_STRONG},
#line 233
  {(ustring)"number", KEYWORD_STRONG},
#line 233
  {(ustring)"number_base", KEYWORD_STRONG},
#line 233
  {(ustring)"of", KEYWORD_STRONG},
#line 233
  {(ustring)"offline", KEYWORD_STRONG},
#line 233
  {(ustring)"on", KEYWORD_STRONG},
#line 233
  {(ustring)"online", KEYWORD_STRONG},
#line 233
  {(ustring)"open", KEYWORD_STRONG},
#line 233
  {(ustring)"option", KEYWORD_STRONG},
#line 233
  {(ustring)"or", KEYWORD_STRONG},
#line 233
  {(ustring)"order", KEYWORD_STRONG},
#line 233
  {(ustring)"others", KEYWORD_STRONG},
#line 233
  {(ustring)"out", KEYWORD_STRONG},
#line 233
  {(ustring)"package", KEYWORD_STRONG},
#line 233
  {(ustring)"partition", KEYWORD_STRONG},
#line 233
  {(ustring)"pctfree", KEYWORD_STRONG},
#line 233
  {(ustring)"pls_integer", KEYWORD_STRONG},
#line 233
  {(ustring)"positive", KEYWORD_STRONG},
#line 233
  {(ustring)"positiven", KEYWORD_STRONG},
#line 233
  {(ustring)"pragma", KEYWORD_STRONG},
#line 233
  {(ustring)"prior", KEYWORD_STRONG},
#line 233
  {(ustring)"private", KEYWORD_STRONG},
#line 233
  {(ustring)"privileges", KEYWORD_STRONG},
#line 233
  {(ustring)"procedure", KEYWORD_STRONG},
#line 233
  {(ustring)"public", KEYWORD_STRONG},
#line 233
  {(ustring)"raise", KEYWORD_STRONG},
#line 233
  {(ustring)"range", KEYWORD_STRONG},
#line 233
  {(ustring)"raw", KEYWORD_STRONG},
#line 233
  {(ustring)"real", KEYWORD_STRONG},
#line 233
  {(ustring)"record", KEYWORD_STRONG},
#line 233
  {(ustring)"ref", KEYWORD_STRONG},
#line 233
  {(ustring)"release", KEYWORD_STRONG},
#line 233
  {(ustring)"remr", KEYWORD_STRONG},
#line 233
  {(ustring)"rename", KEYWORD_STRONG},
#line 233
  {(ustring)"resource", KEYWORD_STRONG},
#line 233
  {(ustring)"return", KEYWORD_STRONG},
#line 233
  {(ustring)"reverse", KEYWORD_STRONG},
#line 233
  {(ustring)"revoke", KEYWORD_STRONG},
#line 233
  {(ustring)"rollback", KEYWORD_STRONG},
#line 233
  {(ustring)"row", KEYWORD_STRONG},
#line 233
  {(ustring)"rowid", KEYWORD_STRONG},
#line 233
  {(ustring)"rowlabel", KEYWORD_STRONG},
#line 233
  {(ustring)"rownum", KEYWORD_STRONG},
#line 233
  {(ustring)"rows", KEYWORD_STRONG},
#line 233
  {(ustring)"rowtype", KEYWORD_STRONG},
#line 233
  {(ustring)"run", KEYWORD_STRONG},
#line 233
  {(ustring)"savepoint", KEYWORD_STRONG},
#line 233
  {(ustring)"schema", KEYWORD_STRONG},
#line 233
  {(ustring)"select", KEYWORD_STRONG},
#line 233
  {(ustring)"separate", KEYWORD_STRONG},
#line 233
  {(ustring)"session", KEYWORD_STRONG},
#line 233
  {(ustring)"set", KEYWORD_STRONG},
#line 233
  {(ustring)"share", KEYWORD_STRONG},
#line 233
  {(ustring)"size", KEYWORD_STRONG},
#line 233
  {(ustring)"smallint", KEYWORD_STRONG},
#line 233
  {(ustring)"space", KEYWORD_STRONG},
#line 233
  {(ustring)"sql", KEYWORD_STRONG},
#line 233
  {(ustring)"sqlcode", KEYWORD_STRONG},
#line 233
  {(ustring)"sqlerrm", KEYWORD_STRONG},
#line 233
  {(ustring)"start", KEYWORD_STRONG},
#line 233
  {(ustring)"statement", KEYWORD_STRONG},
#line 233
  {(ustring)"stddev", KEYWORD_STRONG},
#line 233
  {(ustring)"subtype", KEYWORD_STRONG},
#line 233
  {(ustring)"successful", KEYWORD_STRONG},
#line 233
  {(ustring)"sum", KEYWORD_STRONG},
#line 233
  {(ustring)"synonym", KEYWORD_STRONG},
#line 233
  {(ustring)"sysdate", KEYWORD_STRONG},
#line 233
  {(ustring)"tabauth", KEYWORD_STRONG},
#line 233
  {(ustring)"table", KEYWORD_STRONG},
#line 233
  {(ustring)"tables", KEYWORD_STRONG},
#line 233
  {(ustring)"task", KEYWORD_STRONG},
#line 233
  {(ustring)"terminate", KEYWORD_STRONG},
#line 233
  {(ustring)"then", KEYWORD_STRONG},
#line 233
  {(ustring)"to", KEYWORD_STRONG},
#line 233
  {(ustring)"trigger", KEYWORD_STRONG},
#line 233
  {(ustring)"true", KEYWORD_STRONG},
#line 233
  {(ustring)"type", KEYWORD_STRONG},
#line 233
  {(ustring)"uid", KEYWORD_STRONG},
#line 233
  {(ustring)"union", KEYWORD_STRONG},
#line 233
  {(ustring)"unique", KEYWORD_STRONG},
#line 233
  {(ustring)"update", KEYWORD_STRONG},
#line 233
  {(ustring)"use", KEYWORD_STRONG},
#line 233
  {(ustring)"user", KEYWORD_STRONG},
#line 233
  {(ustring)"validate", KEYWORD_STRONG},
#line 233
  {(ustring)"values", KEYWORD_STRONG},
#line 233
  {(ustring)"varchar", KEYWORD_STRONG},
#line 233
  {(ustring)"varchar2", KEYWORD_STRONG},
#line 233
  {(ustring)"variance", KEYWORD_STRONG},
#line 233
  {(ustring)"view", KEYWORD_STRONG},
#line 233
  {(ustring)"views", KEYWORD_STRONG},
#line 233
  {(ustring)"when", KEYWORD_STRONG},
#line 233
  {(ustring)"whenever", KEYWORD_STRONG},
#line 233
  {(ustring)"where", KEYWORD_STRONG},
#line 233
  {(ustring)"while", KEYWORD_STRONG},
#line 233
  {(ustring)"with", KEYWORD_STRONG},
#line 233
  {(ustring)"work", KEYWORD_STRONG},
#line 233
  {(ustring)"write", KEYWORD_STRONG},
#line 233
  {(ustring)"xor", KEYWORD_STRONG},
#line 233

   ENDKEYWORD
};

const char * plsql_abbreviations[]= {
  "pks", "pkb", "\0"
};

const uchar  plsql_description[] = "\
a2ps-plsql Pretty Printer Version 1.0.0 beta - 18-MAR-97\
This style is to be checked.\n\
Please report changes needed to Pierre Mareschal <pmaresch@be.oracle.com>";

#define plsql_style_def { plsql_style, "plsql",				\
  plsql_abbreviations, plsql_description, 				\
  CASE_SENSITIVE, sql_characters, sql_characters, plsql_keywords,	\
  NOSYMBOL, NOSYMBOL, sql_sequences, sh_verbatims, EMPTY }



/************************************************************
 * 4. Oracle SQL, Oracle PL/SQL (v. 2.3), and SQL*Plus keywords
 *    ---------------------------------------------------------
 */
const keyword oracle_keywords [] = {
   {(ustring)"abort", KEYWORD_STRONG},
#line 307
  {(ustring)"accept", KEYWORD_STRONG},
#line 307
  {(ustring)"access", KEYWORD_STRONG},
#line 307
  {(ustring)"add", KEYWORD_STRONG},
#line 307
  {(ustring)"admin", KEYWORD_STRONG},
#line 307
  {(ustring)"after", KEYWORD_STRONG},
#line 307
  {(ustring)"all", KEYWORD_STRONG},
#line 307
  {(ustring)"allocate", KEYWORD_STRONG},
#line 307
  {(ustring)"alter", KEYWORD_STRONG},
#line 307
  {(ustring)"analyze", KEYWORD_STRONG},
#line 307
  {(ustring)"and", KEYWORD_STRONG},
#line 307
  {(ustring)"any", KEYWORD_STRONG},
#line 307
  {(ustring)"archive", KEYWORD_STRONG},
#line 307
  {(ustring)"archivelog", KEYWORD_STRONG},
#line 307
  {(ustring)"array", KEYWORD_STRONG},
#line 307
  {(ustring)"arraylen", KEYWORD_STRONG},
#line 307
  {(ustring)"as", KEYWORD_STRONG},
#line 307
  {(ustring)"asc", KEYWORD_STRONG},
#line 307
  {(ustring)"assert", KEYWORD_STRONG},
#line 307
  {(ustring)"assign", KEYWORD_STRONG},
#line 307
  {(ustring)"at", KEYWORD_STRONG},
#line 307
  {(ustring)"audit", KEYWORD_STRONG},
#line 307
  {(ustring)"authorization", KEYWORD_STRONG},
#line 307
  {(ustring)"avg", KEYWORD_STRONG},
#line 307
  {(ustring)"backup", KEYWORD_STRONG},
#line 307
  {(ustring)"base_table", KEYWORD_STRONG},
#line 307
  {(ustring)"become", KEYWORD_STRONG},
#line 307
  {(ustring)"before", KEYWORD_STRONG},
#line 307
  {(ustring)"begin", KEYWORD_STRONG},
#line 307
  {(ustring)"between", KEYWORD_STRONG},
#line 307
  {(ustring)"binary_integer", KEYWORD_STRONG},
#line 307
  {(ustring)"block", KEYWORD_STRONG},
#line 307
  {(ustring)"body", KEYWORD_STRONG},
#line 307
  {(ustring)"boolean", KEYWORD_STRONG},
#line 307
  {(ustring)"by", KEYWORD_STRONG},
#line 307
  {(ustring)"cache", KEYWORD_STRONG},
#line 307
  {(ustring)"cancel", KEYWORD_STRONG},
#line 307
  {(ustring)"cascade", KEYWORD_STRONG},
#line 307
  {(ustring)"case", KEYWORD_STRONG},
#line 307
  {(ustring)"change", KEYWORD_STRONG},
#line 307
  {(ustring)"char", KEYWORD_STRONG},
#line 307
  {(ustring)"char_base", KEYWORD_STRONG},
#line 307
  {(ustring)"character", KEYWORD_STRONG},
#line 307
  {(ustring)"check", KEYWORD_STRONG},
#line 307
  {(ustring)"checkpoint", KEYWORD_STRONG},
#line 307
  {(ustring)"close", KEYWORD_STRONG},
#line 307
  {(ustring)"cluster", KEYWORD_STRONG},
#line 307
  {(ustring)"clusters", KEYWORD_STRONG},
#line 307
  {(ustring)"cobol", KEYWORD_STRONG},
#line 307
  {(ustring)"colauth", KEYWORD_STRONG},
#line 307
  {(ustring)"column", KEYWORD_STRONG},
#line 307
  {(ustring)"columns", KEYWORD_STRONG},
#line 307
  {(ustring)"comment", KEYWORD_STRONG},
#line 307
  {(ustring)"commit", KEYWORD_STRONG},
#line 307
  {(ustring)"compile", KEYWORD_STRONG},
#line 307
  {(ustring)"compress", KEYWORD_STRONG},
#line 307
  {(ustring)"connect", KEYWORD_STRONG},
#line 307
  {(ustring)"constant", KEYWORD_STRONG},
#line 307
  {(ustring)"constraint", KEYWORD_STRONG},
#line 307
  {(ustring)"constraints", KEYWORD_STRONG},
#line 307
  {(ustring)"contents", KEYWORD_STRONG},
#line 307
  {(ustring)"continue", KEYWORD_STRONG},
#line 307
  {(ustring)"controlfile", KEYWORD_STRONG},
#line 307
  {(ustring)"count", KEYWORD_STRONG},
#line 307
  {(ustring)"crash", KEYWORD_STRONG},
#line 307
  {(ustring)"create", KEYWORD_STRONG},
#line 307
  {(ustring)"current", KEYWORD_STRONG},
#line 307
  {(ustring)"currval", KEYWORD_STRONG},
#line 307
  {(ustring)"cursor", KEYWORD_STRONG},
#line 307
  {(ustring)"cycle", KEYWORD_STRONG},
#line 307
  {(ustring)"data_base", KEYWORD_STRONG},
#line 307
  {(ustring)"database", KEYWORD_STRONG},
#line 307
  {(ustring)"datafile", KEYWORD_STRONG},
#line 307
  {(ustring)"date", KEYWORD_STRONG},
#line 307
  {(ustring)"dba", KEYWORD_STRONG},
#line 307
  {(ustring)"debugoff", KEYWORD_STRONG},
#line 307
  {(ustring)"debugon", KEYWORD_STRONG},
#line 307
  {(ustring)"dec", KEYWORD_STRONG},
#line 307
  {(ustring)"decimal", KEYWORD_STRONG},
#line 307
  {(ustring)"declare", KEYWORD_STRONG},
#line 307
  {(ustring)"default", KEYWORD_STRONG},
#line 307
  {(ustring)"definition", KEYWORD_STRONG},
#line 307
  {(ustring)"delay", KEYWORD_STRONG},
#line 307
  {(ustring)"delete", KEYWORD_STRONG},
#line 307
  {(ustring)"delta", KEYWORD_STRONG},
#line 307
  {(ustring)"desc", KEYWORD_STRONG},
#line 307
  {(ustring)"digits", KEYWORD_STRONG},
#line 307
  {(ustring)"disable", KEYWORD_STRONG},
#line 307
  {(ustring)"dismount", KEYWORD_STRONG},
#line 307
  {(ustring)"dispose", KEYWORD_STRONG},
#line 307
  {(ustring)"distinct", KEYWORD_STRONG},
#line 307
  {(ustring)"do", KEYWORD_STRONG},
#line 307
  {(ustring)"double", KEYWORD_STRONG},
#line 307
  {(ustring)"drop", KEYWORD_STRONG},
#line 307
  {(ustring)"dump", KEYWORD_STRONG},
#line 307
  {(ustring)"each", KEYWORD_STRONG},
#line 307
  {(ustring)"else", KEYWORD_STRONG},
#line 307
  {(ustring)"elsif", KEYWORD_STRONG},
#line 307
  {(ustring)"enable", KEYWORD_STRONG},
#line 307
  {(ustring)"end", KEYWORD_STRONG},
#line 307
  {(ustring)"entry", KEYWORD_STRONG},
#line 307
  {(ustring)"escape", KEYWORD_STRONG},
#line 307
  {(ustring)"events", KEYWORD_STRONG},
#line 307
  {(ustring)"except", KEYWORD_STRONG},
#line 307
  {(ustring)"exception", KEYWORD_STRONG},
#line 307
  {(ustring)"exception_init", KEYWORD_STRONG},
#line 307
  {(ustring)"exceptions", KEYWORD_STRONG},
#line 307
  {(ustring)"exclusive", KEYWORD_STRONG},
#line 307
  {(ustring)"exec", KEYWORD_STRONG},
#line 307
  {(ustring)"execute", KEYWORD_STRONG},
#line 307
  {(ustring)"exists", KEYWORD_STRONG},
#line 307
  {(ustring)"exit", KEYWORD_STRONG},
#line 307
  {(ustring)"explain", KEYWORD_STRONG},
#line 307
  {(ustring)"extent", KEYWORD_STRONG},
#line 307
  {(ustring)"externally", KEYWORD_STRONG},
#line 307
  {(ustring)"false", KEYWORD_STRONG},
#line 307
  {(ustring)"fetch", KEYWORD_STRONG},
#line 307
  {(ustring)"file", KEYWORD_STRONG},
#line 307
  {(ustring)"float", KEYWORD_STRONG},
#line 307
  {(ustring)"flush", KEYWORD_STRONG},
#line 307
  {(ustring)"for", KEYWORD_STRONG},
#line 307
  {(ustring)"force", KEYWORD_STRONG},
#line 307
  {(ustring)"foreign", KEYWORD_STRONG},
#line 307
  {(ustring)"form", KEYWORD_STRONG},
#line 307
  {(ustring)"fortran", KEYWORD_STRONG},
#line 307
  {(ustring)"found", KEYWORD_STRONG},
#line 307
  {(ustring)"freelist", KEYWORD_STRONG},
#line 307
  {(ustring)"freelists", KEYWORD_STRONG},
#line 307
  {(ustring)"from", KEYWORD_STRONG},
#line 307
  {(ustring)"function", KEYWORD_STRONG},
#line 307
  {(ustring)"generic", KEYWORD_STRONG},
#line 307
  {(ustring)"go", KEYWORD_STRONG},
#line 307
  {(ustring)"goto", KEYWORD_STRONG},
#line 307
  {(ustring)"grant", KEYWORD_STRONG},
#line 307
  {(ustring)"group", KEYWORD_STRONG},
#line 307
  {(ustring)"groups", KEYWORD_STRONG},
#line 307
  {(ustring)"having", KEYWORD_STRONG},
#line 307
  {(ustring)"identified", KEYWORD_STRONG},
#line 307
  {(ustring)"if", KEYWORD_STRONG},
#line 307
  {(ustring)"immediate", KEYWORD_STRONG},
#line 307
  {(ustring)"in", KEYWORD_STRONG},
#line 307
  {(ustring)"including", KEYWORD_STRONG},
#line 307
  {(ustring)"increment", KEYWORD_STRONG},
#line 307
  {(ustring)"index", KEYWORD_STRONG},
#line 307
  {(ustring)"indexes", KEYWORD_STRONG},
#line 307
  {(ustring)"indicator", KEYWORD_STRONG},
#line 307
  {(ustring)"initial", KEYWORD_STRONG},
#line 307
  {(ustring)"initrans", KEYWORD_STRONG},
#line 307
  {(ustring)"insert", KEYWORD_STRONG},
#line 307
  {(ustring)"instance", KEYWORD_STRONG},
#line 307
  {(ustring)"int", KEYWORD_STRONG},
#line 307
  {(ustring)"integer", KEYWORD_STRONG},
#line 307
  {(ustring)"interface", KEYWORD_STRONG},
#line 307
  {(ustring)"intersect", KEYWORD_STRONG},
#line 307
  {(ustring)"into", KEYWORD_STRONG},
#line 307
  {(ustring)"is", KEYWORD_STRONG},
#line 307
  {(ustring)"key", KEYWORD_STRONG},
#line 307
  {(ustring)"language", KEYWORD_STRONG},
#line 307
  {(ustring)"layer", KEYWORD_STRONG},
#line 307
  {(ustring)"level", KEYWORD_STRONG},
#line 307
  {(ustring)"like", KEYWORD_STRONG},
#line 307
  {(ustring)"limited", KEYWORD_STRONG},
#line 307
  {(ustring)"link", KEYWORD_STRONG},
#line 307
  {(ustring)"lists", KEYWORD_STRONG},
#line 307
  {(ustring)"lock", KEYWORD_STRONG},
#line 307
  {(ustring)"logfile", KEYWORD_STRONG},
#line 307
  {(ustring)"long", KEYWORD_STRONG},
#line 307
  {(ustring)"loop", KEYWORD_STRONG},
#line 307
  {(ustring)"manage", KEYWORD_STRONG},
#line 307
  {(ustring)"manual", KEYWORD_STRONG},
#line 307
  {(ustring)"max", KEYWORD_STRONG},
#line 307
  {(ustring)"maxdatafiles", KEYWORD_STRONG},
#line 307
  {(ustring)"maxextents", KEYWORD_STRONG},
#line 307
  {(ustring)"maxinstances", KEYWORD_STRONG},
#line 307
  {(ustring)"maxlogfiles", KEYWORD_STRONG},
#line 307
  {(ustring)"maxloghistory", KEYWORD_STRONG},
#line 307
  {(ustring)"maxlogmembers", KEYWORD_STRONG},
#line 307
  {(ustring)"maxtrans", KEYWORD_STRONG},
#line 307
  {(ustring)"maxvalue", KEYWORD_STRONG},
#line 307
  {(ustring)"min", KEYWORD_STRONG},
#line 307
  {(ustring)"minextents", KEYWORD_STRONG},
#line 307
  {(ustring)"minus", KEYWORD_STRONG},
#line 307
  {(ustring)"minvalue", KEYWORD_STRONG},
#line 307
  {(ustring)"mlslabel", KEYWORD_STRONG},
#line 307
  {(ustring)"mod", KEYWORD_STRONG},
#line 307
  {(ustring)"mode", KEYWORD_STRONG},
#line 307
  {(ustring)"modify", KEYWORD_STRONG},
#line 307
  {(ustring)"module", KEYWORD_STRONG},
#line 307
  {(ustring)"mount", KEYWORD_STRONG},
#line 307
  {(ustring)"natural", KEYWORD_STRONG},
#line 307
  {(ustring)"naturaln", KEYWORD_STRONG},
#line 307
  {(ustring)"new", KEYWORD_STRONG},
#line 307
  {(ustring)"next", KEYWORD_STRONG},
#line 307
  {(ustring)"nextval", KEYWORD_STRONG},
#line 307
  {(ustring)"noarchivelog", KEYWORD_STRONG},
#line 307
  {(ustring)"noaudit", KEYWORD_STRONG},
#line 307
  {(ustring)"nocache", KEYWORD_STRONG},
#line 307
  {(ustring)"nocompress", KEYWORD_STRONG},
#line 307
  {(ustring)"nocycle", KEYWORD_STRONG},
#line 307
  {(ustring)"nomaxvalue", KEYWORD_STRONG},
#line 307
  {(ustring)"nominvalue", KEYWORD_STRONG},
#line 307
  {(ustring)"none", KEYWORD_STRONG},
#line 307
  {(ustring)"noorder", KEYWORD_STRONG},
#line 307
  {(ustring)"noresetlogs", KEYWORD_STRONG},
#line 307
  {(ustring)"normal", KEYWORD_STRONG},
#line 307
  {(ustring)"nosort", KEYWORD_STRONG},
#line 307
  {(ustring)"not", KEYWORD_STRONG},
#line 307
  {(ustring)"notfound", KEYWORD_STRONG},
#line 307
  {(ustring)"nowait", KEYWORD_STRONG},
#line 307
  {(ustring)"null", KEYWORD_STRONG},
#line 307
  {(ustring)"number", KEYWORD_STRONG},
#line 307
  {(ustring)"number_base", KEYWORD_STRONG},
#line 307
  {(ustring)"numeric", KEYWORD_STRONG},
#line 307
  {(ustring)"of", KEYWORD_STRONG},
#line 307
  {(ustring)"off", KEYWORD_STRONG},
#line 307
  {(ustring)"offline", KEYWORD_STRONG},
#line 307
  {(ustring)"old", KEYWORD_STRONG},
#line 307
  {(ustring)"on", KEYWORD_STRONG},
#line 307
  {(ustring)"online", KEYWORD_STRONG},
#line 307
  {(ustring)"only", KEYWORD_STRONG},
#line 307
  {(ustring)"open", KEYWORD_STRONG},
#line 307
  {(ustring)"optimal", KEYWORD_STRONG},
#line 307
  {(ustring)"option", KEYWORD_STRONG},
#line 307
  {(ustring)"or", KEYWORD_STRONG},
#line 307
  {(ustring)"order", KEYWORD_STRONG},
#line 307
  {(ustring)"others", KEYWORD_STRONG},
#line 307
  {(ustring)"out", KEYWORD_STRONG},
#line 307
  {(ustring)"own", KEYWORD_STRONG},
#line 307
  {(ustring)"package", KEYWORD_STRONG},
#line 307
  {(ustring)"parallel", KEYWORD_STRONG},
#line 307
  {(ustring)"partition", KEYWORD_STRONG},
#line 307
  {(ustring)"pctfree", KEYWORD_STRONG},
#line 307
  {(ustring)"pctincrease", KEYWORD_STRONG},
#line 307
  {(ustring)"pctused", KEYWORD_STRONG},
#line 307
  {(ustring)"plan", KEYWORD_STRONG},
#line 307
  {(ustring)"pli", KEYWORD_STRONG},
#line 307
  {(ustring)"pls_integer", KEYWORD_STRONG},
#line 307
  {(ustring)"positive", KEYWORD_STRONG},
#line 307
  {(ustring)"positiven", KEYWORD_STRONG},
#line 307
  {(ustring)"pragma", KEYWORD_STRONG},
#line 307
  {(ustring)"precision", KEYWORD_STRONG},
#line 307
  {(ustring)"primary", KEYWORD_STRONG},
#line 307
  {(ustring)"prior", KEYWORD_STRONG},
#line 307
  {(ustring)"private", KEYWORD_STRONG},
#line 307
  {(ustring)"privileges", KEYWORD_STRONG},
#line 307
  {(ustring)"procedure", KEYWORD_STRONG},
#line 307
  {(ustring)"profile", KEYWORD_STRONG},
#line 307
  {(ustring)"public", KEYWORD_STRONG},
#line 307
  {(ustring)"quota", KEYWORD_STRONG},
#line 307
  {(ustring)"raise", KEYWORD_STRONG},
#line 307
  {(ustring)"range", KEYWORD_STRONG},
#line 307
  {(ustring)"raw", KEYWORD_STRONG},
#line 307
  {(ustring)"read", KEYWORD_STRONG},
#line 307
  {(ustring)"real", KEYWORD_STRONG},
#line 307
  {(ustring)"record", KEYWORD_STRONG},
#line 307
  {(ustring)"recover", KEYWORD_STRONG},
#line 307
  {(ustring)"ref", KEYWORD_STRONG},
#line 307
  {(ustring)"references", KEYWORD_STRONG},
#line 307
  {(ustring)"referencing", KEYWORD_STRONG},
#line 307
  {(ustring)"release", KEYWORD_STRONG},
#line 307
  {(ustring)"remr", KEYWORD_STRONG},
#line 307
  {(ustring)"rename", KEYWORD_STRONG},
#line 307
  {(ustring)"resetlogs", KEYWORD_STRONG},
#line 307
  {(ustring)"resource", KEYWORD_STRONG},
#line 307
  {(ustring)"restricted", KEYWORD_STRONG},
#line 307
  {(ustring)"return", KEYWORD_STRONG},
#line 307
  {(ustring)"reuse", KEYWORD_STRONG},
#line 307
  {(ustring)"reverse", KEYWORD_STRONG},
#line 307
  {(ustring)"revoke", KEYWORD_STRONG},
#line 307
  {(ustring)"role", KEYWORD_STRONG},
#line 307
  {(ustring)"roles", KEYWORD_STRONG},
#line 307
  {(ustring)"rollback", KEYWORD_STRONG},
#line 307
  {(ustring)"row", KEYWORD_STRONG},
#line 307
  {(ustring)"rowid", KEYWORD_STRONG},
#line 307
  {(ustring)"rowlabel", KEYWORD_STRONG},
#line 307
  {(ustring)"rownum", KEYWORD_STRONG},
#line 307
  {(ustring)"rows", KEYWORD_STRONG},
#line 307
  {(ustring)"rowtype", KEYWORD_STRONG},
#line 307
  {(ustring)"run", KEYWORD_STRONG},
#line 307
  {(ustring)"savepoint", KEYWORD_STRONG},
#line 307
  {(ustring)"schema", KEYWORD_STRONG},
#line 307
  {(ustring)"scn", KEYWORD_STRONG},
#line 307
  {(ustring)"section", KEYWORD_STRONG},
#line 307
  {(ustring)"segment", KEYWORD_STRONG},
#line 307
  {(ustring)"select", KEYWORD_STRONG},
#line 307
  {(ustring)"separate", KEYWORD_STRONG},
#line 307
  {(ustring)"sequence", KEYWORD_STRONG},
#line 307
  {(ustring)"session", KEYWORD_STRONG},
#line 307
  {(ustring)"set", KEYWORD_STRONG},
#line 307
  {(ustring)"share", KEYWORD_STRONG},
#line 307
  {(ustring)"shared", KEYWORD_STRONG},
#line 307
  {(ustring)"size", KEYWORD_STRONG},
#line 307
  {(ustring)"smallint", KEYWORD_STRONG},
#line 307
  {(ustring)"snapshot", KEYWORD_STRONG},
#line 307
  {(ustring)"some", KEYWORD_STRONG},
#line 307
  {(ustring)"sort", KEYWORD_STRONG},
#line 307
  {(ustring)"space", KEYWORD_STRONG},
#line 307
  {(ustring)"sql", KEYWORD_STRONG},
#line 307
  {(ustring)"sqlbuf", KEYWORD_STRONG},
#line 307
  {(ustring)"sqlcode", KEYWORD_STRONG},
#line 307
  {(ustring)"sqlerrm", KEYWORD_STRONG},
#line 307
  {(ustring)"sqlerror", KEYWORD_STRONG},
#line 307
  {(ustring)"sqlstate", KEYWORD_STRONG},
#line 307
  {(ustring)"start", KEYWORD_STRONG},
#line 307
  {(ustring)"statement", KEYWORD_STRONG},
#line 307
  {(ustring)"statement_id", KEYWORD_STRONG},
#line 307
  {(ustring)"statistics", KEYWORD_STRONG},
#line 307
  {(ustring)"stddev", KEYWORD_STRONG},
#line 307
  {(ustring)"stop", KEYWORD_STRONG},
#line 307
  {(ustring)"storage", KEYWORD_STRONG},
#line 307
  {(ustring)"subtype", KEYWORD_STRONG},
#line 307
  {(ustring)"successful", KEYWORD_STRONG},
#line 307
  {(ustring)"sum", KEYWORD_STRONG},
#line 307
  {(ustring)"switch", KEYWORD_STRONG},
#line 307
  {(ustring)"synonym", KEYWORD_STRONG},
#line 307
  {(ustring)"sysdate", KEYWORD_STRONG},
#line 307
  {(ustring)"system", KEYWORD_STRONG},
#line 307
  {(ustring)"tabauth", KEYWORD_STRONG},
#line 307
  {(ustring)"table", KEYWORD_STRONG},
#line 307
  {(ustring)"tables", KEYWORD_STRONG},
#line 307
  {(ustring)"tablespace", KEYWORD_STRONG},
#line 307
  {(ustring)"task", KEYWORD_STRONG},
#line 307
  {(ustring)"temporary", KEYWORD_STRONG},
#line 307
  {(ustring)"terminate", KEYWORD_STRONG},
#line 307
  {(ustring)"then", KEYWORD_STRONG},
#line 307
  {(ustring)"thread", KEYWORD_STRONG},
#line 307
  {(ustring)"time", KEYWORD_STRONG},
#line 307
  {(ustring)"to", KEYWORD_STRONG},
#line 307
  {(ustring)"tracing", KEYWORD_STRONG},
#line 307
  {(ustring)"transaction", KEYWORD_STRONG},
#line 307
  {(ustring)"trigger", KEYWORD_STRONG},
#line 307
  {(ustring)"triggers", KEYWORD_STRONG},
#line 307
  {(ustring)"true", KEYWORD_STRONG},
#line 307
  {(ustring)"truncate", KEYWORD_STRONG},
#line 307
  {(ustring)"type", KEYWORD_STRONG},
#line 307
  {(ustring)"uid", KEYWORD_STRONG},
#line 307
  {(ustring)"under", KEYWORD_STRONG},
#line 307
  {(ustring)"union", KEYWORD_STRONG},
#line 307
  {(ustring)"unique", KEYWORD_STRONG},
#line 307
  {(ustring)"unlimited", KEYWORD_STRONG},
#line 307
  {(ustring)"until", KEYWORD_STRONG},
#line 307
  {(ustring)"update", KEYWORD_STRONG},
#line 307
  {(ustring)"use", KEYWORD_STRONG},
#line 307
  {(ustring)"user", KEYWORD_STRONG},
#line 307
  {(ustring)"using", KEYWORD_STRONG},
#line 307
  {(ustring)"validate", KEYWORD_STRONG},
#line 307
  {(ustring)"values", KEYWORD_STRONG},
#line 307
  {(ustring)"varchar", KEYWORD_STRONG},
#line 307
  {(ustring)"varchar2", KEYWORD_STRONG},
#line 307
  {(ustring)"variance", KEYWORD_STRONG},
#line 307
  {(ustring)"view", KEYWORD_STRONG},
#line 307
  {(ustring)"views", KEYWORD_STRONG},
#line 307
  {(ustring)"when", KEYWORD_STRONG},
#line 307
  {(ustring)"whenever", KEYWORD_STRONG},
#line 307
  {(ustring)"where", KEYWORD_STRONG},
#line 307
  {(ustring)"while", KEYWORD_STRONG},
#line 307
  {(ustring)"with", KEYWORD_STRONG},
#line 307
  {(ustring)"work", KEYWORD_STRONG},
#line 307
  {(ustring)"write", KEYWORD_STRONG},
#line 307
  {(ustring)"xor", KEYWORD_STRONG},
#line 307

   ENDKEYWORD
};

const char * oracle_abbreviations[]= {
  "\0"
};

const uchar oracle_description[] = "\
a2ps-oracle Pretty Printer Version 1.0.0 beta - 18-MAR-97\
For comments, support for -- /*..*/ and //.\n\
This style is to be checked.\n\
Please report changes needed to Pierre Mareschal <pmaresch@be.oracle.com>";

#define oracle_style_def { oracle_style, "oracle",			\
  oracle_abbreviations, oracle_description, 				\
  CASE_SENSITIVE, sql_characters, sql_characters, oracle_keywords,	\
  NOSYMBOL, NOSYMBOL, sql_sequences, sh_verbatims, EMPTY }


/************************************************************
 * 5. Oracle Server Parameter File
 *    ----------------------------
 */
const sequence initora_sequences [] = {
  {(ustring)"#", COMMENT, COMMENT, (ustring)"$", COMMENT},
  /* Literals         */
  {(ustring)"\"", PLAIN, STRING, (ustring)"\"", PLAIN},
  {(ustring)"\'", PLAIN, STRING, (ustring)"\'", PLAIN},
  ENDSEQUENCE
};
const uchar initora_characters [] = {
  'A', 'Z',
  'a', 'z',
  '_', '_',
  '\0'
};

const keyword initora_keywords [] = {
   {(ustring)"always_anti_join", KEYWORD_STRONG},
#line 408
  {(ustring)"audit_trail", KEYWORD_STRONG},
#line 408
  {(ustring)"background_dump_dest", KEYWORD_STRONG},
#line 408
  {(ustring)"bitmap_merge_area_size", KEYWORD_STRONG},
#line 408
  {(ustring)"blank_trimming", KEYWORD_STRONG},
#line 408
  {(ustring)"cache_size_threshold", KEYWORD_STRONG},
#line 408
  {(ustring)"checkpoint_process", KEYWORD_STRONG},
#line 408
  {(ustring)"cleanup_rollback_entries", KEYWORD_STRONG},
#line 408
  {(ustring)"close_cached_open_cursors", KEYWORD_STRONG},
#line 408
  {(ustring)"commit_point_strength", KEYWORD_STRONG},
#line 408
  {(ustring)"compatible", KEYWORD_STRONG},
#line 408
  {(ustring)"compatible_no_recovery", KEYWORD_STRONG},
#line 408
  {(ustring)"control_files", KEYWORD_STRONG},
#line 408
  {(ustring)"cpu_count", KEYWORD_STRONG},
#line 408
  {(ustring)"create_bitmap_area_size", KEYWORD_STRONG},
#line 408
  {(ustring)"cursor_space_for_time", KEYWORD_STRONG},
#line 408
  {(ustring)"db_block_buffers", KEYWORD_STRONG},
#line 408
  {(ustring)"db_block_checkpoint_batch", KEYWORD_STRONG},
#line 408
  {(ustring)"db_block_checksum", KEYWORD_STRONG},
#line 408
  {(ustring)"db_block_lru_extended_statistics", KEYWORD_STRONG},
#line 408
  {(ustring)"db_block_lru_latches", KEYWORD_STRONG},
#line 408
  {(ustring)"db_block_lru_statistics", KEYWORD_STRONG},
#line 408
  {(ustring)"db_block_size", KEYWORD_STRONG},
#line 408
  {(ustring)"db_domain", KEYWORD_STRONG},
#line 408
  {(ustring)"db_file_multiblock_read_count", KEYWORD_STRONG},
#line 408
  {(ustring)"db_file_simultaneous_writes", KEYWORD_STRONG},
#line 408
  {(ustring)"db_file_standby_name_convert", KEYWORD_STRONG},
#line 408
  {(ustring)"db_files", KEYWORD_STRONG},
#line 408
  {(ustring)"db_name", KEYWORD_STRONG},
#line 408
  {(ustring)"dblink_encrypt_login", KEYWORD_STRONG},
#line 408
  {(ustring)"delayed_logging_block_cleanouts", KEYWORD_STRONG},
#line 408
  {(ustring)"discrete_transactions_enabled", KEYWORD_STRONG},
#line 408
  {(ustring)"distributed_lock_timeout", KEYWORD_STRONG},
#line 408
  {(ustring)"distributed_recovery_connection_hold_time", KEYWORD_STRONG},
#line 408
  {(ustring)"distributed_transactions", KEYWORD_STRONG},
#line 408
  {(ustring)"dml_locks", KEYWORD_STRONG},
#line 408
  {(ustring)"enqueue_resources", KEYWORD_STRONG},
#line 408
  {(ustring)"event", KEYWORD_STRONG},
#line 408
  {(ustring)"fixed_date", KEYWORD_STRONG},
#line 408
  {(ustring)"gc_db_locks", KEYWORD_STRONG},
#line 408
  {(ustring)"gc_files_to_locks", KEYWORD_STRONG},
#line 408
  {(ustring)"gc_freelist_groups", KEYWORD_STRONG},
#line 408
  {(ustring)"gc_lck_procs", KEYWORD_STRONG},
#line 408
  {(ustring)"gc_releasable_locks", KEYWORD_STRONG},
#line 408
  {(ustring)"gc_rollback_locks", KEYWORD_STRONG},
#line 408
  {(ustring)"gc_rollback_segments", KEYWORD_STRONG},
#line 408
  {(ustring)"gc_save_rollback_locks", KEYWORD_STRONG},
#line 408
  {(ustring)"gc_segments", KEYWORD_STRONG},
#line 408
  {(ustring)"gc_tablespaces", KEYWORD_STRONG},
#line 408
  {(ustring)"global_names", KEYWORD_STRONG},
#line 408
  {(ustring)"hash_area_size", KEYWORD_STRONG},
#line 408
  {(ustring)"hash_join_enabled", KEYWORD_STRONG},
#line 408
  {(ustring)"hash_multiblock_io_count", KEYWORD_STRONG},
#line 408
  {(ustring)"ifile", KEYWORD_STRONG},
#line 408
  {(ustring)"instance_number", KEYWORD_STRONG},
#line 408
  {(ustring)"job_queue_interval", KEYWORD_STRONG},
#line 408
  {(ustring)"job_queue_keep_connections", KEYWORD_STRONG},
#line 408
  {(ustring)"job_queue_processes", KEYWORD_STRONG},
#line 408
  {(ustring)"license_max_sessions", KEYWORD_STRONG},
#line 408
  {(ustring)"license_max_users", KEYWORD_STRONG},
#line 408
  {(ustring)"license_sessions_warning", KEYWORD_STRONG},
#line 408
  {(ustring)"log_archive_buffer_size", KEYWORD_STRONG},
#line 408
  {(ustring)"log_archive_buffers", KEYWORD_STRONG},
#line 408
  {(ustring)"log_archive_dest", KEYWORD_STRONG},
#line 408
  {(ustring)"log_archive_format", KEYWORD_STRONG},
#line 408
  {(ustring)"log_archive_start", KEYWORD_STRONG},
#line 408
  {(ustring)"log_block_checksum", KEYWORD_STRONG},
#line 408
  {(ustring)"log_buffer", KEYWORD_STRONG},
#line 408
  {(ustring)"log_checkpoint_interval", KEYWORD_STRONG},
#line 408
  {(ustring)"log_checkpoint_timeout", KEYWORD_STRONG},
#line 408
  {(ustring)"log_checkpoints_to_alert", KEYWORD_STRONG},
#line 408
  {(ustring)"log_file_standby_name_convert", KEYWORD_STRONG},
#line 408
  {(ustring)"log_files", KEYWORD_STRONG},
#line 408
  {(ustring)"log_simultaneous_copies", KEYWORD_STRONG},
#line 408
  {(ustring)"log_small_entry_max_size", KEYWORD_STRONG},
#line 408
  {(ustring)"max_commit_propagation_delay", KEYWORD_STRONG},
#line 408
  {(ustring)"max_dump_file_size", KEYWORD_STRONG},
#line 408
  {(ustring)"max_enabled_roles", KEYWORD_STRONG},
#line 408
  {(ustring)"max_rollback_segments", KEYWORD_STRONG},
#line 408
  {(ustring)"max_transaction_branches", KEYWORD_STRONG},
#line 408
  {(ustring)"mts_dispatchers", KEYWORD_STRONG},
#line 408
  {(ustring)"mts_listener_address", KEYWORD_STRONG},
#line 408
  {(ustring)"mts_max_dispatchers", KEYWORD_STRONG},
#line 408
  {(ustring)"mts_max_servers", KEYWORD_STRONG},
#line 408
  {(ustring)"mts_multiple_listeners", KEYWORD_STRONG},
#line 408
  {(ustring)"mts_servers", KEYWORD_STRONG},
#line 408
  {(ustring)"mts_service", KEYWORD_STRONG},
#line 408
  {(ustring)"nls_currency", KEYWORD_STRONG},
#line 408
  {(ustring)"nls_date_format", KEYWORD_STRONG},
#line 408
  {(ustring)"nls_date_language", KEYWORD_STRONG},
#line 408
  {(ustring)"nls_iso_currency", KEYWORD_STRONG},
#line 408
  {(ustring)"nls_language", KEYWORD_STRONG},
#line 408
  {(ustring)"nls_numeric_characters", KEYWORD_STRONG},
#line 408
  {(ustring)"nls_sort", KEYWORD_STRONG},
#line 408
  {(ustring)"nls_territory", KEYWORD_STRONG},
#line 408
  {(ustring)"open_cursors", KEYWORD_STRONG},
#line 408
  {(ustring)"open_links", KEYWORD_STRONG},
#line 408
  {(ustring)"optimizer_mode", KEYWORD_STRONG},
#line 408
  {(ustring)"optimizer_percent_parallel", KEYWORD_STRONG},
#line 408
  {(ustring)"oracle_trace_collection_name", KEYWORD_STRONG},
#line 408
  {(ustring)"oracle_trace_collection_path", KEYWORD_STRONG},
#line 408
  {(ustring)"oracle_trace_collection_size", KEYWORD_STRONG},
#line 408
  {(ustring)"oracle_trace_enable", KEYWORD_STRONG},
#line 408
  {(ustring)"oracle_trace_facility_name", KEYWORD_STRONG},
#line 408
  {(ustring)"oracle_trace_facility_path", KEYWORD_STRONG},
#line 408
  {(ustring)"os_authent_prefix", KEYWORD_STRONG},
#line 408
  {(ustring)"os_roles", KEYWORD_STRONG},
#line 408
  {(ustring)"parallel_default_max_instances", KEYWORD_STRONG},
#line 408
  {(ustring)"parallel_max_servers", KEYWORD_STRONG},
#line 408
  {(ustring)"parallel_min_percent", KEYWORD_STRONG},
#line 408
  {(ustring)"parallel_min_servers", KEYWORD_STRONG},
#line 408
  {(ustring)"parallel_server_idle_time", KEYWORD_STRONG},
#line 408
  {(ustring)"partition_view_enabled", KEYWORD_STRONG},
#line 408
  {(ustring)"pre_page_sga", KEYWORD_STRONG},
#line 408
  {(ustring)"processes", KEYWORD_STRONG},
#line 408
  {(ustring)"recovery_parallelism", KEYWORD_STRONG},
#line 408
  {(ustring)"remote_dependencies_mode", KEYWORD_STRONG},
#line 408
  {(ustring)"remote_login_passwordfile", KEYWORD_STRONG},
#line 408
  {(ustring)"remote_os_authent", KEYWORD_STRONG},
#line 408
  {(ustring)"remote_os_roles", KEYWORD_STRONG},
#line 408
  {(ustring)"resource_limit", KEYWORD_STRONG},
#line 408
  {(ustring)"rollback_segments", KEYWORD_STRONG},
#line 408
  {(ustring)"row_cache_cursors", KEYWORD_STRONG},
#line 408
  {(ustring)"row_locking", KEYWORD_STRONG},
#line 408
  {(ustring)"sequence_cache_entries", KEYWORD_STRONG},
#line 408
  {(ustring)"sequence_cache_hash_buckets", KEYWORD_STRONG},
#line 408
  {(ustring)"serializable", KEYWORD_STRONG},
#line 408
  {(ustring)"session_cached_cursors", KEYWORD_STRONG},
#line 408
  {(ustring)"sessions", KEYWORD_STRONG},
#line 408
  {(ustring)"shared_pool_reserved_min_alloc", KEYWORD_STRONG},
#line 408
  {(ustring)"shared_pool_reserved_size", KEYWORD_STRONG},
#line 408
  {(ustring)"shared_pool_size", KEYWORD_STRONG},
#line 408
  {(ustring)"snapshot_refresh_interval", KEYWORD_STRONG},
#line 408
  {(ustring)"snapshot_refresh_keep_connections", KEYWORD_STRONG},
#line 408
  {(ustring)"snapshot_refresh_processes", KEYWORD_STRONG},
#line 408
  {(ustring)"sort_area_retained_size", KEYWORD_STRONG},
#line 408
  {(ustring)"sort_area_size", KEYWORD_STRONG},
#line 408
  {(ustring)"sort_direct_writes", KEYWORD_STRONG},
#line 408
  {(ustring)"sort_read_fac", KEYWORD_STRONG},
#line 408
  {(ustring)"sort_spacemap_size", KEYWORD_STRONG},
#line 408
  {(ustring)"sort_write_buffer_size", KEYWORD_STRONG},
#line 408
  {(ustring)"sort_write_buffers", KEYWORD_STRONG},
#line 408
  {(ustring)"sql92_security", KEYWORD_STRONG},
#line 408
  {(ustring)"sql_trace", KEYWORD_STRONG},
#line 408
  {(ustring)"temporary_table_locks", KEYWORD_STRONG},
#line 408
  {(ustring)"text_enable", KEYWORD_STRONG},
#line 408
  {(ustring)"thread", KEYWORD_STRONG},
#line 408
  {(ustring)"timed_statistics", KEYWORD_STRONG},
#line 408
  {(ustring)"transactions", KEYWORD_STRONG},
#line 408
  {(ustring)"transactions_per_rollback_segment", KEYWORD_STRONG},
#line 408
  {(ustring)"user_dump_dest", KEYWORD_STRONG},
#line 408
  {(ustring)"utl_file_dir", KEYWORD_STRONG},
#line 408

   ENDKEYWORD
};

const char * initora_abbreviations[]= {
  "ora", "\0"
};

const uchar initora_description[] = "\
a2ps-initora Pretty Printer Version 1.0.0 beta - 18-MAR-97\
This style is to be checked.\n\
Please report changes needed to Pierre Mareschal <pmaresch@be.oracle.com>";

#define initora_style_def { initora_style, "initora", 			\
  initora_abbreviations, initora_description, 				\
  CASE_INSENSITIVE, initora_characters, initora_characters, initora_keywords,\
  NOSYMBOL, NOSYMBOL, initora_sequences, sh_verbatims, EMPTY }


/************************************************************
 * 6. SQL3 Standard
 *    -------------
 */


/************************************************************
 * 7. Other Database Access Language (and specifics)
 *    ----------------------------------------------
 */

/************************************************************
 *	End of Database Access Languages
 ************************************************************/
#line 394 "styles.c.in"

/************************************************************************/
/*									*/
/* 		Definition of the struct for the styles			*/
/*									*/
/************************************************************************/

#line 405
struct style_sheets languages [] =
#line 405
{
#line 405
  ada_style_def,
#line 405
  c_style_def,
#line 405
  cpp_style_def,
#line 405
  caml_style_def,
#line 405
  claire_style_def,
#line 405
  coq_style_def,
#line 405
  clisp_style_def,
#line 405
  eiffel_style_def,
#line 405
  fortran_style_def,
#line 405
  initora_style_def,
#line 405
  java_style_def,
#line 405
  lace_style_def,
#line 405
  m68000_style_def,
#line 405
  mail_style_def,
#line 405
  modula3_style_def,
#line 405
  o2c_style_def,
#line 405
  oberon_style_def,
#line 405
  objc_style_def,
#line 405
  octave_style_def,
#line 405
  oracle_style_def,
#line 405
  pascal_style_def,
#line 405
  perl_style_def,
#line 405
  plsql_style_def,
#line 405
  postscript_style_def,
#line 405
  prescript_style_def,
#line 405
  prolog_style_def,
#line 405
  promela_style_def,
#line 405
  python_style_def,
#line 405
  sather_style_def,
#line 405
  scheme_style_def,
#line 405
  sdl_style_def,
#line 405
  sh_style_def,
#line 405
  sql_style_def,
#line 405
  sql92_style_def,
#line 405
  tcl_style_def,
#line 405
  tk_style_def,
#line 405
  unity_style_def,
#line 405
  verilog_style_def,
#line 405
  vhdl_style_def,
#line 405
  zsh_style_def
#line 405
};

int nbr_languages = sizeof(languages) / sizeof(languages[0]);
