% -*-postscript-*-
% PostScript Prologue for a2ps (Colored)
%
% $Id: color.pro,v 1.19.2.1 1997/04/30 10:38:10 demaille Exp $
%

%
% This file is part of a2ps.
% 
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2, or (at your option)
% any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; see the file COPYING.  If not, write to
% the Free Software Foundation, 59 Temple Place - Suite 330,
% Boston, MA 02111-1307, USA.
%

% -- code follows this line --
%%BeginResource: procset a2ps-color-prolog 2.0 1
%%DocumentProcessColors: Red Green Blue
%%IncludeResource: file base.ps

% Function title: prints page header.
% Overload to get colored title
% <ct> <rt> <lt> are passed as argument
/title { 
  % 1. Draw the background
  x v get y v get moveto
  0 setgray
  gsave
    0 th 2 div neg rmoveto 
    th setlinewidth
    0.5 0.5 1 setrgbcolor
    pw 0 rlineto stroke
  grestore
  % 2. Border it
  gsave
    0.7 setlinewidth
    pw 0 rlineto
    0 th neg rlineto
    pw neg 0 rlineto
    closepath stroke
  grestore
  % stk: ct rt lt
  x v get y v get th sub 1 add moveto
  df setfont
  % 3. The left title
  gsave
    dup stringwidth pop dfs add exch % leave space took on stack
    dfs hm rmoveto
    show                        % left title
  grestore
  exch
  % stk: ct ltw rt
  % 4. the right title
  gsave
    dup stringwidth pop dfs add exch % leave space took on stack
    dup
    pw exch stringwidth pop dfs add sub
    hm
    rmoveto
    show                        % right title
  grestore
  % stk: ct ltw rtw
  % 5. the center title
  gsave
    pw 3 1 roll
    % stk: ct pw ltw rtw
    3 copy 
    % Move to the center of the left room
    sub add 2 div hm rmoveto
    % What is the available space in here?
    add sub dfs sub dfs sub
    % stk: ct space_left
    fnf setfont
    1 1 1 setrgbcolor
    cfshow
  grestore
} bind def

%Face: Plain Courier
/p {
  0 0 0 FG
  false BG
  false UL
  false BX
  fc setfont
  Show
} bind def

%Face: Symbol Symbol
/sy {
  0 0 0 FG
  false BG
  fs setfont
  Show
} bind def

%Face: Keyword Courier
/k {
  false BG
  false UL
  false BX
  0 0 0.9 FG
  fc setfont
  Show
} bind def

%Face: Keyword_strong Courier-Bold
/K {
  false BG
  false UL
  false BX
  0 0 0.8 FG
  fcb setfont
  Show
} bind def

%Face: Comment Courier
/c {
  false BG
  false UL
  false BX
  0.8 0 0 FG
  fc setfont
  Show 
} bind def

%Face: Comment_strong Courier-Bold
/C {
  0 0 0 FG
  false BG
  false UL
  false BX
  fcb setfont
  Show 
} bind def

%Face: Label Courier
/l {
  0 0 0 FG
  0.8 0.8 0 true BG
  false UL
  false BX
  fc setfont
  Show
} bind def

%Face: Label_strong Courier-Bold
/L {
  0 0 0 FG
  1 1 0 true BG
  false UL
  false BX
  fcb setfont
  Show 
} bind def

%Face: String Times
/str {
  false BG
  false UL
  false BX
  0 0.5 0 FG
  ft setfont
  Show
} bind def

% Function print line number (<string> # -)
/# {
  gsave
    sx cw mul 2 div neg 0 rmoveto
    f# setfont
    0.8 0.1 0.1 FG
    c-show
  grestore
} bind def
%%EndResource
%%BeginSetup
% The font for line numbering
/f# /Helvetica findfont bfs .6 mul scalefont def
%%EndSetup
