/* xmalloc.h -- malloc declarations wrapper
   Copyright (C) 1996 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _XMALLOC_H_
#define _XMALLOC_H_

#if HAVE_CONFIG_H
# include <config.h>
#endif

#ifndef POINTER
# if defined (__GNUC__) || __STDC__
#  define POINTER void *
# else
#  define POINTER char *
# endif
#endif

#ifndef PARAMS
# if defined (__GNUC__) || __STDC__
#  define PARAMS(args) args
# else
#  define PARAMS(args) ()
# endif
#endif

#if HAVE_MALLOC_H
# include <malloc.h>
#else
extern POINTER free ();
#endif

extern POINTER calloc ();
extern POINTER malloc ();
extern POINTER realloc ();

#include "xstring.h"

POINTER xmalloc PARAMS ((size_t n));
POINTER xcalloc PARAMS ((size_t n, size_t s));
POINTER xrealloc PARAMS ((void *p, size_t n));
char *xstrdup PARAMS ((const char *cp));

#define ALLOC(t, n) ((t *) xmalloc (sizeof (t) * (n)))
#define	CALLOC(t, n) ((t *) xcalloc (sizeof (t), (n)))
#define MALLOC(n) ((char *) xmalloc (sizeof (char) * (n)))
#define REALLOC(o, t, n) ((t *) xrealloc ((o), sizeof (t) * (n)))
#define REMALLOC(o, n) ((char *) xrealloc ((o), sizeof (char) * (n)))
#define CLONE(o, t, n) ((t *) memcpy (ALLOC (t, (n)), (o), sizeof (t) * (n)))
#define FREE(o) \
   do {			\
      free (o);		\
   } while (0)
#define XFREE(o) 	\
   do {			\
      if (o) 		\
	free (o);	\
   } while (0)

#ifdef WITH_DMALLOC
#  include <dmalloc.h>
#endif

#endif /* _XMALLOC_H_ */
