/*
 * routines.h
 *
 * general use routines
 * Copyright (c) 1988, 89, 90, 91, 92, 93 Miguel Santana
 * Copyright (c) 1995, 96, 97 Akim Demaille, Miguel Santana
 * $Id: routines.h,v 1.3.2.2 1997/05/26 08:25:24 demaille Exp $
 */

/*
 * This file is part of a2ps.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _ROUTINES_H_
#define _ROUTINES_H_
#if HAVE_CONFIG_H
/* Prototypes for functions defined in lib/.  */

/* Support of prototyping when possible */
#ifndef ___P
#  if PROTOTYPES
#    define ___P(protos) protos
#  else /* no PROTOTYPES */
#    define ___P(protos) ()
#  endif /* no PROTOTYPES */
#endif

/*
 * From xmalloc.c
 */
#include "xmalloc.h"

/*
 * From xgetcwd.c
 */
char *xgetcwd PARAMS ((void));

/*
 * from xgethostname.c
 */
char *xgethostname PARAMS ((void));

/*
 * From message.c
 */
#include "message.h"

#endif

#include "jobs.h"

#define ustrcat(x,y) 					\
	(strcat((char *)(x), (const char *)(y)))
#define ustrcpy(x,y) 					\
	(strcpy((char *)(x), (const char *)(y)))
#define ustrncpy(x,y,z) 				\
	(strncpy((char *)(x), (const char *)(y), (z)))
#define ustrcmp(x,y)					\
	(strcmp((const char *)(x), (const char *)(y)))
#define ustrncmp(x,y,z)					\
	(strncmp((const char *)(x), (const char *)(y), (z)))
#define ustrlen(x)					\
	(strlen((const char *)(x)))
#define ustrchr(x,y) 					\
	((ustring) strchr((char *)(x), (int)(y)))
#define ustrrchr(x,y) 					\
	((ustring) strrchr((char *)(x), (int)(y)))
#define xustrdup(x) 					\
	((ustring) xstrdup((char *)(x)))

/*
 * Concatenation of a char. No malloc is done.
 */
#define USTRCCAT(s, c)					\
  do { int __len = strlen((char *)s);			\
       *(s+__len) = c;					\
       *(s+__len+1) = '\0'; 				\
  } while (FALSE)


#define IS_BETWEEN(x, min, max) (((min) <= (x)) && ((x) <= (max)))
#define strprefix(s1, s2) (!strncmp(s1, s2, strlen(s1)))
#define ustrprefix(s1, s2) (!ustrncmp(s1, s2, ustrlen(s1)))

#define IS_EMPTY(s1) (((char *) (s1) == NULL) || (*(s1) == NUL))
#define UNNULL(s1) (((char *) (s1) == NULL) ? "" : (char *) (s1))
#define ustrequ(s1, s2) (!ustrcmp(s1, s2))
#define strcaseequ(s1, s2) (!strcasecmp(s1, s2))

/* Definition of the integer divertions */
#define JOB_NB_PAGES	1
#define JOB_NB_SHEETS	2
#define JOB_NB_FILES	3
#define FILE_NB_PAGES	4
#define FILE_NB_SHEETS	5
#define FILE_NB_LINES	6

/* Functions on strings */
int is_strlower PARAMS((const ustring string));
void ustrccat PARAMS((ustring string, uchar c));
int strcnt PARAMS((ustring s, uchar c));

/* Expand escape sequences in a string */
void format_user_string PARAMS ((print_job * job, const char *context_name, const ustring str, ustring res));

#endif
