/*
 * routine.c
 *
 * general use routines
 * Copyright (c) 1988, 89, 90, 91, 92, 93 Miguel Santana
 * Copyright (c) 1995, 96, 97 Akim Demaille, Miguel Santana
 * $Id: routines.c,v 1.4.2.2 1997/06/16 14:56:55 demaille Exp $
 */

/*
 * This file is part of a2ps.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "a2ps.h"
#include "psgen.h"
#include "routines.h"
#include "jobs.h"

/*
 * Concatenation of a char. No malloc is done.
 */
void
ustrccat(ustring string, uchar c)
{
  int len = strlen((char *)string);
  *(string+len) = c;
  *(string+len+1) = '\0';
}

/*
 * return TRUE iff there are no upper case chars
 */
int 
is_strlower(const ustring string)
{
  ustring s = (ustring) string;

  for (/* skip */; *s != NUL; s++)
    if (isupper(*s))
      return FALSE;
  return TRUE;
}

/*
 * Count the number of occurrence of C in S
 */
int
strcnt (ustring s, uchar c)
{
  int res;
  for (res = 0 ; *s ; s++)
    if (*s == c)
      res++;
  return res;
}

/*
 * Help macros for the format_user_string() function.
 */

#define NEED_NBYTES(n) 				\
  do {						\
    if (rbufpos + (n) >= rbuflen)		\
      {						\
        rbuflen += (n) + 1024;			\
        rbuf = xrealloc (rbuf, rbuflen);	\
      }						\
  } while (0)

#define APPEND_CH(ch)				\
  do {						\
    int a;					\
    /*NEED_NBYTES (width);*/			\
    if (width && justification < 0)		\
      rbuf[rbufpos++] = (ch);			\
    for (a = 0; a < width - 1; a++)		\
      rbuf[rbufpos++] = ' ';			\
    if (!width || justification > 0)		\
      rbuf[rbufpos++] = (ch);			\
  } while (0)

#define APPEND_STR(str)				\
  do {						\
    int len = ustrlen ((str));			\
    int nspace;					\
						\
    if (len > width)				\
      nspace = 0;				\
    else					\
      nspace = width - len;			\
						\
    /*NEED_NBYTES (nspace + len);*/		\
    if (width && justification > 0)		\
      for (; nspace; nspace--)			\
	rbuf[rbufpos++] = ' ';			\
						\
    memcpy (rbuf + rbufpos, str, len);		\
    rbufpos += len;				\
						\
    if (width && justification < 0)		\
      for (; nspace; nspace--)			\
	rbuf[rbufpos++] = ' ';			\
  } while (0)

/*
 * Once again, I must admit a brand lot of this comes from
 * GNU enscript
 */
void
format_user_string (print_job * job,
		    const char *context_name, const ustring str, ustring rbuf)
{
  ustring cp, cp2;
/*  char *rbuf = NULL;*/
/*  int rbuflen = 0; */
  int rbufpos = 0;
  int i = 0;
  int j;
  uchar buf[512], buf2[512], buf3[256];
  int width = 0;
  int justification = 1;

  /* Format string. */
  for (i = 0; str[i] != '\0'; i++)
    {
      int type;
      
      type = str[i];
      
      if (type == '%' || type == '$')
	{
	  i++;
	  width = 0;
	  justification = 1;

	  /* Get optional width and justification. */
	  if (str[i] == '-')
	    {
	      i++;
	      justification = -1;
	    }
	  while (isdigit (str[i]))
	    width = width * 10 + str[i++] - '0';

	  /* Handle escapes. */
	  if (type == '%')
	    {
	      /* General state related %-escapes. */
	      switch (str[i])
		{
		case '%':	/* `%%' character `%' */
		  APPEND_CH ('%');
		  break;

		case '?':	/* `%?' if-then meta sequence */
		  {
		    int test = 0;
		    
		    uchar cond = str[++i];
		    uchar sep = str[++i];		    
		    ustring if_true, if_false, end;

		    if_true = xustrdup(str + ++i);
		    if_false = ustrchr (if_true, sep);
		    if (!if_false)
		      error (1, 0, _("%s: missing separator for %s escape"),
			     context_name, "%?");
		    *if_false = NUL;
		    if_false++;
		    end = ustrchr (if_false, sep);
		    i += end - if_true;
		    if (!end)
		      error (1, 0, _("%s: missing separator for %s escape"),
			     context_name, "%?");
		    *end = NUL;
		    switch (cond) {
		    case 'l': /* in landscape */
		      test = job->orientation == landscape;
		      break;
		    case 'v': /* on a verso side */
		      test = job->total_sheets & 0x1;
		      break;
		    case '1':	/* Is the tag1 not empty? */
		      test = !IS_EMPTY(job->tag1);
		      break;
		    case '2':	/* Is the tag2 not empty? */
		      test = !IS_EMPTY(job->tag2);
		      break;
		    case '3':	/* Is the tag3 not empty? */
		      test = !IS_EMPTY(job->tag3);
		      break;
		    case '4':	/* Is the tag4 not empty? */
		      test = !IS_EMPTY(job->tag4);
		      break;
		    default:
		      error (1, 0, _("%s: unknown `%s' escape `%c' (%d)"),
			     context_name, "%?", str[i], str[i]);
		      break;
		    }
		    if (test)
		      format_user_string (job, context_name, if_true, buf);
		    else
		      format_user_string (job, context_name, if_false, buf);
		    APPEND_STR (buf);
		    XFREE (if_true);
		  }
		break;

		case 'a':	/* `%a' NLS'ed `printed by USERNAME */
		  if (str[i + 1] == '{')
		    {
		      /* `%a{username@machine}' */
		      for (j = 0, i += 2;
			   j < sizeof (buf) && str[i] && str[i] != '}';
			   i++, j++)
			buf[j] = str[i];
		      if (str[i] != '}')
			error (1, 0, _("%s: too long format for %s escape"),
			       context_name, "%a{}");
		      
		      buf[j] = '\0';
		      cp = ustrrchr (buf, '@');
		      if (cp)
			*cp = NUL;
		    } else {
		      /* `%a' just prints NLS'ed `printed by USERNAME' */
		      ustrcpy (buf, job->pw_gecos);
		      cp = ustrchr (buf, ',');
		      if (cp)
			*cp = '\0';
		    }
		  sprintf ((char *)buf2, _("Printed by %s"), buf);
		  APPEND_STR (buf2);
		  break;

		case 'A':  /* `%A' NLS'ed `printed by USERNAME from MACHINE */
		  if (str[i + 1] == '{')
		    {		      		/* `%a{username@machine}' */
		      for (j = 0, i += 2;
			   j < sizeof (buf) && str[i] && str[i] != '}';
			   i++, j++)
			buf[j] = str[i];
		      if (str[i] != '}')
			error (1, 0, _("%s: too long format for %s escape"),
			       "%A{}", context_name);
		      buf[j] = '\0';

		      cp = ustrrchr (buf, '@');
		      if (cp) {
			*cp = NUL;
			cp ++;
		      }
		    } else {				/* `%a' */
		      ustrcpy (buf, job->pw_gecos);
		      cp = ustrchr (buf, ',');
		      if (cp)
			*cp = '\0';
		      cp = (ustring) xgethostname ();
		      cp2 = ustrchr (cp, '.');
		      if (cp2)
			*cp2 = '\0';
		    }
		  if (cp)
		    sprintf ((char *)buf3, 
			     _("Printed by %s from %s"), buf, cp);
		  else
		    sprintf ((char *)buf3, _("Printed by %s"), buf);
		  APPEND_STR (buf3);
		  break;

		case 'c':	/* `%c' trailing component of pwd. */
		  cp = (ustring) xgetcwd ();
		  if (!cp)
		    error (1, errno, 
			   _("can't get current working directory"));
		  cp2 = ustrrchr (cp, DIR_SEP);
		  if (cp2)
		    cp2++;
		  else
		    cp2 = cp;
		  APPEND_STR (cp2);
		  XFREE (cp);
		  break;
		case 'C':	/* `%C' runtime in `hh:mm:ss' format */
		  sprintf ((char *)buf, "%d:%02d:%02d", job->run_tm.tm_hour,
			   job->run_tm.tm_min, job->run_tm.tm_sec);
		  APPEND_STR (buf);
		  break;
		case 'd':	/* `%d' current working directory */
		  cp = (ustring) xgetcwd ();
		  if (!cp)
		    error (1, errno, 
			   _("can't get current working directory"));
		  APPEND_STR (cp);
		  XFREE (cp);
		  break;

		case 'D':
		  if (str[i + 1] == '{')
		    {
		      /* `%D{}' format run date with strftime() */
		      for (j = 0, i += 2;
			   j < sizeof (buf2) && str[i] && str[i] != '}';
			   i++, j++)
			buf2[j] = str[i];
		      if (str[i] != '}')
			error (1, 0, _("%s: too long format for %s escape"),
			       context_name, "%D{}");
		      
		      buf2[j] = '\0';
		      strftime ((char *) buf, sizeof (buf), 
				(char *) buf2, &job->run_tm);
		    }
		  else
		    {
		      /* `%D' run date in `yy-mm-dd' format */
		      sprintf ((char *)buf, "%02d-%02d-%02d", 
			       job->run_tm.tm_year,
			       job->run_tm.tm_mon + 1, 
			       job->run_tm.tm_mday);
		    }
		  APPEND_STR (buf);
		  break;
		  
		case 'e':	/* `%e' run date in localized short format */
		  /* Translators: please make a short date format
		   * according to the std form in your language, using
		   * _only_ ANSI C %* escapes */
		  strftime ((char *) buf, sizeof (buf), 
			    (_("%b %d, %y")), &job->run_tm);
		  APPEND_STR (buf);
		  break;
		  
		case 'E':	/* `%E' run date in localized long format */
		  /* Translators: please make a short date format
		   * according to the std form in your language, using
		   * _only_ ANSI C %* escapes */
		  strftime ((char *) buf, sizeof (buf), 
			    (_("%A %B %d, %y")), &job->run_tm);
		  APPEND_STR (buf);
		  break;
		  
		case 'F':	/* `%F' run date in `dd.mm.yyyy' format */
		  sprintf ((char *)buf, "%d.%d.%d",
			   job->run_tm.tm_mday,
			   job->run_tm.tm_mon + 1,
			   job->run_tm.tm_year+1900);
		  APPEND_STR (buf);
		  break;

		case 'l':	/* %l top most line in the current page */
                  sprintf ((char *)buf, "%d", job->jobs->toplinenum);
                  APPEND_STR (buf);
                  break;

		case 'm':	/* `%m' the hostname up to the first `.' */
		  cp = (ustring) xgethostname ();
		  cp2 = ustrchr (cp, '.');
		  if (cp2)
		    *cp2 = '\0';
		  APPEND_STR (cp);
		  XFREE (cp);
		  break;

		case 'M':	/* `%M' the full hostname */
		  cp = (ustring) xgethostname ();
		  APPEND_STR (cp);
		  XFREE (cp);
		  break;

		case 'n':	/* `%n' username */
		  APPEND_STR (job->pw_name);
		  break;

		case 'N':	/* `%N' pw_gecos up to the first `,' char */
		  ustrcpy (buf, job->pw_gecos);
		  cp = ustrchr (buf, ',');
		  if (cp)
		    *cp = '\0';
		  APPEND_STR (buf);
		  break;

		case 'p':	/* `%p' current page number */
		  sprintf ((char *)buf, "%d", job->total_pages);
		  APPEND_STR (buf);
		  break;
		  
		case 'P':	/* `%P' total number of pages */
		  APPEND_CH (JOB_NB_PAGES);
		  break;
		  
		case 'q':	/* localized `Page %p' */
		  sprintf ((char *)buf, _("Page %d"), job->total_pages);
		  APPEND_STR (buf);
		  break;
		  
		case 'Q':	/* localized `Page %p/%P' */
		  sprintf ((char *)buf, _("Page %d/%c"), 
			   job->total_pages, JOB_NB_PAGES);
		  APPEND_STR (buf);
		  break;
		  
		case 's':	/* `%s' current sheet number */
		  sprintf ((char *)buf, "%d", job->total_sheets);
		  APPEND_STR (buf);
		  break;

		case 'S':	/* `%S' total number of sheets */
		  APPEND_CH (JOB_NB_SHEETS);
		  break;

		case 't':	/* `%t' runtime in 12-hour am/pm format */
		  sprintf ((char *)buf, "%d:%02d%s",
			   job->run_tm.tm_hour > 12
			   ? job->run_tm.tm_hour - 12 : job->run_tm.tm_hour,
			   job->run_tm.tm_min,
			   job->run_tm.tm_hour > 12 ? "pm" : "am");
		  APPEND_STR (buf);
		  break;

		case 'T':	/* `%T' runtime in 24-hour format */
		  sprintf ((char *)buf, "%d:%02d", 
			   job->run_tm.tm_hour, job->run_tm.tm_min);
		  APPEND_STR (buf);
		  break;

		case '*':	/* `%*' runtime in 24-hour format with secs */
		  sprintf ((char *)buf, "%d:%02d:%02d",
			   job->run_tm.tm_hour, 
			   job->run_tm.tm_min,
			   job->run_tm.tm_sec);
		  APPEND_STR (buf);
		  break;

		case 'V':	/* `%V': name & version of this program */
		  sprintf ((char *) buf, "%s %s", PACKAGE, VERSION);
		  APPEND_STR (buf);
		  break;

		case 'W':	/* `%W' run date in `mm/dd/yy' format */
		  sprintf ((char *)buf, "%02d/%02d/%02d", 
			   job->run_tm.tm_mon + 1,
			   job->run_tm.tm_mday, 
			   job->run_tm.tm_year);
		  APPEND_STR (buf);
		  break;

		default:
		  error (1, 0, _("%s: unknown `%s' escape `%c' (%d)"),
			 context_name, "%", str[i], str[i]);
		  break;
		}
	    }
	  else
	    {
	      /* Input file related $-escapes. */
	      switch (str[i])
		{
		case '$':	/* `$$' character `$' */
		  APPEND_CH ('$');
		  break;

		case '(':	/* $(ENVVAR)  */
		  for (j = 0, i++;
		       str[i] && str[i] != ')' && j < sizeof (buf) - 1;
		       i++)
		    buf[j++] = str[i];

		  if (str[i] == '\0')
		    error (1, 0, _("%s: no closing ')' for %s escape"),
			   context_name, "$()");
		  if (str[i] != ')')
		    error (1, 0, _("%s: too long variable name for %s escape"),
			   context_name, "$()");
		  buf[j] = '\0';

		  cp = (ustring) getenv ((char *)buf);
		  if (cp == UNULL)
		    cp = (ustring) "";
		  APPEND_STR (cp);
		  break;

		case 'C':	/* `$C' modtime in `hh:mm:ss' format */
		  sprintf ((char *)buf, "%d:%02d:%02d", 
			   job->jobs->mod_tm.tm_hour,
			   job->jobs->mod_tm.tm_min, 
			   job->jobs->mod_tm.tm_sec);
		  APPEND_STR (buf);
		  break;

		case 'D':
		  if (str[i + 1] == '{')
		    {
		      /* `$D{}' format modification date with strftime() */
		      for (j = 0, i += 2;
			   j < sizeof (buf2) && str[i] && str[i] != '}';
			   i++, j++)
			buf2[j] = str[i];
		      if (str[i] != '}')
			error (1, 0, _("%s: too long format for %s escape"),
			       context_name, "$D{}");

		      buf2[j] = '\0';
		      strftime ((char *) buf, sizeof (buf),
				(char *) buf2, &(job->jobs->mod_tm));
		    }
		  else
		    {
		      /* `$D' mod date in `yy-mm-dd' format */
		      sprintf ((char *)buf, "%02d-%02d-%02d",
			       job->jobs->mod_tm.tm_year,
			       job->jobs->mod_tm.tm_mon + 1,
			       job->jobs->mod_tm.tm_mday);
		    }
		  APPEND_STR (buf);
		  break;

		case 'e':	/* `$E' mod date in localized short format */
		  /* Translators: please make a short date format
		   * according to the std form in your language, using
		   * _only_ ANSI C %* escapes */
		  strftime ((char *) buf, sizeof (buf), 
			    (_("%b %d, %y")), &(job->jobs->mod_tm));
		  APPEND_STR (buf);
		  break;
		  
		case 'E':	/* `%E' mod date in localized long format */
		  /* Translators: please make a short date format
		   * according to the std form in your language, using
		   * _only_ ANSI C %* escapes */
		  strftime ((char *) buf, sizeof (buf), 
			    (_("%A %B %d, %y")), &(job->jobs->mod_tm));
		  APPEND_STR (buf);
		  break;

		case 'F':	/* `$F' run date in `dd.mm.yyyy' format */
		  sprintf ((char *)buf, "%d.%d.%d",
			   job->jobs->mod_tm.tm_mday,
			   job->jobs->mod_tm.tm_mon + 1,
			   job->jobs->mod_tm.tm_year+1900);
		  APPEND_STR (buf);
		  break;

		case 'p':	/* `$p' current page number for this file */
		  sprintf ((char *)buf, "%d", 
			   job->total_pages - job->jobs->first_page);
		  APPEND_STR (buf);
		  break;
		  
		case 'P':	/* `$P' total number of pages of this file */
		  APPEND_CH (FILE_NB_PAGES);
		  break;
		  
		case 'q':	/* localized `Page $p' */
		  sprintf ((char *)buf, _("Page %d"), 
			   job->total_pages - job->jobs->first_page);
		  APPEND_STR (buf);
		  break;
		  
		case 'Q':	/* localized `Page $p/$P' */
		  sprintf ((char *)buf, _("Page %d/%c"), 
			   job->total_pages - job->jobs->first_page,
			   FILE_NB_PAGES);
		  APPEND_STR (buf);
		  break;
		  
		case 's':	/* `$s' current sheet number in the file */
		  sprintf ((char *)buf, "%d", 
			   job->total_sheets - job->jobs->first_sheet);
		  APPEND_STR (buf);
		  break;
		  
		case 'S':	/* `$S' total number of sheets in this file */
		  APPEND_CH (FILE_NB_PAGES);
		  break;
		  
		case 't':
		  switch (str[i + 1]) {
		  case '1':	/* `$t1' first marker grabbed from file */
		    i++;
		    APPEND_STR (job->tag1);
		    break;
		    
		  case '2':	/* `$t2' second marker grabbed from file */
		    i++;
		    APPEND_STR (job->tag2);
		    break;
		    
		  case '3':	/* `$t3' third marker grabbed from file */
		    i++;
		    APPEND_STR (job->tag3);
		    break;
		    
		  case '4':	/* `$t4' fourth marker grabbed from file */
		    i++;
		    APPEND_STR (job->tag4);
		    break;
		    
		  default:	/* `$t' runtime in 12-hour am/pm format */
		    sprintf ((char *)buf, "%d:%02d%s",
			     (job->jobs->mod_tm.tm_hour > 12
			      ? job->jobs->mod_tm.tm_hour-12 
			      : job->jobs->mod_tm.tm_hour),
			     job->jobs->mod_tm.tm_min,
			     job->jobs->mod_tm.tm_hour > 12 ? "pm" : "am");
		    APPEND_STR (buf);
		  }
		  break;
		  
		case 'T':	/* `$T' runtime in 24-hour format */
		  sprintf ((char *)buf, "%d:%02d", 
			   job->jobs->mod_tm.tm_hour,
			   job->jobs->mod_tm.tm_min);
		  APPEND_STR (buf);
		  break;

		case '*':	/* `$*' runtime in 24-hour format with secs */
		  sprintf ((char *)buf, "%d:%02d:%02d", 
			   job->jobs->mod_tm.tm_hour, 
			   job->jobs->mod_tm.tm_min,
			   job->jobs->mod_tm.tm_sec);
		  APPEND_STR (buf);
		  break;

		case 'v':	/* `$v': input file number */
		  sprintf ((char *)buf, "%d", job->jobs->num);
		  APPEND_STR (buf);
		  break;

		case 'V':	/* `$V': total number of files */
		  APPEND_CH (JOB_NB_FILES);
		  break;

		case 'W':	/* `$W' run date in `mm/dd/yy' format */
		  sprintf ((char *)buf, "%02d/%02d/%02d", 
			   job->jobs->mod_tm.tm_mon + 1,
			   job->jobs->mod_tm.tm_mday, 
			   job->jobs->mod_tm.tm_year);
		  APPEND_STR (buf);
		  break;

		case 'N':	/* `$N' the full name of the printed file */
		  APPEND_STR (job->jobs->name);
		  break;

		case 'n':	/* `$n' input file name without directory */
		  cp = ustrrchr (job->jobs->name, DIR_SEP);
		  if (cp == NULL)
		    cp = job->jobs->name;
		  else
		    cp ++;
		  APPEND_STR (cp);
		  break;

		case 'l':	/* $l current line in the current page	*/
		  sprintf ((char *)buf, "%d", job->jobs->linenum - 1);
		  APPEND_STR (buf);
		  break;

		case 'L':	/* $L number of lines in this file */
		  APPEND_CH (FILE_NB_LINES);
		  break;

		default:
		  error (1, 0, _("%s: unknown `%s' escape `%c' (%d)"),
			 context_name, "$", str[i], str[i]);
		  break;
		}
	    }
	  /* Reset width so the else-arm goes ok at the next round. */
	  width = 0;
	  justification = 1;
	}
      else
	APPEND_CH (str[i]);
    }
  APPEND_CH ('\0');

  message (4, _("expansion of %s user string (\"%s\") is \"%s\"\n"),
	   context_name, str, rbuf);
}
