/*
 * pathwalk.h
 *
 * functions for ooking for files, reading files etc. 
 * Copyright (c) 1988, 89, 90, 91, 92, 93 Miguel Santana
 * Copyright (c) 1995, 96, 97 Akim Demaille, Miguel Santana
 * $Id: pathwalk.h,v 1.1 1997/03/16 18:20:00 demaille Exp $
 */

/*
 * This file is part of a2ps.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _PATHWALK_H_
#define _PATHWALK_H_

#if HAVE_CONFIG_H
# include <config.h>
/* Support of prototyping when possible */
# ifndef PARAMS
#   if PROTOTYPES
#     define PARAMS(protos) protos
#   else /* no PROTOTYPES */
#     define PARAMS(protos) ()
#   endif /* no PROTOTYPES */
# endif
#endif

/*
 * Dump NAME.SUFFIX in the PATH on STDOUT
 */
int pw_paste_file PARAMS ((char * path, const char *name, const char *suffix));

/*
 * Is the file CONTEXT somewhere in PATH
 */
int pw_file_exists PARAMS ((char * path, const char *name, const char *suffix));

/*
 * Return malloc'ed path to NAME.SUFFIX if in PATH, NULL otherwise
 */
char * pw_find_file PARAMS ((char * path, const char *name, const char *suffix));

/*
 * Report on STDOUT the files in PATH that end with SUFFIX
 */
int pw_list_suffix PARAMS ((char * path, char * dirfmt, char * filefmt, char * enddir, const char *suffix));

#endif /* not defined _PATHWALK_H_ */
