/*
 * output.h
 *
 * routines for ram-diverted output
 * Copyright (c) 1988, 89, 90, 91, 92, 93 Miguel Santana
 * Copyright (c) 1995, 96, 97 Akim Demaille, Miguel Santana
 * $Id: output.h,v 1.4 1997/04/01 12:38:15 demaille Exp $
 */

/*
 * This file is part of a2ps.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _OUTPUT_H_
#define _OUTPUT_H_

# ifndef __attribute__
/* This feature is available in gcc versions 2.5 and later.  */
#  if __GNUC__ < 2 || (__GNUC__ == 2 && __GNUC_MINOR__ < 5) || __STRICT_ANSI__
#   define __attribute__(Spec) /* empty */
#  endif
/* The __-protected variants of `format' and `printf' attributes
   are accepted by gcc versions 2.6.4 (effectively 2.7) and later.  */
#  if __GNUC__ < 2 || (__GNUC__ == 2 && __GNUC_MINOR__ < 7)
#   define __format__ format
#   define __printf__ printf
#  endif
# endif


struct chunk;

# if defined (__STDC__) && __STDC__
extern void output (struct chunk * div, const char *format, ...)
     __attribute__ ((__format__ (__printf__, 2, 3)));
# else
void output ();
# endif

void output_char PARAMS ((struct chunk * div, uchar c));
void output_delayed_int PARAMS ((struct chunk * div, int * ptr));
void output_delayed_chunk PARAMS ((struct chunk * div, struct chunk * sub_div));
void output_file PARAMS ((struct chunk * div, struct print_job * job, const char *name, const char *suffix));
void output_delayed_routine PARAMS ((struct chunk * div, void (*fn) (struct print_job * job), void * arg));

struct chunk * new_divertion PARAMS ((void));
void divertion_to_void PARAMS ((struct chunk * div, int forget));
void undivert PARAMS ((struct print_job * job));
void underivation PARAMS ((struct chunk * div));
#endif

