/*
 * medias.c
 *
 * Used paper formats
 * Copyright (c) 1988, 89, 90, 91, 92, 93 Miguel Santana
 * Copyright (c) 1995, 96, 97 Akim Demaille, Miguel Santana
 * $Id: medias.c,v 1.1 1997/03/07 16:06:38 demaille Exp $
 */

/*
 * This file is part of a2ps.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include "a2ps.h"
#include "medias.h"
#include "routines.h"

/************************************************************************/
/*				media selection				*/
/************************************************************************/
/* media: name, width, height, llx, lly, urx, ury */
media medias[] = {
  { "A3", 		842, 1190, 24, 24, 818, 1166},
  { "A4", 		595, 842, 24, 24, 571, 818},
  { "A5", 		420, 595, 24, 24, 396, 571},
  { "B4",              	729, 1032, 24, 24, 705, 1008},
  { "B5",              	516,  729, 24, 24, 492, 705},
  { "Letter", 		612, 792, 24, 24, 588, 768},
  { "Legal", 		612, 1008, 24, 24, 588, 984},
  { "Tabloid",         	792, 1224, 24, 24, 768,  1200},
  { "Ledger",         	1224,  792, 24, 24,    1200,  768},
  { "Statement",	396, 612,  24, 24,  372, 588},
  { "Executive", 	540,  720, 24, 24, 516, 696},
  { "Folio",           	612,  936, 24, 24, 588, 912},
  { "Quarto",         	610,  780, 24, 24, 586, 756},
  { "10x14",           	720, 1008, 24, 24, 696, 984},
  /* Desk Jet users */
  { "A4dj", 		595, 842, 24, 50, 571, 818},
  { "Letterdj", 	612, 792, 24, 40, 588, 768},
};

int nbr_medias = sizeof(medias) / sizeof(medias[0]);

/*
 * Return the index of the media used.
 * Return -1 if none
 */
int
select_media (char *string)
{
  int i;
  for (i=0 ; i < nbr_medias ; i++)
    if (strcaseequ (medias[i].name, string))
      return i;
  
  return -1;
}
