/*
 * fonts.h
 *
 * definition of the fonts used by a2ps
 * Copyright (c) 1988, 89, 90, 91, 92, 93 Miguel Santana
 * Copyright (c) 1995, 96, 97 Akim Demaille, Miguel Santana
 * $Id: fonts.h,v 1.5.2.1 1997/04/16 14:43:02 demaille Exp $
 */

/*
 * This file is part of a2ps.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _FONTS_H_
#define _FONTS_H_
#include "config.h"

/* To define a relation between the physical font, and the
 * logical font, we need to be able to speack of the physical font */
typedef enum {
  unknown_font = -2,
  courier_font = 0,  courier_italic_font = 1,
    courier_bold_font = 2,  courier_bolditalic_font = 3,
  times_font = 4, times_bold_font = 5, 
    times_italic_font = 6, times_bolditalic_font = 7,
  helvetica_font = 8, helvetica_bold_font = 9,
     helvetica_italic_font = 10, helvetica_bolditalic_font = 11,
  symbol_font = 12
} FONT;

/* including Symbol, but not the unknwon_font */
#define NB_FONTS (symbol_font + 1)

FONT string_to_font PARAMS ((char * string));
char * font_to_string PARAMS ((FONT font));

#endif
