/*
 * fonts.c
 *
 * definition of the fonts used by a2ps
 * Copyright (c) 1988, 89, 90, 91, 92, 93 Miguel Santana
 * Copyright (c) 1995, 96, 97 Akim Demaille, Miguel Santana
 * $Id: fonts.c,v 1.4.2.1 1997/04/16 14:42:55 demaille Exp $
 */

/*
 * This file is part of a2ps.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "a2ps.h"
#include "fonts.h"
#include "routines.h"

FONT
string_to_font (char * string)
{
  if (strequ (string, "Courier"))
    return courier_font;
  else if (strequ (string, "Courier-Bold"))
    return courier_bold_font;
  else if (strequ (string, "Courier-Italic") 
	   || (strequ (string, "Courier-Oblique")))
    return courier_italic_font;
  else if (strequ (string, "Courier-BoldItalic")
	   || (strequ (string, "Courier-BoldOblique")))
    return courier_bolditalic_font;
  else if (strequ (string, "Symbol"))
    return symbol_font;
  else if (strequ (string, "Times")
	   || strequ (string, "Times-Roman"))
    return times_font;
  else if (strequ (string, "Times-Bold"))
    return times_bold_font;
  else if (strequ (string, "Times-Italic"))
    return times_italic_font;
  else if (strequ (string, "Times-BoldItalic"))
    return times_bolditalic_font;
  else if (strequ (string, "Helvetica"))
    return helvetica_font;
  else if (strequ (string, "Helvetica-Bold"))
    return helvetica_bold_font;
  else if (strequ (string, "Helvetica-Italic") 
	   || (strequ (string, "Helvetica-Oblique")))
    return helvetica_italic_font;
  else if (strequ (string, "Helvetica-BoldItalic")
	   || (strequ (string, "Helvetica-BoldOblique")))
    return helvetica_bolditalic_font;
  else return unknown_font;
}

FONT
ps_name_to_font (char * string)
{
  /* Courier */
  if (strequ (string, "fc"))
    return courier_font;
  else if (strequ (string, "fcb"))
    return courier_bold_font;
  else if (strequ (string, "fci"))
    return courier_italic_font;
  else if (strequ (string, "fce"))
    return courier_bolditalic_font;

  /* Symbol */
  else if (strequ (string, "fs"))
    return symbol_font;

  /* Times */
  else if (strequ (string, "ft"))
    return times_font;
  else if (strequ (string, "ftb"))
    return times_bold_font;
  else if (strequ (string, "fti"))
    return times_italic_font;
  else if (strequ (string, "fte"))
    return times_bolditalic_font;

  /* Helvetica */
  else if (strequ (string, "fh"))
    return helvetica_font;
  else if (strequ (string, "fhb"))
    return helvetica_bold_font;
  else if (strequ (string, "fhi"))
    return helvetica_italic_font;
  else if (strequ (string, "fhe"))
    return helvetica_bolditalic_font;
  /* Error */
  else return unknown_font;
}


char *
font_to_string (FONT font)
{
  switch (font) {
  case courier_font:
   return "Courier";
  case courier_bold_font:
   return "Courier-Bold";
  case courier_italic_font:
   return "Courier-Oblique";
  case courier_bolditalic_font:
   return "Courier-BoldOblique";
  case symbol_font:
    return "Symbol";
  case times_font:
    return "Times-Roman";
  case times_bold_font:
    return "Times-Bold";
  case times_italic_font:
    return "Times-Italic";
  case times_bolditalic_font:
    return "Times-BoldItalic";
  case helvetica_font:
    return "Helvetica";
  case helvetica_bold_font:
    return "Helvetica-Bold";
  case helvetica_italic_font:
    return "Helvetica-Oblique";
  case helvetica_bolditalic_font:
    return "Helvetica-BoldOblique";
  default:
    return "unknown font";
  }
}
