/*
 * faces.h
 *
 * definition of the faces used by a2ps
 * Copyright (c) 1988, 89, 90, 91, 92, 93 Miguel Santana
 * Copyright (c) 1995, 96, 97 Akim Demaille, Miguel Santana
 * $Id: faces.h,v 1.4.2.1 1997/04/16 14:42:49 demaille Exp $
 */

/*
 * This file is part of a2ps.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _FACES_H_
#define _FACES_H_

#include "fonts.h"

/* fonts used in language modes */
typedef enum { 
  NO_FACE = -1,
  PLAIN = 0, 
  SYMBOL = 1, 
  KEYWORD = 2, KEYWORD_STRONG = 3,
  COMMENT = 4, COMMENT_STRONG = 5,
  STRING = 6,
  LABEL = 7, LABEL_STRONG = 8,
  /* Specials */
  INVISIBLE = 16,
  TAG1 = 32, TAG2 = 64, TAG3 = 128, TAG4 = 256,
  DEC1 = 512, DEC2 = 1024,
  /* Encoding instruction */
  ENCODING_TAG = 2048,
  /* Masks */
  FACE_MASK = 15
} FACE;

#define NB_FACES  9
#define NB_FACES_NULLS	\
	{ NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL}

FACE string_to_face PARAMS ((char * string));
char * face_to_ps PARAMS ((FACE face));
char * face_to_string PARAMS ((FACE face));
int check_face_to_font PARAMS ((FONT face_2_font[NB_FACES]));
void init_face_to_font PARAMS ((FONT face_2_font[NB_FACES]));
#endif
