/*
 * faces.h
 *
 * definition of the faces used by a2ps
 * Copyright (c) 1988, 89, 90, 91, 92, 93 Miguel Santana
 * Copyright (c) 1995, 96, 97 Akim Demaille, Miguel Santana
 * $Id: faces.c,v 1.6.2.1 1997/04/16 14:42:43 demaille Exp $
 */

/*
 * This file is part of a2ps.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "a2ps.h"
#include "faces.h"

FACE
string_to_face (char * string)
{
  if (strequ (string, "Plain"))
    return PLAIN;
  else if (strequ (string, "Symbol"))
    return SYMBOL;
  else if (strequ (string, "Keyword"))
    return KEYWORD;
  else if (strequ (string, "Keyword_strong"))
    return KEYWORD_STRONG;
  else if (strequ (string, "Comment"))
    return COMMENT;
  else if (strequ (string, "Comment_strong"))
    return COMMENT_STRONG;
  else if (strequ (string, "Label"))
    return LABEL;
  else if (strequ (string, "Label_strong"))
    return LABEL_STRONG;
  else if (strequ (string, "String"))
    return STRING;
  else return NO_FACE;
}

char *
face_to_string (FACE face)
{
  switch (face) {
  case PLAIN:
    return "Plain";
  case SYMBOL:
    return "Symbol";
  case KEYWORD:
    return "Keyword";
  case KEYWORD_STRONG:
    return "Keyword_strong";
  case COMMENT:
    return "Comment";
  case COMMENT_STRONG:
    return "Comment_strong";
  case LABEL:
    return "Label";
  case LABEL_STRONG:
    return "Label_strong";
  case STRING:
    return "String";
  default:
   return "unknown face";
  }
}

/* convertion from a font to the postscript function */
char *
face_to_ps (FACE face)
{
  switch (face) {
  case PLAIN:
    return "p";
  case SYMBOL:
    return "sy";
  case KEYWORD:
    return "k";
  case KEYWORD_STRONG:
    return "K";
  case COMMENT:
    return "c";
  case COMMENT_STRONG:
    return "C";
  case LABEL:
    return "l";
  case LABEL_STRONG:
    return "L";
  case STRING:
    return "str";
  default:
    error (1, 0, "face_to_ps: %d", face);
  }
  return 0; /* For -Wall */
}

/* Check that the face_to_font knowldge is complete */
int
check_face_to_font (FONT face_2_font[NB_FACES])
{
  FACE f;
  int err = FALSE;

  for (f = 0 ; f < NB_FACES ; f++)
    if (face_2_font [f] == unknown_font) {
      err = TRUE;
      error (0, 0, "face `%s' has no specified font", face_to_string (f));
    }
  return err;
}

/* Initialize the face_font_to_font array to non acceptable values */
void
init_face_to_font (FONT face_2_font[NB_FACES])
{
  FACE f;
  for (f = 0 ; f < NB_FACES ; f++)
    face_2_font [f] = unknown_font;
}
