/*
 * encodings
 *
 * definition of the char encodings used
 * Copyright (c) 1988, 89, 90, 91, 92, 93 Miguel Santana
 * Copyright (c) 1995, 96, 97 Akim Demaille, Miguel Santana
 * $Id: encoding.h,v 1.1.2.1 1997/05/26 08:25:14 demaille Exp $
 */

/*
 * This file is part of a2ps.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/************************************************************************/
/*			encoding selection				*/
/************************************************************************/
#ifndef _ENCODINGS_H_
#define _ENCODINGS_H_
#include "a2ps.h"
#include "faces.h"
#include "fonts.h"

struct print_job;	/* Declared in jobs.h which includes this file */

/* Definition of the various encodings used */
/* various encoding schemes */
typedef enum {
  NOENCODING = -1,
  ENC_ASCII, 
  ENC_LATIN1, ENC_LATIN2, ENC_LATIN3, ENC_LATIN4, ENC_LATIN5, ENC_LATIN6,
  ENC_HP, ENC_MAC, ENC_IBMPC, ENC_PCG, ENC_CP1250
} ENCODING;

typedef struct {
  ENCODING encoding;
  const char * names[2];
  const char * encoding_vector_name;
  char new_line;
  unsigned int * font_WX[NB_FONTS];
  unsigned int * WX[NB_FACES];/* Correspondance between font and WX	*/
} code;


extern code encodings[] ;
extern int nbr_encodings;
ENCODING select_encoding PARAMS ((char *string));


#define COURIER_WX	600	/* Any char in courier has WX = 600 */

/*
 * Computation of the width of the chars in the current encoding
 */
inline unsigned int char_WX PARAMS ((struct print_job * job, uchar c));
unsigned int string_WX PARAMS ((struct print_job * job, ustring string));

/*
 * Multi-lingual routines
 */
void ps_set_encoding PARAMS ((struct print_job * job, ENCODING enc));
void ps_end_encoding PARAMS ((struct print_job * job));
void ps_switch_encoding PARAMS ((struct print_job * job, ENCODING enc));

#endif
