/*
 * encodings
 *
 * definition of the char encodings used
 * Copyright (c) 1988, 89, 90, 91, 92, 93 Miguel Santana
 * Copyright (c) 1995, 96, 97 Akim Demaille, Miguel Santana
 * $Id: encoding.c,v 1.1.2.1 1997/05/26 08:25:13 demaille Exp $
 */

/*
 * This file is part of a2ps.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include "encoding.h"
#include "routines.h"
/************************************************************************/
/*			encoding selection				*/
/************************************************************************/

#define UKN	COURIER_WX

/* These are built by ogonkify */
#include "ascii.afc"
#include "latin1.afc"
#include "latin2.afc"
#include "latin3.afc"
#include "latin4.afc"
#include "latin5.afc"
#include "latin6.afc"
#include "cp1250.afc"
#include "macintosh.afc"
#include "ibmpc.afc"
#include "hp.afc"

/* These were quasi hand made */
#include "symbol.Afc"
#include "pcg.Afc"

/*
 * Table to describe the encoding schemes and their name
 */
#define NB_FACES_NULLS	\
	{ NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL}

/* Make sure to respect the order with that of the fonts:
   courier_font = 0, 
   times_font = 1, times_bold_font = 2, 
   times_italic_font = 3, times_bolditalic_font = 4,
   helvetica_font = 5
   */
code encodings[] = {
  { 
    ENC_ASCII, 	{"ASCII", "7 bits"}, "ASCIIEncoding", '\n', 
    ascii_WX,
    NB_FACES_NULLS
  },  
  { 
    ENC_LATIN1, {"Latin1", "ISO8859-1"}, "ISOLatin1Encoding", '\n', 
    latin1_WX,
    NB_FACES_NULLS
  },  
  { 
    ENC_LATIN2, {"Latin2", "ISO8859-2"},"ISOLatin2Encoding", 	'\n', 
    latin2_WX,
    NB_FACES_NULLS
  },  
  { 
    ENC_LATIN3, {"Latin3", "ISO8859-3"},"ISOLatin3Encoding", 	'\n', 
    latin3_WX,
    NB_FACES_NULLS
  },  
  { 
    ENC_LATIN4, {"Latin4", "ISO8859-4"}, "ISOLatin4Encoding", '\n', 
    latin4_WX,
    NB_FACES_NULLS
  },  
  { 
    ENC_LATIN5, {"Latin5", "ISO8859-9"},"ISOLatin5Encoding", 	'\n', 
    latin5_WX,
    NB_FACES_NULLS
  },
  { 
    ENC_LATIN6, {"Latin6", "ISO8859-10"},"ISOLatin6Encoding", 	'\n', 
    latin6_WX,
    NB_FACES_NULLS
  },  
  { 
    ENC_HP, 	{"HP", "HP 8 Roman"},	"HPRomanEncoding", 	'\n', 
    hp_WX,
    NB_FACES_NULLS
  },  
  { 
    ENC_MAC, 	{"Mac", "Macintosh"},	"MacintoshEncoding", 	'\r', 
    macintosh_WX,
    NB_FACES_NULLS
  },  
  { 
    ENC_IBMPC, 	{"IBMPC", "PC Text"},	"IBMPCEncoding", 	'\n', 
    ibmpc_WX,
    NB_FACES_NULLS
  },  
  { 
    ENC_PCG, 	{"PCG", "PC Graphic"},	"PCGraphicEncoding", 	'\n', 
    {
      pcg_PCFont_WX,
      pcg_PCFont_WX, pcg_PCFont_WX, pcg_PCFont_WX,
      pcg_PCFont_WX,
      pcg_PCFont_WX
    },
    NB_FACES_NULLS
  }, 
  { 
    ENC_CP1250,	{"CP1250", "MicroSoft's CP-1250"},   "CP1250Encoding", 	'\n', 
    cp1250_WX,
    NB_FACES_NULLS
  }
};

int nbr_encodings =  sizeof(encodings) / sizeof(encodings[0]);

/*
 * Return the index of the encoding.
 * Return NOENCODING if none
 */
ENCODING
select_encoding (char *string)
{
  ENCODING i;
  int j;

  for (i=0 ; i < nbr_encodings ; i++)
    for (j=0 ; j < 2 ; j++)
      if (strcaseequ(encodings[i].names[j], string))
	return encodings[i].encoding;

  return NOENCODING;
}

/*
 *	Returns the WX of a char (including M- and ^)
 */
unsigned int
char_WX(print_job * job, uchar c)
{
/*#define _WX_(char)  (encodings[job->encoding].WX[job->status->font][char])*/
#define _WX_(char)  (job->status->current_wx[job->status->face][char])
  int wx = _WX_(c);

  /* Only printable characters have a positive wx */
  if (wx)
    return wx;

  switch (job->only_printable) {
  case TRUE:
    return wx;
  
  case FALSE:
    return(0177 < c ? (_WX_('M') + _WX_('-')): 0 
	   + (((c&0177) < ' ' || (c&0177) == 0177) ? _WX_('^') : 0)
	   + wx);
  }
  error (1, 0, "char_WX");
  return 0;	/* For -Wall */
}

/*
 *	Returns the WX of a string (including M- and ^)
 */
unsigned int 
string_WX(print_job * job, ustring string)
{
  unsigned int result=0;

  for (/* skip */; *string ; string ++)
    result += char_WX(job, *string);

  return result;
}
