/* darray.h -- dynamic arrays
   Copyright (c) 1988, 89, 90, 91, 92, 93 Miguel Santana
   Copyright (c) 1995, 96, 97 Akim Demaille, Miguel Santana

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

/* Author: Akim Demaille <demaille@inf.enst.fr> */

#ifndef _DARRAY_H_
#define _DARRAY_H_

#ifndef PARAMS
# if defined (__GNUC__) || __STDC__
#  define PARAMS(args) args
# else
#  define PARAMS(args) ()
# endif
#endif

struct darray {
  char * name;
  size_t size;
  size_t increment;
  size_t len;		/* assert (len + 1 <= size) */
  void ** content;
  void (* self_print) PARAMS ((const void *));
  int (* cmp) PARAMS ((const void * k1, const void * k2));
};

struct darray *
da_create PARAMS ((char * name, size_t size, size_t increment, 
	   void (* self_print) (const void *),
	   int (* cmp) (const void *, const void *)));
void da_erase PARAMS ((struct darray * arr));
void da_grow PARAMS ((struct darray * arr));
int da_is_full PARAMS ((struct darray * arr));
void da_append PARAMS ((struct darray * arr, void * elem));
void da_concat PARAMS ((struct darray * arr, struct darray * arr2));

void da_sort PARAMS ((struct darray * arr));
void da_report PARAMS ((struct darray * arr));
void da_dump_content PARAMS ((struct darray * arr));
void da_map PARAMS ((struct darray * arr, void (* fn) (void *)));
#endif
