/*
 * confg.h
 *
 * Read and understanding everything about the options 
 * & (dynamic) configuration of a2ps.
 * Copyright (c) 1988, 89, 90, 91, 92, 93 Miguel Santana
 * Copyright (c) 1995, 96, 97 Akim Demaille, Miguel Santana
 */

/*
 * This file is part of a2ps.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _CONFG_H_
#define _CONFG_H_

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

struct print_job;

/************************************************************************
 *	The various global behaviors
 */
typedef enum {
  b_ps,  	/* postscript generator (usual PS converter) */
  b_report, 	/* report internal capabilities */
  b_guess, 	/* do not print but report the corresponding guessed language */
  b_help, 
  b_version, 
  b_list_options, 
  b_list_features
} BEHAVIOR;

/*
 * Handle the options.
 */
int handle_option PARAMS ((struct print_job * job, int argc, char *argv[]));
void handle_string_options PARAMS ((struct print_job * job, char *string));

/*
 * Read the configuration file
 */
int read_config PARAMS ((struct print_job * job, char *path, char *file));
void read_sys_config PARAMS ((struct print_job * job));
#endif
