/*
 * a2ps.h
 *
 * shared header with the whole package
 * Copyright (c) 1988, 89, 90, 91, 92, 93 Miguel Santana
 * Copyright (c) 1995, 96, 97 Akim Demaille, Miguel Santana
 * $Id: a2ps.h,v 1.4.2.2 1997/06/16 14:56:44 demaille Exp $
 */

/*
 * This file is part of a2ps.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _A2PS_H_
#define _A2PS_H_


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>

/* Support of prototyping when possible */
#ifndef PARAMS
#  if PROTOTYPES
#    define PARAMS(protos) protos
#  else /* no PROTOTYPES */
#    define PARAMS(protos) ()
#  endif /* no PROTOTYPES */
#endif

#if STDC_HEADERS

#  include <stdlib.h>

#else /* no STDC_HEADERS */

#  if HAVE_STDLIB_H
#    include <stdlib.h>
#  endif

#  ifndef HAVE_STRCHR
#    define strchr index
#    define strrchr rindex
#  endif
char *strchr ();
char *strrchr ();

#  ifndef HAVE_STRERROR
extern char *strerror PARAMS ((int));
#  endif

#endif /* no STDC_HEADERS */

#if HAVE_MATH_H
#  include <math.h>
#else
extern double atan2 PARAMS ((double, double));
#endif

#include <errno.h>
#ifndef errno
extern int errno;
#endif

#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>

#if HAVE_PWD_H
#  include <pwd.h>
#endif

#include "xunistd.h"

#include "xstring.h"

#if TIME_WITH_SYS_TIME
#  include <time.h>
#  include <sys/time.h>
#else 
#  if HAVE_SYS_TIME_H
#    include <sys/time.h>
#  else
#    include <time.h>
#  endif
#endif

/*	Internationalization stuff	*/
#include "xnls.h"

#include "error.h"

/************************************************************************/
/*									*/
/*	     P r e p r o c e s s i n g   d e f i n i t i o n s		*/
/*									*/
/************************************************************************/

#include "liba2ps.h"

/*
 * Common definitions
 */
#define	FALSE		0
#define	TRUE		1
#define UNDEF		2	/* used to make the != between options
				 * specified (y/n) by user, and not
				 * specified				*/
#ifndef NULL
#  define NULL		0
#endif
#define UNULL 		(uchar *) NULL
#ifndef NUL
#  define NUL		'\0'
#endif
#ifndef EXIT_SUCCESS
#  define EXIT_SUCCESS	0
#endif
#ifndef EXIT_FAILURE
#  define EXIT_FAILURE	1
#endif
#define EXIT_BADARG	2	/* bad argument (option) was given	*/
#define EXIT_UKNLANG	3	/* unknown language was requested	*/
#define EXIT_UKNCODE	4	/* unknown encoding was requested	*/

#endif
