;;
//	charon.cl
//* essai de resolution du pb d'Irne Charon
	version/ sans objets, avec rgles sur les impossibilits, et sur la reduction pour lettres manquantes. Avec disparition des L_set et L_moins
*//
 

//*  quelques globales de la grande grille			**//
nb_art      :: 22 ;; nb d'articulations
nb_mot      :: 20
ordre_score :: list('e', 'l', 'i', 'm', 'a', 'r', 'b', 'f', 'o', 'd')
alphabet    :: set!(ordre_score)
nb_lettre   :: size(alphabet) ;; taille de l'alphabet
min_mot     :: 3
max_mot     :: 9 ;; taille maximale des mots
SUIVI       :: 2
AKIM :: 1
DEBUG       :: 10
meilleur_score:integer :: 0
nb_backtrack:integer   :: 0


[etat_rech <: thing(;; ensembles des lettres qu'il FAUT faire apparatre
                     let_manquantes:set = {},
                     ;; ensemble des familles sur lesquels il y a encore doute
                     fam_vivantes:set = {},
                     init?:boolean = true)]
rik :: etat_rech()

;;
;;  Les inconnues sont les articulations et les mots
;; elles sont representees par des ensembles: ceux des possibilites
;;
[M[x:(1 .. nb_mot)] : list -> list()]  ;; les mots : ensembles de mots possibles
[A[x:(1 .. nb_art)] : set -> alphabet] ;; ensembles de lettres possibles
[L[l:alphabet] : set -> {}]            ;; ou l'on rencontre la lettre manquante l
[F[f:set[string]] : set -> {}]         ;; ou l'on rencontre des membres de la famille f

(event(M, A, L, F, fam_vivantes, let_manquantes, init?),
 multivalued?(M) := false, multivalued?(A) := false, 
 multivalued?(L) := false, multivalued?(F) := false,
 multivalued?(fam_vivantes) := false, multivalued?(let_manquantes) := false )
store(M, A, L, F, let_manquantes, fam_vivantes)

[mot1[a:(1 .. nb_art)] : (1 .. nb_mot) -> unknown]
[pos1[a:(1 .. nb_art)] : integer -> unknown]
[mot2[a:(1 .. nb_art)] : (1 .. nb_mot) -> unknown]
[pos2[a:(1 .. nb_art)] : integer -> unknown]
[articulations[m:(1 .. nb_mot)] : set -> {}]
[longueur[m:(1 .. nb_mot)] : (1 .. max_mot) -> 1]

;;
;;  Initialisations
;;
;; quels sont les mots de n lettres
[dico[n:(min_mot .. max_mot)] : list -> list()]
[apparait_dans_mot_de[n:(min_mot .. max_mot)] : set -> set()]
[sure_dans_mot_de[n:(min_mot .. max_mot)] : set -> set()]
;; combien de points ramenent un mot s
[score_mot[s:string] : integer -> 0]
;; quelle est la famille de s
[famille[s:string] : set -> {}]  

[score(self:string) : integer 
  -> let res := 0 in (for i in (1 .. length(self)) res :+ score_let[self[i]], res)]

[nouveau_mot(s:string, fam:set) : void 
  -> dico[length(s)] :add s, 
     score_mot[s] := score(s),
     famille[s] := fam]

;; mots de 'longueur' lettres dans la liste des possibles
[init_dico(fichier:string) : void
 -> printf("Lecture des mots et calcul des scores\n"), 
    for n in (min_mot .. max_mot) dico[n] := list(),
    let fdico := fopen(fichier, "r"), token := unknown in
      while ((token := eval(read(fdico))) != eof)
        case token
          (bag     nouveau_mot(token[1], set!(token)),
           string  nouveau_mot(token, set(token)),
           any     trace(DEBUG, "Lecture de ~S (type = ~S) dans le dico\n",
                         token, isa(token))),
    for n in (min_mot .. max_mot) 
      (dico[n] := sort(dico[n], score>= @ string),
       for l in alphabet 
         (let nb_apparition := size({%mot in dico[n] | l % %mot}) in
            (if (nb_apparition = size(dico[n])) 
                sure_dans_mot_de[n] :add l
             else if (nb_apparition > 0) 
                apparait_dans_mot_de[n] :add l))),
    printf("Dictionnaire initialise.\n")]


[init_mot() : void  
 -> printf("Initialisation des mots et des lettres\n"),
    let manquent := alphabet in
      (for m in (1 .. nb_mot) 
         (M[m] := dico[longueur[m]],
          for l in apparait_dans_mot_de[longueur[m]] L[l] :add m,
          manquent := difference(manquent, sure_dans_mot_de[longueur[m]])),
       let_manquantes(rik) := manquent,
       for l in difference(alphabet, manquent), L[l] := {}),
    printf("Mots initialises.\n")]

[init_art() : void
 -> printf("Initialisation des articulations\n"), 
    for a in (1 .. nb_art)
        (A[a] := alphabet, articulations[mot1[a]] :add a, 
         articulations[mot2[a]] :add a),
    printf("Articulations initialisees.\n")]

[initialisation(grille:string, dictionnaire:string) : void
  -> load(grille),
     meilleur_score := 0,
     init?(rik) := true,
     init_grille(), 
     init_dico(dictionnaire), init_mot(), init_art(),
     init_fam(), 
     init?(rik) := false]

[simplification() : void 
  -> printf("Dbut de la simplification.\n"),
     maj_art(1),
     printf("Simplification faite.\n")]

[go() : void 
  -> initialisation("grande", "dico"), 
     simplification(), gc()]

;;
;; Description de l'etat actuel des recherches
;;
[complexite() : void
 -> printf("M : ~S~I\n", size(M[1]), 
           for m in (2 .. nb_mot) printf(".~S", size(M[m]))),
    printf("A : ~S~I\n", size(A[1]), 
           for a in (2 .. nb_art) printf(".~S", size(A[a])))]

[etat_dico() : void
  -> for n in (min_mot .. max_mot) 
        printf("dico[~S] = ~S\nsres : ~S, apparaissent : ~S\n\n",
             n, dico[n], sure_dans_mot_de[n], apparait_dans_mot_de[n])]

[etat_mot() : void
  -> for m in (1 .. nb_mot) printf("M[~S] (~S) : ~S\n", m, size(M[m]), M[m])]
[solution() : void
  -> printf("M[1]=~A~I\n", M[1][1], 
           for m in (2 .. nb_mot) printf(", M[~S]=~A", m, M[m][1]))]
[implications() : void
  -> for m in (1 .. nb_mot) printf("M[~S] => ~S\n", m, implications(m))]
[score(m:(1 .. nb_mot)) : integer -> list{score_mot[%mot] | %mot in M[m]}]

[etat_fam() : void
  -> for %fam in fam_vivantes(rik) printf("~S dans ~S\n", %fam, F[%fam])] 

[etat_art() : void
  -> for a in (1 .. nb_art) printf("A[~S] (~S) : ~S\n", a, size(A[a]), A[a])]

[etat_let() : void
 -> if let_manquantes(rik)
      (printf("Il me reste  trouver ~S, qui sont dans\n",let_manquantes(rik)),
       for l in let_manquantes(rik) printf("~S : ~S\n", l, L[l]))
    else printf("Contraintes sur les lettres verifiees\n")]

[etat() : void
 -> complexite(), etat_art(), etat_mot()]    

 


;;
;;  Propagation des contraintes sur les articulations
;;

;; Articulation impossible  satisfaire
[art_vide(a:(1 .. nb_art)) :: 
  A[a] = {}
  => error("Grille impossible : l'articulation ~S n'a pas de solution.\n", a)]

[maj_art(a:(1 .. nb_art)) : void
  -> let %let1 := {}, %let2 := {} in
       (for m in M[mot1[a]] 
            (if (m[pos1[a]] % A[a]) (%let1 :add m[pos1[a]])),
        for m in M[mot2[a]] 
            (if (m[pos2[a]] % A[a]) (%let2 :add m[pos2[a]])),
        if (%let1 ^ %let2 != A[a])
           (trace(SUIVI, "A[~S]=~S => ~S (impossibilites de mots)\n", 
                  a, A[a], %let1 ^ %let2),
	    A[a] := %let1 ^ %let2,
            if (%let1 != A[a]) maj_mot(mot1[a]),
            if (%let2 != A[a]) maj_mot(mot2[a])))]

[A_set(a:(1 .. nb_art), %let:set) : void
  -> if (A[a] != %let) 
           (A[a] := %let, maj_mot(mot1[a]), maj_mot(mot2[a]))]

[A_set(a: (1 .. nb_art), final:char) : void -> A_set(a, set(final))]



;;
;;  Propagation des contraintes sur les mots
;;

;; Regle sur impossibilite de mot
[mot_vide(m: (1 .. nb_mot)) ::
  size(M[m]) = 0
  => error("Grille impossible : le mot ~S n'a pas de solution.\n", m)]

;; Implications dues aux articulations
[maj_mot(m:(1 .. nb_mot)) : void
 -> let impossibles := {} in
    (for a in articulations[m]
       let %pos := (if (m = mot1[a]) pos1[a] else pos2[a]) in
          impossibles :U {mot in M[m] | not(mot[%pos] % A[a])},
     trace(SUIVI, "M[~S]=~S => ~S (Impossibilites d'articulations)\n",
           m, M[m], difference(M[m], impossibles)),
     M_moins(m, impossibles))]

;; Quel est le "degre" d'implication d'un mot (sur les articulations qu'il touche) ?
[implications(m:(1 .. nb_mot)) : integer
  -> let res := 1 in (for a in articulations[m] res :* size(A[a]), res)]

;; Un mot est libre si ses articulations sont figees, et aucune lettre manquante
;; n'y apparat
[mot_libre?(m:(1 .. nb_mot)) : boolean
  -> implications(m) = 1 & not({l in let_manquantes(rik) | m % L[l]})]


[meilleurs_scores(m:(1 .. nb_mot)) : list
  -> let %mots := list(M[m][1]), %score := score_mot[M[m][1]] in
      (for s in cdr(M[m]) 
         (if (score_mot[s] < %score) return(%mots) else %mots :add s),
       %mots)]

[maj_meilleurs_scores(m:(1 .. nb_mot)) : void
 -> let best := meilleurs_scores(m) in
      (trace(SUIVI, "M[~S]=~S est libre, je le reduis  ~S, ses meilleurs scores\n",
            m, M[m], best),
       M_set(m, best))]

[M_set(m: (1 .. nb_mot), final:list) : void
 -> if (final != M[m])
      (;; on supprime les apparitions des familles des mots disparus
       for mot in difference(M[m], set!(final))
          F[famille[mot]] := {m' in F[famille[mot]] | m != m'},
       M[m] := final
       ,
       ;; si tous les mots sont de la meme famille, on la supprime ailleurs
       if meme_famille(M[m]) maj_fam(m),
       ;; mise  jour des contraintes sur les lettres
       maj_let(m),
       ;; mise  jour des articulations touchees
       for a in articulations[m] maj_art(a),
       ;; simplification si possible aux seuls meilleurs scores
       if mot_libre?(m) maj_meilleurs_scores(m)
       )]


[M_set(m: (1 .. nb_mot), final:string) : void -> M_set(m, list(final))]
[M_moins(m: (1 .. nb_mot), impossibles:set) : void 
  -> M_set(m, difference(M[m], impossibles))]



;;
;; Propagation des contraintes sur les familles
;; 

;; Mise en place du reperage des familles
[init_fam() : void
  -> printf("Initialisation des contraintes de famille.\n"),
     let les_familles := {} in
       (for m in (1 .. nb_mot) for %mot in M[m]
          (F[famille[%mot]] :add m, les_familles :add famille[%mot]),
        fam_vivantes(rik) := {f in les_familles | size(F[f]) > 1},
        for f in les_familles (if (size(F[f]) <= 1) F[f] := {})),
     printf("Contraintes de famille initialisees.\n")]

[meme_famille(mots:list) : boolean -> set!(mots) <= famille[mots[1]]]

;; On a detecte qu'en m, il n'y a plus qu'une seule famille : 
;; on retire toutes les autres apparitions de cette famille.
[maj_fam(m:(1 .. nb_mot)) : void
  -> let f := famille[M[m][1]], autres_membres := {f' in F[f] | f' != m} in 
       (for m' in autres_membres 
           (trace(DEBUG, "autres membres : ~S\n", autres_membres),
            ;; m' contient un membre de la famille f : on supprime m' qui est bloqu
            M_moins(m', f)), 
        ;; on ne cherche plus  suivre la famille f
        fam_vivantes(rik) :delete f, F[f] := {})]





;;
;;   Propagation des contraintes sur les lettres
;;

;; Regle d'impossibilite sur lettres manquantes
[let_vide(l:char, r:etat_rech) ::
  L[l] = {} & l % let_manquantes(r)
  => error("Grille impossible : pas de possibilites de placer la lettre~S\n", l)]

;; Regle de reduction des possibilites sur exigeance de lettres
[L_reduction(l:char, r:etat_rech) ::
  init?(r) = false & size(L[l]) = 1 
  => trace(SUIVI, "M[~S]=~S => ~S (contrainte de lettre (~A)).\n",
                  L[l][1], M[L[l][1]], list{%mot in M[L[l][1]] | l % %mot}, l),
     M_set(L[l][1], list{%mot in M[L[l][1]] | l % %mot}),
     let_manquantes(r) := {%l in let_manquantes(r) | %l != l}]

;; On regarde ce qu'il advient des lettres manquantes
[maj_let(m:(1 .. nb_mot)) : void
 -> let let_sures := {}, nest_plus_en_m := {} in
     (;; on cherche si les mots retenus pour m rendent des lettres sres
      ;; ou si des lettres manquantes n'apparaissent plus
      for l in let_manquantes(rik)
         (let nb_apparition := size({%mot in M[m] | l % %mot}) in
            (if (nb_apparition = 0) nest_plus_en_m :add l
             else if (nb_apparition = size(M[m])) let_sures :add l)),
      let_manquantes(rik) := difference(let_manquantes(rik), let_sures),
      for l in nest_plus_en_m L[l] := {m' in L[l] | m' != m})]



;;
;;  Calculs des scores
;;

;; Le score retourne, s'il reste des indeterminations, est le meilleur possible 
[score() : integer
  -> let best := 0, %A_classe := list() in
       (for m in (1 .. nb_mot) best :+ score_mot[M[m][1]],
        for a in (1 .. nb_art) 
            (%A_classe := A_classe(a),
             best :- score_let[%A_classe[size(%A_classe)]]),
        best)]

[score>=(s1:string, s2:string) : boolean -> score_mot[s1] >= score_mot[s2]]




;;
;;  Raisonnements hypothetiques sur les mots
;;

;; Le prochain pivot est le mot avec le plus grand degre de liberte
[prochain_pivot_mot() : (1 .. nb_mot)
 -> let %plus_gd := 1, %degre := 1 in
      (for m in (1 .. nb_mot) 
          (if (size(M[m]) > %degre) (%degre := size(M[m]), %plus_gd := m)),
       if (%degre = 1) 0 else %plus_gd)]

[essayer_mot(m:(1 .. nb_mot), s:string) : void
  -> trace(SUIVI, "J'essaie, en fixant M[~S]  ~S\n", m, s),
     M_set(m, s),
     trace(SUIVI, "score => ~S\n", score()),
     if (score() < meilleur_score) ;; Mettre <= ou <
        error("J'arrte : je ne peux plus pretendre  meilleur score.")]

;; Recherche, mots en premier
[rech_mot(message:string) : void
  -> let m := prochain_pivot_mot() in
       (if (m > 0)
           (for s in M[m]
             (world+(),
              try
                (essayer_mot(m, s),
                 print_in_string(), printf("~AM[~S] = ~A, ", message, m, s),
                 rech_mot(end_of_string()))
              catch error 
                 trace(SUIVI, "Backtracking (~S) :\n~A\n", meilleur_score, message),
              world-(), nb_backtrack :+ 1)) 
        else 
            (printf("\n~A\nscore : ~S, ~S backtracks, ~S decisions\n~I\n", message, 
                    score(), nb_backtrack, world?(), solution()),
             if (meilleur_score < score()) meilleur_score := score()))]

[recherche_sur_mot() : boolean -> rech_mot("")]


;;
;;  Raisonnements hypothetiques sur les articulations
;;

;; classement des lettres dans l'ordre de score
[A_classe(a:(1 .. nb_art)) : list[char] -> list{c in ordre_score | c % A[a]}]

;; Retourne l'articulation qui est la moins determinee
[prochain_pivot_art() : (1 .. nb_art)
 -> let %plus_gd := 1, %degre := 1 in
      (for a in (1 .. nb_art) 
          (if (size(A[a]) > %degre) (%degre := size(A[a]), %plus_gd := a)),
       if (%degre = 1) 0 else %plus_gd)]

[essayer_art(a:(1 .. nb_art), c:char) : void
  -> trace(SUIVI, "J'essaie, en fixant A[~S]  ~S\n", a, c),
     A_set(a, c),
     trace(SUIVI, "score => ~S\n", score()),
     if (score() <= meilleur_score) 
        error("J'arrte : je ne peux plus pretendre  un meilleur score.")]

;;
;; Recherche sur articulations en premiers pivots
;;
[rech_art(message:string) : void
  -> let a := prochain_pivot_art() in
       (if (a > 0)
          (for c in A_classe(a)
            (world+(),
             try
               (essayer_art(a, c),
                print_in_string(), printf("~AA[~S] = ~A, ", message, a, c),
                rech_art(end_of_string()))
             catch error 
                trace(SUIVI, "Backtracking: (~S):\n~A\n", meilleur_score, message),
             world-(), nb_backtrack :+ 1))
        else rech_mot(message))]

[recherche_sur_art() : boolean -> rech_art("")]





