/****************************************************************************/
/*  video  version 0.25                                                     */
/*                                                                          */
/* program to access the video-blaster and compatible cards                 */
/* for the GNU djgpp/gcc compiler                                           */
/*                                                                          */
/* (C)1994/97 Bernhard Schwall                                              */
/*                                                                          */
/* version 0.1                                                              */
/*    show the video under dos and linux and control the sound              */
/*    (on Media Pro Plus)                                                   */
/*                                                                          */
/* version 0.2                                                              */
/*   save and load single pictures in .TGA format                           */
/*                                                                          */
/* version 0.21                                                             */
/*   grayscale software video without saving and loading                    */
/*                                                                          */
/* version 0.22                                                             */
/*   renamed to vid_bw.c because of problems with DOS                       */
/*                                                                          */
/* version 0.23                                                             */
/*   added timer_m to run vid_bw under DOS and Linux                        */
/*                                                                          */
/* version 0.24                                                             */
/*   memory access changed                                                  */
/*                                                                          */
/* version 0.25                                                             */
/*   color display                                                          */
/****************************************************************************/

#include "v_access.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#ifdef linux
#include <time.h>
#include <vga.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <stdlib.h>
#else
#include <dos.h>
#include <pc.h>
#include <math.h>
#endif
#include "timer_m.h"

#define min(a,b) ((a) < (b) ? (a) : (b))
#define max(a,b) ((a) > (b) ? (a) : (b))

int XOff, YOff;
int uTab[256], vTab[256];

/****************************************************************************/

void init_grey(){
int i,f;
#ifndef linux
  union REGS ireg, oreg;
#endif

  for (i=0; i<64; i++){
    f = i+4;
    if (f>63) f = 63;
#ifdef linux
    vga_setpalette(i, f, f, f);
#else
    ireg.x.ax = 0x1010;
    ireg.x.bx = i;
    ireg.h.cl = f;
    ireg.h.ch = f;
    ireg.h.dh = f;
    int86(0x10, &ireg, &oreg);
#endif
  }
}

/****************************************************************************/

void init_color(){
int i, r, g, b;
#ifndef linux
  union REGS ireg, oreg;
#endif

  for (r=0; r<8; r++){
    for (g=0; g<8; g++){
      for (b=0; b<4; b++){
        i = (r << 5) | (g << 2) | b;
#ifdef linux
        vga_setpalette(i, r << 3, g << 3, b << 4);
#else
       ireg.x.ax = 0x1010;
       ireg.x.bx = i;
       ireg.h.cl = (b << 3) | 7;
       ireg.h.ch = (g << 3) | 7;
       ireg.h.dh = (r << 3) | 7;
       int86(0x10, &ireg, &oreg);
#endif
      }
    }
  }
}

#ifndef linux
void vga_clear(){
  memset((char *)0xe00a0000, 0, 64000);
}
#endif

/****************************************************************************/

void init(){

#ifndef linux
  union REGS ireg, oreg;
#endif
  int i;

#ifdef linux
  vga_disabledriverreport();
  vga_init();
  vga_setmode(G320x200x256);
#else
  ireg.x.ax = 0x13;
  int86(0x10, &ireg, &oreg);
#endif
  init_color();
  V_Initialize("", 1);

  for (i=-128; i<128; i++){
    uTab[i+128] = (i * 226) / 127;
    vTab[i+128] = (i * 179) / 127;
  }
}

/****************************************************************************/

void done(){
#ifdef linux
  vga_setmode(TEXT);
#else
  union REGS ireg, oreg;

  ireg.x.ax = 0x03;
  int86(0x10, &ireg, &oreg);
#endif
  V_Exit();
}

/****************************************************************************/

void YUVtoRGB(char *InBuffer, char *OutBuffer, int Pixel)
/* read a line from the card and convert it to RGB 24 bit */
{
  BYTE *src=InBuffer;
  INT  z, r, g, b, u, v, y[4], *yz, count=1;
  signed char uBild, vBild;

  do{
    y[0] = (*src++ & 0xfe) | 1;
    uBild = *src & 0xc0;
    vBild = (*src++ & 0x30) << 2;
    y[1] = (*src++ & 0xfe) | 1;
    uBild |= (*src & 0xc0) >> 2;
    vBild |= (*src++ & 0x30);
    y[2] = (*src++ & 0xfe) | 1;
    uBild |= (*src & 0xc0) >> 4;
    vBild |= (*src++ &0x30) >> 2;
    y[3] = (*src++ & 0xfe) | 1;
    uBild |= (*src & 0xc0) >> 6;
    vBild |= (*src++ & 0x30) >> 4;

    u = (uBild * 226) / 127;
    v = (vBild * 179) / 127;

    yz = y;
    for (z=0; z<4; z++){
      r = max(min(*yz+v, 255), 0);
      b = max(min(*yz+u, 255), 0);
      g = ((*yz*436L) >> 8) - ((r*130U) >> 8) - ((b*50U) >> 8);
      if (g<0) g = 0;
      else
        if (g>255) g = 255;
      *OutBuffer++ = (r & 0xe0) | ((g >> 3) & 0x1c) | (b >> 6);
      yz++;
    }
  } while ((count += 4) < Pixel);
}

/***************************************************************************/

void Display_video(char *Buffer, int SizeX, int SizeY, char *Screen,
                   int Quality){
  int x,y;
  BYTE *src;
  BYTE *dest=(BYTE *)Buffer;
  BYTE Line[2048];
    
  V_FreezeVideo();
  src = VidMem;
  x = SizeX*2;
  for (y=0; y<SizeY; y++){
    memmove(dest, src, x);
    dest+= x;
    src += 2048L;
  }
  V_UnfreezeVideo();
  if (Quality == 0){
    src = Buffer;
    for (y=0; y<SizeY; y++){
      dest = Line;
      for (x=0; x<SizeX; x++){
        *dest++ = *src >> 2;
        src += 2;
      }
#ifdef linux
      vga_drawscansegment(Line, XOff, y+YOff, SizeX);
#else
      memmove(Screen, Line, SizeX);
      Screen += 320;
#endif
    }
  }
  else{
    for (y=0; y<SizeY; y++){
      YUVtoRGB(Buffer, Line, SizeX);
#ifdef linux
      vga_drawscansegment(Line, XOff, y+YOff, SizeX);
#else
      memmove(Screen, Line, SizeX);
      Screen += 320;
#endif
      Buffer += SizeX*2;
    }
  }
}

/**************************************************************************/

int main(int argc, char *argv[])
{
  char ch = 0;
  int Mute = 0;
  int Volume;
  int XRes, YRes;
  int Freeze = 0;
  char *Screen;
  char *Buffer;
  unsigned long time1, time2, time3;
  long Count=0;
  int Quality = 1;

  init(); 

  Volume = V_GetVolume();
  V_CreateWindow(0,0,XRes=320,YRes=200); 
  XOff = 0;
  YOff = 0;
#ifdef linux
  Screen=(char *)graph_mem;
#else
  Screen=(char *)((0xe00a0000+320*YOff)+XOff);
#endif

  V_DisableVideo();
  Buffer=(char *)malloc(XRes*YRes*4);
  InitializeTimer();

  do {
    time1=ReadTimer();
#ifdef linux
    while ((ch=vga_getkey()) == 0){
#else
    while (kbhit() == 0){
#endif
      if (Freeze == 0){
        time3 = ReadTimer();
        Display_video(Buffer, XRes, YRes, Screen, Quality);
        Count++;
        switch (XRes){
        case 320:  while ((ReadTimer()-time3) < 
                          (unsigned long)(CLOCKS_PER_SEC/8));
                   break;
        case 240:  while ((ReadTimer()-time3) < 
                          (unsigned long)(CLOCKS_PER_SEC/12));
                   break;
        case 160:  while ((ReadTimer()-time3) < 
                          (unsigned long)(CLOCKS_PER_SEC/16));
                   break;
        }
      }
    }
#ifndef linux
    ch = getkey();
#endif
    time2=ReadTimer()-time1;
    switch (ch){
    case 's': Freeze ^= 1;
              break;
    case '2': 
#ifdef linux
              printf("%ix%i: %i Bilder, nearly. %f frames per second\n",
                 XRes, YRes, (int)Count,
                 (float)Count/((float)time2/100));
#endif
              V_CreateWindow(0,0,XRes=320,YRes=200); 
              V_DisableVideo();
              Count = 0;
              XOff = 0;
              YOff = 0;
#ifndef linux
              Screen=(char *)((0xe00a0000+320*YOff)+XOff);
#endif
              vga_clear();
              break;
    case '3': 
#ifdef linux
              printf("%ix%i: %i frames, nearly. %f frames per second\n",
                 XRes, YRes, (int)Count,
                 (float)Count/((float)time2/100));
#endif
              V_CreateWindow(0,0,XRes=240,YRes=150); 
              V_DisableVideo();
              Count = 0;
              XOff = 40;
              YOff = 25;
#ifndef linux
              Screen=(char *)((0xe00a0000+320*YOff)+XOff);
#endif
              vga_clear();
              break;
    case '4': 
#ifdef linux
              printf("%ix%i: %i frames, nearly %f frames per second\n",
                 XRes, YRes, (int)Count,
                 (float)Count/((float)time2/100));
#endif
              V_CreateWindow(0,0,XRes=160,YRes=100); 
              V_DisableVideo();
              Count = 0;
              XOff = 80;
              YOff = 50;
#ifndef linux
              Screen=(char *)((0xe00a0000+320*YOff)+XOff);
#endif
              vga_clear();
              break;
    case 'l': Volume += 8;
              if (Volume > 255) Volume = 255;
              V_SetVolume(Volume);
              break;
    case 'q': Volume -= 8;
              if (Volume < 0) Volume = 0;
              V_SetVolume(Volume);
              break;
    case '+': Volume += 2;
              if (Volume > 255) Volume = 255;
              V_SetVolume(Volume);
              break;
    case '-': Volume -= 2;
              if (Volume < 0) Volume = 0;
              V_SetVolume(Volume);
              break;
    case 'm': if (Mute == 0){
                Mute = Volume;
                V_SetVolume(0);
              }
              else {
                V_SetVolume(Mute);
                Mute = 0;
              }
              break;
    case 'b': if (Quality == 0){
#ifdef linux
                printf("%ix%i: %i frames, nearly %f frames per second\n",
                        XRes, YRes, (int)Count,
                        (float)Count/((float)time2/100));
#endif
                Count = 0;
                Quality = 1;
                init_color();
              }
              else{
#ifdef linux
                printf("%ix%i: %i frames, nearly %f frames per second\n",
                        XRes, YRes, (int)Count,
                        (float)Count/((float)time2/100));
#endif
                Count = 0;
                Quality = 0;
                init_grey();
              }
              break;
    }
  } while (ch != 27);
  done();
  free(Buffer);
  printf("%iX%i: %i pictures, nearly %f frames per second\n",
          XRes, YRes, (int)Count, 
          (float)Count/((float)time2/CLOCKS_PER_SEC));
  RestoreTimer();
  return 0;
}
