/* routine for reading the time in millisseconds
   based on TIMER.C, version 1.2  11.Dez 1991 by
   David Kirschbaum
   Toad Hall
   rewritten for GNU GCC by
   Bernhard Schwall 24.Jan.1994
*/

#ifdef linux
#include <time.h>
#else
#include <pc.h>
#endif

#ifdef linux
void InitializeTimer(){
}

void RestoreTimer(){
}

unsigned long ReadTimer(){
  return (unsigned long)clock();
}

#else /* DOS */
void InitializeTimer(){
  outportb(0x43,0x34);
  outportb(0x40,0x00);
  outportb(0x40,0x00);
}

void RestoreTimer(){
  outportb(0x43,0x36);
  outportb(0x40,0x00);
  outportb(0x40,0x00);
}

unsigned long ReadTimer(){
unsigned char b1,b2;
unsigned short w1,w2;

  asm("cli"
  :
  :);
  outportb(0x20,0x0a);
  outportb(0x43,0x00);
  b1 = inportb(0x20);
  w1 = inportb(0x40);
  w1 += ((unsigned short)inportb(0x40)) << 8;
  w1 ^= 0xffff;
  b2 = inportb(0x21);
  outportb(0x21,0xff);
  w2 = *((unsigned short *)0xe000046c);
  outportb(0x21,b2);
  asm("sti"
        :
        :);
  if (b1==1){
    if (w1 <= 0xff) w2++;
  }
  return ((((unsigned long)w2) << 16)+w1)/1000;
}
#endif
