/* includefile for RECORD.C  version 0.1

   taken from avi2yuv.h
*/

#ifndef _RECORD_H
#define _RECORD_H

/* some usefull types */

typedef signed long    LONG;
typedef unsigned char  uCHAR;
typedef signed char    sCHAR;
typedef unsigned long  FOURCC;             /* Type of FOUR Character Codes */

enum AVI_TYPE {YVU9, RGB24};

/* Macro to convert expressions of form 'F','O','U','R' to
   numbers of type FOURCC: */

#define MAKEFOURCC(a,b,c,d) ( ((DWORD)a)      | (((DWORD)b)<< 8) | \
                             (((DWORD)c)<<16) | (((DWORD)d)<<24)  )

/* The only FOURCCs interpreted by this program: */

#define RIFFtag MAKEFOURCC('R','I','F','F')
#define LISTtag MAKEFOURCC('L','I','S','T')
#define JUNKtag MAKEFOURCC('J','U','N','K')
#define AVItag  MAKEFOURCC('A','V','I',' ')
#define hdrltag MAKEFOURCC('h','d','r','l')
#define avihtag MAKEFOURCC('a','v','i','h')
#define strltag MAKEFOURCC('s','t','r','l')
#define strhtag MAKEFOURCC('s','t','r','h')
#define strftag MAKEFOURCC('s','t','r','f')
#define movitag MAKEFOURCC('m','o','v','i')
#define rectag  MAKEFOURCC('r','e','c',' ')
#define vidstag MAKEFOURCC('v','i','d','s')
#define Tag00db MAKEFOURCC('0','0','d','b')
#define Tag00dc MAKEFOURCC('0','0','d','c')
#define Tag01wb MAKEFOURCC('0','1','w','b')

/* possible video formats */
#define TagMJPG MAKEFOURCC('M','J','P','G')
#define Tagmjpg MAKEFOURCC('m','j','p','g')
#define TagDIB  MAKEFOURCC('D','I','B',' ')
#define TagRGB  MAKEFOURCC('R','G','B',' ')
#define TagYVU9 MAKEFOURCC('Y','V','U','9')

/* structs of the AVI header */

typedef struct {
  FOURCC fccID;
  DWORD  dwSize;
  FOURCC fccType;
} tChunkHeader;

typedef struct {
  FOURCC fccID;
  DWORD  dwSize;
  DWORD  dwMicroSecPerFrame;
  DWORD  dwMaxBytesPerSec;
  DWORD  dwReserved1;
  DWORD  dwFlags;
  DWORD  dwTotalFrames;
  DWORD  dwInitialFrames;
  DWORD  dwStreams;
  DWORD  dwSuggestedBufferSize;
  DWORD  dwWidth;
  DWORD  dwHeight;
  DWORD  dwReserved2a;
  DWORD  dwReserved2b;
  DWORD  dwReserved2c;
  DWORD  dwReserved2d;
} tMainAVIHeader;

typedef struct {
  FOURCC fccID;
  DWORD  dwSize;
  FOURCC fccType;
  FOURCC fccHandler;
  DWORD dwFlags;
  DWORD dwReserved1;
  DWORD dwInitialFrames;
  DWORD dwScale;
  DWORD dwRate;
  DWORD dwStart;
  DWORD dwLength;
  DWORD dwSuggestedBufferSize;
  DWORD dwQuality;
  DWORD dwSampleSize;
  DWORD dwReserved2;
  WORD  wSizeX;
  WORD  wSizeY;
} tAVIStreamHeader;

typedef struct {
  FOURCC fccID;
  DWORD  dwSize;
  DWORD biSize;
  LONG  biWidth;
  LONG  biHeight;
  WORD  biPlanes;
  WORD  biBitCount;
  DWORD biCompression;
  DWORD biSizeImage;
  LONG  biXPelsPerMeter;
  LONG  biYPelsPerMeter;
  DWORD biClrUsed;
  DWORD biClrImportant;
} tBitmapInfoHeader;

typedef struct {
  FOURCC fccID;
  DWORD  dwSize;
} tMovieHeader;

#endif
