/****************************************************************************/
/*  record  version 0.2                                                     */
/*                                                                          */
/* program to record AVIs with the video-blaster and compatible cards       */
/* for the GNU djgpp/gcc compiler                                           */
/*                                                                          */
/* (C)1994/97 Bernhard Schwall                                              */
/*                                                                          */
/* version 0.1                                                              */
/* version 0.2                                                              */
/*   optionaly write RGB24 AVI                                              */
/****************************************************************************/

#include "v_access.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#ifdef linux
#include <time.h>
#include <vga.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <stdlib.h>
#else
#include <dos.h>
#include <pc.h>
#include <math.h>
#endif
#include "timer_m.h"
#include "record.h"

#define min(a,b) ((a) < (b) ? (a) : (b))
#define max(a,b) ((a) > (b) ? (a) : (b))

int XOff, YOff, XRes, YRes;
int VidCount;
int VidFPS;
unsigned long VidWait;
BYTE **Video;
enum AVI_TYPE AVIType;

/****************************************************************************/

void init_grey(){
int i,f;
#ifndef linux
  union REGS ireg, oreg;
  int j;
#endif

  for (i=0; i<64; i++){
    f = i+4;
    if (f>63) f = 63;
#ifdef linux
    vga_setpalette(i<<2, f, f, f);
    vga_setpalette((i<<2)+1, f, f, f);
    vga_setpalette((i<<2)+2, f, f, f);
    vga_setpalette((i<<2)+3, f, f, f);
#else
    for (j=0; j<4; j++){
      ireg.x.ax = 0x1010;
      ireg.x.bx = (i<<2)+j;
      ireg.h.cl = f;
      ireg.h.ch = f;
      ireg.h.dh = f;
      int86(0x10, &ireg, &oreg);
    }
#endif
  }
}

/****************************************************************************/

void init(){

#ifndef linux
  union REGS ireg, oreg;
#endif
  int i;

#ifdef linux
  vga_disabledriverreport();
  vga_init();
  vga_setmode(G320x240x256);
#else
  ireg.x.ax = 0x13;
  int86(0x10, &ireg, &oreg);
#endif
  init_grey();
  V_Initialize("", 1);
  
  Video = (BYTE **)malloc((sizeof(BYTE *)) * VidCount);
  for (i=0; i<VidCount; i++){
    if (AVIType == YVU9) {
      Video[i] = (BYTE *)malloc(XRes*YRes+(XRes >> 2)*(YRes >> 2)*2);
    }
    else {
      Video[i] = (BYTE *)malloc(XRes*YRes+(XRes >> 2)*YRes*2);
    }
  }
}

/****************************************************************************/

void done(){
  int i;
#ifdef linux
  vga_setmode(TEXT);
#else
  union REGS ireg, oreg;

  ireg.x.ax = 0x03;
  int86(0x10, &ireg, &oreg);
#endif
  V_Exit();
  
  for (i=0; i<VidCount; i++){
    free(Video[i]);
  }
  free(Video);
}

/***************************************************************************/

void Display_video(char *Buffer, char *Screen){
  int x,y;
  BYTE *src;
  BYTE *dest=(BYTE *)Buffer;
  BYTE Line[320];
    
  src = VidMem;
  x = XRes*2;
  V_FreezeVideo();
  for (y=0; y<YRes; y++){
    memmove(dest, src, x);
    dest+= x;
    src += 2048L;
  }
  V_UnfreezeVideo();
  src = Buffer;
  for (y=0; y<YRes; y++){
    dest = Line;
    for (x=0; x<XRes; x++){
      *dest++ = *src;
      src += 2;
    }
#ifdef linux
    vga_drawscansegment(Line, XOff, y+YOff, XRes);
#else
    memmove(Screen, Line, XRes);
    Screen += 320;
#endif
  }
}

/**************************************************************************/

void display_frame(char *Buffer, char *Screen)
{
  int y;
  for (y=0; y<YRes; y++){
#ifdef linux
    vga_drawscansegment(Buffer, XOff, y+YOff, XRes);
#else
    memmove(Screen, Buffer, XRes);
    Screen += 320;
#endif
    Buffer += XRes;
  }
}

/**************************************************************************/

void record(char *Buffer)
{
  int count;
  int x,y;
  BYTE *src;
  BYTE *dest;
  unsigned long time1;
  char *YBuf;
  signed char *UBuf, *VBuf;
  signed char uBild, vBild;
  int ULine[80], VLine[80];
  
  for (count=0; count<VidCount; count++){
    time1 = ReadTimer();
    dest = Buffer;
    src = VidMem;
    x = XRes * 2;
    V_FreezeVideo();
    for (y=0; y<YRes; y++){
      memmove(dest, src, x);
      dest+= x;
      src += 2048L;
    }
    V_UnfreezeVideo();
    src = Buffer;
    YBuf = Video[count];
    VBuf = YBuf+XRes*YRes;
    if (AVIType == YVU9) {
      UBuf = VBuf+(XRes >> 2)*(YRes >> 2);
    }
    else{
      UBuf = VBuf+(XRes >> 2)*YRes;
    }
    memset(ULine, 0, sizeof(ULine));
    memset(VLine, 0, sizeof(VLine));
    for (y=0; y<YRes; y++){
      for (x=0; x<(XRes >> 2); x++){
        *YBuf++ = *src++ | 1;
        uBild = *src & 0xc0;
        vBild = (*src++ & 0x30) << 2;
        *YBuf++ = *src++ | 1;
        uBild |= (*src & 0xc0) >> 2;
        vBild |= (*src++ & 0x30);
        *YBuf++ = *src++ | 1;
        uBild |= (*src & 0xc0) >> 4;
        vBild |= (*src++ &0x30) >> 2;
        *YBuf++ = *src++ | 1;
        uBild |= (*src & 0xc0) >> 6;
        vBild |= (*src++ & 0x30) >> 4;
        if (AVIType == YVU9){
          if ((y % 4) == 3){
            *UBuf++ = ((ULine[x]+uBild) >> 2) + 128;
            *VBuf++ = ((VLine[x]+vBild) >> 2) + 128;
            ULine[x] = VLine[x] = 0;
            
          }
          else{
            ULine[x] += uBild;
            VLine[x] += vBild;
          }
        }
        else {
          *UBuf++ = uBild;
          *VBuf++ = vBild;
        }
      }  
    }
    do {
    } while ((ReadTimer()-time1) < VidWait);
  }
}

/**************************************************************************/

void play(char *Buffer, char *Screen)
{
  int count;
  unsigned long time1;

  V_FreezeVideo();
  for (count=0; count <VidCount; count++){
    time1 = ReadTimer();
    display_frame(Video[count], Screen);
    do {
    } while ((ReadTimer()-time1) < VidWait);
  }
}

/**************************************************************************/


void writeAVI(char *Name)
{
   tMainAVIHeader    MainAVIHeader;
   tAVIStreamHeader  AVIStreamHeader;
   tBitmapInfoHeader BitmapInfoHeader;
   tMovieHeader      MovieHeader;
   tChunkHeader      ChunkHeader;
   FILE *f;
   int i, UVsize, u, v, x, y, z, r, g, b;
   signed char *UBuf, *VBuf;
   unsigned char *YBuf, *BGRBuf;
   unsigned char Buffer[0x0800];
   long BufferSize;
   
   if ((f = fopen(Name, "wb")) == NULL) {
     return;
   }
   
   if (AVIType == YVU9){
     UVsize = (XRes >> 2) * (YRes >> 2) * 2;
   }
   else {
     UVsize = XRes*YRes*2;
   }
   ChunkHeader.fccID   = RIFFtag;
   ChunkHeader.dwSize  = 0;
   ChunkHeader.fccType = AVItag;
   fwrite(&ChunkHeader, sizeof(ChunkHeader), 1, f);
   
   ChunkHeader.fccID   = LISTtag;
   ChunkHeader.dwSize  = 4+sizeof(MainAVIHeader)+sizeof(ChunkHeader)+
                         sizeof(AVIStreamHeader)+sizeof(BitmapInfoHeader);
   ChunkHeader.fccType = hdrltag;
   fwrite(&ChunkHeader, sizeof(ChunkHeader), 1, f);
   
   MainAVIHeader.fccID = avihtag;
   MainAVIHeader.dwSize = sizeof(MainAVIHeader)-8;
   MainAVIHeader.dwMicroSecPerFrame = (DWORD)((1000000 << 1) / VidFPS);
   MainAVIHeader.dwMaxBytesPerSec = ((XRes*YRes+UVsize)*VidFPS) >> 1;
   MainAVIHeader.dwReserved1 = 0;
   MainAVIHeader.dwFlags = 0;
   MainAVIHeader.dwTotalFrames = VidCount;
   MainAVIHeader.dwInitialFrames = 0;
   MainAVIHeader.dwStreams = 1;
   MainAVIHeader.dwSuggestedBufferSize = (XRes*YRes+UVsize);
   MainAVIHeader.dwWidth = XRes;
   MainAVIHeader.dwHeight = YRes;
   MainAVIHeader.dwReserved2a = 0;
   MainAVIHeader.dwReserved2b = 0;
   MainAVIHeader.dwReserved2c = 0;
   MainAVIHeader.dwReserved2d = 0;
   fwrite(&MainAVIHeader, sizeof(MainAVIHeader), 1, f);

   ChunkHeader.fccID   = LISTtag;
   ChunkHeader.dwSize  = sizeof(AVIStreamHeader)+sizeof(BitmapInfoHeader)+4;
   ChunkHeader.fccType = strltag;
   fwrite(&ChunkHeader, sizeof(ChunkHeader), 1, f);
   
   AVIStreamHeader.fccID = strhtag;
   AVIStreamHeader.dwSize = sizeof(AVIStreamHeader)-8;
   AVIStreamHeader.fccType = vidstag;
   if (AVIType == YVU9){
     AVIStreamHeader.fccHandler = TagYVU9;
   }
   else{
     AVIStreamHeader.fccHandler = TagDIB;
   }
   AVIStreamHeader.dwFlags = 0;
   AVIStreamHeader.dwReserved1 = 0;
   AVIStreamHeader.dwInitialFrames = 0;
   AVIStreamHeader.dwScale = (DWORD)((1000000 << 1) / VidFPS);
   AVIStreamHeader.dwRate = 1000000;
   AVIStreamHeader.dwStart = 0;
   AVIStreamHeader.dwLength = VidCount;
   AVIStreamHeader.dwSuggestedBufferSize = (XRes*YRes+UVsize);
   AVIStreamHeader.dwQuality = 10000;
   AVIStreamHeader.dwSampleSize = (XRes*YRes+UVsize);
   AVIStreamHeader.dwReserved2 = 0;
   AVIStreamHeader.wSizeX = XRes;
   AVIStreamHeader.wSizeY = YRes;
   fwrite(&AVIStreamHeader, sizeof(AVIStreamHeader), 1, f);
   
   BitmapInfoHeader.fccID = strftag;
   BitmapInfoHeader.dwSize = sizeof(BitmapInfoHeader)-8;
   BitmapInfoHeader.biSize = sizeof(BitmapInfoHeader)-8;
   BitmapInfoHeader.biWidth = XRes;
   BitmapInfoHeader.biHeight = YRes;
   BitmapInfoHeader.biPlanes = 1;
   BitmapInfoHeader.biBitCount = 24;
   if (AVIType == YVU9){
     BitmapInfoHeader.biCompression = TagYVU9;
   }
   else{
     BitmapInfoHeader.biCompression = 0; /* BI_RGB */
   }
   BitmapInfoHeader.biSizeImage = XRes*YRes*3;
   BitmapInfoHeader.biXPelsPerMeter = 0;
   BitmapInfoHeader.biYPelsPerMeter = 0;
   BitmapInfoHeader.biClrUsed = 0;
   BitmapInfoHeader.biClrImportant = 0;
   fwrite(&BitmapInfoHeader, sizeof(BitmapInfoHeader), 1, f);
   
   fflush(f);
   BufferSize = 0x800-ftell(f)- 8/*JUNK*/ - 12/*movi*/;
   MovieHeader.fccID = JUNKtag;
   MovieHeader.dwSize = BufferSize;
   fwrite(&MovieHeader, sizeof(MovieHeader), 1, f);
   memset(Buffer, 0, BufferSize);
   fwrite(Buffer, BufferSize, 1, f);
   
   ChunkHeader.fccID   = LISTtag;
   ChunkHeader.dwSize  = (sizeof(MovieHeader)+
                          (XRes*YRes+UVsize)
                         )*VidCount+4;
   ChunkHeader.fccType = movitag;
   fwrite(&ChunkHeader, sizeof(ChunkHeader), 1, f);

   MovieHeader.fccID = Tag00db;
   MovieHeader.dwSize  = (XRes*YRes+UVsize);
   for (i=0; i<VidCount; i++){
     if (AVIType == YVU9){
       fwrite(&MovieHeader, sizeof(MovieHeader), 1, f);
       fwrite(Video[i], XRes*YRes+UVsize, 1, f);
     }
     else{
       fwrite(&MovieHeader, sizeof(MovieHeader), 1, f);
       /* picture is saved bottom up */
       YBuf = Video[i]+XRes*(YRes-1);
       VBuf = Video[i]+XRes*YRes+(XRes >> 2)*(YRes-1);
       UBuf = VBuf+(XRes >> 2)*YRes;
       for (y=0; y<YRes; y++){
         BGRBuf = Buffer;
         for (x=0; x<(XRes >> 2); x++){
           u = ((*UBuf++) * 226) / 127;
           v = ((*VBuf++) * 179) / 127;
           for (z=0; z<4; z++){
             if ((r = (*YBuf) + v) < 0) r = 0;
             else
               if (r > 255) r = 255;
             if ((b = (*YBuf) + u) < 0) b = 0;
             else
               if (b > 255) b = 255;
             g = (((*YBuf)*436L) >> 8) - ((r*130U) >> 8) - ((b*50U) >> 8);
             if (g < 0) g = 0;
             else
               if (g > 255) g = 255;
             *BGRBuf++ = b;
             *BGRBuf++ = g;
             *BGRBuf++ = r;
             YBuf++;
           } /* next z */
         } /* next x */
         fwrite(Buffer, XRes*3, 1, f);
         YBuf -= (XRes*2);
         UBuf -= (XRes >> 1);
         VBuf -= (XRes >> 1);
       } /* next y */
     } /* RGB24 */
   }
   
   fflush(f);
   ChunkHeader.fccID   = RIFFtag;
   ChunkHeader.dwSize  = ftell(f)-8;
   ChunkHeader.fccType = AVItag;
   fseek(f, 0, SEEK_SET);
   fwrite(&ChunkHeader, sizeof(ChunkHeader), 1, f);
   
   fclose(f);
}

/**************************************************************************/

int main(int argc, char *argv[])
{
  char ch = 0;
  int Mute = 0;
  int Volume;
  int Freeze = 0;
  char *Screen;
  char *Buffer;
  char FileName[100];
  unsigned long time1;

  AVIType = YVU9;
  XRes = 240;
  YRes = 180;
  VidCount = 50;
  VidFPS = 24;
  strcpy(FileName, "test.avi");
  while (argc > 1){
    switch (argv[1][1]){
    case 'h': printf("record v0.2\n");
              printf("record [options]\n");
              printf(" -s SizeX SizeY\n");
              printf("        SizeX  horizontal video resolution\n");
              printf("        SizeY  vertical video resolution\n");
              printf(" -n Num\n");
              printf("        Num    number of frames recorded\n");
              printf(" -t FPS\n");
              printf("        FPS    number of frames recorded per second\n");
              printf(" -a Type\n");
              printf("        Type   type of the AVI: YVU9, RGB24\n");
              printf(" -f Name\n");
              printf("        Name   filename for the AVI\n");
              exit(0);
    case 's': if (argc < 4) {
                printf("missing argument for -s\n");
                exit(0);
              }
              sscanf(argv[2], "%i", &XRes);
              sscanf(argv[3], "%i", &YRes);
              if (XRes > 320) {
                printf("only SizeX <= 320 allowed\n");
                exit(0);
              }
              if (YRes > 240) {
                printf("only SizeY <= 240 allowed\n");
                exit(0);
              }
              if ((XRes % 4) != 0) {
                XRes = (XRes | 3)+1;
                printf("SizeX must be multiple of 4 (%i or %i)\n", XRes-4, XRes);
                exit(0);
              }
              if ((YRes % 4) != 0) {
                YRes = (YRes | 3)+1;
                printf("SizeY must be multiple of 4 (%i or %i)\n", YRes-4, YRes);
                exit(0);
              }
              argv += 2;
              argc -= 2;
              break;
    case 't': { float f;
                if (argc < 3) {
                  printf("missing argument for -t\n");
                  exit(0);
                }
                sscanf(argv[2], "%f", &f);
                VidFPS = (int)(f*2);
                argv++;
                argc--;
              }
              break;
    case 'n': if (argc < 3) {
                printf("missing argument for -n\n");
                exit(0);
              }
              sscanf(argv[2], "%i", &VidCount);
              argv++;
              argc--;
              break;
    case 'a': { if (argc < 3) {
                  printf("missing argument for -a\n");
                  exit(0);
                }
                if (!strcmp("YVU9", argv[2])) {
                  AVIType = YVU9;
                }
                else {
                  if (!strcmp("RGB24", argv[2])) {
                    AVIType = RGB24;
                  }
                  else {
                    printf("unknown AVI type\n");
                    exit(0);
                  }
                }
              }
              argv++;
              argc--;
              break;
    case 'f': if (argc < 3) {
                printf("missing argument for -f\n");
                exit(0);
              }
              strcpy(FileName, argv[2]);
              if (FileName[strlen(FileName)-4] != '.') {
                strcat(FileName, ".avi");
              }
              argv++;
              argc--;
              break;
    default:  printf("unknown option %s\n", argv[1]);
              if (argv[1][0] != '-') printf("- missing ?\n");
              exit(0);
    }
    argv++;
    argc--;
  }
  VidWait = (unsigned long)((CLOCKS_PER_SEC << 1) / VidFPS);
  
  init(); 

  Mute = Volume = V_GetVolume();
  V_SetVolume(0);
  V_CreateWindow(0,0,XRes,YRes); 
  XOff = (320-XRes) >> 1;
  YOff = (240-YRes) >> 1;
#ifdef linux
  Screen=(char *)graph_mem;
#else
  Screen=(char *)((0xe00a0000+320*YOff)+XOff);
#endif

  V_DisableVideo();
  Buffer=(char *)malloc(XRes*YRes*2);
  InitializeTimer();

  do {
    time1=ReadTimer();
#ifdef linux
    while ((ch=vga_getkey()) == 0){
#else
    while (kbhit() == 0){
#endif
      if (Freeze == 0){
        Display_video(Buffer, Screen);
        do {
        } while ((ReadTimer()-time1) < VidWait);
      }
      time1 = ReadTimer();
    }
#ifndef linux
    ch = getkey();
#endif
    switch (ch){
    case 's': Freeze ^= 1;
              break;
    case 'l': Volume += 8;
              if (Volume > 255) Volume = 255;
              V_SetVolume(Volume);
              break;
    case 'q': Volume -= 8;
              if (Volume < 0) Volume = 0;
              V_SetVolume(Volume);
              break;
    case '+': Volume += 2;
              if (Volume > 255) Volume = 255;
              V_SetVolume(Volume);
              break;
    case '-': Volume -= 2;
              if (Volume < 0) Volume = 0;
              V_SetVolume(Volume);
              break;
    case 'm': if (Mute == 0){
                Mute = Volume;
                V_SetVolume(0);
              }
              else {
                V_SetVolume(Mute);
                Mute = 0;
              }
              break;
    case 'r': record(Buffer);
              break;
    case 'p': play(Buffer, Screen);
              Freeze = 1;
              break;
    case 'w': writeAVI(FileName);
              Freeze = 0;
              break;
    }
  } while (ch != 27);
  done();
  free(Buffer);
  RestoreTimer();
  return 0;
}
