/*
 * This file is part of the fbdvd program
 * Copyright (C) 2001 Mark Sanderson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef PLAY_H
#define PLAY_H

#include "output/video_out.h"
#include "ac3/ac3.h"
#include "mpeg2/mpeg2.h"
#include <stdint.h>

extern int video_width;
extern int video_height;
extern int video_aspect;
extern int video_framerate;
extern int video_bitrate;
extern int video_bufsize;
extern int video_constrained;

extern mpeg2dec_t mpeg;

int ac3_fill_buffer(uint_8 **bstart, uint_8 **bend);

void play_init();
void play_close();
int play();
void play_seek(off_t where);

#endif
