/*
 * This file is part of the fbdvd program
 * Copyright (C) 2001 Mark Sanderson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef VIDEO_H
#define VIDEO_H

#include "video_out.h"
#include "yuv2rgb.h"

typedef struct video_frame_s {
   vo_frame_t vo;
   uint8_t *rgb_ptr;
   uint8_t *rgbdata;
   int rgb_stride;
   int yuv_stride;
} video_frame_t;

typedef struct video_instance_s {
   vo_instance_t vo;
   int prediction_index;
   vo_frame_t *frame_ptr[3];
   video_frame_t frame[3];
   uint8_t *rgbdata;
   int bytes;
   int width, height;
   int rgbstride;
} video_instance_t;

extern video_instance_t vo;
extern int frames_in;
extern int frames_out;

void init_video();
void (* video_render)(void);
void pan_scan(int direction);

#endif
