/**
 * Copyright (C) 2001 Billy Biggs <vektor@dumbterm.net>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <sys/types.h>
#include <unistd.h>
#include "../main.h"
#include "dvd.h"

#include "ifo_types.h"
#include "ifo_read.h"

typedef struct block_t {
   int start_block, end_block;
} block_list;

block_list *cell = NULL;
int dvd_current_cell, dvd_cells;
int dvd_start_block, dvd_end_block;

void dvd_next_cell() {
   if (dvd_current_cell >= dvd_cells) {
      dvd_current_cell = 0;
      dvd_eof = 1;
   }
   dvd_start_block = cell[dvd_current_cell].start_block;
   dvd_end_block = cell[dvd_current_cell].end_block;
   dvd_current_cell++;
}

void dvd_set_cell(off_t pos) {
   int i;
   
   for(i = 0; i< dvd_cells; i++) {
      if (pos >= cell[i].start_block && pos <= cell[i].end_block) {
	 dvd_current_cell = i + 1;
         return;
      }
   }
}

int dvd_read() {
    int pgc_id, len, start_cell, cur_cell, cur_pack;
    int ttn, pgn, next_cell;
    dvd_file_t *title;
    ifo_handle_t *vmg_file;
    tt_srpt_t *tt_srpt;
    ifo_handle_t *vts_file;
    vts_ptt_srpt_t *vts_ptt_srpt;
    pgc_t *cur_pgc;
    int i, audio_tracks;
    audio_attr_t *vts_audio_attr;

    dvd_current_cell = dvd_cells = 0;
    
    /* Test for ifo, this may be an mpeg file */
    if (dvd_open_ifo(0)) {
       dvd_start_block = 0;
       dvd_end_block = 0;
       return 0;
    }

    vmg_file = ifoOpen();
    if( !vmg_file ) {
        fprintf( stderr, "Can't open VMG info.\n" );
        return 1;
    }
    tt_srpt = vmg_file->tt_srpt;

    if( dvd_title < 1 || dvd_title > tt_srpt->nr_of_srpts ) {
        fprintf( stderr, "Invalid title %d.\n", dvd_title );
        ifoClose( vmg_file );
        return 1;
    }

    if( dvd_chapter < 1 || dvd_chapter > tt_srpt->title[ dvd_title - 1 ].nr_of_ptts ) {
        fprintf( stderr, "Invalid chapter %d\n", dvd_chapter );
        ifoClose( vmg_file );
        return 1;
    }

    if( dvd_angle < 1 || dvd_angle > tt_srpt->title[ dvd_title - 1 ].nr_of_angles ) {
        fprintf( stderr, "Invalid angle %d\n", dvd_angle );
        ifoClose( vmg_file );
        return 1;
    }

    if (dvd_open_ifo(tt_srpt->title[ dvd_title - 1 ].title_set_nr))
       return 1;
   
    vts_file = ifoOpen();
    if( !vts_file ) {
        fprintf( stderr, "Can't open the title %d info file.\n",
                 tt_srpt->title[ dvd_title - 1 ].title_set_nr );
        ifoClose( vmg_file );
        return 1;
    }

    ttn = tt_srpt->title[ dvd_title - 1 ].vts_ttn;
    vts_ptt_srpt = vts_file->vts_ptt_srpt;
    pgc_id = vts_ptt_srpt->title[ ttn - 1 ].ptt[ dvd_chapter - 1 ].pgcn;
    pgn = vts_ptt_srpt->title[ ttn - 1 ].ptt[ dvd_chapter - 1 ].pgn;
    cur_pgc = vts_file->vts_pgcit->pgci_srp[ pgc_id - 1 ].pgc;
    start_cell = cur_pgc->program_map[ pgn - 1 ] - 1;

    film_mode = vts_file->vtsi_mat->vts_video_attr.film_mode;
    audio_tracks = vts_file->vtsi_mat->nr_of_vts_audio_streams;
    vts_audio_attr = vts_file->vtsi_mat->vts_audio_attr;
/*
    for(i=0;i<audio_tracks;i++) {
//    audio_attr_t vts_audio_attr[8];
       fprintf(stderr,"i=%d af=%d multi=%d lang=%d app=%d quant=%d freq=%d ?=%d ch=%d\n",i,
	       vts_audio_attr[i].audio_format,
	       vts_audio_attr[i].multichannel_extension,
	       vts_audio_attr[i].lang_type,
	       vts_audio_attr[i].application_mode,
	       vts_audio_attr[i].quantization,
	       vts_audio_attr[i].sample_frequency,
	       vts_audio_attr[i].unknown1,
	       vts_audio_attr[i].channels);
    }
*/
   
    if (cell)
        free(cell);
    cell = calloc(sizeof(block_list), cur_pgc->nr_of_cells);   
   
    next_cell = start_cell;
    for( cur_cell = start_cell; next_cell < cur_pgc->nr_of_cells; ) {

        cur_cell = next_cell;

        /* Check if we're entering an angle block. */
        if( cur_pgc->cell_playback[ cur_cell ].block_type
                                        == BLOCK_TYPE_ANGLE_BLOCK ) {
            int i;

            cur_cell += (dvd_angle - 1);
            for( i = 0;; ++i ) {
                if( cur_pgc->cell_playback[ cur_cell + i ].block_mode
                                          == BLOCK_MODE_LAST_CELL ) {
                    next_cell = cur_cell + i + 1;
                    break;
                }
            }
        } else {
            next_cell = cur_cell + 1;
        }

        cell[dvd_cells].start_block = cur_pgc->cell_playback[ cur_cell ].first_sector;
        cell[dvd_cells].end_block = cur_pgc->cell_playback[ cur_cell ].last_sector;
        dvd_cells++;
    }
   
    dvd_open_vob(tt_srpt->title[ dvd_title - 1 ].title_set_nr, 1);
    dvd_next_cell();

    ifoClose( vts_file );
    ifoClose( vmg_file );

    return 0;
}

