/*
 * This file is part of the fbdvd program
 * Copyright (C) 2001 Mark Sanderson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _DVD_H
#define _DVD_H

#include <sys/types.h>

#define DVD_VIDEO_LB_LEN 2048

typedef unsigned char dvd_block[DVD_VIDEO_LB_LEN];

extern int dvd_eof;
extern off_t dvd_pos;

int dvd_open		(char *device);
int dvd_open_ifo       	(int title);
int dvd_open_vob	(int title, int chapter);
int dvd_close		();
off_t dvd_ifoseek      	(off_t pos);
int dvd_vobseek	        (off_t pos);
int dvd_readblock	(dvd_block *buffer);
int dvd_readbytes	(void *buffer, int len);

extern int dvd_start_block;
extern int dvd_end_block;
extern int dvd_cells;
extern int dvd_current_cell;

#endif
