/****************************************************************/
/*   ************* PROPRIETARY PROGRAM MATERIAL *************   */
/*   **** (C) 1994 interpersonal-computing GmbH Germany  ****   */
/*--------------------------------------------------------------*/
/*                                                              */
/*              Screen Machine II  API for UNIX                 */
/*                                                              */
/*                        Release 1.1                           */
/*                         01.12.1994                           */
/*                                                              */
/*                        smlib.h  1.3                          */
/*                                                              */
/*                                                              */
/*--------------------------------------------------------------*/
/* Author: Michael Friedel                                      */
/*--------------------------------------------------------------*/
/* This source manuscript is proprietary to interpersonal-      */
/* computing GmbH and is not to be reproduced, used or          */
/* disclosed except in accordance with interpersonal-computing  */
/* software
license.
                                           */
/****************************************************************/

/* $Author: mfriedel $ $Date: 94/08/17 16:45:11 $ */

/* 
 * $Log:	smlib.h,v $
 * Revision 1.3  94/08/17  16:45:11  mfriedel
 * Fixed bug with opening device to often
 * 
 */

#ifndef SMLIB_H
#define SMLIB_H

/* For clipping*/
typedef short SMClip[6];
typedef SMClip*	SMClips;

#define CLIP_LEFT 	0
#define CLIP_RIGHT 	1
#define	CLIP_TOP	2
#define	CLIP_BOTTOM	3
#define	CLIP_STATE	4
#define	CLIP_NUM	5
#define SM_CLIPLIST_LEN 64

#define SM_REMOVE_CLIP 		1
#define	SM_SET_CLIP		2
#define SM_SYSTEM_NTSC		0
#define SM_SYSTEM_PAL		1
#define SM_SYSTEM_SECAM		2

#define SM_FIELD_ODD	1
#define SM_FIELD_EVEN	2
#define SM_FIELD_BOTH	3

#define SM_INPUT_BLACK	0
#define SM_INPUT_RED	1
#define SM_INPUT_YELLOW	2
#define SM_INPUT_SVHS	3


short smInit (short nAdr, short nWdt,short nHgt);
short smOpen ( short nSM);
short smClose ( short nSM);
short smSetSystem (  short nSM, short nSystem);
short smSetXofs (  short nSM, short nXOffset);
short smSetYofs (  short nSM, short nYOffset);
short smSetPll (  short nSM, short nPll);
short smSetHScale (  short nSM,short nScale);
short smSetInterlaced (  short nSM, short bOn);
short smSetVideoFrame (  short nSM, short nLft, short nTop, short nRgt, short nBot);
short smSetZoomFrame (  short nSM, short nLft, short nTop, short nRgt, short nBot);
short smSetWindowFrame (  short nSM, short nLft, short nTop, short nWdt, short nHgt);
short smSetVideo (  short nSM, short bOn);
short smSetLive ( short nSM,short bOn);
short smSetMixer (  short nSM, short nMix);
short smSetInputFields ( short nSM, short nFrm);
short smSetInput ( short nSM, short nInput);
short smSetColor (  short nSM, short bOn);
short smSetVideoSource (  short nSM,short nMode);
short smSetBrightness (  short nSM, short nBrightness);
short smSetContrast (  short nSM, short nContrast);
short smSetSaturation (  short nSM, short nSaturation);
short smSetRGB (  short nSM, short nRed, short nGreen, short nBlue);
short smSetPreFilter ( short nSM, short nPrefilter);
short smSetSharpness (  short nSM, short nSharpness);
short smSetNoiseFilter ( short nSM, short nNoiseFilter);
short smSetBandPass (  short nSM, short nBandpass);
short smSetHue ( short nSM, short nHue);
short smSetInputFilter (  short nSM, short nFlt);
short smSetLumaIntensity (  short nSM, short nInt);
short smSetChromaIntensity (  short nSM, short nInt);
short smClearClips (  short nVMC);
short smRemoveClip ( short nVMC,short clipnum);
short smSetClip (  short nVMC, SMClip theClip);
short smSetClipList (  short nSM, SMClips theClips, int count);

short smGetSystem (  short nSM );
short smGetXofs (  short nSM );
short smGetYofs (  short nSM );
short smGetPll (  short nSM);
short smGetHScale (  short nSM );
short smGetInterlaced (  short nSM );
short smGetVideoFrame (  short nSM, short *pnLft, short *pnTop, short *pnRgt, short *pnBot);

/* Display handling*/

short smGetZoomFrame (  short nSM, short *pnLft, short *pnTop, short *pnRgt, short *pnBot);
short smGetWindowFrame (  short nSM, short *pnLft, short *pnTop, short *pnWdt, short *pnHgt);
short smGetVideo (  short nSM );
short smGetLive ( short nSM );
short smGetMixer (  short nSM );
short smGetInputFields ( short nSM );
short smGetInput ( short nSM );

/* Quality */

short smGetColor (  short nSM );
short smGetVideoSource (  short nSM );
short smGetBrightness (  short nSM );
short smGetContrast (  short nSM );
short smGetSaturation (  short nSM );
short smGetRGB (  short nSM, short *pnRed, short *pnGreen, short *pnBlue);
short smGetPreFilter ( short nSM );
short smGetSharpness (  short nSM );
short smGetNoiseFilter ( short nSM );
short smGetBandPass (  short nSM );
short smGetHue ( short nSM );
short smGetInputFilter (  short nSM );
short smGetLumaIntensity (  short nSM );
short smGetChromaIntensity (  short nSM );

short smSetAudio (  short nSM,short bOn);
short smSetAudioBalance (  short nSM,short nVal);
short smSetAudioBass (  short nSM,short nVal);
short smSetAudioTreble (  short nSM,short nVal);
short smSetAudioFader (  short nSM,short nVal);
short smSetAudioVolume (  short nSM,short nVal);
short smSetAudioInput (  short nSM, short nInput);

short smGetAudio (  short nSM );
short smGetAudioBalance ( short nSM );
short smGetAudioBass ( short nSM );
short smGetAudioTreble (  short nSM );
short smGetAudioFader ( short nSM );
short smGetAudioVolume ( short nSM );
short smGetAudioInput ( short nSM );

short smSetFlipDisplay (  short nSM,short bOn);
short smSetMosaic (  short nSM,short nVal);
short smSetPosterize (  short nSM,short nVal);
short smSetChromaInvert (  short nSM,short nVal);
short smSetLumaInvert (  short nSM,short nVal);

short smGetFlipDisplay (  short nSM );
short smGetMosaic ( short nSM );
short smGetPosterize ( short nSM );
short smGetChromaInvert (  short nSM );
short smGetLumaInvert ( short nSM );
short smPatternFill (  short nSM, short type);

short smReadImage(short nSM, unsigned char* imagedata,int *imagesize);
short smReadYImage(short nSM, unsigned char* imagedata,int *imagesize);
short smWriteImage(short nSM, unsigned char* imageData,int imageSize);
short smWriteYImage(short nSM, unsigned char* imageData,int imageSize);

short smSendTuner(short nSM, char *data, short count, char ttype);
short smGetTuner(short nSM, char *data);
short smSendVT(short nSM,char *data,short count);
short smReceiveVT(short nSM,char *data,short count);
short smSetStereo (  short nSM,short nVal);
short smGetStereo (  short nSM );

#endif
