/*
    GMP3Info - Displays and allows editing of MP3 ID3 tags and various
               technical aspects of MP3 files (GTK interface)

    gmp3info.c - main part of GTK version of MP3Info

    Copyright (C) 2000  Cedric Tefft <cedric@earthling.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  ***************************************************************************

  This program is based in part on GMP3Info 0.5 by Ricardo Cerqueira <rmc@rccn.net>

*/

#include <gtk/gtk.h>
#define __MAIN
#include "mp3info.h"
#undef __MAIN

gchar *gtext_genre(unsigned char genre);
unsigned char gget_genre (char *genre);

GtkWidget	*id3win,*id3win_frame_global;
GtkWidget	*id3win_frame_title,*id3win_frame_artist,*id3win_frame_album;
GtkWidget	*id3win_frame_year,*id3win_frame_comment, *id3win_frame_albyear;
GtkWidget	*id3win_frame_genre,*id3win_frame_track,*id3win_frame_comtrack;
GtkWidget	*id3win_text_title,*id3win_text_artist,*id3win_text_album;
GtkWidget	*id3win_text_year,*id3win_text_comment,*id3win_combo_genre;
GtkWidget	*id3win_text_track;
GtkWidget	*id3win_frame_buttons,*id3win_ok_button,*id3win_cancel_button;
GList 		*genrelist=NULL;
gchar		track[4]="",fbuf[4];

unsigned char genre=255;
FILE  *fp;
unsigned char sig[2];
unsigned int track_num;
mp3info mp3;
int read_only=0;

void exit_save( GtkWidget *widget, GtkWidget *data) {
   	char tmp[31];

	if(!read_only) {
	   	strcpy(mp3.id3.title,gtk_entry_get_text(GTK_ENTRY(id3win_text_title)));
	   	strcpy(mp3.id3.artist,gtk_entry_get_text(GTK_ENTRY(id3win_text_artist)));
	   	strcpy(mp3.id3.album,gtk_entry_get_text(GTK_ENTRY(id3win_text_album)));
	   	strcpy(mp3.id3.year,gtk_entry_get_text(GTK_ENTRY(id3win_text_year)));
	   	strcpy(mp3.id3.comment,gtk_entry_get_text(GTK_ENTRY(id3win_text_comment)));
	        strcpy(tmp,gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(id3win_combo_genre)->entry)));
	        mp3.id3.genre[0]=gget_genre(tmp);
	   	strcpy(tmp,gtk_entry_get_text(GTK_ENTRY(id3win_text_track)));
		mp3.id3.track[0]=atoi(tmp);
		if (mp3.id3.track[0] > 255)
			mp3.id3.track[0]=255;
	        write_tag(&mp3);
	}

   	fclose(mp3.file);
   	gtk_main_quit();
}

int main(int argc, char *argv[] ) {
    
   int i;


   memset(&mp3,0,sizeof(mp3info));

   if(argc==2) { 
	if ( !( mp3.file=fopen(argv[1],"rb+") ) ) {
	    if((mp3.file=fopen(argv[1],"rb")))
		read_only=1;
	    else {
		perror("Error opening MP3 file.");
		return 0;
	    }
	}

	mp3.filename=argv[1];
	get_mp3_info(&mp3,SCAN_QUICK,0);
	if(!mp3.header_isvalid && !mp3.id3_isvalid) {
		g_print("File is corrupt or is not a standard MP3 file!\n");
		return 0;
	}
    
        gtk_init (&argc, &argv);
        
        id3win=gtk_window_new(GTK_WINDOW_DIALOG);
        gtk_window_set_title(GTK_WINDOW(id3win),"MP3info - An ID3 tag editor");
        gtk_window_set_policy (GTK_WINDOW(id3win), FALSE,FALSE,FALSE);
        gtk_widget_set_usize(id3win,450,340);
        gtk_container_border_width(GTK_CONTAINER(id3win),10);
        gtk_signal_connect(GTK_OBJECT(id3win), "delete_event", (GtkSignalFunc) gtk_exit, NULL);
        id3win_frame_global=gtk_vbox_new(FALSE,10);
        
        id3win_frame_title=gtk_frame_new("Title");
        gtk_container_border_width(GTK_CONTAINER(id3win_frame_title),5);
        id3win_text_title=gtk_entry_new_with_max_length(30);
        gtk_entry_set_text(GTK_ENTRY(id3win_text_title),mp3.id3.title);
        gtk_container_add(GTK_CONTAINER(id3win_frame_title),id3win_text_title);
        gtk_box_pack_start(GTK_BOX(id3win_frame_global),id3win_frame_title,TRUE,TRUE,0);
        
        id3win_frame_artist=gtk_frame_new("Artist");
        gtk_container_border_width(GTK_CONTAINER(id3win_frame_artist),5);
        id3win_text_artist=gtk_entry_new_with_max_length(30);
        gtk_entry_set_text(GTK_ENTRY(id3win_text_artist),mp3.id3.artist);
        gtk_container_add(GTK_CONTAINER(id3win_frame_artist),id3win_text_artist);
        gtk_box_pack_start(GTK_BOX(id3win_frame_global),id3win_frame_artist,TRUE,TRUE,0);
        
        id3win_frame_albyear=gtk_hbox_new(FALSE,30);
        id3win_frame_album=gtk_frame_new("Album");
        gtk_container_border_width(GTK_CONTAINER(id3win_frame_album),5);
        id3win_text_album=gtk_entry_new_with_max_length(30);
        gtk_entry_set_text(GTK_ENTRY(id3win_text_album),mp3.id3.album);
        gtk_container_add(GTK_CONTAINER(id3win_frame_album),id3win_text_album);
        gtk_box_pack_start(GTK_BOX(id3win_frame_albyear),id3win_frame_album,TRUE,TRUE,0);
        
        id3win_frame_year=gtk_frame_new("Year");
        gtk_widget_set_usize(id3win_frame_year,2,0);
        gtk_container_border_width(GTK_CONTAINER(id3win_frame_year),5);
        id3win_text_year=gtk_entry_new_with_max_length(4);
        gtk_entry_set_text(GTK_ENTRY(id3win_text_year),mp3.id3.year);
        gtk_container_add(GTK_CONTAINER(id3win_frame_year),id3win_text_year);
        gtk_box_pack_start(GTK_BOX(id3win_frame_albyear),id3win_frame_year,TRUE,TRUE,0);
        gtk_box_pack_start(GTK_BOX(id3win_frame_global),id3win_frame_albyear,TRUE,TRUE,0);
        
        id3win_frame_comtrack=gtk_hbox_new(FALSE,30);
        id3win_frame_comment=gtk_frame_new("Comment");
        gtk_container_border_width(GTK_CONTAINER(id3win_frame_comment),5);
        id3win_text_comment=gtk_entry_new_with_max_length(30);
        gtk_entry_set_text(GTK_ENTRY(id3win_text_comment),mp3.id3.comment);
        gtk_container_add(GTK_CONTAINER(id3win_frame_comment),id3win_text_comment);
        gtk_box_pack_start(GTK_BOX(id3win_frame_comtrack),id3win_frame_comment,TRUE,TRUE,0);
        
        id3win_frame_track=gtk_frame_new("Track");
        gtk_widget_set_usize(id3win_frame_track,2,0);
        gtk_container_border_width(GTK_CONTAINER(id3win_frame_track),5);
        id3win_text_track=gtk_entry_new_with_max_length(3);
        gtk_entry_set_text(GTK_ENTRY(id3win_text_track),mp3.id3.track);
        gtk_container_add(GTK_CONTAINER(id3win_frame_track),id3win_text_track);
        gtk_box_pack_start(GTK_BOX(id3win_frame_comtrack),id3win_frame_track,TRUE,TRUE,0);
        gtk_box_pack_start(GTK_BOX(id3win_frame_global),id3win_frame_comtrack,TRUE,TRUE,0);
        
        id3win_frame_genre=gtk_frame_new("Genre");
        gtk_container_border_width(GTK_CONTAINER(id3win_frame_genre),5);
        id3win_combo_genre=gtk_combo_new();
        for(i=0;i<MAXGENRE+2;i++) {
        	genrelist = g_list_append(genrelist, typegenre[galphagenreindex[i]]);
        }
        gtk_combo_set_popdown_strings(GTK_COMBO(id3win_combo_genre),genrelist);
        gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(id3win_combo_genre)->entry), gtext_genre(mp3.id3.genre[0]));
        gtk_container_add(GTK_CONTAINER(id3win_frame_genre),id3win_combo_genre);
        gtk_box_pack_start(GTK_BOX(id3win_frame_global),id3win_frame_genre,TRUE,TRUE,0);
        
        id3win_frame_buttons=gtk_hbox_new(TRUE,30);
        id3win_ok_button=gtk_button_new_with_label("OK");
        gtk_box_pack_start(GTK_BOX(id3win_frame_buttons),id3win_ok_button,TRUE,TRUE,0);
	if(read_only) {
	  gtk_widget_set_sensitive (id3win_text_title, FALSE);
	  gtk_widget_set_sensitive (id3win_text_artist, FALSE);
	  gtk_widget_set_sensitive (id3win_text_album, FALSE);
	  gtk_widget_set_sensitive (id3win_text_year, FALSE);
	  gtk_widget_set_sensitive (id3win_text_comment, FALSE);
	  gtk_widget_set_sensitive (id3win_text_track, FALSE);
	  gtk_widget_set_sensitive (id3win_combo_genre, FALSE);	
	} else {
	        id3win_cancel_button=gtk_button_new_with_label("Cancel");
        	gtk_box_pack_start(GTK_BOX(id3win_frame_buttons),id3win_cancel_button,TRUE,TRUE,0);
	        gtk_signal_connect (GTK_OBJECT (id3win_cancel_button), "clicked", GTK_SIGNAL_FUNC (gtk_exit), NULL);
        }

        gtk_widget_set_usize(id3win_frame_buttons,30,20);
        gtk_box_pack_start(GTK_BOX(id3win_frame_global),id3win_frame_buttons,TRUE,TRUE,0);
        
        gtk_container_add(GTK_CONTAINER(id3win),id3win_frame_global);
        
        gtk_signal_connect (GTK_OBJECT (id3win_ok_button), "clicked", GTK_SIGNAL_FUNC (exit_save), NULL);
        
        gtk_widget_show_all(id3win);
        gtk_main();
        
        return(0);
   } else {
      g_print("You must supply an MP3 file as an argument (example: 'gmp3info somesong.mp3').\n");
      return(0);
   }

			
}

gchar *gtext_genre(unsigned char genre) {
   int genre_num = (int) genre;

   if(genre_num <= MAXGENRE) {
	return((gchar *)typegenre[genre_num]);
   } else {
	return((gchar *)"");
   }
}

unsigned char gget_genre (char *genre) {
	int num_genre=0;

        if(genre[0] == '\0') { return 255; }

	sscanf(genre,"%u",&num_genre);
	if(num_genre == 0) {
		if(genre[0] != '0') {
			while(num_genre++ <= MAXGENRE) {
				if(!strcasecmp(genre,typegenre[num_genre-1])) {
					return num_genre-1;
				}
			}
			num_genre=256;
		}		
	}

	if(num_genre < 0 || num_genre > MAXGENRE) {
		num_genre=255;
	}
	return (unsigned char) num_genre;
}


