/*
 * textfunc.c
 * 
 * Auxilliary text mode functions for MP3info
 *
 * Original Author:
 *       Ricardo Cerqueira      <rmc@rccn.net>
 *  
 * This software is covered by the GNU public license, which should be in a file named
 * LICENSE acompanying this.
 *         
 */

#include "mp3info.h"


/*
 * Name of this one is quite obvious...
 */

void CenterText(int line, char *text) {
   mvprintw(line,(COLS/2)-((int)strlen(text)/2),text);
}

/*
 * If "string" is shorter than "length", pad it with ' ' (spaces)
 */

void pad(char *string, int length) {
        int l;

        l=strlen(string);
        while(l<length) {
                string[l] = ' ';
                l++;
        }

        string[l]='\0';
}

/*
 * Build the final tag, ready to be inserted into the file
 */

void buildtag(char *buf, struct id3tag *tag) {

	strcpy(buf,"TAG");
	pad(tag->title,TEXT_FIELD_LEN); 
	strncat(buf,tag->title,TEXT_FIELD_LEN);
	pad(tag->artist,TEXT_FIELD_LEN); 
	strncat(buf,tag->artist,TEXT_FIELD_LEN);
	pad(tag->album,TEXT_FIELD_LEN); 
	strncat(buf,tag->album,TEXT_FIELD_LEN);
	pad(tag->year,INT_FIELD_LEN); 
	strncat(buf,tag->year,INT_FIELD_LEN);
	pad(tag->comment,TEXT_FIELD_LEN); 
	strncat(buf,tag->comment,TEXT_FIELD_LEN);
	strncat(buf,tag->genre,1);
	if (tag->track[0] != '\0') {
		buf[125]='\0';
		buf[126]=tag->track[0];
	}
}

/*
 * Another one with an obvious name :-)
 */

void display_help() {

	printf("%s\n\n",VERSION);
	printf("  USAGE: mp3info INFO-OPTIONS\n");
	printf("         mp3info [EDIT-OPTIONS] MP3-file1 [.. MP3-fileN]\n\n");
        printf("   INFO-OPTIONS\n");
	printf("-h	--	Display this help page\n");
	printf("-G	--	Display genre list\n");
	printf("-x	--	Display technical MP3 info (experimental)\n\n");
        printf("   EDIT-OPTIONS\n");
	printf("-i	   --   Edit ID3 tag interactively\n");
	printf("-d	   --   Delete ID3 tag\n");
	printf("-f	   --   Assume all files are MP3's (don't check for std. MP3 header)\n");
	printf("-t title   --   Specify ID3 track title\n");
	printf("-a artist  --   Specify ID3 artist name\n");
	printf("-l album   --   Specify ID3 album name\n");
	printf("-y year    --   Specify ID3 copyright year\n");
	printf("-c comment --   Specify ID3 comment\n");
 	printf("-n track   --   Specify ID3 v1.1 track number\n");
	printf("-g genre   --   Specify ID3 genre (use -G option for a list of valid genres)\n\n");
	printf("Specifying MP3 files without any edit options displays the existing tag.\n");
	printf("Specifying a track number of 0 reverts ID3 tag to 1.0 format\n");
	printf("Non-specified fields, if existant, will remain unchanged.\n");
	printf("Genres can be specified as numbers or names: '-g 17' same as '-g Rock'\n");
	printf("Remember: Multiple word fields must be enclosed in \"\" (eg: -t \"A title\")\n\n");


}

/*
 * Display an existing tag (if any), or error message
 */

void view_tag(char *filename,struct id3tag *tag) {
	   char genre[40]="";

	   printf("File: %s\n",filename);
	   printf("Title:   %s",tag->title);
	   if (tag->track[0] != '\0') {
	       printf(" Track: %d\n",tag->track[0]);
	   } else {
	       printf("\n");
	   }
	   printf("Artist:  %s\n",tag->artist);
	   printf("Album:   %-30s ",tag->album);
	   printf("Year:  %s\n",tag->year);
	   printf("Comment: %-30s ",tag->comment);
           text_genre(tag->genre,genre);
	   printf("Genre: %s\n",genre);

}

void display_genres(int alphagenreindex[],char *typegenre[]) {
	int i,j,index;
//	int *alphagenreindex=&(galphagenreindex[1]);
	printf("Extended MP3 ID3 Genres\n=======================\n");
	for(i=0;i<GENREROWS;i++) {
	   for(j=0;j<3;j++) {
	      index=(GENREROWS*j)+i;
	      if(index <= MAXGENRE) {
	         printf("%3d %-21s ",alphagenreindex[index],typegenre[alphagenreindex[index]]);
              }
           }
	   printf("\n");
	}
}

unsigned int get_genre (char *genre) {
	int num_genre=0;

        if(genre[0] == '\0') { return 255; }

	sscanf(genre,"%u",&num_genre);
	if(num_genre == 0) {
		if(genre[0] != '0') {
			while(num_genre++ <= MAXGENRE) {
				if(!strcasecmp(genre,typegenre[num_genre-1])) {
					return num_genre-1;
				}
			}
			num_genre=256;
		}		
	}

	if(num_genre < 0 || num_genre > MAXGENRE) {
		num_genre=256;
	}
	return num_genre;
}

void text_genre(unsigned char *genre,char *buffer) {
   int genre_num = (int) genre[0];

   if(genre_num <= MAXGENRE) {
	sprintf(buffer,"%s [%d]",typegenre[genre_num],genre_num);
   } else if(genre_num < 255) {
	sprintf(buffer,"(UNKNOWN) [%d]",genre_num);
   } else {
	buffer[0]='\0';
   }
}



