#include "mp3info.h"

char *layer_text[] = {
	"I", "II", "III"
};

int frequencies[2][3] = {
   {22050,24000,16000},  /* MPEG 2.0 */
   {44100,48000,32000}   /* MPEG 1.0 */
};

int bitrate[2][3][14] = { 
  { /* MPEG 2.0 */
    {32,48,56,64,80,96,112,128,144,160,176,192,224,256},  /* layer 1 */
    {8,16,24,32,40,48,56,64,80,96,112,128,144,160},       /* layer 2 */
    {8,16,24,32,40,48,56,64,80,96,112,128,144,160}        /* layer 3 */
  },

  { /* MPEG 1.0 */
    {32,64,96,128,160,192,224,256,288,320,352,384,416,448}, /* layer 1 */
    {32,48,56,64,80,96,112,128,160,192,224,256,320,384},    /* layer 2 */
    {32,40,48,56,64,80,96,112,128,160,192,224,256,320}      /* layer 3 */
  }
};

int frame_size_index[] = {24000, 72000, 72000};

char *mode_text[] = {
   "stereo", "joint stereo", "dual channel", "mono"
};

char *emphasis_text[] = {
  "none", "50/15 microsecs", "reserved", "CCITT J 17"
};

int get_header(FILE *file,mp3header *header)
{
    unsigned char buffer[sizeof(header)];

    fread(&buffer,sizeof(header),1,file);
    header->sync=((int)buffer[0] + (256*(buffer[1] >> 4)));
    header->version=(buffer[1] >> 3) & 1;
    header->layer=(buffer[1] >> 1) & 3;
    if((header->sync != 0xFFF) || (header->layer != 1)) {
	return 0;
    }
    header->crc=buffer[1] & 1;
    header->bitrate=(buffer[2] >> 4) & 0x0F;
    header->freq=(buffer[2] >> 2) & 0x3;
    header->padding=(buffer[2] >>1) & 0x1;
    header->extension=(buffer[2]) & 0x1;
    header->mode=(buffer[3] >> 6) & 0x3;
    header->mode_extension=(buffer[3] >> 4) & 0x3;
    header->copyright=(buffer[3] >> 3) & 0x1;
    header->original=(buffer[3] >> 2) & 0x1;
    header->emphasis=(buffer[3]) & 0x3;
    return 1;

}

void print_header(mp3header *header,off_t filesize) {

	int frame_size,num_frames,length,minutes,seconds;

	printf("Media Type:  MPEG %s Layer %s\n",header->version ? "1.0" : "2.0",layer_text[3-header->layer]);
	printf("Audio:       %dKB/s, %dKHz (%s)\n",
	    bitrate[header->version][3-header->layer][header->bitrate-1],
	    frequencies[header->version][header->freq]/1000,mode_text[header->mode]);
        printf("Emphasis:    %s\n",emphasis_text[header->emphasis]);
        printf("CRC:         %s\nCopyright:   %s\nOriginal:    %s\n",
		!header->crc ? "Yes" : "No",
		header->copyright ? "Yes" : "No",
		header->original ? "Yes" : "No");

	frame_size=(frame_size_index[3-header->layer]*(header->version+1))*
		    bitrate[header->version][3-header->layer][header->bitrate-1]/
		    frequencies[header->version][header->freq];

	num_frames=(int)(filesize/frame_size);
	length=((num_frames*100)/(3844));
/*       printf("Frame Size: %d\n",frame_size);
	printf("Number of Frames: %d\n",num_frames);
*/
	minutes=(length/60);
	seconds=(length % 60);
	printf("Length:      %d:%02d\n",minutes,seconds);
	
/*        printf("Padding: %d\n",header->padding); */


}