/*
 * mp3info.c
 *
 * MP3info's main file. MP3info is an ID3 tag editor.
 *
 * Author:
 *       Ricardo Cerqueira	<rmc@rccn.net>
 *
 * This software is covered by the GNU public license, which should be in a file named
 * LICENSE acompanying this.
 *
 */

#include "mp3info.h"


int main(int argc, char *argv[]) {
FILE  *fp;
int c, interactive = 0;
char fullline[128], title[31]="", artist[31]="", album[31]="", year[5]="", comment[31]="", fbuf[4];
unsigned char sig[2];
unsigned char genre[1];
unsigned int g;


   if (argc < 2 ) /* Only command is given. Short help */ {
	   printf("%s\r\n  Usage: %s [-h] (-i | -t title -a artist -l album -y year -c comment ) 
			   /path/to/the/file.mp3\r\n\r\n",VERSION,argv[0]); 
	   return 0;
   } else if ( argc != 3 && !strcmp(argv[1],"-i") ) /* Curses mode. Filename missing or garbage */ {
	   printf("%s\r\nYou must enter an MP3 file as an argument in interactive mode!\r\n  
			   Usage: %s -i /path/to/the/file.mp3\r\n\r\n",VERSION,argv[0]); 
	   return 0;
   }

   if (!strcmp(argv[1],"-h")) { display_help(); return 0; }
   
   /* if we only want to read out the information, we don't need write
       +      access... this makes it work as a lister for CD-ROMs. CH 09/99 */
   if (!strcmp(argv[1],"-v")) { 
     if ( !( fp=fopen(argv[argc-1],"r") ) ) {
             perror("Error opening MP3");
             return 0;
     }
   } else {
     if ( !( fp=fopen(argv[argc-1],"rb+") ) ) {
             perror("Error opening MP3");
             return 0;
     }
}

   /* Let's see if it's an MP3. SMJ 06/1999 */     

   fread(sig,sizeof(sig),1,fp);                         
   sig[0] &= 0xff;
   sig[1] &= 0xf0;                                                         
   if(!((sig[0] == 0xff) && (sig[1] == 0xf0))) {
           fprintf(stderr,"%s is not an MP3 file!\n",argv[argc-1]);        
           return(-1);
   }                                                          

   
 
   /* Go to EOF and check if there's already a tag */

   if ( fseek(fp, -128, SEEK_END )) { return 0; }
   fread(fbuf,1,3,fp); fbuf[3] = '\0';
   if (!strcmp("TAG",fbuf)) {
	   /* Holy cow, Batman! I found something! Better save it for later use... */
	   fseek(fp, -125, SEEK_END); 
	   fread(title,1,30,fp); title[30] = '\0';
	   fread(artist,1,30,fp); artist[30] = '\0';
	   fread(album,1,30,fp); album[30] = '\0';
	   fread(year,1,4,fp); year[4] = '\0';
	   fread(comment,1,30,fp); comment[30] = '\0';
	   fread(genre,1,1,fp);
	   /* freads moved the file pointer. Get it back to the beginning of the tag so it 	*
	    * will be overwritten 								*/
           fseek(fp, -128, SEEK_END);
   } else {
	   /* No tags here. Back to the EOF to append the new one */
	   fseek(fp, 0, SEEK_END); 
   }
       
   if(argc==2) {                                                          
           view_tag(fp);
           return(0);        
   }
  
   /* Let's see what the user wants to do... */
   while ((c=getopt(argc,argv,"vhit:a:l:y:c:g:"))!=-1) {

	switch(c) {
		case 'v':
			view_tag(fp); return 0;
			break;
		case 'h':
			display_help(); return 0;
			break;
		case 'i':
   	 		tagedit_curs(fp,argv[argc-1],fullline);
			interactive = 1;
			break;
		case 't':
			strncpy(title,optarg,TEXT_FIELD_LEN);
			break;
		case 'a':
			strncpy(artist,optarg,TEXT_FIELD_LEN);
			break;
		case 'l':
			strncpy(album,optarg,TEXT_FIELD_LEN);
			break;
		case 'y':
			strncpy(year,optarg,INT_FIELD_LEN);
			break;
		case 'c':
			strncpy(comment,optarg,TEXT_FIELD_LEN);
			break;
		case 'g':
			sscanf(optarg,"%u",&g);
			genre[0] = (unsigned char) g;
			break;
	}
   }
   /* Interactive mode builds the tag for itself, so... */
   if ( !interactive ) { buildtag(fullline,title,artist,album,year,comment,genre); }

   /* Finally! Get it done! */
   fwrite(fullline,1,128,fp);

   fclose(fp);
   return 0;
}

