/*
 * mp3curs.c
 *
 * Curses functions for MP3info
 *
 * Author:
 *       Ricardo Cerqueira	<rmc@rccn.net>
 *
 * This software is covered by the GNU public license, which should be in a file named
 * LICENSE acompanying this.
 *
 */

#include "mp3info.h"

/*
 * Check if Break is given, and if so, clean term and exit, else pad the input.
 */

char *checkinput(int c, char *string, int length) {
        if (c == CTRL_C) { endwin(); exit(0); }
        pad(string,length);
        return string;
}

/*
 * Get the cursor to the right place, and get input
 */

char *curs_addparam(WINDOW *win, int line, int length, char *buf) {
        int c;
        char string[TEXT_FIELD_LEN];

        wmove(win,line,16);
        c = wgetnstr(win,string,length);
        strcat(buf,checkinput(c,string,length));
        return buf;
}

/*
 * Bring up the curses window, then get and parse input, and build the tag.
 */

void tagedit_curs(FILE *fp, char *filename, char *line) {
WINDOW *mainwin;

   strcpy(line,"TAG");
   initscr(); cbreak(); noecho();
   nonl();
   mainwin = newwin(8,COLS,5,0);
   intrflush(mainwin, FALSE);
   keypad(mainwin, TRUE);
   CenterText(1,VERSION);
   CenterText(2,"Ricardo Cerqueira <rmc@rccn.net>, 1999");
#ifdef HAVE_TOUCHWIN
   touchwin(mainwin);
#endif
   box(mainwin, 0, 0);
   wmove(mainwin,1,1); 
   wprintw(mainwin,"Song Title:");
   wmove(mainwin,2,1); 
   wprintw(mainwin,"Artist Name:");
   wmove(mainwin,3,1); 
   wprintw(mainwin,"Album Name:");
   wmove(mainwin,4,1); 
   wprintw(mainwin,"Year:");
   wmove(mainwin,5,1); 
   wprintw(mainwin,"Comment:");
   fseek(fp,0,2);
   wmove(mainwin,7,4);
   wprintw(mainwin," %s, %i bytes ",filename,ftell(fp));
   wmove(mainwin,7,COLS-22);
   wprintw(mainwin," Press ^C to quit ");
   refresh();
   echo();
   strcpy(line,curs_addparam(mainwin,1,30,line));
   strcpy(line,curs_addparam(mainwin,2,30,line));
   strcpy(line,curs_addparam(mainwin,3,30,line));
   strcpy(line,curs_addparam(mainwin,4,4,line));
   strcpy(line,curs_addparam(mainwin,5,30,line));
   strcat(line,"");
   endwin();
}

