/*
 * mp3info.c
 *
 * MP3info's main file. MP3info is an ID3 tag editor.
 *
 * Author:
 *       Ricardo Cerqueira	<rmc@ssi.aaum.pt>
 *
 * This software is covered by the GNU public license, which should be in a file named
 * LICENSE acompanying this.
 *
 */

#include "mp3info.h"


void main(int argc, char *argv[]) {
FILE  *fp;
int c, interactive = 0;
char fullline[128], title[31]="", artist[31]="", album[31]="", year[5]="", comment[31]="", fbuf[4];

   if (argc < 2 ) /* Only command is given. Short help */ {
	   printf("%s\r\n  Usage: %s [-h] (-i | -t title -a artist -l album -y year -c comment ) 
			   /path/to/the/file.mp3\r\n\r\n",VERSION,argv[0]); 
	   exit();
   } else if ( argc != 3 && !strcmp(argv[1],"-i") ) /* Curses mode. Filename missing or garbage */ {
	   printf("%s\r\nYou must enter an MP3 file as an argument in interactive mode!\r\n  
			   Usage: %s -i /path/to/the/file.mp3\r\n\r\n",VERSION,argv[0]); 
	   exit();
   }

   if (!strcmp(argv[1],"-h")) { display_help(); exit(); }
   if ( !( fp=fopen(argv[argc-1],"rb+") ) ) {
           perror("Error opening MP3");
           return;
   }
  
   /* Go to EOF and check if there's already a tag */

   if ( fseek(fp, -128, SEEK_END )) { exit(); }
   fread(fbuf,1,3,fp); fbuf[3] = '\0';
   if (!strcmp("TAG",fbuf)) {
	   /* Holy cow, Batman! I found something! Better save it for later use... */
	   fseek(fp, -125, SEEK_END); 
	   fread(title,1,30,fp); title[30] = '\0';
	   fread(artist,1,30,fp); artist[30] = '\0';
	   fread(album,1,30,fp); album[30] = '\0';
	   fread(year,1,4,fp); year[4] = '\0';
	   fread(comment,1,30,fp); comment[30] = '\0';
	   /* freads moved the file pointer. Get it back to the beginning of the tag so it 	*
	    * will be overwritten 								*/
           fseek(fp, -128, SEEK_END);
   } else {
	   /* No tags here. Back to the EOF to append the new one */
	   fseek(fp, 0, SEEK_END); 
   }
  
   /* Let's see what the user wants to do... */
   while ((c=getopt(argc,argv,"hit:a:l:y:c:"))!=-1) {

	switch(c) {
		case 'h':
			display_help(); exit();
			break;
		case 'i':
   	 		tagedit_curs(fp,argv[argc-1],fullline);
			interactive = 1;
			break;
		case 't':
			strncpy(title,optarg,TEXT_FIELD_LEN);
			break;
		case 'a':
			strncpy(artist,optarg,TEXT_FIELD_LEN);
			break;
		case 'l':
			strncpy(album,optarg,TEXT_FIELD_LEN);
			break;
		case 'y':
			strncpy(year,optarg,INT_FIELD_LEN);
			break;
		case 'c':
			strncpy(comment,optarg,TEXT_FIELD_LEN);
			break;
	}
   }
   /* Interactive mode builds the tag for itself, so... */
   if ( !interactive ) { buildtag(fullline,title,artist,album,year,comment); }

   /* Finally! Get it done! */
   fwrite(fullline,1,128,fp);

   fclose(fp);
   exit();
}

