/*
 * textfunc.c
 * 
 * Auxilliary text mode functions for MP3info
 *
 * Author:
 *       Ricardo Cerqueira      <rmc@ssi.aaum.pt>
 *  
 * This software is covered by the GNU public license, which should be in a file named
 * LICENSE acompanying this.
 *         
 */

#include "mp3info.h"

/*
 * Name of this one is quite obvious...
 */

void CenterText(int line, char *text) {
   mvprintw(line,(COLS/2)-((int)strlen(text)/2),text);
}

/*
 * If "string" is shorter than "length", pad it with ' ' (spaces)
 */

void pad(char *string, int length) {
        int l;

        l=strlen(string);
        while(l<length) {
                string[l] = ' ';
                l++;
        }

        string[l]='\0';
}

/*
 * Build the final tag, ready to be inserted into the file
 */

void buildtag(char *buf, char *title, char *artist, char *album, char *year, char *comment) {

	strcpy(buf,"TAG");
	pad(title,TEXT_FIELD_LEN); 
	strncat(buf,title,TEXT_FIELD_LEN);
	pad(artist,TEXT_FIELD_LEN); 
	strncat(buf,artist,TEXT_FIELD_LEN);
	pad(album,TEXT_FIELD_LEN); 
	strncat(buf,album,TEXT_FIELD_LEN);
	pad(year,INT_FIELD_LEN); 
	strncat(buf,year,INT_FIELD_LEN);
	pad(comment,TEXT_FIELD_LEN); 
	strncat(buf,comment,TEXT_FIELD_LEN);
	strncat(buf,"",1);
}

/*
 * Another one with an obvious name :-)
 */

void display_help() {

	printf("%s\n\n",VERSION);
	printf("  Usage: mp3info [-v] (-i | -t title -a artist -l album -y year -c comment )
			/path/to/the/file.mp3\n\n");
	printf("-h	--	Display this info and exit\n");
	printf("-v	--	View existing tag and exit\n");
	printf("-i	--	Enter interactive mode\n\n");
	printf("  Command line options:\n\n");
	printf("-t	--	Track title\n");
	printf("-a	--	Artist Name\n");
	printf("-l	--	Album Name\n");
	printf("-y	--	Year\n");
	printf("-c	--	Comment\n\n");
	printf("Non-specified fields, if existant, will remain unchanged.\n");
	printf("Remember: Multiple word fields must be enclosed in \"\" (eg: -t \"A title\")\n\n");

}

/*
 * Display an existing tag (if any), or error message
 */

void view_tag(FILE *fp) {
   char buf[31],fbuf[5];
	
   if ( fseek(fp, -128, SEEK_END )) { exit(); }
   fread(fbuf,1,3,fp); fbuf[3] = '\0';
   if (!strcmp("TAG",fbuf)) {
	   fseek(fp, -125, SEEK_END);
           fread(buf,1,30,fp); buf[30] = '\0';
	   printf("Title:   %s\n",buf);
           fread(buf,1,30,fp); buf[30] = '\0';
	   printf("Artist:  %s\n",buf);
           fread(buf,1,30,fp); buf[30] = '\0';
	   printf("Album:   %s ",buf);
           fread(buf,1,4,fp); buf[4] = '\0';
	   printf("Year: %s\n",buf);
           fread(buf,1,30,fp); buf[30] = '\0';
	   printf("Comment: %s\n",buf);
   } else {
	   printf("No ID3 found in this file.\n");
   }

}



