/*
 * mp3info.c
 *
 * Author:
 *       Ricardo Cerqueira	<rmc@ssi.aaum.pt>
 *
 * This software is covered by the GNU public license, which should be in a file named
 * LICENSE acompanying this.
 *
 */

#include "mp3info.h"


void main(int argc, char *argv[]) {
FILE  *fp;
WINDOW *mainwin;
char fullline[128];

   if (argc != 2 || !strcmp(argv[1],"-h")) { 
	   printf("%s\r\nYou must enter an MP3 file as a single argument!\r\n  Usage: %s /path/to/the/file.mp3\r\n\r\n",VERSION,argv[0]); 
	   exit();
   }
   if ( !( fp=fopen(argv[1],"ab+") ) ) {
           perror("Error opening MP3:");
           return;
   }

   strcpy(fullline,"TAG");
   initscr(); cbreak(); noecho();
   nonl();
   mainwin = newwin(8,COLS,5,0);
   intrflush(mainwin, FALSE);
   keypad(mainwin, TRUE);
   CenterText(1,VERSION);
   CenterText(2,"Ricardo Cerqueira <rmc@ssi.aaum.pt>, 1999");
   touchwin(mainwin);
   box(mainwin, 0, 0);
   wmove(mainwin,1,1); 
   wprintw(mainwin,"Song Title:");
   wmove(mainwin,2,1); 
   wprintw(mainwin,"Artist Name:");
   wmove(mainwin,3,1); 
   wprintw(mainwin,"Album Name:");
   wmove(mainwin,4,1); 
   wprintw(mainwin,"Year:");
   wmove(mainwin,5,1); 
   wprintw(mainwin,"Comment:");
   fseek(fp,0,2);
   wmove(mainwin,7,4);
   wprintw(mainwin," %s, %i bytes ",argv[1],ftell(fp));
   wmove(mainwin,7,COLS-22);
   wprintw(mainwin," Press ^C to quit ");
   refresh();
   echo();
   strcpy(fullline,addparam(mainwin,1,30,fullline));
   strcpy(fullline,addparam(mainwin,2,30,fullline));
   strcpy(fullline,addparam(mainwin,3,30,fullline));
   strcpy(fullline,addparam(mainwin,4,4,fullline));
   strcpy(fullline,addparam(mainwin,5,30,fullline));
   strcat(fullline,"");
   fprintf(fp,fullline);
   fclose(fp);
   endwin();
   exit();
}

