.TH NAME_OF_THIS_PROGRAM 1 "DATE_OF_LAST_MODIFICATION" "Version VERSION_NUMBER" "Linux User's Manual"
.SH NAME
name_of_this_program \- record cdda file
.SH SYNOPSIS
.B 
name_of_this_program
.RB [ -hvV ]
.RB [ -d\ device ]
.RB [ -n\ buffers ]
.RB [ -s\ size ]
.RI [ file ]
.SH DESCRIPTION
.I Name_of_this_program
records a cdda file (44.1kHz/16bit/stereo linear encoded raw pcm sound file
with big-endian byte order) from the dsp device
.I
device
of the soundcard which defaults to
.IR DEFAULT_DSP_DEVICE_NAME .
By default, the cdda stream is written to
.I stdout
but may be put directly to disk by specifying
.IR file .

Advanced (or unsatisfied) users may set the number of (the program internal)
audio buffers to
.I buffers
and their sizes to
.IR size .

After launching
.IR name_of_this_program ,
recording is started and stopped by hitting `s' and `q' (+ENTER), repectively.
When using a single buffer (see options below), the recording time is
set via
.I size
and recording cannot be stopped by hitting `q'. However, it can always be
aborted by sending
.I SIGTERM
(Ctrl-C).

.SH OPTIONS
.TP
.B -h
display some (more or less) helpful information on
.I HELP_CHANNEL
and exit successfully
.TP
.B -v
raise verbosity level on
.I
INFO_CHANNEL
by one
.TP
.B -V
display version and compilation info on
.I VERSION_CHANNEL
and exit successfully
.TP
.BI "\-d " device
use
.I device
as dsp device
(default is
.IR DEFAULT_DSP_DEVICE_NAME )
.TP
.BI "\-n " buffers
set number of buffers to
.I buffers
(default is
.IR DEFAULT_NUMBER_OF_BUFFERS )
.TP
.BI "\-s " frames
set buffer size to
.I frames
( 2352 bytes) (default is
.IR DEFAULT_BUFFER_SIZE )
-- may be specified as lba or msf

.SH EXAMPLES
.BR "name_of_this_program -vv" " sound_file.cdr"

will be the usual way of recording files with a lot of informative output.
If there are clicks in the recorded file, the last resort is sampling
to RAM with a buffer as large as neccessary. With 128 MB swap space
the maximum recording time is about 12 minutes and 40 seconds. Then
the longest possible sound file may be recorded by
.TP
.BR "name_of_this_program -vvn 1 -s 12:40:" " > sound_file.cdr"

.SH HINTS
for recording non-clicking cdda tracks:
.TP
.I *
keep the system load (especially disk access) caused by concurring processes
as low as possible
.TP
.I *
switch ide drive to (U)DMA mode -- at least since v2.2.* the kernel support
this mode
.TP
.I *
play with the number of buffers and their size -- at least the last may
improve operation
.TP
.I *
last resort: sample to RAM by specifying one large buffer -- swapping usually
does not annoy the sampling process 

.SH ABBREVIATIONS
.TP
.I CDDA
stands for Compact Disk Digital Audio.
.TP
.I dsp
stands for digital signal processing.

.SH AUTHOR
MY_EMAIL_ADDRESS

.SH SEE ALSO
.BR cddack (1),
.BR cddagen (1),
.BR cddamod (1),
.BR cddaplay (1),
.BR cddaproc (1),
.BR cddaread (1)
