/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  int VRfCheckSym (const float x[], int N)

Purpose:
  Determine if an array of floats is symmetric or anti-symmetric

Description:
  This procedure returns a value which indicates whether a given array of float
  values is symmetric, anti-symmetric or neither.  A symmetric array has values
  which satisfy,
    x[i] = x[N-i-1], for i = 0, 1, ..., N-1.
  An anti-symmetric array has values which satisfy,
    x[i] = -x[N-i-1], for i = 0, 1, ..., N-1.
  An all-zero array will be declared to be symmetric.

Parameters:
  <-  int VRfCheckSym
      integer value,
        +1, if x[i] =  x[N-i-1], for i = 0, 1, ..., N-1
        -1, if x[i] = -x[N-i-1], for i = 0, 1, ..., N-1
         0, otherwise
   -> const float x[]
      Array of floats (N elements)
   -> int N
      Number of elements in the input array

Author / revision:
  P. Kabal  Copyright (C) 1995
  $Revision: 1.9 $  $Date: 1995/02/09 21:04:45 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: VRfCheckSym.c 1.9 1995/02/09 AFsp-V2R1 $";

#include <libtsp.h>

int
VRfCheckSym (x, N)

     const float x[];
     int N;

{
  int i;
  int j;

/* Check for symmetry, no need to check the middle point */
  for (i = 0, j = N - 1; i < j; ++i, --j) {
    if (x[i] != x[j])
      break;
  }
  if (i >= j)
    return 1;

/* Check for anti-symmetry, check for middle point (must be zero) */
  for (i = 0, j = N - 1; i <= j; ++i, --j) {
    if (x[i] != -x[j])
      break;
  }
  if (i > j)
    return -1;

/* Otherwise */
  return 0;

}
