/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  char *UTgetHost (void)

Purpose:
  Get the host name

Description:
  This routine returns the host machine name.  Under MSDOS, a zero-length
  string is returned.

Parameters:
  <-  char UTgetHost[]
      Pointer to a character string containing the host name.  This string is
      null terminated.  This is a pointer to an internal static storage area;
      each call to this routine overlays this storage.

Author / revision:
  P. Kabal  Copyright (C) 1995
  $Revision: 1.5 $  $Date: 1995/11/22 02:26:26 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: UTgetHost.c 1.5 1995/11/22 AFsp-V2R1 $";

#include <string.h>
#include <libtsp.h>
#include <libtsp/nucleus.h>

#ifdef _MSDOS
#  ifndef MSDOS
#    define MSDOS 1	/* For MSVC with /Za option */
#  endif
#endif

#ifdef MSDOS
#  define NO_HOSTNAME
#endif

#ifdef NO_HOSTNAME
#  define MAXHOSTNAMELEN	0	/* Null host name for MS-DOS */
#else
#  include <sys/param.h>	/* MAXHOSTNAMELEN on many systems */
#  ifndef MAXHOSTNAMELEN
#    include <netdb.h>		/* For Sun Solaris */
#  endif
#endif

#ifndef NO_HOSTNAME
#  ifdef sun		/* gethostname is not available on all Sun systems */
#    define USE_UNAME	1
#  endif
#endif

#ifndef NO_HOSTNAME
#  ifdef USE_UNAME
#    include <sys/utsname.h>
#  else
int
gethostname p_((char *name, int len));	/* Some systems do not have a prototype
					   for gethostname.  Sun ANSI compilers
					   have it in sysent.h. */
#  endif
#endif

char *
UTgetHost ()

{
  static char Host[MAXHOSTNAMELEN+1];

#ifdef NO_HOSTNAME

  Host[0] = '\0';

#else

#  ifdef USE_UNAME	/* Use uname to get the host name */

  struct utsname UnameStruct;

  if (uname (&UnameStruct) >= 0)
    strcpy (Host, UnameStruct.nodename);
  else {
    UTwarn ("UTgetHost - Error return from uname()");
    Host[0] = '\0';
  }

#  else			/* Use gethostname to get the host name */

  if (gethostname (Host, MAXHOSTNAMELEN) == 0)
    Host[MAXHOSTNAMELEN+1] = '\0';	/* In case the host name is too long */
  else {
    UTwarn ("UTgetHost - Error return from gethostname");
    Host[0] = '\0';
  }

#  endif

#endif

  return Host;
}
